/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general.rtp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;

public class RtpPacket
implements Serializable {
    private int version = 2;
    private boolean padding = false;
    private boolean extensions = false;
    private int cc = 0;
    private boolean marker = false;
    private int payloadType;
    private int seqNumber;
    private int timestamp;
    private long ssrc;
    private byte[] payload;
    private int offset = 0;
    private int length = 0;
    private Date time;

    public RtpPacket(byte[] data) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        int b = in.read() & 0xFF;
        this.version = (b & 0xC) >> 6;
        this.padding = (b & 0x20) == 32;
        this.extensions = (b & 0x10) == 16;
        this.cc = b & 0xF;
        b = in.read() & 0xFF;
        this.marker = (b & 0x80) == 128;
        this.payloadType = b & 0x7F;
        this.seqNumber = (in.read() & 0xFF) << 8;
        this.seqNumber |= in.read() & 0xFF;
        this.timestamp = in.readInt();
        this.ssrc = in.readInt();
        this.payload = new byte[160];
        int numBytes = in.read(this.payload);
        if (numBytes < 0) {
            numBytes = 0;
        }
        byte[] realPayload = new byte[numBytes];
        for (int q = 0; q < numBytes; ++q) {
            realPayload[q] = this.payload[q];
        }
        this.payload = realPayload;
    }

    public RtpPacket(byte payloadType, int seqNumber, int timestamp, long ssrc, byte[] payload) {
        this.payloadType = payloadType;
        this.payload = payload;
        this.seqNumber = seqNumber;
        this.timestamp = timestamp;
        this.ssrc = ssrc;
    }

    public RtpPacket(byte payloadType, int seqNumber, int timestamp, long ssrc, byte[] payload, int offset, int length) {
        this.payloadType = payloadType;
        this.payload = payload;
        this.seqNumber = seqNumber;
        this.timestamp = timestamp;
        this.ssrc = ssrc;
        this.offset = offset;
        this.length = length;
    }

    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public long getSSRC() {
        return this.ssrc;
    }

    public int getPayloadType() {
        return this.payloadType;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        bout.write(128);
        bout.write(this.payloadType);
        bout.write((byte)((this.seqNumber & 0xFF00) >> 8));
        bout.write((byte)(this.seqNumber & 0xFF));
        bout.write((byte)((this.timestamp & 0xFF000000) >> 24));
        bout.write((byte)((this.timestamp & 0xFF0000) >> 16));
        bout.write((byte)((this.timestamp & 0xFF00) >> 8));
        bout.write((byte)(this.timestamp & 0xFF));
        bout.write((byte)((this.ssrc & 0xFFFFFFFFFF000000L) >> 24));
        bout.write((byte)((this.ssrc & 0xFF0000L) >> 16));
        bout.write((byte)((this.ssrc & 0xFF00L) >> 8));
        bout.write((byte)(this.ssrc & 0xFFL));
        bout.write(this.payload, this.offset, this.length);
        return bout.toByteArray();
    }

    public String toString() {
        return "RTP Packet[seq=" + this.seqNumber + ", timestamp=" + this.timestamp + ", payload_size=" + this.payload.length + "]";
    }
}

