/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sdp.Attribute;
import javax.sdp.SdpFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.AbstractTestCase;
import org.mobicents.media.server.testsuite.general.CallDisplayInterface;
import org.mobicents.media.server.testsuite.general.ann.AnnouncementTest;
import org.mobicents.media.server.testsuite.general.file.FileUtils;
import org.mobicents.media.server.testsuite.gui.MainGUI;
import org.mobicents.media.server.testsuite.gui.MainGUIAboutBox;
import org.mobicents.media.server.testsuite.gui.graph.RtpTrafficDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainGUIView
extends FrameView
implements CallDisplayInterface {
    private JLabel _labelCPS;
    private JLabel _labelCallDuration;
    private JLabel _labelCalls;
    private JLabel _labelClientAddress;
    private JLabel _labelClientPort;
    private JLabel _labelCodec;
    private JLabel _labelCompletedCalls;
    private JLabel _labelDumpDir;
    private JLabel _labelErrorCalls;
    private JLabel _labelOngoingCalls;
    private JLabel _labelServerAddress;
    private JLabel _labelServerPort;
    private JMenuItem annTestAction;
    private JButton buttonDecreaseBy10;
    private JButton buttonDecreaseCPSBy1;
    private JButton buttonIncreaseCPSBy1;
    private JButton buttonIncreseDurrationBy10;
    private JButton buttonStartTest;
    private JButton buttonStopTest;
    private JPanel dataLoadPanel;
    private JPanel dataPanel;
    private JFileChooser dirLoadFileChooser;
    private JTextField fieldAnnFileURL;
    private JTextField fieldCPS;
    private JTextField fieldCallDurrationTextField;
    private JTextField fieldClientAddress;
    private JTextField fieldClientPort;
    private JComboBox fieldCodecBox;
    private JTextField fieldCompletedCalls;
    private JTextField fieldDataDumpDir;
    private JTextField fieldFailedCalls;
    private JTable fieldLoadedDataDisplayTable;
    private JTextField fieldOngoingCalls;
    private JTextField fieldServerAddress;
    private JTextField fieldServerPort;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JLabel labelFileUrl;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JPanel testSetupPanel;
    private JTabbedPane userDialogPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    private AbstractTestCase currentTest;
    private static Map<String, Vector<Attribute>> attributerMap = new HashMap<String, Vector<Attribute>>();
    private static final String[] _COMBO_BOX_VALUES = new String[]{"ULAW", "ALAW"};

    public MainGUIView(SingleFrameApplication app) {
        super((Application)app);
        this.initComponents();
        this.initLocalComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainGUIView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MainGUIView.this.busyIconIndex = (MainGUIView.this.busyIconIndex + 1) % MainGUIView.this.busyIcons.length;
                MainGUIView.this.statusAnimationLabel.setIcon(MainGUIView.this.busyIcons[MainGUIView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!MainGUIView.this.busyIconTimer.isRunning()) {
                        MainGUIView.this.statusAnimationLabel.setIcon(MainGUIView.this.busyIcons[0]);
                        MainGUIView.this.busyIconIndex = 0;
                        MainGUIView.this.busyIconTimer.start();
                    }
                    MainGUIView.this.progressBar.setVisible(true);
                    MainGUIView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    MainGUIView.this.busyIconTimer.stop();
                    MainGUIView.this.statusAnimationLabel.setIcon(MainGUIView.this.idleIcon);
                    MainGUIView.this.progressBar.setVisible(false);
                    MainGUIView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    MainGUIView.this.statusMessageLabel.setText(text == null ? "" : text);
                    MainGUIView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    MainGUIView.this.progressBar.setVisible(true);
                    MainGUIView.this.progressBar.setIndeterminate(false);
                    MainGUIView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = MainGUI.getApplication().getMainFrame();
            this.aboutBox = new MainGUIAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        MainGUI.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.userDialogPanel = new JTabbedPane();
        this.dataLoadPanel = new JPanel();
        this.dirLoadFileChooser = new JFileChooser();
        this.dataPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.fieldLoadedDataDisplayTable = new JTable();
        this.testSetupPanel = new JPanel();
        this.jSeparator1 = new JSeparator();
        this._labelCallDuration = new JLabel();
        this._labelCPS = new JLabel();
        this._labelServerAddress = new JLabel();
        this._labelClientAddress = new JLabel();
        this._labelCodec = new JLabel();
        this._labelServerPort = new JLabel();
        this._labelClientPort = new JLabel();
        this._labelDumpDir = new JLabel();
        this.fieldCallDurrationTextField = new JTextField();
        this.fieldCPS = new JTextField();
        this.fieldServerAddress = new JTextField();
        this.fieldClientAddress = new JTextField();
        this.fieldDataDumpDir = new JTextField();
        this.fieldServerPort = new JTextField();
        this.fieldClientPort = new JTextField();
        this.fieldCodecBox = new JComboBox();
        this.jSeparator2 = new JSeparator();
        this.buttonStartTest = new JButton();
        this.buttonStopTest = new JButton();
        this.buttonIncreseDurrationBy10 = new JButton();
        this.buttonDecreaseBy10 = new JButton();
        this.buttonIncreaseCPSBy1 = new JButton();
        this.buttonDecreaseCPSBy1 = new JButton();
        this.jSeparator3 = new JSeparator();
        this._labelOngoingCalls = new JLabel();
        this.fieldOngoingCalls = new JTextField();
        this._labelCompletedCalls = new JLabel();
        this._labelCalls = new JLabel();
        this.fieldCompletedCalls = new JTextField();
        this._labelErrorCalls = new JLabel();
        this.fieldFailedCalls = new JTextField();
        this.jSeparator4 = new JSeparator();
        this.labelFileUrl = new JLabel();
        this.fieldAnnFileURL = new JTextField();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        this.annTestAction = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        this.userDialogPanel.setName("dialogTabbedPane");
        this.dataLoadPanel.setName("dataLoadPanel");
        this.dirLoadFileChooser.setFileSelectionMode(1);
        this.dirLoadFileChooser.setName("dirLoadFileChooser");
        this.dirLoadFileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.dirLoadFileChooserActionPerformed(evt);
            }
        });
        GroupLayout dataLoadPanelLayout = new GroupLayout((Container)this.dataLoadPanel);
        this.dataLoadPanel.setLayout((LayoutManager)dataLoadPanelLayout);
        dataLoadPanelLayout.setHorizontalGroup((GroupLayout.Group)dataLoadPanelLayout.createParallelGroup(1).add((Component)this.dirLoadFileChooser, -1, 609, Short.MAX_VALUE));
        dataLoadPanelLayout.setVerticalGroup((GroupLayout.Group)dataLoadPanelLayout.createParallelGroup(1).add((Component)this.dirLoadFileChooser, -1, 478, Short.MAX_VALUE));
        ResourceMap resourceMap = ((MainGUI)Application.getInstance(MainGUI.class)).getContext().getResourceMap(MainGUIView.class);
        this.userDialogPanel.addTab(resourceMap.getString("dataLoadPanel.TabConstraints.tabTitle", new Object[0]), null, this.dataLoadPanel);
        this.dataPanel.setName("dataPanel");
        this.jScrollPane1.setName("jScrollPane1");
        this.fieldLoadedDataDisplayTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Call Seq", "Endpoint", "Avg Jitter", "Peak Jitter", "Title 5", "Call ID"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, String.class, Long.class, Long.class, Object.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.fieldLoadedDataDisplayTable.setName("fieldLoadedDataDisplayTable");
        this.fieldLoadedDataDisplayTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MainGUIView.this.fieldLoadedDataDisplayTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.fieldLoadedDataDisplayTable);
        GroupLayout dataPanelLayout = new GroupLayout((Container)this.dataPanel);
        this.dataPanel.setLayout((LayoutManager)dataPanelLayout);
        dataPanelLayout.setHorizontalGroup((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 609, Short.MAX_VALUE));
        dataPanelLayout.setVerticalGroup((GroupLayout.Group)dataPanelLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 478, Short.MAX_VALUE));
        this.userDialogPanel.addTab(resourceMap.getString("dataPanel.TabConstraints.tabTitle", new Object[0]), null, this.dataPanel);
        this.testSetupPanel.setName("testSetupPanel");
        this.jSeparator1.setName("jSeparator1");
        this._labelCallDuration.setText(resourceMap.getString("_labelCallDuration.text", new Object[0]));
        this._labelCallDuration.setName("_labelCallDuration");
        this._labelCPS.setText(resourceMap.getString("_labelCPS.text", new Object[0]));
        this._labelCPS.setName("_labelCPS");
        this._labelServerAddress.setText(resourceMap.getString("_labelServerAddress.text", new Object[0]));
        this._labelServerAddress.setName("_labelServerAddress");
        this._labelClientAddress.setText(resourceMap.getString("_labelClientAddress.text", new Object[0]));
        this._labelClientAddress.setName("_labelClientAddress");
        this._labelCodec.setText(resourceMap.getString("_labelCodec.text", new Object[0]));
        this._labelCodec.setName("_labelCodec");
        this._labelServerPort.setText(resourceMap.getString("_labelServerPort.text", new Object[0]));
        this._labelServerPort.setName("_labelServerPort");
        this._labelClientPort.setText(resourceMap.getString("_labelClientPort.text", new Object[0]));
        this._labelClientPort.setName("_labelClientPort");
        this._labelDumpDir.setText(resourceMap.getString("_labelDumpDir.text", new Object[0]));
        this._labelDumpDir.setName("_labelDumpDir");
        this.fieldCallDurrationTextField.setText(resourceMap.getString("fieldCallDurrationTextField.text", new Object[0]));
        this.fieldCallDurrationTextField.setName("fieldCallDurrationTextField");
        this.fieldCPS.setText(resourceMap.getString("fieldCPS.text", new Object[0]));
        this.fieldCPS.setName("fieldCPS");
        this.fieldServerAddress.setText(resourceMap.getString("fieldServerAddress.text", new Object[0]));
        this.fieldServerAddress.setName("fieldServerAddress");
        this.fieldClientAddress.setText(resourceMap.getString("fieldClientAddress.text", new Object[0]));
        this.fieldClientAddress.setName("fieldClientAddress");
        this.fieldDataDumpDir.setText(resourceMap.getString("fieldDataDumpDir.text", new Object[0]));
        this.fieldDataDumpDir.setName("fieldDataDumpDir");
        this.fieldServerPort.setText(resourceMap.getString("fieldServerPort.text", new Object[0]));
        this.fieldServerPort.setName("fieldServerPort");
        this.fieldClientPort.setText(resourceMap.getString("fieldClientPort.text", new Object[0]));
        this.fieldClientPort.setName("fieldClientPort");
        this.fieldCodecBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fieldCodecBox.setName("fieldCodecBox");
        this.jSeparator2.setName("jSeparator2");
        this.buttonStartTest.setText(resourceMap.getString("buttonStartTest.text", new Object[0]));
        this.buttonStartTest.setEnabled(false);
        this.buttonStartTest.setName("buttonStartTest");
        this.buttonStartTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.buttonStartTestActionPerformed(evt);
            }
        });
        this.buttonStopTest.setText(resourceMap.getString("buttonStopTest.text", new Object[0]));
        this.buttonStopTest.setName("buttonStopTest");
        this.buttonStopTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.buttonStopTestActionPerformed(evt);
            }
        });
        this.buttonIncreseDurrationBy10.setText(resourceMap.getString("buttonIncreseDurrationBy10.text", new Object[0]));
        this.buttonIncreseDurrationBy10.setName("buttonIncreseDurrationBy10");
        this.buttonIncreseDurrationBy10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.buttonIncreseDurrationBy10ActionPerformed(evt);
            }
        });
        this.buttonDecreaseBy10.setText(resourceMap.getString("buttonDecreaseBy10.text", new Object[0]));
        this.buttonDecreaseBy10.setName("buttonDecreaseBy10");
        this.buttonDecreaseBy10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.buttonDecreaseBy10ActionPerformed(evt);
            }
        });
        this.buttonIncreaseCPSBy1.setText(resourceMap.getString("buttonIncreaseCPSBy1.text", new Object[0]));
        this.buttonIncreaseCPSBy1.setName("buttonIncreaseCPSBy1");
        this.buttonIncreaseCPSBy1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.buttonIncreaseCPSBy1ActionPerformed(evt);
            }
        });
        this.buttonDecreaseCPSBy1.setText(resourceMap.getString("buttonDecreaseCPSBy1.text", new Object[0]));
        this.buttonDecreaseCPSBy1.setName("buttonDecreaseCPSBy1");
        this.buttonDecreaseCPSBy1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.buttonDecreaseCPSBy1ActionPerformed(evt);
            }
        });
        this.jSeparator3.setName("jSeparator3");
        this._labelOngoingCalls.setText(resourceMap.getString("_labelOngoingCalls.text", new Object[0]));
        this._labelOngoingCalls.setName("_labelOngoingCalls");
        this.fieldOngoingCalls.setBackground(resourceMap.getColor("fieldOngoingCalls.background"));
        this.fieldOngoingCalls.setText(resourceMap.getString("fieldOngoingCalls.text", new Object[0]));
        this.fieldOngoingCalls.setEnabled(false);
        this.fieldOngoingCalls.setName("fieldOngoingCalls");
        this._labelCompletedCalls.setText(resourceMap.getString("_labelCompletedCalls.text", new Object[0]));
        this._labelCompletedCalls.setName("_labelCompletedCalls");
        this._labelCalls.setFont(resourceMap.getFont("_labelCalls.font"));
        this._labelCalls.setText(resourceMap.getString("_labelCalls.text", new Object[0]));
        this._labelCalls.setName("_labelCalls");
        this.fieldCompletedCalls.setBackground(resourceMap.getColor("fieldCompletedCalls.background"));
        this.fieldCompletedCalls.setText(resourceMap.getString("fieldCompletedCalls.text", new Object[0]));
        this.fieldCompletedCalls.setEnabled(false);
        this.fieldCompletedCalls.setName("fieldCompletedCalls");
        this._labelErrorCalls.setText(resourceMap.getString("_labelErrorCalls.text", new Object[0]));
        this._labelErrorCalls.setName("_labelErrorCalls");
        this.fieldFailedCalls.setBackground(resourceMap.getColor("fieldFailedCalls.background"));
        this.fieldFailedCalls.setText(resourceMap.getString("fieldFailedCalls.text", new Object[0]));
        this.fieldFailedCalls.setEnabled(false);
        this.fieldFailedCalls.setName("fieldFailedCalls");
        this.jSeparator4.setName("jSeparator4");
        this.labelFileUrl.setText(resourceMap.getString("labelFileUrl.text", new Object[0]));
        this.labelFileUrl.setName("labelFileUrl");
        this.fieldAnnFileURL.setText(resourceMap.getString("fieldAnnFileURL.text", new Object[0]));
        this.fieldAnnFileURL.setName("fieldAnnFileURL");
        GroupLayout testSetupPanelLayout = new GroupLayout((Container)this.testSetupPanel);
        this.testSetupPanel.setLayout((LayoutManager)testSetupPanelLayout);
        testSetupPanelLayout.setHorizontalGroup((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 589, Short.MAX_VALUE).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1, false).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().add((Component)this._labelClientAddress).addPreferredGap(1).add((Component)this.fieldClientAddress)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1).add((Component)this._labelCallDuration).add((Component)this._labelCPS).add((Component)this._labelServerAddress)).addPreferredGap(0).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1, false).add((Component)this.fieldCallDurrationTextField, -1, 108, Short.MAX_VALUE).add((Component)this.fieldCPS).add((Component)this.fieldServerAddress, -2, 143, -2)))).add(86, 86, 86).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1).add((Component)this._labelServerPort).add((Component)this._labelClientPort).add((Component)this._labelCodec).add((Component)this._labelDumpDir)).addPreferredGap(0).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1, false).add((Component)this.fieldClientPort).add((Component)this.fieldServerPort).add((Component)this.fieldDataDumpDir).add((Component)this.fieldCodecBox, 0, 136, Short.MAX_VALUE))))).add(2, (GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator4, -1, 589, Short.MAX_VALUE)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((Component)this._labelOngoingCalls).addPreferredGap(0).add((Component)this.fieldOngoingCalls, -2, 105, -2).addPreferredGap(0).add((Component)this._labelCompletedCalls).addPreferredGap(0).add((Component)this.fieldCompletedCalls, -2, 101, -2).add(39, 39, 39).add((Component)this._labelErrorCalls).addPreferredGap(0).add((Component)this.fieldFailedCalls, -2, 92, -2)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().add(243, 243, 243).add((Component)this._labelCalls)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator3, -1, 589, Short.MAX_VALUE)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.buttonStartTest).addPreferredGap(0).add((Component)this.buttonStopTest).add(38, 38, 38).add((Component)this.buttonIncreseDurrationBy10).addPreferredGap(0).add((Component)this.buttonDecreaseBy10).add(41, 41, 41).add((Component)this.buttonIncreaseCPSBy1).addPreferredGap(0).add((Component)this.buttonDecreaseCPSBy1)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator2, -1, 589, Short.MAX_VALUE)).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.labelFileUrl).addPreferredGap(0).add((Component)this.fieldAnnFileURL, -2, 458, -2))).addContainerGap()));
        testSetupPanelLayout.linkSize(new Component[]{this.fieldCompletedCalls, this.fieldFailedCalls, this.fieldOngoingCalls}, 1);
        testSetupPanelLayout.setVerticalGroup((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(1).add((GroupLayout.Group)testSetupPanelLayout.createSequentialGroup().add(8, 8, 8).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this._labelCallDuration).add((Component)this._labelCodec).add((Component)this.fieldCallDurrationTextField, -2, -1, -2).add((Component)this.fieldCodecBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this._labelCPS).add((Component)this._labelDumpDir).add((Component)this.fieldCPS, -2, -1, -2).add((Component)this.fieldDataDumpDir, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this._labelServerAddress).add((Component)this._labelServerPort).add((Component)this.fieldServerAddress, -2, -1, -2).add((Component)this.fieldServerPort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this._labelClientAddress).add((Component)this._labelClientPort).add((Component)this.fieldClientAddress, -2, -1, -2).add((Component)this.fieldClientPort, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this.labelFileUrl).add((Component)this.fieldAnnFileURL, -2, -1, -2)).add(21, 21, 21).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(1).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this.buttonStartTest).add((Component)this.buttonStopTest).add((Component)this.buttonIncreseDurrationBy10).add((Component)this.buttonDecreaseBy10).add((Component)this.buttonIncreaseCPSBy1).add((Component)this.buttonDecreaseCPSBy1)).addPreferredGap(1).add((Component)this.jSeparator3, -2, 10, -2).addPreferredGap(0).add((Component)this._labelCalls).addPreferredGap(1).add((GroupLayout.Group)testSetupPanelLayout.createParallelGroup(3).add((Component)this._labelOngoingCalls).add((Component)this.fieldOngoingCalls, -2, -1, -2).add((Component)this._labelCompletedCalls).add((Component)this.fieldCompletedCalls, -2, -1, -2).add((Component)this.fieldFailedCalls, -2, -1, -2).add((Component)this._labelErrorCalls)).addPreferredGap(0).add((Component)this.jSeparator4, -2, 10, -2).addContainerGap(165, Short.MAX_VALUE)));
        this.userDialogPanel.addTab(resourceMap.getString("testSetupPanel.TabConstraints.tabTitle", new Object[0]), null, this.testSetupPanel);
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.userDialogPanel, -1, 614, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.userDialogPanel, -1, 505, Short.MAX_VALUE));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = ((MainGUI)Application.getInstance(MainGUI.class)).getContext().getActionMap(MainGUIView.class, (Object)this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.annTestAction.setAccelerator(KeyStroke.getKeyStroke(65, 8));
        this.annTestAction.setText(resourceMap.getString("annTestAction.text", new Object[0]));
        this.annTestAction.setName("annTestAction");
        this.annTestAction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainGUIView.this.annTestActionActionPerformed(evt);
            }
        });
        fileMenu.add(this.annTestAction);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout((Container)this.statusPanel);
        this.statusPanel.setLayout((LayoutManager)statusPanelLayout);
        statusPanelLayout.setHorizontalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((Component)statusPanelSeparator, -1, 614, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().addContainerGap().add((Component)this.statusMessageLabel).addPreferredGap(0, 440, Short.MAX_VALUE).add((Component)this.progressBar, -2, -1, -2).addPreferredGap(0).add((Component)this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup((GroupLayout.Group)statusPanelLayout.createParallelGroup(1).add((GroupLayout.Group)statusPanelLayout.createSequentialGroup().add((Component)statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)statusPanelLayout.createParallelGroup(3).add((Component)this.statusMessageLabel).add((Component)this.statusAnimationLabel).add((Component)this.progressBar, -2, -1, -2)).add(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void dirLoadFileChooserActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("ApproveSelection")) {
            try {
                File directory = this.dirLoadFileChooser.getSelectedFile();
                AbstractTestCase test = FileUtils.deserializeTestCase(directory);
                test.setCallDisplay(this, directory);
                this.buttonStartTest.setEnabled(true);
                this.userDialogPanel.setSelectedComponent(this.dataPanel);
                this.currentTest = test;
                this.fieldLoadedDataDisplayTable.setModel(this.currentTest.getTableModel());
                this.updateCallView();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void buttonStartTestActionPerformed(ActionEvent evt) {
        try {
            this.currentTest.start();
            this.buttonStartTest.setEnabled(false);
            this.fieldCallDurrationTextField.setEnabled(false);
            this.fieldClientAddress.setEnabled(false);
            this.fieldClientPort.setEnabled(false);
            this.fieldCodecBox.setEnabled(false);
            this.fieldDataDumpDir.setEnabled(false);
            this.fieldServerAddress.setEnabled(false);
            this.fieldServerPort.setEnabled(false);
            this.fieldCPS.setEnabled(false);
            this.dirLoadFileChooser.setCurrentDirectory(new File(this.fieldDataDumpDir.getText()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buttonStopTestActionPerformed(ActionEvent evt) {
        if (this.currentTest != null) {
            // empty if block
        }
        try {
            this.currentTest.stop();
            this.buttonStartTest.setEnabled(true);
            this.fieldCallDurrationTextField.setEnabled(true);
            this.fieldClientAddress.setEnabled(true);
            this.fieldClientPort.setEnabled(true);
            this.fieldCodecBox.setEnabled(true);
            this.fieldDataDumpDir.setEnabled(true);
            this.fieldServerAddress.setEnabled(true);
            this.fieldServerPort.setEnabled(true);
            this.fieldCPS.setEnabled(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void buttonIncreseDurrationBy10ActionPerformed(ActionEvent evt) {
        long l = Long.valueOf(this.fieldCallDurrationTextField.getText());
        this.fieldCallDurrationTextField.setText((l += 10L) + "");
        if (this.currentTest != null) {
            this.currentTest.onCallLengthChange();
        }
    }

    private void buttonDecreaseBy10ActionPerformed(ActionEvent evt) {
        long l = Long.valueOf(this.fieldCallDurrationTextField.getText());
        if ((l += 10L) < 5L) {
            l = 10L;
        }
        this.fieldCallDurrationTextField.setText(l + "");
        if (this.currentTest != null) {
            this.currentTest.onCallLengthChange();
        }
    }

    private void buttonIncreaseCPSBy1ActionPerformed(ActionEvent evt) {
        long l = Long.valueOf(this.fieldCPS.getText()) + 1L;
        this.fieldCPS.setText("" + l);
        if (this.currentTest != null) {
            this.currentTest.onCPSChange();
        }
    }

    private void buttonDecreaseCPSBy1ActionPerformed(ActionEvent evt) {
        long l = Long.valueOf(this.fieldCPS.getText()) - 1L;
        if (l < 0L) {
            l = 0L;
        }
        this.fieldCPS.setText("" + l);
        if (this.currentTest != null) {
            this.currentTest.onCPSChange();
        }
    }

    private void initLocalComponents() {
        this.fieldCodecBox.removeAllItems();
        for (String s : _COMBO_BOX_VALUES) {
            this.fieldCodecBox.addItem(s);
        }
        this.dirLoadFileChooser.setCurrentDirectory(new File("./"));
        File wavFile = new File("target/audio/ulaw_13s.wav");
        this.fieldAnnFileURL.setText(wavFile.toURI().toString());
    }

    private void annTestActionActionPerformed(ActionEvent evt) {
        try {
            if (this.currentTest != null) {
                this.currentTest.stop();
            }
            this.currentTest = new AnnouncementTest();
            this.currentTest.setCallDisplay(this);
            this.buttonStartTest.setEnabled(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fieldLoadedDataDisplayTableMouseClicked(MouseEvent evt) {
        Long seq = (Long)this.fieldLoadedDataDisplayTable.getValueAt(this.fieldLoadedDataDisplayTable.getSelectedRow(), 0);
        AbstractCall callToDisplay = this.currentTest.getCallBySequence(seq);
        RtpTrafficDialog dialog = new RtpTrafficDialog((Frame)this.getFrame(), true, callToDisplay);
        dialog.setVisible(true);
    }

    @Override
    public String getLocalAddress() {
        return this.fieldClientAddress.getText();
    }

    @Override
    public String getRemoteAddress() {
        return this.fieldServerAddress.getText();
    }

    @Override
    public int getLocalPort() {
        return Integer.valueOf(this.fieldClientPort.getText());
    }

    @Override
    public int getRemotePort() {
        return Integer.valueOf(this.fieldServerPort.getText());
    }

    @Override
    public int getCallDuration() {
        return Integer.valueOf(this.fieldCallDurrationTextField.getText());
    }

    @Override
    public int getCPS() {
        return Integer.valueOf(this.fieldCPS.getText());
    }

    @Override
    public Vector<Attribute> getCodec() {
        return attributerMap.get(this.fieldCodecBox.getSelectedItem());
    }

    @Override
    public void updateCallView() {
        JFrame fm = this.getFrame();
        fm.invalidate();
        if (this.currentTest != null) {
            this.fieldOngoingCalls.setText(this.currentTest.getOngoingCallNumber() + "");
            this.fieldFailedCalls.setText(this.currentTest.getErrorCallNumber() + "");
            this.fieldCompletedCalls.setText(this.currentTest.getCompletedCallNumber() + "");
        }
        fm.validate();
    }

    @Override
    public File getDefaultDataDumpDirectory() {
        return new File(this.fieldDataDumpDir.getText());
    }

    @Override
    public String getFileURL() {
        return this.fieldAnnFileURL.getText();
    }

    static {
        SdpFactory sdpFactory = SdpFactory.getInstance();
        Vector<Attribute> attributes = new Vector<Attribute>();
        attributes.add(sdpFactory.createAttribute("rtpmap", "0 pcmu/8000"));
        attributerMap.put(_COMBO_BOX_VALUES[0], attributes);
        attributes = new Vector();
        attributes.add(sdpFactory.createAttribute("rtpmap", "8 pcma/8000"));
        attributerMap.put(_COMBO_BOX_VALUES[1], attributes);
    }
}

