/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.gui.graph;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;

public class RtpTrafficGraph
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private AbstractCall call;
    private JButton closeButton;
    private JPanel desktop;
    private JPanel jPanel1;
    private int returnStatus = 0;

    public RtpTrafficGraph(Frame parent, boolean modal, AbstractCall call) throws IOException {
        super(parent, modal);
        this.call = call;
        this.initComponents();
        List<RtpPacket> packets = call.getRtp();
        XYSeries j = new XYSeries((Comparable)((Object)"Jitter"));
        for (int i = 0; i < packets.size() - 1; ++i) {
            RtpPacket p1 = packets.get(i);
            RtpPacket p2 = packets.get(i + 1);
            j.add((double)i, (double)(p2.getTime().getTime() - p1.getTime().getTime()));
        }
        XYSeriesCollection dataset = new XYSeriesCollection(j);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Jitter chart", (String)"Jitter", (String)"Time", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        ChartPanel chartPanel = new ChartPanel(chart);
        this.desktop.removeAll();
        this.desktop.add((Component)chartPanel, "Center");
    }

    private void printErrors(int[] errors, int count) {
        for (int i = 0; i < count; ++i) {
            System.out.println(errors[i]);
        }
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.closeButton = new JButton();
        this.desktop = new JPanel();
        this.setTitle("RTP Traffic");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RtpTrafficGraph.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RtpTrafficGraph.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.closeButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.desktop.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.desktop, "Center");
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

