/*
 * MainGUIView.java
 */

package org.mobicents.media.server.testsuite.gui;

import java.io.File;
import java.util.Vector;
import javax.sdp.Attribute;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.sdp.SdpFactory;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.AbstractTestCase;
import org.mobicents.media.server.testsuite.general.CallDisplayInterface;
import org.mobicents.media.server.testsuite.general.ann.AnnouncementTest;
import org.mobicents.media.server.testsuite.general.file.FileUtils;
import org.mobicents.media.server.testsuite.gui.graph.RtpTrafficDialog;
/**
 * The application's main frame.
 */
public class MainGUIView extends FrameView implements CallDisplayInterface{

    public MainGUIView(SingleFrameApplication app) {
        super(app);

        initComponents();

        
        initLocalComponents();
        
        
        
        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = MainGUI.getApplication().getMainFrame();
            aboutBox = new MainGUIAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        MainGUI.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        userDialogPanel = new javax.swing.JTabbedPane();
        dataLoadPanel = new javax.swing.JPanel();
        dirLoadFileChooser = new javax.swing.JFileChooser();
        dataPanel = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        fieldLoadedDataDisplayTable = new javax.swing.JTable();
        testSetupPanel = new javax.swing.JPanel();
        jSeparator1 = new javax.swing.JSeparator();
        _labelCallDuration = new javax.swing.JLabel();
        _labelCPS = new javax.swing.JLabel();
        _labelServerAddress = new javax.swing.JLabel();
        _labelClientAddress = new javax.swing.JLabel();
        _labelCodec = new javax.swing.JLabel();
        _labelServerPort = new javax.swing.JLabel();
        _labelClientPort = new javax.swing.JLabel();
        _labelDumpDir = new javax.swing.JLabel();
        fieldCallDurrationTextField = new javax.swing.JTextField();
        fieldCPS = new javax.swing.JTextField();
        fieldServerAddress = new javax.swing.JTextField();
        fieldClientAddress = new javax.swing.JTextField();
        fieldDataDumpDir = new javax.swing.JTextField();
        fieldServerPort = new javax.swing.JTextField();
        fieldClientPort = new javax.swing.JTextField();
        fieldCodecBox = new javax.swing.JComboBox();
        jSeparator2 = new javax.swing.JSeparator();
        buttonStartTest = new javax.swing.JButton();
        buttonStopTest = new javax.swing.JButton();
        buttonIncreseDurrationBy10 = new javax.swing.JButton();
        buttonDecreaseBy10 = new javax.swing.JButton();
        buttonIncreaseCPSBy1 = new javax.swing.JButton();
        buttonDecreaseCPSBy1 = new javax.swing.JButton();
        jSeparator3 = new javax.swing.JSeparator();
        _labelOngoingCalls = new javax.swing.JLabel();
        fieldOngoingCalls = new javax.swing.JTextField();
        _labelCompletedCalls = new javax.swing.JLabel();
        _labelCalls = new javax.swing.JLabel();
        fieldCompletedCalls = new javax.swing.JTextField();
        _labelErrorCalls = new javax.swing.JLabel();
        fieldFailedCalls = new javax.swing.JTextField();
        jSeparator4 = new javax.swing.JSeparator();
        labelFileUrl = new javax.swing.JLabel();
        fieldAnnFileURL = new javax.swing.JTextField();
        _labelMaxCalls = new javax.swing.JLabel();
        fieldMaxCallNumber = new javax.swing.JTextField();
        _labelConcurrentCalls = new javax.swing.JLabel();
        fieldConcurrentCalls = new javax.swing.JTextField();
        _labelMaxFailCalls = new javax.swing.JLabel();
        fieldMaxFailCalls = new javax.swing.JTextField();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        annTestAction = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();

        mainPanel.setName("mainPanel"); // NOI18N

        userDialogPanel.setName("dialogTabbedPane"); // NOI18N

        dataLoadPanel.setName("dataLoadPanel"); // NOI18N

        dirLoadFileChooser.setFileSelectionMode(javax.swing.JFileChooser.DIRECTORIES_ONLY);
        dirLoadFileChooser.setName("dirLoadFileChooser"); // NOI18N
        dirLoadFileChooser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dirLoadFileChooserActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout dataLoadPanelLayout = new org.jdesktop.layout.GroupLayout(dataLoadPanel);
        dataLoadPanel.setLayout(dataLoadPanelLayout);
        dataLoadPanelLayout.setHorizontalGroup(
            dataLoadPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(dirLoadFileChooser, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 609, Short.MAX_VALUE)
        );
        dataLoadPanelLayout.setVerticalGroup(
            dataLoadPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(dirLoadFileChooser, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 478, Short.MAX_VALUE)
        );

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.mobicents.media.server.testsuite.gui.MainGUI.class).getContext().getResourceMap(MainGUIView.class);
        userDialogPanel.addTab(resourceMap.getString("dataLoadPanel.TabConstraints.tabTitle"), resourceMap.getIcon("dataLoadPanel.TabConstraints.tabIcon"), dataLoadPanel); // NOI18N

        dataPanel.setName("dataPanel"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        fieldLoadedDataDisplayTable.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Call Seq", "Endpoint", "Avg Jitter", "Peak Jitter", "Title 5", "Call ID"
            }
        ) {
            Class[] types = new Class [] {
                java.lang.Long.class, java.lang.String.class, java.lang.Long.class, java.lang.Long.class, java.lang.Object.class, java.lang.Object.class
            };
            boolean[] canEdit = new boolean [] {
                false, false, false, false, false, false
            };

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        fieldLoadedDataDisplayTable.setName("fieldLoadedDataDisplayTable"); // NOI18N
        fieldLoadedDataDisplayTable.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                fieldLoadedDataDisplayTableMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(fieldLoadedDataDisplayTable);

        org.jdesktop.layout.GroupLayout dataPanelLayout = new org.jdesktop.layout.GroupLayout(dataPanel);
        dataPanel.setLayout(dataPanelLayout);
        dataPanelLayout.setHorizontalGroup(
            dataPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 609, Short.MAX_VALUE)
        );
        dataPanelLayout.setVerticalGroup(
            dataPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 478, Short.MAX_VALUE)
        );

        userDialogPanel.addTab(resourceMap.getString("dataPanel.TabConstraints.tabTitle"), resourceMap.getIcon("dataPanel.TabConstraints.tabIcon"), dataPanel); // NOI18N

        testSetupPanel.setName("testSetupPanel"); // NOI18N

        jSeparator1.setName("jSeparator1"); // NOI18N

        _labelCallDuration.setText(resourceMap.getString("_labelCallDuration.text")); // NOI18N
        _labelCallDuration.setName("_labelCallDuration"); // NOI18N

        _labelCPS.setText(resourceMap.getString("_labelCPS.text")); // NOI18N
        _labelCPS.setName("_labelCPS"); // NOI18N

        _labelServerAddress.setText(resourceMap.getString("_labelServerAddress.text")); // NOI18N
        _labelServerAddress.setName("_labelServerAddress"); // NOI18N

        _labelClientAddress.setText(resourceMap.getString("_labelClientAddress.text")); // NOI18N
        _labelClientAddress.setName("_labelClientAddress"); // NOI18N

        _labelCodec.setText(resourceMap.getString("_labelCodec.text")); // NOI18N
        _labelCodec.setName("_labelCodec"); // NOI18N

        _labelServerPort.setText(resourceMap.getString("_labelServerPort.text")); // NOI18N
        _labelServerPort.setName("_labelServerPort"); // NOI18N

        _labelClientPort.setText(resourceMap.getString("_labelClientPort.text")); // NOI18N
        _labelClientPort.setName("_labelClientPort"); // NOI18N

        _labelDumpDir.setText(resourceMap.getString("_labelDumpDir.text")); // NOI18N
        _labelDumpDir.setName("_labelDumpDir"); // NOI18N

        fieldCallDurrationTextField.setText(resourceMap.getString("fieldCallDurrationTextField.text")); // NOI18N
        fieldCallDurrationTextField.setName("fieldCallDurrationTextField"); // NOI18N

        fieldCPS.setText(resourceMap.getString("fieldCPS.text")); // NOI18N
        fieldCPS.setName("fieldCPS"); // NOI18N

        fieldServerAddress.setText(resourceMap.getString("fieldServerAddress.text")); // NOI18N
        fieldServerAddress.setName("fieldServerAddress"); // NOI18N

        fieldClientAddress.setText(resourceMap.getString("fieldClientAddress.text")); // NOI18N
        fieldClientAddress.setName("fieldClientAddress"); // NOI18N

        fieldDataDumpDir.setText(resourceMap.getString("fieldDataDumpDir.text")); // NOI18N
        fieldDataDumpDir.setName("fieldDataDumpDir"); // NOI18N

        fieldServerPort.setText(resourceMap.getString("fieldServerPort.text")); // NOI18N
        fieldServerPort.setName("fieldServerPort"); // NOI18N

        fieldClientPort.setText(resourceMap.getString("fieldClientPort.text")); // NOI18N
        fieldClientPort.setName("fieldClientPort"); // NOI18N

        fieldCodecBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        fieldCodecBox.setName("fieldCodecBox"); // NOI18N

        jSeparator2.setName("jSeparator2"); // NOI18N

        buttonStartTest.setIcon(resourceMap.getIcon("buttonStartTest.icon")); // NOI18N
        buttonStartTest.setText(resourceMap.getString("buttonStartTest.text")); // NOI18N
        buttonStartTest.setEnabled(false);
        buttonStartTest.setName("buttonStartTest"); // NOI18N
        buttonStartTest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonStartTestActionPerformed(evt);
            }
        });

        buttonStopTest.setIcon(resourceMap.getIcon("buttonStopTest.icon")); // NOI18N
        buttonStopTest.setText(resourceMap.getString("buttonStopTest.text")); // NOI18N
        buttonStopTest.setName("buttonStopTest"); // NOI18N
        buttonStopTest.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonStopTestActionPerformed(evt);
            }
        });

        buttonIncreseDurrationBy10.setText(resourceMap.getString("buttonIncreseDurrationBy10.text")); // NOI18N
        buttonIncreseDurrationBy10.setName("buttonIncreseDurrationBy10"); // NOI18N
        buttonIncreseDurrationBy10.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonIncreseDurrationBy10ActionPerformed(evt);
            }
        });

        buttonDecreaseBy10.setText(resourceMap.getString("buttonDecreaseBy10.text")); // NOI18N
        buttonDecreaseBy10.setName("buttonDecreaseBy10"); // NOI18N
        buttonDecreaseBy10.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonDecreaseBy10ActionPerformed(evt);
            }
        });

        buttonIncreaseCPSBy1.setText(resourceMap.getString("buttonIncreaseCPSBy1.text")); // NOI18N
        buttonIncreaseCPSBy1.setName("buttonIncreaseCPSBy1"); // NOI18N
        buttonIncreaseCPSBy1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonIncreaseCPSBy1ActionPerformed(evt);
            }
        });

        buttonDecreaseCPSBy1.setText(resourceMap.getString("buttonDecreaseCPSBy1.text")); // NOI18N
        buttonDecreaseCPSBy1.setName("buttonDecreaseCPSBy1"); // NOI18N
        buttonDecreaseCPSBy1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                buttonDecreaseCPSBy1ActionPerformed(evt);
            }
        });

        jSeparator3.setName("jSeparator3"); // NOI18N

        _labelOngoingCalls.setText(resourceMap.getString("_labelOngoingCalls.text")); // NOI18N
        _labelOngoingCalls.setName("_labelOngoingCalls"); // NOI18N

        fieldOngoingCalls.setBackground(resourceMap.getColor("fieldOngoingCalls.background")); // NOI18N
        fieldOngoingCalls.setText(resourceMap.getString("fieldOngoingCalls.text")); // NOI18N
        fieldOngoingCalls.setEnabled(false);
        fieldOngoingCalls.setName("fieldOngoingCalls"); // NOI18N
        fieldOngoingCalls.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fieldOngoingCallsActionPerformed(evt);
            }
        });

        _labelCompletedCalls.setText(resourceMap.getString("_labelCompletedCalls.text")); // NOI18N
        _labelCompletedCalls.setName("_labelCompletedCalls"); // NOI18N

        _labelCalls.setFont(resourceMap.getFont("_labelCalls.font")); // NOI18N
        _labelCalls.setText(resourceMap.getString("_labelCalls.text")); // NOI18N
        _labelCalls.setName("_labelCalls"); // NOI18N

        fieldCompletedCalls.setBackground(resourceMap.getColor("fieldCompletedCalls.background")); // NOI18N
        fieldCompletedCalls.setText(resourceMap.getString("fieldCompletedCalls.text")); // NOI18N
        fieldCompletedCalls.setEnabled(false);
        fieldCompletedCalls.setName("fieldCompletedCalls"); // NOI18N

        _labelErrorCalls.setText(resourceMap.getString("_labelErrorCalls.text")); // NOI18N
        _labelErrorCalls.setName("_labelErrorCalls"); // NOI18N

        fieldFailedCalls.setBackground(resourceMap.getColor("fieldFailedCalls.background")); // NOI18N
        fieldFailedCalls.setText(resourceMap.getString("fieldFailedCalls.text")); // NOI18N
        fieldFailedCalls.setEnabled(false);
        fieldFailedCalls.setName("fieldFailedCalls"); // NOI18N

        jSeparator4.setName("jSeparator4"); // NOI18N

        labelFileUrl.setText(resourceMap.getString("labelFileUrl.text")); // NOI18N
        labelFileUrl.setName("labelFileUrl"); // NOI18N

        fieldAnnFileURL.setText(resourceMap.getString("fieldAnnFileURL.text")); // NOI18N
        fieldAnnFileURL.setName("fieldAnnFileURL"); // NOI18N

        _labelMaxCalls.setText(resourceMap.getString("_labelMaxCalls.text")); // NOI18N
        _labelMaxCalls.setName("_labelMaxCalls"); // NOI18N

        fieldMaxCallNumber.setText(resourceMap.getString("fieldMaxCallNumber.text")); // NOI18N
        fieldMaxCallNumber.setName("fieldMaxCallNumber"); // NOI18N

        _labelConcurrentCalls.setText(resourceMap.getString("_labelConcurrentCalls.text")); // NOI18N
        _labelConcurrentCalls.setName("_labelConcurrentCalls"); // NOI18N

        fieldConcurrentCalls.setText(resourceMap.getString("fieldConcurrentCalls.text")); // NOI18N
        fieldConcurrentCalls.setName("fieldConcurrentCalls"); // NOI18N

        _labelMaxFailCalls.setText(resourceMap.getString("_labelMaxFailCalls.text")); // NOI18N
        _labelMaxFailCalls.setName("_labelMaxFailCalls"); // NOI18N

        fieldMaxFailCalls.setText(resourceMap.getString("fieldMaxFailCalls.text")); // NOI18N
        fieldMaxFailCalls.setName("fieldMaxFailCalls"); // NOI18N

        org.jdesktop.layout.GroupLayout testSetupPanelLayout = new org.jdesktop.layout.GroupLayout(testSetupPanel);
        testSetupPanel.setLayout(testSetupPanelLayout);
        testSetupPanelLayout.setHorizontalGroup(
            testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(testSetupPanelLayout.createSequentialGroup()
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(jSeparator3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 589, Short.MAX_VALUE))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 589, Short.MAX_VALUE)
                            .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                .add(testSetupPanelLayout.createSequentialGroup()
                                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(_labelCallDuration)
                                        .add(_labelCPS)
                                        .add(_labelServerAddress))
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                        .add(fieldCallDurrationTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 108, Short.MAX_VALUE)
                                        .add(fieldCPS)
                                        .add(fieldServerAddress, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 143, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                                .add(testSetupPanelLayout.createSequentialGroup()
                                    .add(_labelClientAddress)
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(fieldMaxCallNumber, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 143, Short.MAX_VALUE)
                                        .add(org.jdesktop.layout.GroupLayout.TRAILING, fieldClientAddress, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE))
                                    .add(17, 17, 17)
                                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                        .add(_labelServerPort)
                                        .add(_labelClientPort)
                                        .add(_labelDumpDir)
                                        .add(_labelCodec)
                                        .add(_labelConcurrentCalls)
                                        .add(_labelMaxFailCalls))
                                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                        .add(fieldConcurrentCalls)
                                        .add(fieldClientPort)
                                        .add(fieldServerPort)
                                        .add(fieldDataDumpDir)
                                        .add(fieldCodecBox, 0, 136, Short.MAX_VALUE)
                                        .add(fieldMaxFailCalls))
                                    .add(59, 59, 59)))))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(jSeparator4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 589, Short.MAX_VALUE))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(_labelOngoingCalls)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(fieldOngoingCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 105, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(_labelCompletedCalls)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(fieldCompletedCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 101, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(_labelErrorCalls)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(fieldFailedCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 92, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .add(261, 261, 261)
                        .add(_labelCalls))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(buttonStartTest)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(buttonStopTest)
                        .add(22, 22, 22)
                        .add(buttonIncreseDurrationBy10)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(buttonDecreaseBy10)
                        .add(30, 30, 30)
                        .add(buttonIncreaseCPSBy1)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(buttonDecreaseCPSBy1))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(jSeparator2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 589, Short.MAX_VALUE))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(_labelMaxCalls))
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, testSetupPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(labelFileUrl)
                        .add(41, 41, 41)
                        .add(fieldAnnFileURL, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 503, Short.MAX_VALUE)))
                .addContainerGap())
        );

        testSetupPanelLayout.linkSize(new java.awt.Component[] {fieldCPS, fieldCallDurrationTextField, fieldClientAddress, fieldServerAddress}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        testSetupPanelLayout.linkSize(new java.awt.Component[] {fieldCompletedCalls, fieldFailedCalls, fieldOngoingCalls}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        testSetupPanelLayout.setVerticalGroup(
            testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(testSetupPanelLayout.createSequentialGroup()
                .add(8, 8, 8)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelCallDuration)
                            .add(fieldCallDurrationTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelCPS)
                            .add(fieldCPS, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelServerAddress)
                            .add(fieldServerAddress, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelClientAddress)
                            .add(fieldClientAddress, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                    .add(testSetupPanelLayout.createSequentialGroup()
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(fieldCodecBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(_labelCodec))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelDumpDir)
                            .add(fieldDataDumpDir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelServerPort)
                            .add(fieldServerPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(_labelClientPort)
                            .add(fieldClientPort, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(_labelMaxCalls)
                        .add(fieldMaxCallNumber, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(_labelConcurrentCalls)
                        .add(fieldConcurrentCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(fieldMaxFailCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(_labelMaxFailCalls))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(fieldAnnFileURL, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(labelFileUrl))
                .add(106, 106, 106)
                .add(jSeparator2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                        .add(buttonStartTest)
                        .add(buttonStopTest)
                        .add(buttonIncreaseCPSBy1)
                        .add(buttonDecreaseBy10)
                        .add(buttonIncreseDurrationBy10))
                    .add(buttonDecreaseCPSBy1))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(_labelCalls)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(testSetupPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(_labelOngoingCalls)
                    .add(fieldOngoingCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(_labelCompletedCalls)
                    .add(fieldCompletedCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(_labelErrorCalls)
                    .add(fieldFailedCalls, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jSeparator4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(33, Short.MAX_VALUE))
        );

        userDialogPanel.addTab(resourceMap.getString("testSetupPanel.TabConstraints.tabTitle"), resourceMap.getIcon("testSetupPanel.TabConstraints.tabIcon"), testSetupPanel); // NOI18N

        org.jdesktop.layout.GroupLayout mainPanelLayout = new org.jdesktop.layout.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(userDialogPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 614, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(userDialogPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 505, Short.MAX_VALUE)
        );

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.mobicents.media.server.testsuite.gui.MainGUI.class).getContext().getActionMap(MainGUIView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        annTestAction.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_A, java.awt.event.InputEvent.ALT_MASK));
        annTestAction.setText(resourceMap.getString("annTestAction.text")); // NOI18N
        annTestAction.setName("annTestAction"); // NOI18N
        annTestAction.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                annTestActionActionPerformed(evt);
            }
        });
        fileMenu.add(annTestAction);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setName("progressBar"); // NOI18N

        org.jdesktop.layout.GroupLayout statusPanelLayout = new org.jdesktop.layout.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statusPanelSeparator, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 614, Short.MAX_VALUE)
            .add(statusPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(statusMessageLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 440, Short.MAX_VALUE)
                .add(progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statusPanelLayout.createSequentialGroup()
                .add(statusPanelSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(statusMessageLabel)
                    .add(statusAnimationLabel)
                    .add(progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(3, 3, 3))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

    private void dirLoadFileChooserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dirLoadFileChooserActionPerformed
        // TODO add your handling code here:
        
        if(evt.getActionCommand().equals(JFileChooser.APPROVE_SELECTION))
        {
            
            try{
                File directory = this.dirLoadFileChooser.getSelectedFile();
                AbstractTestCase test = FileUtils.deserializeTestCase(directory);
                test.setCallDisplay(this, directory);
                this.buttonStartTest.setEnabled(true);
                this.userDialogPanel.setSelectedComponent(this.dataPanel);
                this.currentTest = test;
                
                this.fieldLoadedDataDisplayTable.setModel(this.currentTest.getTableModel());
                updateCallView();
            }catch(Exception e)
            {
                e.printStackTrace();
            }
        
        }
        
        
        
        
    }//GEN-LAST:event_dirLoadFileChooserActionPerformed

    private void buttonStartTestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonStartTestActionPerformed
        // TODO add your handling code here:
        try{
            this.currentTest.start();
            this.buttonStartTest.setEnabled(false);
            this.fieldCallDurrationTextField.setEnabled(false);
            this.fieldClientAddress.setEnabled(false);
            this.fieldClientPort.setEnabled(false);
            this.fieldCodecBox.setEnabled(false);
            this.fieldDataDumpDir.setEnabled(false);
            this.fieldServerAddress.setEnabled(false);
            this.fieldServerPort.setEnabled(false);
            this.fieldCPS.setEnabled(false);
            this.fieldMaxCallNumber.setEnabled(false);
            this.fieldConcurrentCalls.setEnabled(false);
            this.fieldMaxFailCalls.setEnabled(false);
            this.dirLoadFileChooser.setCurrentDirectory(new File(this.fieldDataDumpDir.getText()));
        }catch(Exception e)
        {
            e.printStackTrace();
        }
        
        
    }//GEN-LAST:event_buttonStartTestActionPerformed

    private void buttonStopTestActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonStopTestActionPerformed
        // TODO add your handling code here:
        if(this.currentTest!=null);
        try{
            
            this.currentTest.stop(false);
            this.buttonStartTest.setEnabled(true);
            this.fieldCallDurrationTextField.setEnabled(true);
            this.fieldClientAddress.setEnabled(true);
            this.fieldClientPort.setEnabled(true);
            this.fieldCodecBox.setEnabled(true);
            this.fieldDataDumpDir.setEnabled(true);
            this.fieldServerAddress.setEnabled(true);
            this.fieldServerPort.setEnabled(true);
            this.fieldCPS.setEnabled(true);
            this.fieldMaxCallNumber.setEnabled(true);
            this.fieldConcurrentCalls.setEnabled(true);
            this.fieldMaxFailCalls.setEnabled(true);
        }catch(Exception e)
        {
            e.printStackTrace();
        }
    }//GEN-LAST:event_buttonStopTestActionPerformed

    private void buttonIncreseDurrationBy10ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonIncreseDurrationBy10ActionPerformed
        // TODO add your handling code here:
        long l = Long.valueOf(this.fieldCallDurrationTextField.getText());
        l+=10;
        this.fieldCallDurrationTextField.setText(l+"");
        if(this.currentTest!=null)
         {
             this.currentTest.onCallLengthChange();
         }
    }//GEN-LAST:event_buttonIncreseDurrationBy10ActionPerformed

    private void buttonDecreaseBy10ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonDecreaseBy10ActionPerformed
        // TODO add your handling code here:
         long l = Long.valueOf(this.fieldCallDurrationTextField.getText());
        l-=10;
        if(l<5)
        {
            l=10;
        }
         this.fieldCallDurrationTextField.setText(l+"");
          if(this.currentTest!=null)
         {
             this.currentTest.onCallLengthChange();
         }
    }//GEN-LAST:event_buttonDecreaseBy10ActionPerformed

    private void buttonIncreaseCPSBy1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonIncreaseCPSBy1ActionPerformed
        // TODO add your handling code here:
         long l = Long.valueOf(this.fieldCPS.getText())+1;
         this.fieldCPS.setText(""+l);
         if(this.currentTest!=null)
         {
             this.currentTest.onCPSChange();
         }
         
         
    }//GEN-LAST:event_buttonIncreaseCPSBy1ActionPerformed

    private void buttonDecreaseCPSBy1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_buttonDecreaseCPSBy1ActionPerformed
        // TODO add your handling code here:
         long l = Long.valueOf(this.fieldCPS.getText())-1;
         if(l<0)
             l=0;
         this.fieldCPS.setText(""+l);
         if(this.currentTest!=null)
         {
             this.currentTest.onCPSChange();
         }
    }//GEN-LAST:event_buttonDecreaseCPSBy1ActionPerformed

    private void initLocalComponents() {
        this.fieldCodecBox.removeAllItems();
        for(String s: _COMBO_BOX_VALUES)
            this.fieldCodecBox.addItem(s);
        this.dirLoadFileChooser.setCurrentDirectory(new File("./"));
        File wavFile = new File("target/audio/ulaw_13s.wav");
        this.fieldAnnFileURL.setText(wavFile.toURI().toString());
    }

    private void annTestActionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_annTestActionActionPerformed
        // TODO add your handling code here:
        
        try{
            if(this.currentTest!=null)
            {
                this.currentTest.stop(true);
            }
        
            this.currentTest= new AnnouncementTest();
            this.currentTest.setCallDisplay(this);
            this.buttonStartTest.setEnabled(true);
        }catch(Exception e)
        {
            
        }
}//GEN-LAST:event_annTestActionActionPerformed

    private void fieldLoadedDataDisplayTableMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fieldLoadedDataDisplayTableMouseClicked
       
        Long seq = (Long) this.fieldLoadedDataDisplayTable.getValueAt(this.fieldLoadedDataDisplayTable.getSelectedRow(), 0);
        AbstractCall callToDisplay = this.currentTest.getCallBySequence(seq);
        RtpTrafficDialog dialog = new RtpTrafficDialog(this.getFrame(), true, callToDisplay);        
        dialog.setVisible(true);
  
}//GEN-LAST:event_fieldLoadedDataDisplayTableMouseClicked

    private void fieldOngoingCallsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fieldOngoingCallsActionPerformed
        // TODO add your handling code here:
    }//GEN-LAST:event_fieldOngoingCallsActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel _labelCPS;
    private javax.swing.JLabel _labelCallDuration;
    private javax.swing.JLabel _labelCalls;
    private javax.swing.JLabel _labelClientAddress;
    private javax.swing.JLabel _labelClientPort;
    private javax.swing.JLabel _labelCodec;
    private javax.swing.JLabel _labelCompletedCalls;
    private javax.swing.JLabel _labelConcurrentCalls;
    private javax.swing.JLabel _labelDumpDir;
    private javax.swing.JLabel _labelErrorCalls;
    private javax.swing.JLabel _labelMaxCalls;
    private javax.swing.JLabel _labelMaxFailCalls;
    private javax.swing.JLabel _labelOngoingCalls;
    private javax.swing.JLabel _labelServerAddress;
    private javax.swing.JLabel _labelServerPort;
    private javax.swing.JMenuItem annTestAction;
    private javax.swing.JButton buttonDecreaseBy10;
    private javax.swing.JButton buttonDecreaseCPSBy1;
    private javax.swing.JButton buttonIncreaseCPSBy1;
    private javax.swing.JButton buttonIncreseDurrationBy10;
    private javax.swing.JButton buttonStartTest;
    private javax.swing.JButton buttonStopTest;
    private javax.swing.JPanel dataLoadPanel;
    private javax.swing.JPanel dataPanel;
    private javax.swing.JFileChooser dirLoadFileChooser;
    private javax.swing.JTextField fieldAnnFileURL;
    private javax.swing.JTextField fieldCPS;
    private javax.swing.JTextField fieldCallDurrationTextField;
    private javax.swing.JTextField fieldClientAddress;
    private javax.swing.JTextField fieldClientPort;
    private javax.swing.JComboBox fieldCodecBox;
    private javax.swing.JTextField fieldCompletedCalls;
    private javax.swing.JTextField fieldConcurrentCalls;
    private javax.swing.JTextField fieldDataDumpDir;
    private javax.swing.JTextField fieldFailedCalls;
    private javax.swing.JTable fieldLoadedDataDisplayTable;
    private javax.swing.JTextField fieldMaxCallNumber;
    private javax.swing.JTextField fieldMaxFailCalls;
    private javax.swing.JTextField fieldOngoingCalls;
    private javax.swing.JTextField fieldServerAddress;
    private javax.swing.JTextField fieldServerPort;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JLabel labelFileUrl;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    private javax.swing.JPanel testSetupPanel;
    private javax.swing.JTabbedPane userDialogPanel;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;
    
    
    //Some custom methods;
    private AbstractTestCase currentTest;

    private static Map<String,Vector<Attribute>> attributerMap = new HashMap<String,Vector<Attribute>>();
    private static final String[] _COMBO_BOX_VALUES = new String[]{"ULAW","ALAW"};
    
    static
    {
        SdpFactory sdpFactory  = SdpFactory.getInstance();
        Vector attributes = new Vector();
        attributes.add(sdpFactory.createAttribute("rtpmap", "0 pcmu/8000"));
        attributerMap.put(_COMBO_BOX_VALUES[0],attributes);
        
        attributes = new Vector();
        attributes.add(sdpFactory.createAttribute("rtpmap", "8 pcma/8000"));
        attributerMap.put(_COMBO_BOX_VALUES[1],attributes);
        
        
//        attributes = new Vector();
//        attributes.add(sdpFactory.createAttribute("rtpmap", "Speex"));
//        attributerMap.put(_COMBO_BOX_VALUES[2],attributes);
        
        
    }
    public String getLocalAddress() {
        return this.fieldClientAddress.getText();
    }

    public String getRemoteAddress() {
        return this.fieldServerAddress.getText();
    }

    public int getLocalPort() {
       return Integer.valueOf(this.fieldClientPort.getText());
    }

    public int getRemotePort() {
        return Integer.valueOf(this.fieldServerPort.getText());
    }

    public int getCallDuration() {
        try{
            return Integer.valueOf(this.fieldCallDurrationTextField.getText());
        }catch(NumberFormatException nfe)
        {
            nfe.printStackTrace();
            return _DEFAULT_CALL_DURATION;
        }
    }

    public int getCPS() {
        try {
            return Integer.valueOf(this.fieldCPS.getText());
        } catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return _DEFAULT_CPS;
        }
    }

    public Vector<Attribute> getCodecs() {
        return attributerMap.get(this.fieldCodecBox.getSelectedItem());
    }

    public int getMaxConcurrentCalls() {
         return Integer.valueOf(this.fieldConcurrentCalls.getText());
    }

    public long getMaxCalls() {
       return Long.valueOf(this.fieldMaxCallNumber.getText());
    }
     public int getMaxFailCalls() {
       return Integer.valueOf(this.fieldMaxFailCalls.getText());
    }
    public void updateCallView() {
        JFrame fm = this.getFrame();
        fm.invalidate();
        if(this.currentTest!=null)
        {
            this.fieldOngoingCalls.setText(this.currentTest.getOngoingCallNumber()+"");
            this.fieldFailedCalls.setText(this.currentTest.getErrorCallNumber()+"");
            this.fieldCompletedCalls.setText(this.currentTest.getCompletedCallNumber()+"");
        }
        
        fm.validate();
    }

    public File getDefaultDataDumpDirectory() {
        return new File(this.fieldDataDumpDir.getText());
    }

    public String getFileURL() {
        return this.fieldAnnFileURL.getText();
    }

    
    
}
