/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general;

import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.Notify;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sdp.Attribute;
import javax.sdp.SdpFactory;
import org.mobicents.media.server.testsuite.general.AbstractCall;
import org.mobicents.media.server.testsuite.general.CallDisplayInterface;
import org.mobicents.media.server.testsuite.general.CallState;
import org.mobicents.media.server.testsuite.general.NamedThreadFactory;
import org.mobicents.media.server.testsuite.general.TestState;
import org.mobicents.media.server.testsuite.general.file.FileUtils;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketFactory;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketFactoryImpl;
import org.mobicents.media.server.testsuite.gui.ext.CallStateTableModel;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;
import org.mobicents.mgcp.stack.JainMgcpStackImpl;
import org.mobicents.mgcp.stack.JainMgcpStackProviderImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTestCase
implements JainMgcpExtendedListener,
Runnable,
Serializable {
    protected transient Logger logger = Logger.getLogger(this.getClass().getName());
    private TestState testState = TestState.Stoped;
    public static final transient String _CASE_FILE = "testcase.bin";
    public static final transient String _COLLECTIVE_CASE_FILE = "graph.txt";
    public static final String _LINE_SEPARATOR;
    public static final int _TURN_OFF_BOUNDRY = -1;
    protected transient SdpFactory sdpFactory;
    protected transient CallDisplayInterface callDisplay;
    protected Map<Long, AbstractCall> callSequenceToCall;
    protected transient CallStateTableModel model;
    protected InetAddress clientTestNodeAddress;
    protected InetAddress serverJbossBindAddress;
    protected long testTimesTamp = System.currentTimeMillis();
    protected transient File testDumpDirectory;
    protected final transient ScheduledExecutorService executors;
    protected transient ScheduledFuture callCreatorTask;
    protected transient ScheduledFuture gracefulStopTask;
    protected final transient ScheduledExecutorService timeGuard;
    protected long ongoingCallNumber;
    protected long errorCallNumber;
    protected long completedCallNumber;
    protected long totalCalls;
    protected long maxErrorCallNumber;
    protected transient RtpSocketFactory socketFactory;
    protected transient JainMgcpStackImpl stack;
    protected transient JainMgcpStackProviderImpl provider;
    protected transient Map<Integer, AbstractCall> mgcpTransactionToProxy = new HashMap<Integer, AbstractCall>();
    protected transient Map<String, AbstractCall> requestIdIdToProxy = new HashMap<String, AbstractCall>();

    public AbstractTestCase() {
        this.callSequenceToCall = new HashMap<Long, AbstractCall>();
        AbstractCall.resetSequence();
        NamedThreadFactory executorsThreadFactory = new NamedThreadFactory("ExecutorsTestCaseFactory");
        NamedThreadFactory timeGuardThreadFactory = new NamedThreadFactory("GuardThreadFactoryTestCaseFactory");
        this.executors = Executors.newScheduledThreadPool(3, executorsThreadFactory);
        this.timeGuard = Executors.newScheduledThreadPool(5, timeGuardThreadFactory);
    }

    public AbstractTestCase(CallDisplayInterface cdi) throws IllegalStateException, SocketException, IOException {
        this.setCallDisplay(cdi);
        this.model = new CallStateTableModel(this.callSequenceToCall);
        AbstractCall.resetSequence();
        NamedThreadFactory executorsThreadFactory = new NamedThreadFactory("ExecutorsTestCaseFactory");
        NamedThreadFactory timeGuardThreadFactory = new NamedThreadFactory("GuardThreadFactoryTestCaseFactory");
        this.executors = Executors.newScheduledThreadPool(3, executorsThreadFactory);
        this.timeGuard = Executors.newScheduledThreadPool(5, timeGuardThreadFactory);
        this.init();
    }

    private void init() throws SocketException, IOException {
        if (this.socketFactory == null) {
            this.socketFactory = new RtpSocketFactoryImpl();
        }
        if (this.socketFactory != null) {
            this.socketFactory.setBindAddress(this.callDisplay.getLocalAddress());
            this.socketFactory.setFormatMap(this.callDisplay.getCodecs());
            this.socketFactory.start();
        }
    }

    protected void incrementOngoignCall() {
        ++this.ongoingCallNumber;
        ++this.totalCalls;
    }

    protected void decrementOngoingCall() {
        --this.ongoingCallNumber;
    }

    protected void incrementErrorCall() {
        ++this.errorCallNumber;
    }

    protected void incrementCompletedCall() {
        ++this.completedCallNumber;
    }

    public long getTestTimeStamp() {
        return this.testTimesTamp;
    }

    public InetAddress getClientTestNodeAddress() {
        return this.clientTestNodeAddress;
    }

    public InetAddress getServerJbossBindAddress() {
        return this.serverJbossBindAddress;
    }

    public CallDisplayInterface getCallDisplayInterface() {
        return this.callDisplay;
    }

    public AbstractCall getCallBySequence(Long seq) {
        return this.callSequenceToCall.get(seq);
    }

    public void callStateChanged(AbstractCall c) {
        CallState callState = c.getState();
        if (callState == CallState.INITIAL) {
            this.incrementOngoignCall();
        } else if (callState == CallState.ENDED) {
            this.decrementOngoingCall();
            this.incrementCompletedCall();
            this.checkForCallInit();
        } else if (callState == CallState.IN_ERROR) {
            this.decrementOngoingCall();
            this.incrementErrorCall();
            this.checkForCallInit();
        }
        this.callDisplay.updateCallView();
        if (this.testState == TestState.Terminating && this.getOngoingCallNumber() == 0L) {
            this.stop(false);
        }
    }

    public CallStateTableModel getTableModel() {
        return this.model;
    }

    public long getCompletedCallNumber() {
        return this.completedCallNumber;
    }

    public long getErrorCallNumber() {
        return this.errorCallNumber;
    }

    public long getOngoingCallNumber() {
        return this.ongoingCallNumber;
    }

    public void setMaxErrorCallNumber(long v) {
        this.maxErrorCallNumber = v;
    }

    public long getTotalCallNumber() {
        return this.totalCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean onGracefull) {
        TestState testState = this.testState;
        synchronized (testState) {
            switch (this.testState) {
                case Terminating: {
                    if (!onGracefull) {
                        return;
                    }
                    try {
                        if (this.provider != null) {
                            try {
                                this.provider.removeJainMgcpListener((JainMgcpListener)this);
                                this.stack.deleteProvider((JainMgcpProvider)this.provider);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.stack != null) {
                            try {
                                this.stack.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.callCreatorTask != null) {
                            this.callCreatorTask.cancel(true);
                        }
                        try {
                            for (AbstractCall call : this.callSequenceToCall.values()) {
                                if (call.getState() != CallState.ESTABILISHED && call.getState() != CallState.INITIAL) continue;
                                call.stop();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        try {
                            this.socketFactory.stop();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.serialize();
                        this.dumpSampleTraffic();
                        break;
                    }
                    finally {
                        this.testState = TestState.Stoped;
                        this.gracefulStopTask = null;
                        if (this.timeGuard != null) {
                            this.timeGuard.shutdownNow();
                        }
                        if (this.executors != null) {
                            this.executors.shutdownNow();
                        }
                    }
                }
                case Running: {
                    this.testState = TestState.Terminating;
                    if (this.gracefulStopTask != null) break;
                    this.gracefulStopTask = this.executors.schedule(new GracefulStopTask(this), (long)(this.callDisplay.getCallDuration() + 1000), TimeUnit.MILLISECONDS);
                    break;
                }
            }
        }
    }

    public void start() throws CreateProviderException, TooManyListenersException {
        try {
            this.stop(false);
            this.clientTestNodeAddress = InetAddress.getByName(this.callDisplay.getLocalAddress());
            this.serverJbossBindAddress = InetAddress.getByName(this.callDisplay.getRemoteAddress());
            this.stack = new JainMgcpStackImpl(this.clientTestNodeAddress, this.callDisplay.getLocalPort());
            this.provider = (JainMgcpStackProviderImpl)this.stack.createProvider();
            this.provider.addJainMgcpListener((JainMgcpListener)this);
            this.testState = TestState.Running;
            this.onCPSChange();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(AbstractTestCase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public TestState getTestState() {
        return this.testState;
    }

    public RtpSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setCallDisplay(CallDisplayInterface cdi) throws IllegalStateException, SocketException, IOException {
        this.callDisplay = cdi;
        this.clientTestNodeAddress = InetAddress.getByName(this.callDisplay.getRemoteAddress());
        this.serverJbossBindAddress = InetAddress.getByName(this.callDisplay.getRemoteAddress());
        this.sdpFactory = SdpFactory.getInstance();
        this.testDumpDirectory = new File(cdi.getDefaultDataDumpDirectory(), "" + this.testTimesTamp);
        if (!this.testDumpDirectory.exists()) {
            if (!this.testDumpDirectory.mkdirs()) {
                throw new IllegalStateException("Failed to create dirs: " + this.testDumpDirectory);
            }
        } else if (!this.testDumpDirectory.isDirectory() || !this.testDumpDirectory.canWrite()) {
            throw new IllegalStateException("Failed to validate dump dir, its either not writeable or is not a directory: " + this.testDumpDirectory);
        }
        this.init();
    }

    public void setCallDisplay(CallDisplayInterface cdi, File testDumpDirectory) throws UnknownHostException, IllegalStateException {
        this.callDisplay = cdi;
        this.sdpFactory = SdpFactory.getInstance();
        this.testDumpDirectory = testDumpDirectory;
        this.model = new CallStateTableModel(this.callSequenceToCall);
        for (AbstractCall call : this.callSequenceToCall.values()) {
            call.setDumpDir(testDumpDirectory);
        }
    }

    public void onCPSChange() {
        int cps;
        if (this.testState == TestState.Stoped) {
            return;
        }
        if (this.callCreatorTask != null) {
            this.callCreatorTask.cancel(true);
        }
        if ((cps = this.getCallDisplayInterface().getCPS()) == 0) {
            return;
        }
        int delta = 1000 / this.getCallDisplayInterface().getCPS();
        this.callCreatorTask = this.executors.scheduleAtFixedRate(this, delta, delta, TimeUnit.MILLISECONDS);
    }

    public void onCallLengthChange() {
    }

    public abstract AbstractCall getNewCall();

    Vector<Attribute> getSDPAttributes() {
        return this.callDisplay.getCodecs();
    }

    public SdpFactory getSdpFactory() {
        return this.sdpFactory;
    }

    public File getTestDumpDirectory() {
        return this.testDumpDirectory;
    }

    @Override
    public void run() {
        if (this.testState == TestState.Running) {
            if (this.maxErrorCallNumber == -1L || this.errorCallNumber >= this.maxErrorCallNumber) {
                // empty if block
            }
            if (this.callDisplay.getMaxConcurrentCalls() != -1 && this.ongoingCallNumber >= (long)this.callDisplay.getMaxConcurrentCalls()) {
                return;
            }
            if (this.callDisplay.getMaxCalls() != -1L && this.totalCalls == this.callDisplay.getMaxCalls()) {
                this.stop(false);
                return;
            }
            try {
                AbstractCall c = this.getNewCall();
                this.callSequenceToCall.put(c.getSequence(), c);
                this.callStateChanged(c);
                c.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void checkForCallInit() {
        if (this.callDisplay.getMaxConcurrentCalls() != -1 && this.callDisplay.getCPS() > 0) {
            try {
                this.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JainMgcpStackProviderImpl getProvider() {
        return this.provider;
    }

    public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
        Notify notify;
        AbstractCall cp;
        if (command instanceof Notify && (cp = this.getCall((notify = (Notify)command).getRequestIdentifier().toString())) != null) {
            cp.processMgcpCommandEvent(command);
        }
    }

    public void processMgcpResponseEvent(JainMgcpResponseEvent response) {
        try {
            AbstractCall cp = this.getCall((JainMgcpEvent)response);
            if (cp != null) {
                cp.processMgcpResponseEvent(response);
            } else {
                System.err.println("NO CALL");
            }
        }
        catch (RuntimeException re) {
            re.printStackTrace();
        }
    }

    public void transactionEnded(int arg0) {
        AbstractCall cp = this.getCall(arg0);
        if (cp != null) {
            cp.transactionEnded(arg0);
        } else {
            this.logger.severe("No call proxy for txid: " + arg0);
        }
    }

    public void transactionRxTimedOut(JainMgcpCommandEvent commandTimedOut) {
        AbstractCall cp = this.getCall((JainMgcpEvent)commandTimedOut);
        if (cp != null) {
            cp.transactionRxTimedOut(commandTimedOut);
        } else {
            this.logger.severe("No call proxy for txid: " + commandTimedOut.getTransactionHandle() + " for timed out event");
        }
    }

    public void transactionTxTimedOut(JainMgcpCommandEvent commandTimeOut) {
        AbstractCall cp = this.getCall((JainMgcpEvent)commandTimeOut);
        if (cp != null) {
            cp.transactionTxTimedOut(commandTimeOut);
        } else {
            this.logger.severe("No call proxy for txid: " + commandTimeOut.getTransactionHandle() + " for timed out event2");
        }
    }

    protected AbstractCall getCall(JainMgcpEvent mgcpEvent) {
        return this.mgcpTransactionToProxy.get(mgcpEvent.getTransactionHandle());
    }

    protected AbstractCall getCall(int txID) {
        return this.mgcpTransactionToProxy.get(txID);
    }

    public void removeCall(JainMgcpEvent mgcpEvent) {
        this.removeCall(mgcpEvent.getTransactionHandle());
    }

    public void removeCall(int txID) {
        this.mgcpTransactionToProxy.remove(txID);
    }

    public void addCall(String ri, AbstractCall cp) {
        this.requestIdIdToProxy.put(ri, cp);
    }

    public void removeCall(String ri) {
        this.requestIdIdToProxy.remove(ri);
    }

    public AbstractCall getCall(String ri) {
        return this.requestIdIdToProxy.get(ri);
    }

    public void addCall(JainMgcpEvent mgcpEvent, AbstractCall cp) {
        this.mgcpTransactionToProxy.put(mgcpEvent.getTransactionHandle(), cp);
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
    }

    protected void serialize() {
        FileUtils.serializeTestCase(this);
    }

    private void writeObject(ObjectOutputStream aStream) throws IOException {
        aStream.defaultWriteObject();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dumpSampleTraffic() {
        Long seq;
        if (this.callSequenceToCall == null || this.callSequenceToCall.size() <= 0) return;
        Iterator<Long> seqIterator = this.callSequenceToCall.keySet().iterator();
        for (int index0 = this.callSequenceToCall.size() / 2; index0 > 0; --index0) {
        }
        AbstractCall call = null;
        while (call == null && seqIterator.hasNext() && ((call = this.callSequenceToCall.get(seq = seqIterator.next())).getState() == CallState.IN_ERROR || call.getState() == CallState.TIMED_OUT)) {
            call = null;
        }
        if (call != null) {
            File callDumpFile = call.getGraphDataFileName();
            FileInputStream inputChannel = null;
            FileOutputStream outputChannel = null;
            try {
                inputChannel = new FileInputStream(callDumpFile);
                outputChannel = new FileOutputStream(new File(this.getTestDumpDirectory(), _COLLECTIVE_CASE_FILE));
                outputChannel.write((this.getCallDisplayInterface().getCallDuration() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((this.getCallDisplayInterface().getCPS() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((this.getCallDisplayInterface().getMaxConcurrentCalls() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((this.getCallDisplayInterface().getMaxFailCalls() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((this.getErrorCallNumber() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((this.getCallDisplayInterface().getMaxCalls() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((this.getTotalCallNumber() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((call.getSequence() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((call.getAvgJitter() + _LINE_SEPARATOR).getBytes());
                outputChannel.write((call.getPeakJitter() + _LINE_SEPARATOR).getBytes());
                while (inputChannel.available() > 0) {
                    byte[] b = new byte[inputChannel.available()];
                    int read = inputChannel.read(b);
                    outputChannel.write(b, 0, read);
                }
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inputChannel != null) {
                    try {
                        inputChannel.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (outputChannel == null) return;
                try {
                    outputChannel.close();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (inputChannel != null) {
                    try {
                        inputChannel.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (outputChannel == null) return;
                try {
                    outputChannel.close();
                    return;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return;
            }
        }
        this.logger.severe("Failed to find call to add data to collective dump file.");
    }

    static {
        String lineSeparator;
        _LINE_SEPARATOR = lineSeparator = System.getProperty("line.separator");
    }

    private class GracefulStopTask
    implements Runnable {
        private AbstractTestCase atc;

        public GracefulStopTask(AbstractTestCase atc) {
            this.atc = atc;
        }

        public void run() {
            this.atc.stop(true);
        }
    }
}

