/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general.rtp;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.sdp.Attribute;
import org.apache.log4j.Logger;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketFactoryImpl;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RtpSocketImpl
implements RtpSocket {
    private static final transient Logger log = Logger.getLogger(RtpSocketImpl.class);
    private int localPort;
    private String localAddress;
    private int remotePort;
    String remoteAddress;
    private InetSocketAddress remoteInetSocketAddress = null;
    private Vector<Attribute> rtpMap = new Vector();
    private final List<RtpSocketListener> dataSinks = new ArrayList<RtpSocketListener>();
    private RtpSocketFactoryImpl rtpSocketFactoryImpl;
    private DatagramChannel channel;
    private DatagramSocket socket;
    private SelectionKey key;

    public RtpSocketImpl(Vector<Attribute> formatMap, RtpSocketFactoryImpl rtpSocketFactory) {
        this.rtpSocketFactoryImpl = rtpSocketFactory;
        this.rtpMap.addAll(formatMap);
        this.localAddress = this.rtpSocketFactoryImpl.getBindAddress();
    }

    @Override
    public int init(InetAddress localAddress, int lowPort, int highPort) throws SocketException, IOException {
        if (this.key != null) {
            this.key.cancel();
            this.key = null;
        }
        this.channel = DatagramChannel.open();
        this.channel.configureBlocking(false);
        this.socket = this.channel.socket();
        boolean bound = false;
        this.localAddress = localAddress.getHostAddress();
        this.localPort = lowPort;
        while (!bound) {
            try {
                InetSocketAddress bindAddress = new InetSocketAddress(localAddress, this.localPort);
                this.socket.bind(bindAddress);
                bound = true;
            }
            catch (SocketException e) {
                ++this.localPort;
                if (this.localPort <= highPort) continue;
                throw e;
            }
        }
        return this.localPort;
    }

    @Override
    public void addListener(RtpSocketListener listener) {
        this.dataSinks.add(listener);
    }

    @Override
    public void removeListener(RtpSocketListener listener) {
        this.dataSinks.remove(listener);
    }

    public void resetRtpMap() {
        this.rtpMap.clear();
        this.rtpMap.addAll(this.rtpSocketFactoryImpl.getFormatMap());
    }

    @Override
    public boolean isChannelOpen() {
        return this.channel != null && this.channel.isOpen();
    }

    @Override
    public void release() {
        this.resetRtpMap();
        if (this.socket != null) {
            this.socket.disconnect();
        }
        this.dataSinks.clear();
        this.rtpSocketFactoryImpl.releaseSocket(this);
    }

    @Override
    public void close() {
        if (this.channel != null) {
            try {
                this.channel.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setPeer(InetAddress address, int port) throws IOException {
        this.remoteAddress = address.getHostAddress();
        this.remotePort = port;
        this.remoteInetSocketAddress = new InetSocketAddress(this.remoteAddress, this.remotePort);
        this.channel.connect(this.remoteInetSocketAddress);
        this.key = this.rtpSocketFactoryImpl.registerSocket(this);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Connect RTP socket[" + this.localAddress + ":" + this.localPort + " to " + this.remoteAddress + ":" + this.remotePort));
        }
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public void notify(Exception e) {
        for (RtpSocketListener l : this.dataSinks) {
            l.error(e);
        }
    }

    @Override
    public void receive(RtpPacket rtpPacket) {
        for (RtpSocketListener l : this.dataSinks) {
            l.receive(rtpPacket);
        }
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public DatagramChannel getChannel() {
        return this.channel;
    }
}

