/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.testsuite.general.rtp;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.mobicents.media.server.testsuite.general.rtp.RtpPacket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocket;
import org.mobicents.media.server.testsuite.general.rtp.RtpSocketImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transceiver
implements Runnable {
    private int bufferSize = 8196;
    private ByteBuffer readerBuffer = ByteBuffer.allocate(this.bufferSize);
    private volatile boolean started = false;
    private HashMap<SelectionKey, RtpSocket> rtpSockets;
    private Selector readSelector;
    private List<RtpSocketImpl> newChannels = new LinkedList<RtpSocketImpl>();

    public Transceiver(HashMap<SelectionKey, RtpSocket> rtpSockets, Selector readSelector) throws SocketException, IOException {
        this.rtpSockets = rtpSockets;
        this.readSelector = readSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewChannel(RtpSocketImpl channel) {
        List<RtpSocketImpl> list = this.newChannels;
        synchronized (list) {
            this.newChannels.add(channel);
        }
    }

    public void start() {
        this.started = true;
        new Thread((Runnable)this, "RTP Transceiver").start();
    }

    public void stop() {
        this.started = false;
    }

    private void notifyError(Exception e) {
        Collection<RtpSocket> list = this.rtpSockets.values();
        for (RtpSocket s : list) {
            s.notify(e);
        }
    }

    public void send(byte[] data, int len, SocketAddress remoteAddress) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.started) {
            List<RtpSocketImpl> list = this.newChannels;
            synchronized (list) {
                try {
                    for (RtpSocketImpl rtpSocketImpl : this.newChannels) {
                        SelectionKey key = rtpSocketImpl.getChannel().register(this.readSelector, 1);
                        rtpSocketImpl.setSelectionKey(key);
                        this.rtpSockets.put(key, rtpSocketImpl);
                    }
                }
                catch (ClosedChannelException e) {
                    e.printStackTrace();
                }
                this.newChannels.clear();
            }
            try {
                this.readSelector.select(2L);
                long receiveStamp = System.currentTimeMillis();
                Set<SelectionKey> keys = this.readSelector.selectedKeys();
                for (SelectionKey sk : keys) {
                    try {
                        DatagramChannel channel;
                        RtpSocket socket = this.rtpSockets.get(sk);
                        if (socket == null || (channel = socket.getChannel()) == null || !socket.isChannelOpen() || channel != null && !channel.isConnected()) continue;
                        int i = channel.read(this.readerBuffer);
                        this.readerBuffer.flip();
                        if (i > 0) {
                            RtpPacket rtpPacket = new RtpPacket(this.readerBuffer);
                            rtpPacket.setTime(new Date(receiveStamp));
                            socket.receive(rtpPacket);
                        }
                        this.readerBuffer.clear();
                    }
                    catch (IOException e) {
                        if (!this.started) continue;
                        this.notifyError(e);
                    }
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

