/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.resources;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.Logger;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ComponentPropertiesPanel;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.common.Title;
import org.mobicents.slee.container.management.console.client.components.ComponentsServiceAsync;
import org.mobicents.slee.container.management.console.client.components.info.ComponentInfo;
import org.mobicents.slee.container.management.console.client.components.info.ResourceAdaptorInfo;
import org.mobicents.slee.container.management.console.client.resources.ResourceAdaptorEntityInfo;
import org.mobicents.slee.container.management.console.client.resources.ResourceAdaptorEntityPanel;
import org.mobicents.slee.container.management.console.client.resources.ResourceAdaptorPanel;
import org.mobicents.slee.container.management.console.client.resources.ResourceServiceAsync;

public class ResourceAdaptorPanel
extends Composite {
    private ComponentsServiceAsync componentsService = ServerConnection.componentsService;
    private ResourceServiceAsync resourceService = ServerConnection.resourceServiceAsync;
    private static final int ROW_COMPONENT_INFO = 0;
    private static final int ROW_ENTITY_TITLE = 1;
    private static final int ROW_ENTITY_LIST = 2;
    private static final int ROW_ENTITY_CREATE = 3;
    private ControlContainer rootPanel = new ControlContainer();
    private BrowseContainer browseContainer;
    private String resourceAdaptorID;
    private ResourceAdaptorInfo resourceAdaptorInfo;
    private ResourceAdaptorEntityInfo[] resourceAdaptorEntityInfos;

    public ResourceAdaptorPanel(BrowseContainer browseContainer, String resourceAdaptorID) {
        this.initWidget((Widget)this.rootPanel);
        this.browseContainer = browseContainer;
        this.resourceAdaptorID = resourceAdaptorID;
        this.refreshData();
    }

    private void refreshData() {
        this.refreshResourceAdaptorProperties();
        ControlContainer entitiesTitlePanel = new ControlContainer();
        entitiesTitlePanel.setWidth("");
        entitiesTitlePanel.setWidget(0, 0, (Widget)new Image("images/resources.entities.gif"));
        entitiesTitlePanel.getCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_BOTTOM);
        entitiesTitlePanel.setWidget(0, 1, (Widget)new Title("Resource adaptor entities", 2));
        this.rootPanel.setWidget(1, 0, (Widget)entitiesTitlePanel);
        this.refreshResourceAdaptorEntities();
        this.setCreateEntityPanel();
    }

    private void refreshResourceAdaptorProperties() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.componentsService.getComponentInfo(this.resourceAdaptorID, (AsyncCallback)callback);
    }

    private void setResourceAdaptorProperties() {
        ComponentPropertiesPanel componentPropertiesPanel = new ComponentPropertiesPanel((ComponentInfo)this.resourceAdaptorInfo);
        this.rootPanel.setWidget(0, 0, (Widget)componentPropertiesPanel);
    }

    private void refreshResourceAdaptorEntities() {
        2 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceService.getResourceAdaptorEntityInfos(this.resourceAdaptorID, (AsyncCallback)callback);
    }

    private void setResourceAdaptorEntities() {
        if (this.resourceAdaptorEntityInfos.length == 0) {
            this.rootPanel.setWidget(2, 0, (Widget)new Label("(No resource adaptor entity)"));
            return;
        }
        ListPanel entityPanel = new ListPanel();
        entityPanel.setHeader(1, "Name");
        entityPanel.setHeader(2, "State");
        entityPanel.setHeader(3, "Actions");
        entityPanel.setHeader(4, "");
        entityPanel.setColumnWidth(1, "100%");
        for (int i = 0; i < this.resourceAdaptorEntityInfos.length; ++i) {
            String entityName = this.resourceAdaptorEntityInfos[i].getName();
            entityPanel.setCell(i, 0, (Widget)new Image("images/resources.entity.gif"));
            Hyperlink nameLink = new Hyperlink(entityName, entityName);
            nameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            entityPanel.setCell(i, 1, (Widget)nameLink);
            entityPanel.setCellText(i, 2, this.resourceAdaptorEntityInfos[i].getState());
            if (this.resourceAdaptorEntityInfos[i].getState().equals("ACTIVE")) {
                Hyperlink deactivateLink = new Hyperlink("deactivate", "deactivate");
                deactivateLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                entityPanel.setCell(i, 3, (Widget)deactivateLink);
            } else if (this.resourceAdaptorEntityInfos[i].getState().equals("INACTIVE")) {
                Hyperlink activateLink = new Hyperlink("activate", "activate");
                activateLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                entityPanel.setCell(i, 3, (Widget)activateLink);
            }
            Hyperlink removeLink = new Hyperlink("remove", "remove");
            removeLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            entityPanel.setCell(i, 4, (Widget)removeLink);
        }
        this.rootPanel.setWidget(2, 0, (Widget)entityPanel);
    }

    private void onEntityName(String entityName) {
        ResourceAdaptorEntityPanel resourceAdaptorEntityPanel = new ResourceAdaptorEntityPanel(this.browseContainer, entityName);
        this.browseContainer.add(entityName, (Widget)resourceAdaptorEntityPanel);
    }

    private void onRemove(String entityName) {
        7 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceService.removeResourceAdaptorEntity(entityName, (AsyncCallback)callback);
    }

    private void onActivate(String entityName) {
        8 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceService.activateResourceAdaptorEntity(entityName, (AsyncCallback)callback);
    }

    private void onDeactivate(String entityName) {
        9 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceService.deactivateResourceAdaptorEntity(entityName, (AsyncCallback)callback);
    }

    private void setCreateEntityPanel() {
        ControlContainer createEntityPanel = new ControlContainer();
        createEntityPanel.setWidth("");
        TextBox createEntityTextBox = new TextBox();
        Button createEntityButton = new Button("Create");
        createEntityPanel.setWidget(0, 0, (Widget)new Image("images/resources.createentity.gif"));
        createEntityPanel.setWidget(0, 1, (Widget)new Label("Create entity:"));
        createEntityPanel.setWidget(0, 2, (Widget)createEntityTextBox);
        createEntityPanel.setWidget(0, 3, (Widget)createEntityButton);
        createEntityButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.rootPanel.setWidget(3, 0, (Widget)createEntityPanel);
    }

    private void createEntity(String entityName) {
        if (entityName == null || entityName.length() == 0) {
            Logger.error((String)"Specify an entity name");
            return;
        }
        11 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.resourceService.createResourceAdaptorEntity(this.resourceAdaptorID, entityName, (AsyncCallback)callback);
    }

    static /* synthetic */ ResourceAdaptorInfo access$002(ResourceAdaptorPanel x0, ResourceAdaptorInfo x1) {
        x0.resourceAdaptorInfo = x1;
        return x0.resourceAdaptorInfo;
    }

    static /* synthetic */ void access$100(ResourceAdaptorPanel x0) {
        x0.setResourceAdaptorProperties();
    }

    static /* synthetic */ ResourceAdaptorEntityInfo[] access$202(ResourceAdaptorPanel x0, ResourceAdaptorEntityInfo[] x1) {
        x0.resourceAdaptorEntityInfos = x1;
        return x1;
    }

    static /* synthetic */ void access$300(ResourceAdaptorPanel x0) {
        x0.setResourceAdaptorEntities();
    }

    static /* synthetic */ void access$400(ResourceAdaptorPanel x0, String x1) {
        x0.onEntityName(x1);
    }

    static /* synthetic */ void access$500(ResourceAdaptorPanel x0, String x1) {
        x0.onDeactivate(x1);
    }

    static /* synthetic */ void access$600(ResourceAdaptorPanel x0, String x1) {
        x0.onActivate(x1);
    }

    static /* synthetic */ void access$700(ResourceAdaptorPanel x0, String x1) {
        x0.onRemove(x1);
    }

    static /* synthetic */ void access$800(ResourceAdaptorPanel x0) {
        x0.refreshResourceAdaptorEntities();
    }

    static /* synthetic */ void access$900(ResourceAdaptorPanel x0, String x1) {
        x0.createEntity(x1);
    }

    static /* synthetic */ ResourceAdaptorInfo access$000(ResourceAdaptorPanel x0) {
        return x0.resourceAdaptorInfo;
    }
}

