/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.services;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ComponentPropertiesPanel;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.common.PropertiesPanel;
import org.mobicents.slee.container.management.console.client.components.ComponentNameClickListener;
import org.mobicents.slee.container.management.console.client.components.ComponentNameLabel;
import org.mobicents.slee.container.management.console.client.components.ComponentsServiceAsync;
import org.mobicents.slee.container.management.console.client.components.info.ComponentInfo;
import org.mobicents.slee.container.management.console.client.components.info.SbbInfo;
import org.mobicents.slee.container.management.console.client.components.info.ServiceInfo;
import org.mobicents.slee.container.management.console.client.services.SbbPanel;
import org.mobicents.slee.container.management.console.client.services.ServicePanel;
import org.mobicents.slee.container.management.console.client.services.ServicesServiceAsync;

public class ServicePanel
extends Composite
implements ComponentNameClickListener {
    ComponentsServiceAsync componentsService = ServerConnection.componentsService;
    ServicesServiceAsync servicesService = ServerConnection.servicesServiceAsync;
    private static final int ROW_COMPONENT_INFO = 0;
    private static final int ROW_SERVICE_INFO = 1;
    private static final int ROW_SBBS = 2;
    private ControlContainer rootPanel = new ControlContainer();
    private BrowseContainer browseContainer;
    private String serviceID;

    public ServicePanel(BrowseContainer browseContainer, String serviceID) {
        this.initWidget((Widget)this.rootPanel);
        this.browseContainer = browseContainer;
        this.serviceID = serviceID;
        this.refreshData();
    }

    private void refreshData() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.componentsService.getComponentInfo(this.serviceID, (AsyncCallback)callback);
        ServicesServiceAsync servicesServiceAsync = ServerConnection.servicesServiceAsync;
        callback = new /* Unavailable Anonymous Inner Class!! */;
        servicesServiceAsync.getSbbsWithinService(this.serviceID, (AsyncCallback)callback);
    }

    private void refreshServicePropertiesPanel(ServiceInfo serviceInfo) {
        ComponentPropertiesPanel componentPropertiesPanel = new ComponentPropertiesPanel((ComponentInfo)serviceInfo);
        this.rootPanel.setWidget(0, 0, (Widget)componentPropertiesPanel);
        PropertiesPanel servicePropertiesPanel = new PropertiesPanel();
        servicePropertiesPanel.add("Address profile", serviceInfo.getAddressProfileTable());
        servicePropertiesPanel.add("Resource profile", serviceInfo.getResourceInfoProfileTable());
        servicePropertiesPanel.add("Root SBB", (Widget)new ComponentNameLabel(serviceInfo.getRootSbbID(), (ComponentNameClickListener)this));
        this.rootPanel.setWidget(1, 0, (Widget)servicePropertiesPanel);
    }

    private void refreshSbbs(ComponentInfo[] sbbInfos) {
        ListPanel listPanel = new ListPanel();
        listPanel.setHeader(1, "Name");
        listPanel.setHeader(2, "Version");
        listPanel.setHeader(3, "Vendor");
        listPanel.setColumnWidth(1, "100px");
        listPanel.setColumnWidth(2, "100px");
        listPanel.setColumnWidth(3, "100%");
        for (int i = 0; i < sbbInfos.length; ++i) {
            SbbInfo sbbInfo = (SbbInfo)sbbInfos[i];
            Hyperlink sbbNameLink = new Hyperlink(sbbInfos[i].getName(), sbbInfos[i].getName());
            sbbNameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            listPanel.setCell(i, 0, (Widget)new Image("images/services.sbb.gif"));
            listPanel.setCell(i, 1, (Widget)sbbNameLink);
            listPanel.setCellText(i, 2, sbbInfos[i].getVersion());
            listPanel.setCellText(i, 3, sbbInfos[i].getVendor());
        }
        this.rootPanel.setWidget(2, 0, (Widget)listPanel);
    }

    private void onSbbName(SbbInfo sbbInfo) {
        SbbPanel sbbPanel = new SbbPanel(this.browseContainer, sbbInfo.getID());
        this.browseContainer.add(sbbInfo.getName(), (Widget)sbbPanel);
    }

    public void onClick(String id, String name) {
        SbbPanel sbbPanel = new SbbPanel(this.browseContainer, id);
        this.browseContainer.add(name, (Widget)sbbPanel);
    }

    static /* synthetic */ void access$000(ServicePanel x0, ServiceInfo x1) {
        x0.refreshServicePropertiesPanel(x1);
    }

    static /* synthetic */ void access$100(ServicePanel x0, ComponentInfo[] x1) {
        x0.refreshSbbs(x1);
    }

    static /* synthetic */ void access$200(ServicePanel x0, SbbInfo x1) {
        x0.onSbbName(x1);
    }
}

