/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.common;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.mobicents.slee.container.management.console.client.PropertiesInfo;

public class PropertiesPanel
extends Composite {
    private FlexTable rootTable = new FlexTable();
    String nameWidth = "100px";

    public PropertiesPanel() {
        this.initWidget((Widget)this.rootTable);
        this.rootTable.setStyleName("common-PropertiesPanel");
        this.rootTable.setCellSpacing(0);
        this.rootTable.setCellPadding(2);
        this.setNameWidth("100px");
    }

    public PropertiesPanel(PropertiesInfo propertiesInfo) {
        this();
        Iterator iterator = propertiesInfo.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = propertiesInfo.getProperty(name);
            this.add(name, value);
        }
    }

    private void setRowStyle(int row) {
        this.rootTable.getCellFormatter().setStyleName(row, 0, "common-PropertiesPanel-name");
        this.rootTable.getCellFormatter().setStyleName(row, 1, "common-PropertiesPanel-value");
        this.rootTable.getRowFormatter().setVerticalAlign(row, HasVerticalAlignment.ALIGN_MIDDLE);
        if (row != 0) {
            this.rootTable.getCellFormatter().addStyleName(row, 0, "common-PropertiesPanel-notfirst");
            this.rootTable.getCellFormatter().addStyleName(row, 1, "common-PropertiesPanel-notfirst");
        }
        if (row % 2 != 0) {
            this.rootTable.getCellFormatter().addStyleName(row, 0, "common-PropertiesPanel-even");
            this.rootTable.getCellFormatter().addStyleName(row, 1, "common-PropertiesPanel-even");
        }
        this.rootTable.getCellFormatter().setWidth(row, 0, this.nameWidth);
        this.rootTable.getCellFormatter().setWidth(row, 1, "");
    }

    public void add(String name, Widget[] values) {
        if (values == null || values.length == 0) {
            this.add(name, (String)null);
            return;
        }
        if (values.length == 1) {
            this.add(name, values[0]);
            return;
        }
        VerticalPanel verticalPanel = new VerticalPanel();
        for (int i = 0; i < values.length; ++i) {
            verticalPanel.add(values[i]);
        }
        this.add(name, (Widget)verticalPanel);
    }

    public void add(String name, String[] values) {
        if (values == null || values.length == 0) {
            this.add(name, (String)null);
            return;
        }
        Label[] labels = new Label[values.length];
        for (int i = 0; i < values.length; ++i) {
            labels[i] = new Label(values[i]);
        }
        this.add(name, (Widget[])labels);
    }

    public void add(String name, String value) {
        if (value == null || value.length() == 0) {
            value = "-";
        }
        this.add(name, (Widget)new Label(value));
    }

    public void add(String name, Widget value) {
        if (value == null) {
            this.add(name, (Widget)new Label("-"));
            return;
        }
        int row = this.rootTable.getRowCount();
        Label nameLabel = new Label(name);
        nameLabel.setWordWrap(false);
        this.rootTable.setWidget(row, 0, (Widget)nameLabel);
        this.rootTable.setWidget(row, 1, value);
        this.setRowStyle(row);
    }

    public void setNameWidth(String nameWidth) {
        this.nameWidth = nameWidth;
    }
}

