/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.common;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.mobicents.slee.container.management.console.client.PropertiesInfo;
import org.mobicents.slee.container.management.console.client.common.EditablePropertiesListener;

public class EditablePropertiesPanel
extends Composite {
    private VerticalPanel rootPanel = new VerticalPanel();
    private FlexTable propertiesTable = new FlexTable();
    private FlexTable buttonPanel = new FlexTable();
    private Button editButton = new Button("Edit properties");
    private Button saveButton = new Button("Save");
    private String nameWidth = "100px";
    private final int READ_MODE = 0;
    private final int WRITE_MODE = 1;
    private int mode = 0;
    private PropertiesInfo propertiesInfo;
    private EditablePropertiesListener listener;

    public EditablePropertiesPanel(PropertiesInfo propertiesInfo, EditablePropertiesListener listener) {
        this.initWidget((Widget)this.rootPanel);
        this.rootPanel.setWidth("100%");
        this.propertiesTable.setStyleName("common-PropertiesPanel");
        this.propertiesTable.setCellSpacing(0);
        this.propertiesTable.setCellPadding(2);
        this.setNameWidth("100px");
        this.buttonPanel.setCellSpacing(0);
        this.buttonPanel.setCellPadding(2);
        this.buttonPanel.setWidget(0, 0, (Widget)this.editButton);
        this.buttonPanel.setWidget(0, 1, (Widget)this.saveButton);
        this.rootPanel.add((Widget)this.propertiesTable);
        this.rootPanel.add((Widget)this.buttonPanel);
        this.editButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.saveButton.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.propertiesInfo = propertiesInfo;
        this.listener = listener;
        this.refreshGUI();
    }

    private void refreshGUI() {
        Iterator iterator = this.propertiesInfo.keySet().iterator();
        int row = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            String value = this.propertiesInfo.getProperty(name);
            if (this.mode == 0) {
                this.add(row, name, (Widget)new Label(value));
            } else {
                TextBox textBox = new TextBox();
                textBox.setText(value);
                this.add(row, name, (Widget)textBox);
            }
            ++row;
        }
        if (this.mode == 0) {
            this.editButton.setEnabled(true);
            this.saveButton.setEnabled(false);
        } else {
            this.editButton.setEnabled(false);
            this.saveButton.setEnabled(true);
        }
    }

    private String getValue(int row) {
        return ((HasText)this.propertiesTable.getWidget(row, 1)).getText();
    }

    private String getName(int row) {
        return ((HasText)this.propertiesTable.getWidget(row, 0)).getText();
    }

    private void refreshPropertiesData() {
        int size = this.propertiesInfo.size();
        for (int row = 0; row < size; ++row) {
            String name = this.getName(row);
            String value = this.getValue(row);
            this.propertiesInfo.setProperty(name, value);
        }
    }

    private void setMode(int mode) {
        this.mode = mode;
        this.refreshGUI();
    }

    private void setRowStyle(int row) {
        this.propertiesTable.getCellFormatter().setStyleName(row, 0, "common-PropertiesPanel-name");
        this.propertiesTable.getCellFormatter().setStyleName(row, 1, "common-PropertiesPanel-value");
        this.propertiesTable.getRowFormatter().setVerticalAlign(row, HasVerticalAlignment.ALIGN_MIDDLE);
        if (row != 0) {
            this.propertiesTable.getCellFormatter().addStyleName(row, 0, "common-PropertiesPanel-notfirst");
            this.propertiesTable.getCellFormatter().addStyleName(row, 1, "common-PropertiesPanel-notfirst");
        }
        if (row % 2 != 0) {
            this.propertiesTable.getCellFormatter().addStyleName(row, 0, "common-PropertiesPanel-even");
            this.propertiesTable.getCellFormatter().addStyleName(row, 1, "common-PropertiesPanel-even");
        }
        this.propertiesTable.getCellFormatter().setWidth(row, 0, this.nameWidth);
        this.propertiesTable.getCellFormatter().setWidth(row, 1, "");
    }

    private void add(int row, String name, Widget value) {
        if (value == null) {
            this.add(row, name, (Widget)new Label("-"));
            return;
        }
        Label nameLabel = new Label(name);
        nameLabel.setWordWrap(false);
        this.propertiesTable.setWidget(row, 0, (Widget)nameLabel);
        this.propertiesTable.setWidget(row, 1, value);
        this.setRowStyle(row);
    }

    public void setNameWidth(String nameWidth) {
        this.nameWidth = nameWidth;
    }

    public void onEditButton() {
        this.setMode(1);
    }

    public void onSaveButton() {
        this.refreshPropertiesData();
        this.setMode(0);
        if (this.listener != null) {
            this.listener.onSaveProperties(this.propertiesInfo);
        }
    }
}

