/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.deployableunits;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.Logger;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.Card;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.deployableunits.DeployableUnitInfo;
import org.mobicents.slee.container.management.console.client.deployableunits.DeployableUnitListPanel;
import org.mobicents.slee.container.management.console.client.deployableunits.DeployableUnitPanel;
import org.mobicents.slee.container.management.console.client.deployableunits.DeployableUnitsServiceAsync;

public class DeployableUnitListPanel
extends Composite {
    DeployableUnitsServiceAsync service = ServerConnection.deployableUnitsService;
    private BrowseContainer browseContainer;
    private ControlContainer rootPanel = new ControlContainer();
    private DeployableUnitInfo[] deployableUnitInfos;

    public DeployableUnitListPanel(BrowseContainer browseContainer, DeployableUnitInfo[] deployableUnitInfos) {
        this.browseContainer = browseContainer;
        this.deployableUnitInfos = deployableUnitInfos;
        this.initWidget((Widget)this.rootPanel);
        String title = null;
        if (deployableUnitInfos == null || deployableUnitInfos.length == 0) {
            title = "No deployable unit found";
            Logger.warning((String)"No deployable unit found");
        } else {
            title = "Deployable units (" + deployableUnitInfos.length + ")";
        }
        browseContainer.add(title, (Widget)this);
        this.setData();
    }

    private void goBack() {
        ((Card)this.browseContainer.getParent()).onShow();
    }

    private void setData() {
        ListPanel listPanel = new ListPanel();
        listPanel.setHeader(1, "Name");
        listPanel.setColumnWidth(1, "100%");
        listPanel.setHeader(2, "Actions");
        for (int i = 0; i < this.deployableUnitInfos.length; ++i) {
            DeployableUnitInfo deployableUnitInfo = this.deployableUnitInfos[i];
            listPanel.setCell(i, 0, (Widget)new Image("images/deployableunits.deployableunit.gif"));
            Hyperlink nameLink = new Hyperlink(deployableUnitInfo.getName(), deployableUnitInfo.getName());
            nameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            listPanel.setCell(i, 1, (Widget)nameLink);
            Hyperlink uninstallLink = new Hyperlink("uninstall", "uninstall");
            uninstallLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            listPanel.setCell(i, 2, (Widget)uninstallLink);
        }
        this.rootPanel.setWidget(0, 0, (Widget)listPanel);
    }

    private void onDeployableUnitName(DeployableUnitInfo deployableUnitInfo) {
        DeployableUnitPanel deployableUnitPanel = new DeployableUnitPanel(this.browseContainer, deployableUnitInfo);
        this.browseContainer.add(deployableUnitInfo.getName(), (Widget)deployableUnitPanel);
    }

    private void onUninstall(DeployableUnitInfo deployableUnitInfo) {
        3 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.uninstall(deployableUnitInfo.getID(), (AsyncCallback)callback);
    }

    static /* synthetic */ void access$000(DeployableUnitListPanel x0, DeployableUnitInfo x1) {
        x0.onDeployableUnitName(x1);
    }

    static /* synthetic */ void access$100(DeployableUnitListPanel x0, DeployableUnitInfo x1) {
        x0.onUninstall(x1);
    }

    static /* synthetic */ void access$200(DeployableUnitListPanel x0) {
        x0.goBack();
    }
}

