/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.container.management.console.client.services;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.mobicents.slee.container.management.console.client.ServerConnection;
import org.mobicents.slee.container.management.console.client.common.BrowseContainer;
import org.mobicents.slee.container.management.console.client.common.ControlContainer;
import org.mobicents.slee.container.management.console.client.common.ListPanel;
import org.mobicents.slee.container.management.console.client.services.ServiceInfoHeader;
import org.mobicents.slee.container.management.console.client.services.ServiceListPanel;
import org.mobicents.slee.container.management.console.client.services.ServicePanel;
import org.mobicents.slee.container.management.console.client.services.ServicesServiceAsync;

public class ServiceListPanel
extends Composite {
    private BrowseContainer browseContainer;
    private ServicesServiceAsync service = ServerConnection.servicesServiceAsync;
    private ControlContainer rootPanel = new ControlContainer();
    private ListPanel serviceListPanel = new ListPanel();
    private ServiceInfoHeader[] serviceInfoHeaders;
    private static final int COLUMN_ICON = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_STATE = 2;
    private static final int COLUMN_ACTIONS = 3;

    public ServiceListPanel(BrowseContainer browseContainer) {
        this.browseContainer = browseContainer;
        this.initWidget((Widget)this.rootPanel);
        this.serviceListPanel.setHeader(1, "Name");
        this.serviceListPanel.setHeader(2, "State");
        this.serviceListPanel.setHeader(3, "Actions");
        this.serviceListPanel.setColumnWidth(1, "100%");
        this.rootPanel.setWidget(0, 0, (Widget)this.serviceListPanel);
        this.refreshData();
    }

    private void refreshData() {
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.getServiceInfoHeaders((AsyncCallback)callback);
    }

    private void refreshTable() {
        if (this.serviceInfoHeaders == null || this.serviceInfoHeaders.length == 0) {
            this.serviceListPanel.emptyTable();
            this.browseContainer.setTitle((Widget)this, "No Service");
            return;
        }
        this.browseContainer.setTitle((Widget)this, "Services (" + this.serviceInfoHeaders.length + ")");
        this.serviceListPanel.emptyTable();
        for (int i = 0; i < this.serviceInfoHeaders.length; ++i) {
            ServiceInfoHeader serviceInfoHeader = this.serviceInfoHeaders[i];
            this.serviceListPanel.setCell(i, 0, (Widget)new Image("images/services.service." + serviceInfoHeader.getServiceStateInfo().getState().toLowerCase() + ".gif"));
            Hyperlink nameLink = new Hyperlink(serviceInfoHeader.getName(), serviceInfoHeader.getName());
            nameLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.serviceListPanel.setCell(i, 1, (Widget)nameLink);
            this.serviceListPanel.setCellText(i, 2, serviceInfoHeader.getServiceStateInfo().getState());
            if (serviceInfoHeader.getServiceStateInfo().getState().equals("INACTIVE")) {
                Hyperlink activateLink = new Hyperlink("activate", "activate " + serviceInfoHeader.getName());
                activateLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                this.serviceListPanel.setCell(i, 3, (Widget)activateLink);
                continue;
            }
            if (!serviceInfoHeader.getServiceStateInfo().getState().equals("ACTIVE")) continue;
            Hyperlink deactivateLink = new Hyperlink("deactivate", "deactivate " + serviceInfoHeader.getName());
            deactivateLink.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.serviceListPanel.setCell(i, 3, (Widget)deactivateLink);
        }
    }

    private void onName(ServiceInfoHeader serviceInfoHeader) {
        ServicePanel servicePanel = new ServicePanel(this.browseContainer, serviceInfoHeader.getId());
        this.browseContainer.add(serviceInfoHeader.getName(), (Widget)servicePanel);
    }

    private void onActivate(ServiceInfoHeader serviceInfoHeader) {
        5 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.activate(serviceInfoHeader.getId(), (AsyncCallback)callback);
    }

    private void onDeactivate(ServiceInfoHeader serviceInfoHeader) {
        6 callback = new /* Unavailable Anonymous Inner Class!! */;
        this.service.deactivate(serviceInfoHeader.getId(), (AsyncCallback)callback);
    }

    static /* synthetic */ ServiceInfoHeader[] access$002(ServiceListPanel x0, ServiceInfoHeader[] x1) {
        x0.serviceInfoHeaders = x1;
        return x1;
    }

    static /* synthetic */ void access$100(ServiceListPanel x0) {
        x0.refreshTable();
    }

    static /* synthetic */ void access$200(ServiceListPanel x0, ServiceInfoHeader x1) {
        x0.onName(x1);
    }

    static /* synthetic */ void access$300(ServiceListPanel x0, ServiceInfoHeader x1) {
        x0.onActivate(x1);
    }

    static /* synthetic */ void access$400(ServiceListPanel x0, ServiceInfoHeader x1) {
        x0.onDeactivate(x1);
    }

    static /* synthetic */ void access$500(ServiceListPanel x0) {
        x0.refreshData();
    }
}

