/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.plugins.library;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.mobicents.plugins.library.pojos.LibraryJar;
import org.mobicents.plugins.library.pojos.LibraryRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLibraryMojo
extends AbstractMojo {
    private LibraryRef libraryId;
    private List<LibraryRef> libraryRefs = new ArrayList<LibraryRef>();
    private List<LibraryJar> libraryJars = new ArrayList<LibraryJar>();
    private File basedir;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    protected List remoteRepos;
    private List resources;
    private String encoding;
    private List filters;
    protected ArtifactInstaller installer;
    protected ArtifactHandler artifactHandler;
    private File libraryDD;
    private File outputDirectory;
    private File targetDirectory;
    private String finalName;
    private JarArchiver jarArchiver;
    private MavenProject project;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private File defaultManifestFile;
    private boolean useDefaultManifestFile;
    private MavenProjectHelper projectHelper;
    private boolean forceCreation;

    protected final MavenProject getProject() {
        return this.project;
    }

    protected abstract String getClassifier();

    protected abstract String getType();

    protected static File getJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".jar");
    }

    protected File getDefaultManifestFile() {
        return this.defaultManifestFile;
    }

    public void execute() throws MojoExecutionException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Executing Maven JAIN SLEE 1.1 Library Plugin");
        }
        this.initialize();
        this.libraryId = this.getLibraryRef(this.project);
        if (this.libraryId == null) {
            throw new MojoExecutionException("Unable to get Library ID from pom, please verify.");
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)(this.libraryId.getName() + "#" + this.libraryId.getVendor() + "#" + this.libraryId.getVersion()));
        }
        for (Object dep : this.project.getDependencyArtifacts()) {
            MavenProject depPom;
            LibraryRef depRef;
            Artifact depArtifact = (Artifact)dep;
            String depGroupId = depArtifact.getGroupId();
            String depArtifactId = depArtifact.getArtifactId();
            String depVersion = depArtifact.getVersion();
            String depScope = depArtifact.getScope();
            if (depScope.equals("compile")) {
                this.libraryJars.add(new LibraryJar(depArtifact.getFile()));
            } else if (depScope.equals("runtime") && (depRef = this.getLibraryRef(depPom = this.getDependency(depGroupId, depArtifactId, depVersion, "pom"))) != null) {
                this.libraryRefs.add(depRef);
            }
            this.getLog().info((CharSequence)("I depend on: [" + depGroupId + "#" + depArtifactId + "#" + depVersion + "] @ " + depScope));
        }
        this.scanResources(new File("./src/main/resources/"), this.libraryJars);
        this.generateLibraryDeploymentDescritptor();
        this.copyJars();
        File libraryJar = this.createArchive();
        String classifier = this.getClassifier();
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), this.getType(), classifier, libraryJar);
        } else {
            this.getProject().getArtifact().setFile(libraryJar);
        }
        try {
            DefaultArtifact duArtifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), VersionRange.createFromVersion((String)this.project.getVersion()), "runtime", "jar", this.getClassifier(), this.artifactHandler);
            duArtifact.setFile(libraryJar);
            this.installer.install(libraryJar, (Artifact)duArtifact, this.localRepository);
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException("Cannot install library jar in local repository", (Exception)((Object)e));
        }
    }

    private void initialize() throws MojoExecutionException {
        if (this.outputDirectory == null) {
            this.outputDirectory = new File(this.basedir.getAbsolutePath(), "target");
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    private void generateLibraryDeploymentDescritptor() throws MojoExecutionException {
        File libraryDescriptorDir = new File(this.outputDirectory, "META-INF");
        if (!libraryDescriptorDir.exists()) {
            libraryDescriptorDir.mkdirs();
        }
        File libraryDD = new File(libraryDescriptorDir.getAbsolutePath(), "library-jar.xml");
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<!DOCTYPE library-jar PUBLIC \r\n\t\t\"-//Sun Microsystems, Inc.//DTD JAIN SLEE Library 1.1//EN\" \r\n\t\t\"http://java.sun.com/dtd/slee-library-jar_1_1.dtd\">\r\n\r\n<library-jar>\r\n\t<library>\r\n";
        xml = xml + this.libraryId.toXmlEntry() + "\r\n";
        for (LibraryRef libraryRef : this.libraryRefs) {
            xml = xml + libraryRef.toXmlEntryWithRef();
        }
        xml = xml + "\r\n";
        for (LibraryJar libraryJar : this.libraryJars) {
            xml = xml + libraryJar.toXmlEntry();
        }
        xml = xml + "\t</library>\r\n</library-jar>\r\n";
        this.getLog().info((CharSequence)("Generated Library descriptor: " + libraryDD.getAbsolutePath() + "\n" + xml + "\n"));
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(libraryDD));
            out.write(xml);
            out.close();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Failed to create deployment descriptor in " + libraryDD.getAbsolutePath()), (Throwable)e);
        }
        this.libraryDD = libraryDD;
    }

    private MavenProject getDependency(String depGroupId, String depArtifactId, String depVersion, String depPackaging) {
        if (depPackaging == null || depPackaging.equals("")) {
            depPackaging = "jar";
        }
        try {
            Artifact pomArtifact = this.factory.createArtifact(depGroupId, depArtifactId, depVersion, "", depPackaging);
            this.resolver.resolve(pomArtifact, this.remoteRepos, this.localRepository);
            MavenProject projectDependencyArtifactMavenProject = this.mavenProjectBuilder.buildFromRepository(pomArtifact, this.remoteRepos, this.localRepository, false);
            return projectDependencyArtifactMavenProject;
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to obtain dependency", (Throwable)e);
            return null;
        }
    }

    private LibraryRef getLibraryRef(MavenProject mavenProject) {
        String libraryDescription = null;
        for (Object pObject : mavenProject.getBuildPlugins()) {
            String libraryVersion;
            String libraryVendor;
            String libraryName;
            Plugin plugin = (Plugin)pObject;
            if (!plugin.getArtifactId().equals("maven-library-plugin")) continue;
            Xpp3Dom configuration = (Xpp3Dom)plugin.getConfiguration();
            if (configuration != null) {
                if (configuration.getChildren("library-name").length <= 0) {
                    this.getLog().error((CharSequence)"Library Name missing in plugin configuration!");
                    return null;
                }
                libraryName = configuration.getChildren("library-name")[0].getValue();
                if (configuration.getChildren("library-vendor").length <= 0) {
                    this.getLog().error((CharSequence)"Library Vendor missing in plugin configuration!");
                    return null;
                }
                libraryVendor = configuration.getChildren("library-vendor")[0].getValue();
                if (configuration.getChildren("library-version").length <= 0) {
                    this.getLog().error((CharSequence)"Library Version missing in plugin configuration!");
                    return null;
                }
                libraryVersion = configuration.getChildren("library-version")[0].getValue();
                if (configuration.getChildren("description").length > 0) {
                    libraryDescription = configuration.getChildren("description")[0].getValue();
                }
            } else {
                this.getLog().error((CharSequence)"Configuration missing in plugin!");
                return null;
            }
            return new LibraryRef(libraryName, libraryVendor, libraryVersion, libraryDescription);
        }
        return null;
    }

    private void scanResources(File file, Collection<LibraryJar> jars) {
        File[] children;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Scanning " + file.getAbsolutePath() + " ..."));
        }
        if ((children = file.listFiles()) != null) {
            for (File child : children) {
                if (!child.isDirectory() && child.getName().toLowerCase().endsWith(".jar")) {
                    jars.add(new LibraryJar(child));
                    continue;
                }
                if (!child.isDirectory()) continue;
                this.scanResources(child, jars);
            }
        }
    }

    private void copyJars() throws MojoExecutionException {
        try {
            File jarsFolder = new File(this.outputDirectory, "jars");
            if (!jarsFolder.exists()) {
                jarsFolder.mkdir();
            }
            for (LibraryJar libJar : this.libraryJars) {
                FileUtils.copyFile((File)libJar.getFile(), (File)new File(jarsFolder, libJar.getFile().getName()));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to copy jars to destination folder.", e);
        }
    }

    public File createArchive() throws MojoExecutionException {
        try {
            if (this.targetDirectory == null) {
                this.targetDirectory = new File(this.basedir.getAbsolutePath(), "target");
            }
            if (!this.targetDirectory.exists()) {
                this.targetDirectory.mkdir();
            }
            File jarFile = AbstractLibraryMojo.getJarFile(this.targetDirectory, this.finalName, this.getClassifier());
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            archiver.setOutputFile(jarFile);
            this.archive.setForced(this.forceCreation);
            archiver.getArchiver().addDirectory(this.outputDirectory);
            archiver.createArchive(this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create library jar.", e);
        }
    }
}

