/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.plugins.library;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class LibraryDeployerMojo
extends AbstractMojo {
    private static final String SCORE = new String("-");
    private static final String JAR_PREFIX = new String(".jar");
    protected MavenProject project;
    protected File targetDirectory;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;
    private ArtifactRepository deploymentRepository;
    private ArtifactDeployer deployer;
    ArtifactHandler artifactHandler;

    private void performDeploy() {
        DefaultArtifact artifact = new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), VersionRange.createFromVersion((String)this.project.getVersion()), "runtime", "jar", "", this.artifactHandler);
        String duJarName = this.project.getArtifactId() + SCORE + this.project.getVersion();
        File duFile = new File(this.targetDirectory, duJarName + JAR_PREFIX);
        try {
            this.deployer.deploy(duFile, (Artifact)artifact, this.deploymentRepository, this.deploymentRepository);
        }
        catch (ArtifactDeploymentException e) {
            this.getLog().error((CharSequence)("Cannot deploy artifact " + artifact), (Throwable)e);
        }
    }

    public void execute() throws MojoExecutionException {
        this.performDeploy();
    }

    public File getTargetDirectory() {
        return this.targetDirectory;
    }
}

