/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.net.InetAddress;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.NodeRegisterImplMBean;
import org.mobicents.tools.sip.balancer.NodeRegisterRMIStub;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRegisterImpl
implements NodeRegister,
NodeRegisterImplMBean {
    private static Logger logger = Logger.getLogger(NodeRegisterImpl.class.getCanonicalName());
    public static final int REGISTRY_PORT = 2000;
    public static final int POINTER_START = 0;
    private long nodeInfoExpirationTaskInterval = 5000L;
    private long nodeExpiration = 5100L;
    private Registry registry;
    private Timer taskTimer = new Timer();
    private TimerTask nodeExpirationTask = null;
    private AtomicInteger pointer;
    private List<SIPNode> nodes;
    private ConcurrentHashMap<String, SIPNode> gluedSessions;
    private InetAddress serverAddress = null;

    public NodeRegisterImpl(InetAddress serverAddress) throws RemoteException {
        this.serverAddress = serverAddress;
    }

    @Override
    public List<SIPNode> getGatheredInfo() {
        return this.nodes;
    }

    @Override
    public boolean startServer() {
        logger.info("Node registry starting...");
        try {
            this.nodes = new CopyOnWriteArrayList<SIPNode>();
            this.gluedSessions = new ConcurrentHashMap();
            this.pointer = new AtomicInteger(0);
            this.register(this.serverAddress);
            this.nodeExpirationTask = new NodeExpirationTimerTask();
            this.taskTimer.scheduleAtFixedRate(this.nodeExpirationTask, this.nodeInfoExpirationTaskInterval, this.nodeInfoExpirationTaskInterval);
            logger.info("Node expiration task created");
            logger.info("Node registry started");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unexpected exception while starting the registry", e);
            return false;
        }
        return true;
    }

    @Override
    public boolean stopServer() {
        logger.info("Stopping node registry...");
        boolean isDeregistered = this.deregister(this.serverAddress);
        boolean taskCancelled = this.nodeExpirationTask.cancel();
        logger.info("Node Expiration Task cancelled " + taskCancelled);
        this.nodes.clear();
        this.nodes = null;
        this.gluedSessions.clear();
        this.gluedSessions = null;
        this.pointer = new AtomicInteger(0);
        logger.info("Node registry stopped.");
        return isDeregistered;
    }

    private void register(InetAddress serverAddress) {
        try {
            this.registry = LocateRegistry.createRegistry(2000);
            this.registry.bind("SIPBalancer", new RegisterRMIStub());
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to bind due to:", e);
        }
        catch (AlreadyBoundException e) {
            throw new RuntimeException("Failed to bind due to:", e);
        }
    }

    private boolean deregister(InetAddress serverAddress) {
        try {
            this.registry.unbind("SIPBalancer");
            return UnicastRemoteObject.unexportObject(this.registry, false);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to unbind due to", e);
        }
        catch (NotBoundException e) {
            throw new RuntimeException("Failed to unbind due to", e);
        }
    }

    @Override
    public void unStickSessionFromNode(String callID) {
        this.gluedSessions.remove(callID);
    }

    @Override
    public SIPNode getNextNode() {
        int nodesSize = this.nodes.size();
        if (nodesSize < 1) {
            return null;
        }
        int index = this.pointer.getAndIncrement() % nodesSize;
        return this.nodes.get(index);
    }

    @Override
    public SIPNode stickSessionToNode(String callID) {
        SIPNode newStickyNode;
        SIPNode node = this.gluedSessions.get(callID);
        if (node == null && (newStickyNode = this.getNextNode()) != null && (node = this.gluedSessions.putIfAbsent(callID, newStickyNode)) == null) {
            node = newStickyNode;
        }
        return node;
    }

    @Override
    public SIPNode getGluedNode(String callID) {
        return this.gluedSessions.get(callID);
    }

    @Override
    public boolean isSIPNodePresent(String host, int port, String transport) {
        logger.info("checking if the node is still alive for " + host + ":" + port + "/" + transport);
        for (SIPNode node : this.nodes) {
            logger.info("node to check against " + node);
            if (!node.getIp().equals(host) || node.getPort() != port) continue;
            String[] nodeTransports = node.getTransports();
            if (nodeTransports.length > 0) {
                for (String nodeTransport : nodeTransports) {
                    if (!nodeTransport.equalsIgnoreCase(transport)) continue;
                    return true;
                }
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void handlePingInRegister(ArrayList<SIPNode> ping) {
        for (SIPNode pingNode : ping) {
            if (this.nodes.size() < 1) {
                this.nodes.add(pingNode);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("NodeExpirationTimerTask Run NSync[" + pingNode + "] added");
                }
                return;
            }
            SIPNode nodePresent = null;
            Iterator<SIPNode> nodesIterator = this.nodes.iterator();
            while (nodesIterator.hasNext() && nodePresent == null) {
                SIPNode node = nodesIterator.next();
                if (!node.equals(pingNode)) continue;
                nodePresent = node;
            }
            if (nodePresent != null) {
                nodePresent.updateTimerStamp();
                continue;
            }
            this.nodes.add(pingNode);
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.info("NodeExpirationTimerTask Run NSync[" + pingNode + "] added");
        }
    }

    @Override
    public InetAddress getAddress() {
        return this.serverAddress;
    }

    @Override
    public long getNodeExpiration() {
        return this.nodeExpiration;
    }

    @Override
    public long getNodeExpirationTaskInterval() {
        return this.nodeInfoExpirationTaskInterval;
    }

    @Override
    public void setNodeExpiration(long value) throws IllegalArgumentException {
        if (value < 150L) {
            throw new IllegalArgumentException("Value cant be less than 150");
        }
        this.nodeExpiration = value;
    }

    @Override
    public void setNodeExpirationTaskInterval(long value) {
        if (value < 150L) {
            throw new IllegalArgumentException("Value cant be less than 150");
        }
        this.nodeInfoExpirationTaskInterval = value;
    }

    class NodeExpirationTimerTask
    extends TimerTask {
        NodeExpirationTimerTask() {
        }

        public void run() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("NodeExpirationTimerTask Running");
            }
            for (SIPNode node : NodeRegisterImpl.this.nodes) {
                if (node.getTimeStamp() + NodeRegisterImpl.this.nodeExpiration < System.currentTimeMillis()) {
                    NodeRegisterImpl.this.nodes.remove(node);
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.info("NodeExpirationTimerTask Run NSync[" + node + "] removed");
                    continue;
                }
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("node time stamp : " + (node.getTimeStamp() + NodeRegisterImpl.this.nodeExpiration) + " , current time : " + System.currentTimeMillis());
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("NodeExpirationTimerTask Done");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisterRMIStub
    extends UnicastRemoteObject
    implements NodeRegisterRMIStub {
        protected RegisterRMIStub() throws RemoteException {
        }

        @Override
        public void handlePing(ArrayList<SIPNode> ping) throws RemoteException {
            NodeRegisterImpl.this.handlePingInRegister(ping);
        }
    }
}

