/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIPBalancerForwarder
implements SipListener {
    private static Logger logger = Logger.getLogger(SIPBalancerForwarder.class.getCanonicalName());
    private SipProvider internalSipProvider;
    private SipProvider externalSipProvider;
    private String myHost;
    private int myPort;
    private int myExternalPort;
    private static AddressFactory addressFactory;
    private static HeaderFactory headerFactory;
    private static MessageFactory messageFactory;
    private SipStack sipStack;
    private NodeRegister register;
    private Properties properties;
    private static final HashSet<String> dialogCreationMethods;

    public SIPBalancerForwarder(Properties properties, NodeRegister register) throws IllegalStateException {
        this.properties = properties;
        this.register = register;
    }

    public void start() {
        SipFactory sipFactory = null;
        this.sipStack = null;
        this.myHost = this.properties.getProperty("host");
        this.myPort = Integer.parseInt(this.properties.getProperty("internalPort"));
        this.myExternalPort = Integer.parseInt(this.properties.getProperty("externalPort"));
        try {
            sipFactory = SipFactory.getInstance();
            sipFactory.setPathName("gov.nist");
            this.sipStack = sipFactory.createSipStack(this.properties);
        }
        catch (PeerUnavailableException pue) {
            throw new IllegalStateException("Cant create stack due to[" + pue.getMessage() + "]", pue);
        }
        try {
            headerFactory = sipFactory.createHeaderFactory();
            addressFactory = sipFactory.createAddressFactory();
            messageFactory = sipFactory.createMessageFactory();
            ListeningPoint lp = this.sipStack.createListeningPoint(this.myHost, this.myPort, "UDP");
            this.internalSipProvider = this.sipStack.createSipProvider(lp);
            this.internalSipProvider.addSipListener((SipListener)this);
            lp = this.sipStack.createListeningPoint(this.myHost, this.myExternalPort, "UDP");
            this.externalSipProvider = this.sipStack.createSipProvider(lp);
            this.externalSipProvider.addSipListener((SipListener)this);
            this.sipStack.start();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cant create sip objects and lps due to[" + ex.getMessage() + "]", ex);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Sip Balancer started on address " + this.myHost + ", external port : " + this.myExternalPort + ", port : " + this.myPort);
        }
    }

    public void stop() {
        Iterator sipProviderIterator = this.sipStack.getSipProviders();
        try {
            while (sipProviderIterator.hasNext()) {
                ListeningPoint[] listeningPoints;
                SipProvider sipProvider = (SipProvider)sipProviderIterator.next();
                for (ListeningPoint listeningPoint : listeningPoints = sipProvider.getListeningPoints()) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Removing the following Listening Point " + listeningPoint);
                    }
                    sipProvider.removeListeningPoint(listeningPoint);
                    this.sipStack.deleteListeningPoint(listeningPoint);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Removing the sip provider");
                }
                sipProvider.removeSipListener((SipListener)this);
                this.sipStack.deleteSipProvider(sipProvider);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cant remove the listening points or sip providers", e);
        }
        this.sipStack.stop();
        this.sipStack = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Sip Balancer stopped");
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        this.register.unStickSessionFromNode(dialogTerminatedEvent.getDialog().getCallId().getCallId());
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processRequest(RequestEvent requestEvent) {
        block13: {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request originalRequest = requestEvent.getRequest();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = (Request)originalRequest.clone();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("transaction " + serverTransaction);
                logger.finest("dialog " + requestEvent.getDialog());
            }
            try {
                if (!"ACK".equals(request.getMethod()) && serverTransaction == null) {
                    serverTransaction = sipProvider.getNewServerTransaction(originalRequest);
                }
                if ("INVITE".equals(request.getMethod())) {
                    Response tryingResponse = messageFactory.createResponse(100, request);
                    serverTransaction.sendResponse(tryingResponse);
                }
                if (sipProvider == this.externalSipProvider) {
                    this.processExternalRequest(requestEvent, sipProvider, originalRequest, serverTransaction, request);
                } else {
                    this.processInternalRequest(serverTransaction, request);
                }
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the request " + request, throwable);
                if ("ACK".equalsIgnoreCase(request.getMethod())) break block13;
                try {
                    Response response = messageFactory.createResponse(500, originalRequest);
                    if (serverTransaction != null) {
                        serverTransaction.sendResponse(response);
                    } else if (sipProvider == this.externalSipProvider) {
                        this.externalSipProvider.sendResponse(response);
                    } else {
                        this.internalSipProvider.sendResponse(response);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unexpected exception while trying to send the error response for this " + request, e);
                }
            }
        }
    }

    private void processInternalRequest(ServerTransaction serverTransaction, Request request) throws ParseException, InvalidArgumentException, TransactionUnavailableException, SipException {
        if (request.getMethod().equals("INVITE") || request.getMethod().equals("SUBSCRIBE")) {
            throw new IllegalStateException("Illegal state!! unexpected dialog creating request " + request);
        }
        this.removeRouteHeadersMeantForLB(request);
        ViaHeader viaHeader = headerFactory.createViaHeader(this.myHost, this.myPort, "UDP", null);
        request.addHeader((Header)viaHeader);
        ClientTransaction ctx = this.externalSipProvider.getNewClientTransaction(request);
        serverTransaction.setApplicationData((Object)ctx);
        ctx.setApplicationData((Object)serverTransaction);
        ctx.sendRequest();
    }

    private void processExternalRequest(RequestEvent requestEvent, SipProvider sipProvider, Request originalRequest, ServerTransaction serverTransaction, Request request) throws ParseException, InvalidArgumentException, SipException, TransactionUnavailableException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("GOT EXTERNAL REQUEST:\n" + request);
        }
        ViaHeader viaHeader = headerFactory.createViaHeader(this.myHost, this.myPort, "UDP", null);
        this.decreaseMaxForwardsHeader(sipProvider, request);
        this.removeRouteHeadersMeantForLB(request);
        if (request.getMethod().equals("INVITE") || request.getMethod().equals("SUBSCRIBE")) {
            this.addLBRecordRoute(sipProvider, request);
        } else if (!request.getMethod().equals("ACK")) {
            SipURI route;
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            HashMap<String, String> parameters = null;
            boolean isSIPNodePresent = true;
            if (routeHeader != null && !(isSIPNodePresent = this.register.isSIPNodePresent((route = (SipURI)routeHeader.getAddress().getURI()).getHost(), route.getPort(), route.getTransportParam()))) {
                parameters = new HashMap<String, String>();
                Iterator routeParametersIt = route.getParameterNames();
                while (routeParametersIt.hasNext()) {
                    String routeParameterName = (String)routeParametersIt.next();
                    String routeParameterValue = route.getParameter(routeParameterName);
                    parameters.put(routeParameterName, routeParameterValue);
                }
                String callID = ((CallID)request.getHeader("Call-ID")).getCallId();
                this.register.unStickSessionFromNode(callID);
                request.removeFirst("Route");
                this.addRouteToNode(originalRequest, serverTransaction, request, parameters);
            }
        }
        String method = request.getMethod();
        if (method.equals("INVITE") || method.equals("SUBSCRIBE")) {
            this.addRouteToNode(originalRequest, serverTransaction, request, null);
        } else if (method.equals("CANCEL")) {
            this.processCancel(originalRequest, serverTransaction);
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("SENDING TO INTERNAL:" + request);
        }
        request.addHeader((Header)viaHeader);
        if ("ACK".equalsIgnoreCase(request.getMethod())) {
            this.internalSipProvider.sendRequest(request);
        } else {
            ClientTransaction ctx = this.internalSipProvider.getNewClientTransaction(request);
            serverTransaction.setApplicationData((Object)ctx);
            ctx.setApplicationData((Object)serverTransaction);
            ctx.sendRequest();
        }
    }

    private void addLBRecordRoute(SipProvider sipProvider, Request request) throws ParseException {
        SipURI sipUri = addressFactory.createSipURI(null, sipProvider.getListeningPoint("UDP").getIPAddress());
        sipUri.setPort(sipProvider.getListeningPoint("UDP").getPort());
        sipUri.setLrParam();
        Address address = addressFactory.createAddress((URI)sipUri);
        address.setURI((URI)sipUri);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ADDING RRH:" + address);
        }
        RecordRouteHeader recordRoute = headerFactory.createRecordRouteHeader(address);
        request.addHeader((Header)recordRoute);
        SipURI internalSipUri = addressFactory.createSipURI(null, this.internalSipProvider.getListeningPoint("UDP").getIPAddress());
        internalSipUri.setPort(this.internalSipProvider.getListeningPoint("UDP").getPort());
        internalSipUri.setLrParam();
        Address internalAddress = addressFactory.createAddress((URI)internalSipUri);
        internalAddress.setURI((URI)internalSipUri);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ADDING RRH:" + internalAddress);
        }
        RecordRouteHeader internalRecordRoute = headerFactory.createRecordRouteHeader(internalAddress);
        request.addHeader((Header)internalRecordRoute);
    }

    private void addRouteToNode(Request originalRequest, ServerTransaction serverTransaction, Request request, Map<String, String> parameters) throws ParseException, SipException, InvalidArgumentException {
        String callID = ((CallID)request.getHeader("Call-ID")).getCallId();
        SIPNode node = this.register.stickSessionToNode(callID);
        if (node != null) {
            SipURI routeSipUri = addressFactory.createSipURI(null, node.getIp());
            routeSipUri.setPort(node.getPort());
            routeSipUri.setLrParam();
            if (parameters != null) {
                Set<Map.Entry<String, String>> routeParameters = parameters.entrySet();
                for (Map.Entry<String, String> entry : routeParameters) {
                    routeSipUri.setParameter(entry.getKey(), entry.getValue());
                }
            }
            RouteHeader route = headerFactory.createRouteHeader(addressFactory.createAddress((URI)routeSipUri));
            request.addFirst((Header)route);
        } else {
            Response response = messageFactory.createResponse(500, originalRequest);
            serverTransaction.sendResponse(response);
        }
    }

    private void removeRouteHeadersMeantForLB(Request request) {
        SipURI routeUri;
        RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
        if (routeHeader != null && (routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost().equalsIgnoreCase(this.myHost) && (routeUri.getPort() == this.myExternalPort || routeUri.getPort() == this.myPort)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("this route header is for us removing it " + routeUri);
            }
            request.removeFirst("Route");
            routeHeader = (RouteHeader)request.getHeader("Route");
            if (routeHeader != null && (routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost().equalsIgnoreCase(this.myHost) && (routeUri.getPort() == this.myExternalPort || routeUri.getPort() == this.myPort)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("this route header is for us removing it " + routeUri);
                }
                request.removeFirst("Route");
            }
        }
    }

    private void decreaseMaxForwardsHeader(SipProvider sipProvider, Request request) throws InvalidArgumentException, ParseException, SipException {
        MaxForwardsHeader maxForwardsHeader = (MaxForwardsHeader)request.getHeader("Max-Forwards");
        if (maxForwardsHeader == null) {
            maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
            request.addHeader((Header)maxForwardsHeader);
        } else if (maxForwardsHeader.getMaxForwards() - 1 > 0) {
            maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
        } else {
            Response response = messageFactory.createResponse(483, request);
            sipProvider.sendResponse(response);
        }
    }

    private void processCancel(Request originalRequest, ServerTransaction serverTransaction) throws ParseException, SipException, InvalidArgumentException, TransactionUnavailableException {
        SIPServerTransaction inviteTransaction = ((SIPServerTransaction)serverTransaction).getCanceledInviteTransaction();
        String callID = ((CallID)originalRequest.getHeader("Call-ID")).getCallId();
        SIPNode node = this.register.getGluedNode(callID);
        if (node == null) {
            node = this.register.getNextNode();
        }
        if (node != null) {
            Response response = messageFactory.createResponse(200, originalRequest);
            response.setReasonPhrase("Cancelling");
            serverTransaction.sendResponse(response);
            ClientTransaction ctx = (ClientTransaction)inviteTransaction.getApplicationData();
            Request cancelRequest = ctx.createCancel();
            SipURI routeSipUri = addressFactory.createSipURI(null, node.getIp());
            routeSipUri.setPort(node.getPort());
            routeSipUri.setLrParam();
            RouteHeader route = headerFactory.createRouteHeader(addressFactory.createAddress((URI)routeSipUri));
            cancelRequest.addFirst((Header)route);
            ClientTransaction cancelClientTransaction = this.internalSipProvider.getNewClientTransaction(cancelRequest);
            cancelClientTransaction.sendRequest();
        } else {
            logger.severe("No node present yet to forward the request " + originalRequest);
            Response response = messageFactory.createResponse(500, originalRequest);
            serverTransaction.sendResponse(response);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        SipProvider sipProvider = (SipProvider)responseEvent.getSource();
        Response originalResponse = responseEvent.getResponse();
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        if (originalResponse.getStatusCode() == 100) {
            return;
        }
        if (clientTransaction == null) {
            return;
        }
        if (!"CANCEL".equalsIgnoreCase(((CSeqHeader)originalResponse.getHeader("CSeq")).getMethod())) {
            Response response = (Response)originalResponse.clone();
            ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
            if (viaHeader.getHost().equalsIgnoreCase(this.myHost) && (viaHeader.getPort() == this.myExternalPort || viaHeader.getPort() == this.myPort)) {
                response.removeFirst("Via");
            }
            if (sipProvider == this.internalSipProvider) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("GOT RESPONSE INTERNAL:\n" + response);
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.finest("GOT RESPONSE INTERNAL, FOR UAS REQ:\n" + response);
            }
            try {
                if (clientTransaction != null) {
                    ServerTransaction serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the response " + response + " (transaction=" + clientTransaction + " / dialog=" + responseEvent.getDialog() + "", ex);
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        ServerTransaction transaction = null;
        if (timeoutEvent.isServerTransaction()) {
            transaction = timeoutEvent.getServerTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        } else {
            transaction = timeoutEvent.getClientTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        }
        String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
        this.register.unStickSessionFromNode(callId);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        ServerTransaction transaction = null;
        if (transactionTerminatedEvent.isServerTransaction()) {
            transaction = transactionTerminatedEvent.getServerTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        } else {
            transaction = transactionTerminatedEvent.getClientTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        }
        String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
        this.register.unStickSessionFromNode(callId);
    }

    static {
        dialogCreationMethods = new HashSet(2);
        dialogCreationMethods.add("INVITE");
        dialogCreationMethods.add("SUBSCRIBE");
    }
}

