/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.lang.management.ManagementFactory;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.mobicents.tools.sip.balancer.NodeRegisterImpl;
import org.mobicents.tools.sip.balancer.SIPBalancerForwarder;

class SipBalancerShutdownHook
extends Thread {
    private static Logger logger = Logger.getLogger(SipBalancerShutdownHook.class.getCanonicalName());
    SIPBalancerForwarder forwarder;
    NodeRegisterImpl registry;
    MBeanServer server;

    public SipBalancerShutdownHook(SIPBalancerForwarder fwd, NodeRegisterImpl registry) {
        this.forwarder = fwd;
        this.registry = registry;
        this.server = ManagementFactory.getPlatformMBeanServer();
    }

    public void run() {
        logger.info("Stopping the sip forwarder");
        this.forwarder.stop();
        logger.info("Stopping the node registry");
        this.registry.stopServer();
        logger.info("Unregistering the node registry");
        try {
            ObjectName on = new ObjectName("slee:name=Balancer,type=sip");
            if (this.server.isRegistered(on)) {
                this.server.unregisterMBean(on);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

