/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.http.balancer;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.logging.Logger;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.mobicents.tools.http.balancer.HttpChannelAssocialtions;
import org.mobicents.tools.http.balancer.HttpClientPipelineFactory;
import org.mobicents.tools.http.balancer.HttpServerPipelineFactory;
import org.mobicents.tools.sip.balancer.BalancerContext;

public class HttpBalancerForwarder {
    private static final Logger logger = Logger.getLogger(HttpBalancerForwarder.class.getCanonicalName());

    public void start() {
        Integer httpPort = 2222;
        if (BalancerContext.balancerContext.properties != null) {
            String httpPortString = BalancerContext.balancerContext.properties.getProperty("httpPort", "2080");
            httpPort = Integer.parseInt(httpPortString);
        }
        logger.info("HTTP LB listening on port " + httpPort);
        HttpChannelAssocialtions.serverBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpServerPipelineFactory());
        HttpChannelAssocialtions.serverBootstrap.bind((SocketAddress)new InetSocketAddress(httpPort));
        HttpChannelAssocialtions.inboundBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpClientPipelineFactory());
    }

    public void stop() {
        HttpChannelAssocialtions.serverBootstrap.releaseExternalResources();
        HttpChannelAssocialtions.inboundBootstrap.releaseExternalResources();
    }
}

