/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.mobicents.tools.sip.balancer.BalancerAlgorithm;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultBalancerAlgorithm
implements BalancerAlgorithm {
    protected Properties properties;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public BalancerContext getBalancerContext() {
        return BalancerContext.balancerContext;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void processInternalRequest(Request request) {
    }

    @Override
    public SIPNode processHttpRequest(HttpRequest request) {
        if (BalancerContext.balancerContext.nodes.size() > 0) {
            String httpSessionId = null;
            httpSessionId = this.getUrlParameters(request.getUri()).get("jsessionid");
            if (httpSessionId == null) {
                CookieDecoder cookieDocoder = new CookieDecoder();
                String cookieString = request.getHeader("Cookie");
                if (cookieString != null) {
                    Set cookies = cookieDocoder.decode(cookieString);
                    for (Cookie c : cookies) {
                        if (!c.getName().equalsIgnoreCase("jsessionid")) continue;
                        httpSessionId = c.getValue();
                    }
                }
            }
            if (httpSessionId != null) {
                String jvmRoute;
                SIPNode node;
                int indexOfDot = httpSessionId.lastIndexOf(46);
                if (indexOfDot > 0 && indexOfDot < httpSessionId.length() && (node = BalancerContext.balancerContext.jvmRouteToSipNode.get(jvmRoute = httpSessionId.substring(indexOfDot + 1))) != null && BalancerContext.balancerContext.nodes.contains(node)) {
                    return node;
                }
                int nodeId = httpSessionId.hashCode() % BalancerContext.balancerContext.nodes.size();
                return BalancerContext.balancerContext.nodes.get(nodeId);
            }
            return BalancerContext.balancerContext.nodes.get(0);
        }
        String unavailaleHost = this.getProperties().getProperty("unavailableHost");
        if (unavailaleHost != null) {
            return new SIPNode(unavailaleHost, unavailaleHost, 0, null, null, 80, 0, null);
        }
        return null;
    }

    @Override
    public SIPNode processAssignedExternalRequest(Request request, SIPNode assignedNode) {
        return assignedNode;
    }

    private HashMap<String, String> getUrlParameters(String url) {
        String[] tokens;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = url.lastIndexOf(63);
        if (start <= 0 || url.length() <= start + 1) {
            return parameters;
        }
        url = url.substring(start + 1);
        for (String token : tokens = url.split("&")) {
            String[] params = token.split("=");
            if (params.length < 2) {
                parameters.put(token, "");
                continue;
            }
            parameters.put(params[0], params[1]);
        }
        return parameters;
    }

    @Override
    public void processInternalResponse(Response response) {
    }

    @Override
    public void processExternalResponse(Response response) {
    }

    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void nodeAdded(SIPNode node) {
    }

    @Override
    public void nodeRemoved(SIPNode node) {
    }

    @Override
    public void jvmRouteSwitchover(String fromJvmRoute, String toJvmRoute) {
    }

    @Override
    public void assignToNode(String id, SIPNode node) {
    }
}

