/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.net.InetAddress;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.NodeRegisterRMIStub;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeRegisterImpl
implements NodeRegister {
    private static Logger logger = Logger.getLogger(NodeRegisterImpl.class.getCanonicalName());
    public static final int POINTER_START = 0;
    private long nodeInfoExpirationTaskInterval = 5000L;
    private long nodeExpiration = 5100L;
    private Registry registry;
    private Timer taskTimer = new Timer();
    private TimerTask nodeExpirationTask = null;
    private InetAddress serverAddress = null;

    public NodeRegisterImpl(InetAddress serverAddress) throws RemoteException {
        this.serverAddress = serverAddress;
    }

    @Override
    public CopyOnWriteArrayList<SIPNode> getNodes() {
        return BalancerContext.balancerContext.nodes;
    }

    public boolean startRegistry(int rmiRegistryPort) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Node registry starting...");
        }
        try {
            BalancerContext.balancerContext.nodes = new CopyOnWriteArrayList();
            BalancerContext.balancerContext.jvmRouteToSipNode = new ConcurrentHashMap();
            this.register(this.serverAddress, rmiRegistryPort);
            this.nodeExpirationTask = new NodeExpirationTimerTask();
            this.taskTimer.scheduleAtFixedRate(this.nodeExpirationTask, this.nodeInfoExpirationTaskInterval, this.nodeInfoExpirationTaskInterval);
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Node expiration task created");
                logger.info("Node registry started");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unexpected exception while starting the registry", e);
            return false;
        }
        return true;
    }

    public boolean stopRegistry() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Stopping node registry...");
        }
        boolean isDeregistered = this.deregister(this.serverAddress);
        boolean taskCancelled = this.nodeExpirationTask.cancel();
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Node Expiration Task cancelled " + taskCancelled);
        }
        BalancerContext.balancerContext.nodes.clear();
        BalancerContext.balancerContext.nodes = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Node registry stopped.");
        }
        return isDeregistered;
    }

    private void register(InetAddress serverAddress, int rmiRegistryPort) {
        try {
            this.registry = LocateRegistry.createRegistry(rmiRegistryPort);
            this.registry.bind("SIPBalancer", new RegisterRMIStub());
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to bind due to:", e);
        }
        catch (AlreadyBoundException e) {
            throw new RuntimeException("Failed to bind due to:", e);
        }
    }

    private boolean deregister(InetAddress serverAddress) {
        try {
            this.registry.unbind("SIPBalancer");
            return UnicastRemoteObject.unexportObject(this.registry, false);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to unbind due to", e);
        }
        catch (NotBoundException e) {
            throw new RuntimeException("Failed to unbind due to", e);
        }
    }

    @Override
    public void unStickSessionFromNode(String callID) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("unsticked  CallId " + callID + " from node " + null);
        }
    }

    @Override
    public SIPNode stickSessionToNode(String callID, SIPNode sipNode) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("sticking  CallId " + callID + " to node " + null);
        }
        return null;
    }

    @Override
    public SIPNode getGluedNode(String callID) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("glueued node " + null + " for CallId " + callID);
        }
        return null;
    }

    @Override
    public boolean isSIPNodePresent(String host, int port, String transport) {
        return this.getNode(host, port, transport) != null;
    }

    @Override
    public SIPNode getNode(String host, int port, String transport) {
        for (SIPNode node : BalancerContext.balancerContext.nodes) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("node to check against " + node);
            }
            if (!node.getIp().equals(host) || node.getPort() != port) continue;
            String[] nodeTransports = node.getTransports();
            if (nodeTransports.length > 0) {
                for (String nodeTransport : nodeTransports) {
                    if (!nodeTransport.equalsIgnoreCase(transport)) continue;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("checking if the node is still alive for " + host + ":" + port + "/" + transport + " : true");
                    }
                    return node;
                }
                continue;
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("checking if the node is still alive for " + host + ":" + port + "/" + transport + " : true");
            }
            return node;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("checking if the node is still alive for " + host + ":" + port + "/" + transport + " : false");
        }
        return null;
    }

    @Override
    public void handlePingInRegister(ArrayList<SIPNode> ping) {
        for (SIPNode pingNode : ping) {
            if (pingNode.getJvmRoute() != null) {
                BalancerContext.balancerContext.jvmRouteToSipNode.put(pingNode.getJvmRoute(), pingNode);
            }
            if (BalancerContext.balancerContext.nodes.size() < 1) {
                BalancerContext.balancerContext.nodes.add(pingNode);
                BalancerContext.balancerContext.balancerAlgorithm.nodeAdded(pingNode);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("NodeExpirationTimerTask Run NSync[" + pingNode + "] added");
                }
                return;
            }
            SIPNode nodePresent = null;
            Iterator<SIPNode> nodesIterator = BalancerContext.balancerContext.nodes.iterator();
            while (nodesIterator.hasNext() && nodePresent == null) {
                SIPNode node = nodesIterator.next();
                if (!node.equals(pingNode)) continue;
                nodePresent = node;
            }
            if (nodePresent != null) {
                nodePresent.updateTimerStamp();
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Ping " + nodePresent.getTimeStamp());
                continue;
            }
            BalancerContext.balancerContext.nodes.add(pingNode);
            BalancerContext.balancerContext.balancerAlgorithm.nodeAdded(pingNode);
            pingNode.updateTimerStamp();
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.info("NodeExpirationTimerTask Run NSync[" + pingNode + "] added");
        }
    }

    @Override
    public void forceRemovalInRegister(ArrayList<SIPNode> ping) {
        for (SIPNode pingNode : ping) {
            if (BalancerContext.balancerContext.nodes.size() < 1) {
                BalancerContext.balancerContext.nodes.remove(pingNode);
                BalancerContext.balancerContext.balancerAlgorithm.nodeRemoved(pingNode);
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("NodeExpirationTimerTask Run NSync[" + pingNode + "] forcibly removed due to a clean shutdown of a node");
                }
                return;
            }
            boolean nodePresent = false;
            Iterator<SIPNode> nodesIterator = BalancerContext.balancerContext.nodes.iterator();
            while (nodesIterator.hasNext() && !nodePresent) {
                SIPNode node = nodesIterator.next();
                if (!node.equals(pingNode)) continue;
                nodePresent = true;
            }
            if (!nodePresent) continue;
            BalancerContext.balancerContext.nodes.remove(pingNode);
            BalancerContext.balancerContext.balancerAlgorithm.nodeRemoved(pingNode);
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.info("NodeExpirationTimerTask Run NSync[" + pingNode + "] forcibly removed due to a clean shutdown of a node. Numbers of nodes present in the balancer : " + BalancerContext.balancerContext.nodes.size());
        }
    }

    public InetAddress getAddress() {
        return this.serverAddress;
    }

    public long getNodeExpiration() {
        return this.nodeExpiration;
    }

    public long getNodeExpirationTaskInterval() {
        return this.nodeInfoExpirationTaskInterval;
    }

    public void setNodeExpiration(long value) throws IllegalArgumentException {
        if (value < 150L) {
            throw new IllegalArgumentException("Value cant be less than 150");
        }
        this.nodeExpiration = value;
    }

    public void setNodeExpirationTaskInterval(long value) {
        if (value < 150L) {
            throw new IllegalArgumentException("Value cant be less than 150");
        }
        this.nodeInfoExpirationTaskInterval = value;
    }

    @Override
    public SIPNode[] getAllNodes() {
        return BalancerContext.balancerContext.nodes.toArray(new SIPNode[0]);
    }

    @Override
    public SIPNode getNextNode() throws IndexOutOfBoundsException {
        return null;
    }

    @Override
    public void jvmRouteSwitchover(String fromJvmRoute, String toJvmRoute) {
        BalancerContext.balancerContext.balancerAlgorithm.jvmRouteSwitchover(fromJvmRoute, toJvmRoute);
    }

    class NodeExpirationTimerTask
    extends TimerTask {
        NodeExpirationTimerTask() {
        }

        public void run() {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("NodeExpirationTimerTask Running");
            }
            for (SIPNode node : BalancerContext.balancerContext.nodes) {
                if (node.getTimeStamp() + NodeRegisterImpl.this.nodeExpiration < System.currentTimeMillis()) {
                    BalancerContext.balancerContext.nodes.remove(node);
                    BalancerContext.balancerContext.balancerAlgorithm.nodeRemoved(node);
                    if (!logger.isLoggable(Level.INFO)) continue;
                    logger.info("NodeExpirationTimerTask Run NSync[" + node + "] removed");
                    continue;
                }
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.finest("node time stamp : " + (node.getTimeStamp() + NodeRegisterImpl.this.nodeExpiration) + " , current time : " + System.currentTimeMillis());
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("NodeExpirationTimerTask Done");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RegisterRMIStub
    extends UnicastRemoteObject
    implements NodeRegisterRMIStub {
        protected RegisterRMIStub() throws RemoteException {
        }

        @Override
        public void handlePing(ArrayList<SIPNode> ping) throws RemoteException {
            NodeRegisterImpl.this.handlePingInRegister(ping);
        }

        @Override
        public void forceRemoval(ArrayList<SIPNode> ping) throws RemoteException {
            NodeRegisterImpl.this.forceRemovalInRegister(ping);
        }

        @Override
        public void switchover(String fromJvmRoute, String toJvmRoute) throws RemoteException {
            NodeRegisterImpl.this.jvmRouteSwitchover(fromJvmRoute, toJvmRoute);
        }
    }
}

