/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class PersistentConsistentHashBalancerAlgorithm
extends DefaultBalancerAlgorithm {
    private static Logger logger = Logger.getLogger(PersistentConsistentHashBalancerAlgorithm.class.getCanonicalName());
    protected String sipHeaderAffinityKey;
    protected String httpAffinityKey;
    protected Cache cache;
    private Object[] nodesArray = new Object[0];
    private boolean nodesAreDirty = true;

    public PersistentConsistentHashBalancerAlgorithm() {
    }

    public PersistentConsistentHashBalancerAlgorithm(String headerName) {
        this.sipHeaderAffinityKey = headerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIPNode processExternalRequest(Request request) {
        Integer nodeIndex = this.hashHeader((Message)request);
        if (nodeIndex < 0) {
            return null;
        }
        BalancerContext balancerContext = this.getBalancerContext();
        if (this.nodesAreDirty) {
            PersistentConsistentHashBalancerAlgorithm persistentConsistentHashBalancerAlgorithm = this;
            synchronized (persistentConsistentHashBalancerAlgorithm) {
                this.syncNodes();
            }
        }
        try {
            SIPNode node = (SIPNode)this.nodesArray[nodeIndex];
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    @NodeModified
    public void modified(Event event) {
        logger.fine(event.toString());
    }

    @Override
    public synchronized void nodeAdded(SIPNode node) {
        this.addNode(node);
        this.syncNodes();
    }

    private void addNode(SIPNode node) {
        Fqn nodes = Fqn.fromString((String)"/BALANCER/NODES");
        this.cache.put(nodes, (Object)node, (Object)"");
        this.dumpNodes();
    }

    @Override
    public synchronized void nodeRemoved(SIPNode node) {
        this.dumpNodes();
    }

    private void dumpNodes() {
        logger.info("The following nodes are in cache right now:");
        for (Object object : this.nodesArray) {
            SIPNode node = (SIPNode)object;
            logger.info(node.toString() + " [ALIVE:" + this.isAlive(node) + "]");
        }
    }

    private boolean isAlive(SIPNode node) {
        return this.getBalancerContext().nodes.contains(node);
    }

    private Integer hashHeader(Message message) {
        String headerValue = null;
        headerValue = this.sipHeaderAffinityKey.equals("from.user") ? ((SipURI)((FromHeader)message.getHeader("From")).getAddress().getURI()).getUser() : (this.sipHeaderAffinityKey.equals("to.user") ? ((SipURI)((ToHeader)message.getHeader("To")).getAddress().getURI()).getUser() : ((SIPHeader)message.getHeader(this.sipHeaderAffinityKey)).getValue());
        if (this.nodesArray.length == 0) {
            throw new RuntimeException("No Application Servers registered. All servers are dead.");
        }
        int nodeIndex = this.hashAffinityKeyword(headerValue);
        if (this.isAlive((SIPNode)this.nodesArray[nodeIndex])) {
            return nodeIndex;
        }
        return -1;
    }

    HashMap<String, String> getUrlParameters(String url) {
        String[] tokens;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = url.lastIndexOf(63);
        if (start <= 0 || url.length() <= start + 1) {
            return parameters;
        }
        url = url.substring(start + 1);
        for (String token : tokens = url.split("&")) {
            String[] params = token.split("=");
            if (params.length < 2) {
                parameters.put(token, "");
                continue;
            }
            parameters.put(params[0], params[1]);
        }
        return parameters;
    }

    @Override
    public SIPNode processHttpRequest(HttpRequest request) {
        String affinityKeyword = this.getUrlParameters(request.getUri()).get(this.httpAffinityKey);
        if (affinityKeyword == null) {
            return super.processHttpRequest(request);
        }
        return (SIPNode)this.nodesArray[this.hashAffinityKeyword(affinityKeyword)];
    }

    protected int hashAffinityKeyword(String keyword) {
        int nodeIndex = Math.abs(keyword.hashCode()) % this.nodesArray.length;
        SIPNode computedNode = (SIPNode)this.nodesArray[nodeIndex];
        if (!this.isAlive(computedNode)) {
            for (int q = 0; q < this.nodesArray.length && !this.isAlive((SIPNode)this.nodesArray[nodeIndex = (nodeIndex + 1) % this.nodesArray.length]); ++q) {
            }
        }
        return nodeIndex;
    }

    @ViewChanged
    public void viewChanged(ViewChangedEvent event) {
        logger.info(event.toString());
    }

    @Override
    public void init() {
        DefaultCacheFactory cacheFactory = new DefaultCacheFactory();
        InputStream configurationInputStream = null;
        String configFile = this.getProperties().getProperty("persistentConsistentHashCacheConfiguration");
        if (configFile != null) {
            logger.info("Try to use cache configuration from " + configFile);
            try {
                configurationInputStream = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e1) {
                logger.log(Level.SEVERE, "File not found", e1);
                throw new RuntimeException(e1);
            }
        } else {
            logger.info("Using default cache settings");
            configurationInputStream = this.getClass().getClassLoader().getResourceAsStream("META-INF/PHA-balancer-cache.xml");
            if (configurationInputStream == null) {
                throw new RuntimeException("Problem loading resource META-INF/PHA-balancer-cache.xml");
            }
        }
        Cache cache = cacheFactory.createCache(configurationInputStream);
        cache.addCacheListener((Object)this);
        cache.create();
        cache.start();
        this.cache = cache;
        for (SIPNode node : this.getBalancerContext().nodes) {
            this.addNode(node);
        }
        this.syncNodes();
        this.httpAffinityKey = this.getProperties().getProperty("httpAffinityKey", "appsession");
        this.sipHeaderAffinityKey = this.getProperties().getProperty("sipHeaderAffinityKey", "Call-ID");
    }

    private void syncNodes() {
        Set nodes = this.cache.getKeys("/BALANCER/NODES");
        if (nodes != null) {
            ArrayList nodeList = new ArrayList();
            nodeList.addAll(nodes);
            Collections.sort(nodeList);
            this.nodesArray = nodeList.toArray();
        }
        this.dumpNodes();
    }
}

