/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mobicents.tools.sip.balancer.NodeRegisterImpl;
import org.mobicents.tools.sip.balancer.RouterImpl;
import org.mobicents.tools.sip.balancer.SIPBalancerForwarder;

public class RegisterTest {
    static InetAddress addr = null;
    static int registerPort;
    static int externalPort;
    static int internalPort;

    public static void main(String[] args) {
        RegisterTest.testBalancer();
    }

    private static void testBalancer() {
        Properties properties = new Properties();
        properties.setProperty("javax.sip.STACK_NAME", "SipBalancerForwarder");
        properties.setProperty("javax.sip.AUTOMATIC_DIALOG_SUPPORT", "off");
        properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "32");
        properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "logs/sipbalancerforwarderdebug.txt");
        properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "logs/sipbalancerforwarder.xml");
        properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "64");
        properties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
        properties.setProperty("gov.nist.javax.sip.CANCEL_CLIENT_TRANSACTION_CHECKED", "false");
        properties.setProperty("host", "127.0.0.1");
        properties.setProperty("internalPort", "5065");
        properties.setProperty("externalPort", "5060");
        try {
            NodeRegisterImpl reg = RegisterTest.prepareRegister();
            reg.startRegistry(2000);
            RouterImpl.setRegister(reg);
            SIPBalancerForwarder sIPBalancerForwarder = new SIPBalancerForwarder(properties, reg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static NodeRegisterImpl prepareRegister() {
        try {
            NodeRegisterImpl reg = new NodeRegisterImpl(addr);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = new ObjectName("slee:name=Balancer,type=sip");
            if (server.isRegistered(on)) {
                server.unregisterMBean(on);
            }
            server.registerMBean(reg, on);
            return reg;
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static void undoRegister(NodeRegisterImpl reg) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = new ObjectName("slee:name=Balancer,type=sip");
            server.unregisterMBean(on);
            reg.stopRegistry();
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            addr = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        registerPort = 5100;
        externalPort = 5010;
        internalPort = 5020;
    }
}

