/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.mobicents.tools.sip.balancer.BalancerRunnerMBean;
import org.mobicents.tools.sip.balancer.NodeRegisterImpl;
import org.mobicents.tools.sip.balancer.RouterImpl;
import org.mobicents.tools.sip.balancer.SIPBalancerForwarder;
import org.mobicents.tools.sip.balancer.SIPNode;
import org.mobicents.tools.sip.balancer.SipBalancerShutdownHook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalancerRunner
implements BalancerRunnerMBean {
    private static final String HOST_PROP = "host";
    private static final String RMI_REGISTRY_PORT_PROP = "rmiRegistryPort";
    private static final String JMX_HTML_ADAPTER_PORT_PROP = "jmxHtmlAdapterPort";
    public static final String SIP_BALANCER_JMX_NAME = "mobicents:type=LoadBalancer,name=LoadBalancer";
    public static final String HTML_ADAPTOR_PORT = "8000";
    public static final String REGISTRY_PORT = "2000";
    public static final String HTML_ADAPTOR_JMX_NAME = "mobicents:name=htmladapter,port=8000";
    private static Logger logger = Logger.getLogger(BalancerRunner.class.getCanonicalName());
    protected SIPBalancerForwarder fwd = null;
    protected NodeRegisterImpl reg = null;
    HtmlAdaptorServer adapter = new HtmlAdaptorServer();
    ObjectName adapterName = null;
    JMXConnectorServer cs = null;

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.fine("Insufficient args");
            throw new IllegalArgumentException("Bad args: supply configuration file location ");
        }
        String configurationFileLocation = args[0].substring("-mobicents-balancer-config=".length());
        BalancerRunner balancerRunner = new BalancerRunner();
        balancerRunner.start(configurationFileLocation);
    }

    @Override
    public void start(String configurationFileLocation) {
        File file = new File(configurationFileLocation);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("the configuration file location " + configurationFileLocation + " does not exists !");
        }
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(fileInputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to load the properties configuration file located at " + configurationFileLocation);
        }
        String ipAddress = properties.getProperty(HOST_PROP);
        InetAddress addr = null;
        try {
            addr = InetAddress.getByName(ipAddress);
        }
        catch (UnknownHostException e) {
            logger.log(Level.SEVERE, "Couldn't get the InetAddress from the host " + ipAddress, e);
            return;
        }
        int jmxHtmlPort = -1;
        String portAsString = properties.getProperty(JMX_HTML_ADAPTER_PORT_PROP, HTML_ADAPTOR_PORT);
        try {
            jmxHtmlPort = Integer.parseInt(portAsString);
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.SEVERE, "Couldn't convert jmxHtmlAdapterPort to a valid integer", nfe);
            return;
        }
        int rmiRegistryPort = -1;
        portAsString = properties.getProperty(RMI_REGISTRY_PORT_PROP, REGISTRY_PORT);
        try {
            rmiRegistryPort = Integer.parseInt(portAsString);
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.SEVERE, "Couldn't convert rmiRegistryPort to a valid integer", nfe);
            return;
        }
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            this.adapterName = new ObjectName(HTML_ADAPTOR_JMX_NAME);
            this.adapter.setPort(jmxHtmlPort);
            server.registerMBean(this.adapter, this.adapterName);
            RouterImpl.setRegister(this.reg);
            this.reg = new NodeRegisterImpl(addr);
            this.reg.startRegistry(rmiRegistryPort);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding shutdown hook");
            }
            this.fwd = new SIPBalancerForwarder(properties, this.reg);
            this.fwd.start();
            ObjectName on = new ObjectName(SIP_BALANCER_JMX_NAME);
            if (server.isRegistered(on)) {
                server.unregisterMBean(on);
            }
            server.registerMBean(this, on);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + ipAddress + ":" + rmiRegistryPort + "/server");
            this.cs = JMXConnectorServerFactory.newJMXConnectorServer(url, null, server);
            this.cs.start();
            this.adapter.start();
            Runtime.getRuntime().addShutdownHook(new SipBalancerShutdownHook(this));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "An unexpected error occurred while starting the load balancer", e);
            return;
        }
    }

    @Override
    public void stop() {
        logger.info("Stopping the sip forwarder");
        this.fwd.stop();
        logger.info("Stopping the node registry");
        this.reg.stopRegistry();
        logger.info("Unregistering the node registry");
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName on = new ObjectName(SIP_BALANCER_JMX_NAME);
            if (server.isRegistered(on)) {
                server.unregisterMBean(on);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "An unexpected error occurred while stopping the load balancer", e);
        }
        try {
            this.cs.stop();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "An unexpected error occurred while stopping the load balancer", e);
        }
        this.adapter.stop();
    }

    @Override
    public long getNodeExpiration() {
        return this.reg.getNodeExpiration();
    }

    @Override
    public long getNodeExpirationTaskInterval() {
        return this.reg.getNodeExpirationTaskInterval();
    }

    @Override
    public long getNumberOfRequestsProcessed() {
        return this.fwd.getNumberOfRequestsProcessed();
    }

    @Override
    public long getNumberOfResponsesProcessed() {
        return this.fwd.getNumberOfResponsesProcessed();
    }

    @Override
    public void setNodeExpiration(long value) {
        this.reg.setNodeExpiration(value);
    }

    @Override
    public void setNodeExpirationTaskInterval(long value) {
        this.reg.setNodeExpirationTaskInterval(value);
    }

    @Override
    public List<SIPNode> getNodes() {
        return this.reg.getNodes();
    }

    @Override
    public String[] getNodeList() {
        List<SIPNode> nodes = this.getNodes();
        String[] nodeList = new String[nodes.size()];
        int i = 0;
        for (SIPNode node : nodes) {
            nodeList[0] = node.toString();
            ++i;
        }
        return nodeList;
    }

    @Override
    public int getNumberOfGluedSessions() {
        return this.reg.getGluedSessions().size();
    }
}

