/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionAlreadyExistsException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RecordRouteHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SIPBalancerForwarder
implements SipListener {
    private static final Logger logger = Logger.getLogger(SIPBalancerForwarder.class.getCanonicalName());
    protected static final HashSet<String> dialogCreationMethods = new HashSet(2);
    public static final String ROUTE_PARAM_NODE_HOST = "node_host";
    public static final String ROUTE_PARAM_NODE_PORT = "node_port";
    protected SipProvider internalSipProvider;
    protected SipProvider externalSipProvider;
    protected String myHost;
    protected int myPort;
    protected int myExternalPort;
    protected static AddressFactory addressFactory;
    protected static HeaderFactory headerFactory;
    protected static MessageFactory messageFactory;
    protected SipStack sipStack;
    protected NodeRegister register;
    protected Properties properties;
    protected RecordRouteHeader internalRecordRouteHeader;
    protected RecordRouteHeader externalRecordRouteHeader;
    protected AtomicLong requestsProcessed = new AtomicLong(0L);
    protected AtomicLong responsesProcessed = new AtomicLong(0L);

    public SIPBalancerForwarder(Properties properties, NodeRegister register) throws IllegalStateException {
        this.properties = properties;
        this.register = register;
    }

    public void start() {
        SipFactory sipFactory = null;
        this.sipStack = null;
        this.myHost = this.properties.getProperty("host");
        this.myPort = Integer.parseInt(this.properties.getProperty("internalPort"));
        this.myExternalPort = Integer.parseInt(this.properties.getProperty("externalPort"));
        try {
            sipFactory = SipFactory.getInstance();
            sipFactory.setPathName("gov.nist");
            this.sipStack = sipFactory.createSipStack(this.properties);
        }
        catch (PeerUnavailableException pue) {
            throw new IllegalStateException("Cant create stack due to[" + pue.getMessage() + "]", pue);
        }
        try {
            headerFactory = sipFactory.createHeaderFactory();
            addressFactory = sipFactory.createAddressFactory();
            messageFactory = sipFactory.createMessageFactory();
            ListeningPoint internalLp = this.sipStack.createListeningPoint(this.myHost, this.myPort, "UDP");
            this.internalSipProvider = this.sipStack.createSipProvider(internalLp);
            this.internalSipProvider.addSipListener((SipListener)this);
            ListeningPoint externalLp = this.sipStack.createListeningPoint(this.myHost, this.myExternalPort, "UDP");
            this.externalSipProvider = this.sipStack.createSipProvider(externalLp);
            this.externalSipProvider.addSipListener((SipListener)this);
            SipURI sipUri = addressFactory.createSipURI(null, internalLp.getIPAddress());
            sipUri.setPort(internalLp.getPort());
            sipUri.setLrParam();
            Address address = addressFactory.createAddress((URI)sipUri);
            address.setURI((URI)sipUri);
            this.internalRecordRouteHeader = headerFactory.createRecordRouteHeader(address);
            SipURI sendingSipUri = addressFactory.createSipURI(null, externalLp.getIPAddress());
            sendingSipUri.setPort(externalLp.getPort());
            sendingSipUri.setLrParam();
            Address sendingAddress = addressFactory.createAddress((URI)sendingSipUri);
            sendingAddress.setURI((URI)sendingSipUri);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding Record Router Header :" + sendingAddress);
            }
            this.externalRecordRouteHeader = headerFactory.createRecordRouteHeader(sendingAddress);
            this.sipStack.start();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create sip objects and lps due to[" + ex.getMessage() + "]", ex);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Sip Balancer started on address " + this.myHost + ", external port : " + this.myExternalPort + ", port : " + this.myPort);
        }
    }

    public void stop() {
        Iterator sipProviderIterator = this.sipStack.getSipProviders();
        try {
            while (sipProviderIterator.hasNext()) {
                ListeningPoint[] listeningPoints;
                SipProvider sipProvider = (SipProvider)sipProviderIterator.next();
                for (ListeningPoint listeningPoint : listeningPoints = sipProvider.getListeningPoints()) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Removing the following Listening Point " + listeningPoint);
                    }
                    sipProvider.removeListeningPoint(listeningPoint);
                    this.sipStack.deleteListeningPoint(listeningPoint);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Removing the sip provider");
                }
                sipProvider.removeSipListener((SipListener)this);
                this.sipStack.deleteSipProvider(sipProvider);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cant remove the listening points or sip providers", e);
        }
        this.sipStack.stop();
        this.sipStack = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Sip Balancer stopped");
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
        this.register.unStickSessionFromNode(dialogTerminatedEvent.getDialog().getCallId().getCallId());
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processRequest(RequestEvent requestEvent) {
        block14: {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request originalRequest = requestEvent.getRequest();
            ServerTransaction serverTransaction = requestEvent.getServerTransaction();
            Request request = (Request)originalRequest.clone();
            String requestMethod = request.getMethod();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("transaction " + serverTransaction);
                logger.finest("dialog " + requestEvent.getDialog());
            }
            try {
                if (!"ACK".equals(requestMethod) && serverTransaction == null) {
                    serverTransaction = sipProvider.getNewServerTransaction(originalRequest);
                }
                if ("INVITE".equals(requestMethod)) {
                    Response tryingResponse = messageFactory.createResponse(100, request);
                    serverTransaction.sendResponse(tryingResponse);
                }
                this.updateStats((Message)request);
                if (dialogCreationMethods.contains(requestMethod)) {
                    this.processDialogCreatingRequest(sipProvider, originalRequest, serverTransaction, request);
                } else {
                    this.processNonDialogCreatingRequest(sipProvider, originalRequest, serverTransaction, request);
                }
            }
            catch (TransactionAlreadyExistsException taex) {
                return;
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the request " + request, throwable);
                if ("ACK".equalsIgnoreCase(requestMethod)) break block14;
                try {
                    Response response = messageFactory.createResponse(500, originalRequest);
                    if (serverTransaction != null) {
                        serverTransaction.sendResponse(response);
                    } else if (sipProvider.equals(this.externalSipProvider)) {
                        this.externalSipProvider.sendResponse(response);
                    } else {
                        this.internalSipProvider.sendResponse(response);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unexpected exception while trying to send the error response for this " + request, e);
                }
            }
        }
    }

    private void updateStats(Message message) {
        if (message instanceof Request) {
            this.requestsProcessed.incrementAndGet();
        } else {
            this.responsesProcessed.incrementAndGet();
        }
    }

    private void processNonDialogCreatingRequest(SipProvider sipProvider, Request originalRequest, ServerTransaction serverTransaction, Request request) throws ParseException, InvalidArgumentException, TransactionUnavailableException, SipException {
        String requestMethod = request.getMethod();
        boolean isAck = false;
        if ("CANCEL".equals(requestMethod)) {
            this.processCancel(sipProvider, originalRequest, serverTransaction);
            return;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("got NON dialog creating request:\n " + request);
        }
        this.decreaseMaxForwardsHeader(sipProvider, request);
        SIPNode sipNode = this.removeRouteHeadersMeantForLB(request);
        if (!"ACK".equals(requestMethod)) {
            RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
            HashMap<String, String> parameters = null;
            boolean isSIPNodePresent = true;
            String callID = ((CallID)request.getHeader("Call-ID")).getCallId();
            if (routeHeader != null) {
                SipURI route = (SipURI)routeHeader.getAddress().getURI();
                isSIPNodePresent = this.register.isSIPNodePresent(route.getHost(), route.getPort(), route.getTransportParam());
                if (!isSIPNodePresent) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("node " + route + " is not alive anymore, picking another one ");
                    }
                    parameters = new HashMap<String, String>();
                    Iterator routeParametersIt = route.getParameterNames();
                    while (routeParametersIt.hasNext()) {
                        String routeParameterName = (String)routeParametersIt.next();
                        String routeParameterValue = route.getParameter(routeParameterName);
                        parameters.put(routeParameterName, routeParameterValue);
                    }
                    this.register.unStickSessionFromNode(callID);
                    request.removeFirst("Route");
                    this.addRouteToNode(originalRequest, serverTransaction, request, parameters);
                }
            } else {
                SIPNode node = this.register.getGluedNode(callID);
                if (node == null || !this.register.isSIPNodePresent(node.getIp(), node.getPort(), node.getTransports()[0])) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("node " + node + " is not alive anymore, picking another one ");
                    }
                    this.register.unStickSessionFromNode(callID);
                    node = this.register.stickSessionToNode(callID, null);
                }
                if (sipProvider.equals(this.externalSipProvider)) {
                    if (node != null) {
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("request coming from external, setting the request URI to the one of the node " + node);
                        }
                        SipURI requestURI = (SipURI)request.getRequestURI();
                        requestURI.setHost(node.getIp());
                        requestURI.setPort(node.getPort());
                        requestURI.setTransportParam(node.getTransports()[0]);
                    } else {
                        Response response = messageFactory.createResponse(500, originalRequest);
                        serverTransaction.sendResponse(response);
                    }
                }
            }
        } else {
            isAck = true;
        }
        ViaHeader viaHeader = headerFactory.createViaHeader(this.myHost, this.myPort, "UDP", null);
        request.addHeader((Header)viaHeader);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ViaHeader added " + viaHeader);
        }
        SipProvider sendingSipProvider = this.externalSipProvider;
        if (sipProvider.equals(this.externalSipProvider)) {
            sendingSipProvider = this.internalSipProvider;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("sending the request:\n" + request + "\n on the other side");
        }
        if (isAck) {
            sendingSipProvider.sendRequest(request);
        } else {
            ClientTransaction ctx = sendingSipProvider.getNewClientTransaction(request);
            serverTransaction.setApplicationData((Object)ctx);
            ctx.setApplicationData((Object)serverTransaction);
            ctx.sendRequest();
        }
    }

    private void processDialogCreatingRequest(SipProvider sipProvider, Request originalRequest, ServerTransaction serverTransaction, Request request) throws ParseException, InvalidArgumentException, SipException, TransactionUnavailableException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("got dialog creating request:\n" + request);
        }
        this.decreaseMaxForwardsHeader(sipProvider, request);
        this.addLBRecordRoute(sipProvider, request);
        SIPNode sipNode = this.removeRouteHeadersMeantForLB(request);
        if (sipNode == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("request is for UAS or proxy case");
            }
            this.addRouteToNode(originalRequest, serverTransaction, request, null);
        } else {
            String callID;
            SIPNode node;
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("request is coming from UAC");
            }
            if ((node = this.register.stickSessionToNode(callID = ((CallID)request.getHeader("Call-ID")).getCallId(), sipNode)) == null) {
                Response response = messageFactory.createResponse(500, originalRequest);
                serverTransaction.sendResponse(response);
            }
        }
        ViaHeader viaHeader = headerFactory.createViaHeader(this.myHost, this.myPort, "UDP", null);
        request.addHeader((Header)viaHeader);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ViaHeader added " + viaHeader);
        }
        SipProvider sendingSipProvider = this.internalSipProvider;
        if (sipProvider.equals(this.internalSipProvider)) {
            sendingSipProvider = this.externalSipProvider;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("sending the request:\n" + request + "\n on the other side");
        }
        if ("ACK".equalsIgnoreCase(request.getMethod())) {
            sendingSipProvider.sendRequest(request);
        } else {
            ClientTransaction ctx = sendingSipProvider.getNewClientTransaction(request);
            serverTransaction.setApplicationData((Object)ctx);
            ctx.setApplicationData((Object)serverTransaction);
            ctx.sendRequest();
        }
    }

    private void addLBRecordRoute(SipProvider sipProvider, Request request) throws ParseException {
        if (sipProvider.equals(this.externalSipProvider)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding Record Router Header :" + this.externalRecordRouteHeader);
            }
            request.addHeader((Header)this.externalRecordRouteHeader);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding Record Router Header :" + this.internalRecordRouteHeader);
            }
            request.addHeader((Header)this.internalRecordRouteHeader);
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding Record Router Header :" + this.internalRecordRouteHeader);
            }
            request.addHeader((Header)this.internalRecordRouteHeader);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding Record Router Header :" + this.externalRecordRouteHeader);
            }
            request.addHeader((Header)this.externalRecordRouteHeader);
        }
    }

    private void addRouteToNode(Request originalRequest, ServerTransaction serverTransaction, Request request, Map<String, String> parameters) throws ParseException, SipException, InvalidArgumentException {
        String callID = ((CallID)request.getHeader("Call-ID")).getCallId();
        SIPNode node = this.register.stickSessionToNode(callID, null);
        if (node != null) {
            SipURI routeSipUri = addressFactory.createSipURI(null, node.getIp());
            routeSipUri.setPort(node.getPort());
            routeSipUri.setLrParam();
            if (parameters != null) {
                Set<Map.Entry<String, String>> routeParameters = parameters.entrySet();
                for (Map.Entry<String, String> entry : routeParameters) {
                    routeSipUri.setParameter(entry.getKey(), entry.getValue());
                }
            }
            RouteHeader route = headerFactory.createRouteHeader(addressFactory.createAddress((URI)routeSipUri));
            request.addFirst((Header)route);
        } else {
            Response response = messageFactory.createResponse(500, originalRequest);
            serverTransaction.sendResponse(response);
        }
    }

    private SIPNode removeRouteHeadersMeantForLB(Request request) {
        SipURI routeUri;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Checking if there is any route headers meant for the LB to remove...");
        }
        SIPNode node = null;
        RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
        if (routeHeader != null && !this.isRouteHeaderExternal((routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost(), routeUri.getPort())) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("this route header is for the LB removing it " + routeUri);
            }
            request.removeFirst("Route");
            node = this.checkRouteHeaderForSipNode(routeUri);
            routeHeader = (RouteHeader)request.getHeader("Route");
            if (routeHeader != null && !this.isRouteHeaderExternal((routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost(), routeUri.getPort())) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("this route header is for the LB removing it " + routeUri);
                }
                request.removeFirst("Route");
                if (node == null) {
                    node = this.checkRouteHeaderForSipNode(routeUri);
                }
            }
        }
        if (node != null && logger.isLoggable(Level.FINEST)) {
            logger.finest("Following node information has been found in one of the route Headers " + node);
        }
        return node;
    }

    private boolean isRouteHeaderExternal(String host, int port) {
        return !host.equalsIgnoreCase(this.myHost) || port != this.myExternalPort && port != this.myPort;
    }

    private SIPNode checkRouteHeaderForSipNode(SipURI routeSipUri) {
        SIPNode node = null;
        String hostNode = routeSipUri.getParameter(ROUTE_PARAM_NODE_HOST);
        String hostPort = routeSipUri.getParameter(ROUTE_PARAM_NODE_PORT);
        if (hostNode != null && hostPort != null) {
            int port = Integer.parseInt(hostPort);
            node = this.register.getNode(hostNode, port, routeSipUri.getTransportParam());
        }
        return node;
    }

    private void decreaseMaxForwardsHeader(SipProvider sipProvider, Request request) throws InvalidArgumentException, ParseException, SipException {
        MaxForwardsHeader maxForwardsHeader;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Decreasing  the Max Forward Header ");
        }
        if ((maxForwardsHeader = (MaxForwardsHeader)request.getHeader("Max-Forwards")) == null) {
            maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
            request.addHeader((Header)maxForwardsHeader);
        } else if (maxForwardsHeader.getMaxForwards() - 1 > 0) {
            maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
        } else {
            Response response = messageFactory.createResponse(483, request);
            sipProvider.sendResponse(response);
        }
    }

    private void processCancel(SipProvider sipProvider, Request originalRequest, ServerTransaction serverTransaction) throws ParseException, SipException, InvalidArgumentException, TransactionUnavailableException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("process Cancel " + originalRequest);
        }
        SIPServerTransaction inviteTransaction = ((SIPServerTransaction)serverTransaction).getCanceledInviteTransaction();
        String callID = ((CallID)originalRequest.getHeader("Call-ID")).getCallId();
        SIPNode node = this.register.getGluedNode(callID);
        if (node == null) {
            node = this.register.getNextNode();
        }
        if (node != null) {
            Response response = messageFactory.createResponse(200, originalRequest);
            response.setReasonPhrase("Cancelling");
            serverTransaction.sendResponse(response);
            ClientTransaction ctx = (ClientTransaction)inviteTransaction.getApplicationData();
            Request cancelRequest = ctx.createCancel();
            SipURI routeSipUri = addressFactory.createSipURI(null, node.getIp());
            routeSipUri.setPort(node.getPort());
            routeSipUri.setLrParam();
            RouteHeader route = headerFactory.createRouteHeader(addressFactory.createAddress((URI)routeSipUri));
            cancelRequest.addFirst((Header)route);
            SipProvider sendingSipProvider = this.internalSipProvider;
            if (sipProvider.equals(this.internalSipProvider)) {
                sendingSipProvider = this.externalSipProvider;
            }
            ClientTransaction cancelClientTransaction = sendingSipProvider.getNewClientTransaction(cancelRequest);
            cancelClientTransaction.sendRequest();
        } else {
            logger.severe("No node present yet to forward the request " + originalRequest);
            Response response = messageFactory.createResponse(500, originalRequest);
            serverTransaction.sendResponse(response);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        Response originalResponse = responseEvent.getResponse();
        ClientTransaction clientTransaction = responseEvent.getClientTransaction();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("got response :\n" + originalResponse);
        }
        if (originalResponse.getStatusCode() == 100) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("dropping 100 response");
            }
            return;
        }
        if (clientTransaction == null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("dropping retransmissions");
            }
            return;
        }
        this.updateStats((Message)originalResponse);
        if (!"CANCEL".equalsIgnoreCase(((CSeqHeader)originalResponse.getHeader("CSeq")).getMethod())) {
            Response response = (Response)originalResponse.clone();
            ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
            if (!this.isRouteHeaderExternal(viaHeader.getHost(), viaHeader.getPort())) {
                response.removeFirst("Via");
            }
            try {
                if (clientTransaction != null) {
                    ServerTransaction serverTransaction = (ServerTransaction)clientTransaction.getApplicationData();
                    serverTransaction.sendResponse(response);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the response " + response + " (transaction=" + clientTransaction + " / dialog=" + responseEvent.getDialog() + "", ex);
            }
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.finest("dropping CANCEL responses, snce it hop by hop");
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        ServerTransaction transaction = null;
        if (timeoutEvent.isServerTransaction()) {
            transaction = timeoutEvent.getServerTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        } else {
            transaction = timeoutEvent.getClientTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        }
        String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
        this.register.unStickSessionFromNode(callId);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        ServerTransaction transaction = null;
        if (transactionTerminatedEvent.isServerTransaction()) {
            transaction = transactionTerminatedEvent.getServerTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        } else {
            transaction = transactionTerminatedEvent.getClientTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        }
        if ("BYE".equals(transaction.getRequest().getMethod())) {
            String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
            this.register.unStickSessionFromNode(callId);
        }
    }

    public long getNumberOfRequestsProcessed() {
        return this.requestsProcessed.get();
    }

    public long getNumberOfResponsesProcessed() {
        return this.responsesProcessed.get();
    }

    static {
        dialogCreationMethods.add("INVITE");
        dialogCreationMethods.add("SUBSCRIBE");
    }
}

