/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import java.io.Serializable;
import java.util.Arrays;

public class SIPNode
implements Serializable {
    private static final long serialVersionUID = -4959114432342926569L;
    private String hostName = null;
    private String ip = null;
    private int port = -1;
    private String[] transports = null;
    private long timeStamp = System.currentTimeMillis();

    public SIPNode(String hostName, String ip, int port, String[] transports) {
        this.hostName = hostName;
        this.ip = ip;
        this.port = port;
        this.transports = transports;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getTransports() {
        return this.transports;
    }

    public String getTransportsAsString() {
        return Arrays.toString(this.transports);
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void updateTimerStamp() {
        this.timeStamp = System.currentTimeMillis();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.ip == null ? 0 : this.ip.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + Arrays.hashCode(this.transports);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SIPNode other = (SIPNode)obj;
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.ip == null ? other.ip != null : !this.ip.equals(other.ip)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return Arrays.equals(this.transports, other.transports);
    }

    public String toString() {
        return "SIPNode hostname[" + this.hostName + "] ip[" + this.ip + "] port[" + this.port + "] transport[" + Arrays.toString(this.transports) + "]";
    }
}

