/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.http.balancer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.Cookie;
import org.jboss.netty.handler.codec.http.CookieDecoder;
import org.jboss.netty.handler.codec.http.CookieEncoder;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.mobicents.tools.http.balancer.HttpChannelAssocialtions;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.SIPNode;

@ChannelPipelineCoverage(value="one")
public class HttpRequestHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(HttpRequestHandler.class.getCanonicalName());
    private volatile HttpRequest request;
    private volatile boolean readingChunks;

    public void messageReceived(ChannelHandlerContext ctx, final MessageEvent e) throws Exception {
        if (!this.readingChunks) {
            this.request = (HttpRequest)e.getMessage();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Request URI accessed: " + this.request.getUri() + " channel " + e.getChannel());
            }
            Channel associatedChannel = HttpChannelAssocialtions.channels.get(e.getChannel());
            SIPNode node = null;
            try {
                node = BalancerContext.balancerContext.balancerAlgorithm.processHttpRequest(this.request);
            }
            catch (Exception ex) {
                StringWriter sw = new StringWriter();
                ex.printStackTrace(new PrintWriter(sw));
                this.writeResponse(e, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Mobicents Load Balancer Error: Exception in the balancer algorithm:\n" + sw.toString());
                return;
            }
            if (node == null) {
                this.writeResponse(e, HttpResponseStatus.INTERNAL_SERVER_ERROR, "Mobicents Load Balancer Error: All nodes are Dead!");
                return;
            }
            if (associatedChannel != null && associatedChannel.isConnected()) {
                associatedChannel.write((Object)this.request);
            } else {
                e.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        HttpRequestHandler.this.closeChannelPair(arg0.getChannel());
                    }
                });
                ChannelFuture future = HttpChannelAssocialtions.inboundBootstrap.connect((SocketAddress)new InetSocketAddress(node.getIp(), node.getHttpPort()));
                future.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture arg0) throws Exception {
                        Channel channel = arg0.getChannel();
                        HttpChannelAssocialtions.channels.put(e.getChannel(), channel);
                        HttpChannelAssocialtions.channels.put(channel, e.getChannel());
                        if (HttpRequestHandler.this.request.isChunked()) {
                            HttpRequestHandler.this.readingChunks = true;
                        }
                        channel.write((Object)HttpRequestHandler.this.request);
                        channel.getCloseFuture().addListener(new ChannelFutureListener(){

                            public void operationComplete(ChannelFuture arg0) throws Exception {
                                HttpRequestHandler.this.closeChannelPair(arg0.getChannel());
                            }
                        });
                    }
                });
            }
        } else {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
            }
            HttpChannelAssocialtions.channels.get(e.getChannel()).write((Object)chunk);
        }
    }

    private void closeChannelPair(Channel channel) {
        Channel associatedChannel = HttpChannelAssocialtions.channels.get(channel);
        if (associatedChannel != null) {
            try {
                HttpChannelAssocialtions.channels.remove(associatedChannel);
                if (!associatedChannel.isConnected()) {
                    associatedChannel.disconnect();
                    associatedChannel.close();
                }
                associatedChannel = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        HttpChannelAssocialtions.channels.remove(channel);
        if (logger.isLoggable(Level.FINE)) {
            try {
                logger.fine("Channel closed " + HttpChannelAssocialtions.channels.size() + " " + channel);
                Enumeration<Channel> c = HttpChannelAssocialtions.channels.keys();
                while (c.hasMoreElements()) {
                    logger.fine(c.nextElement().toString());
                }
            }
            catch (Exception e) {
                logger.log(Level.FINE, "error", e);
            }
        }
    }

    private void writeResponse(MessageEvent e, HttpResponseStatus status, String responseString) {
        CookieDecoder cookieDecoder;
        Set cookies;
        String cookieString;
        ChannelBuffer buf = ChannelBuffers.copiedBuffer((String)responseString, (String)"UTF-8");
        boolean close = "close".equalsIgnoreCase(this.request.getHeader("Connection")) || this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_0) && !"keep-alive".equalsIgnoreCase(this.request.getHeader("Connection"));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.setContent(buf);
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        if (!close) {
            response.setHeader("Content-Length", String.valueOf(buf.readableBytes()));
        }
        if ((cookieString = this.request.getHeader("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        ChannelFuture future = e.getChannel().write((Object)response);
        if (close) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.log(Level.SEVERE, "Error", e.getCause());
        e.getChannel().close();
    }
}

