/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

public class CallIDAffinityBalancerAlgorithm
extends DefaultBalancerAlgorithm {
    private static Logger logger = Logger.getLogger(CallIDAffinityBalancerAlgorithm.class.getCanonicalName());
    private String headerName = "Call-ID";
    private ConcurrentHashMap<String, SIPNode> callIdMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> callIdTimestamps = new ConcurrentHashMap();
    private AtomicInteger nextNodeCounter = new AtomicInteger(0);
    private int maxCallIdleTime = 500;
    private Timer cacheEvictionTimer = new Timer();

    public void processInternalRequest(Request request) {
        logger.fine("internal request");
    }

    public void processInternalResponse(Response request) {
        logger.fine("internal response");
    }

    public void processExternalResponse(Response request) {
        logger.fine("external response");
    }

    public SIPNode processExternalRequest(Request request) {
        String callId = ((SIPHeader)request.getHeader(this.headerName)).getValue();
        SIPNode node = this.callIdMap.get(callId);
        this.callIdTimestamps.put(callId, System.currentTimeMillis());
        BalancerContext balancerContext = this.getBalancerContext();
        if (node == null) {
            node = this.nextAvailableNode();
            if (node == null) {
                return null;
            }
            this.callIdMap.put(callId, node);
        } else if (!balancerContext.nodes.contains(node)) {
            node = this.nextAvailableNode();
            if (node == null) {
                return null;
            }
            this.callIdMap.put(callId, node);
        }
        if (node == null) {
            return null;
        }
        return node;
    }

    private synchronized SIPNode nextAvailableNode() {
        BalancerContext balancerContext = this.getBalancerContext();
        if (balancerContext.nodes.size() == 0) {
            return null;
        }
        int nextNode = this.nextNodeCounter.incrementAndGet();
        return balancerContext.nodes.get(nextNode %= balancerContext.nodes.size());
    }

    public void init() {
        String maxTimeInCacheString = this.getProperties().getProperty("callIdAffinityMaxTimeInCache");
        if (maxTimeInCacheString != null) {
            this.maxCallIdleTime = Integer.parseInt(maxTimeInCacheString);
        }
        logger.info("Call Idle Time is " + this.maxCallIdleTime + " seconds. Inactive calls will be evicted.");
        this.cacheEvictionTimer.schedule(new TimerTask(){

            public void run() {
                try {
                    ArrayList<String> oldCalls = new ArrayList<String>();
                    for (String key : CallIDAffinityBalancerAlgorithm.this.callIdTimestamps.keySet()) {
                        long time = (Long)CallIDAffinityBalancerAlgorithm.this.callIdTimestamps.get(key);
                        if (System.currentTimeMillis() - time <= (long)(1000 * CallIDAffinityBalancerAlgorithm.this.maxCallIdleTime)) continue;
                        oldCalls.add(key);
                    }
                    for (String key : oldCalls) {
                        CallIDAffinityBalancerAlgorithm.this.callIdMap.remove(key);
                        CallIDAffinityBalancerAlgorithm.this.callIdTimestamps.remove(key);
                    }
                    if (oldCalls.size() > 0) {
                        logger.info("Reaping idle calls... Evicted " + oldCalls.size() + " calls.");
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to clean up old calls. If you continue to se this message frequestly and the memory is growing, report this problem.", e);
                }
            }
        }, 0L, 6000L);
    }

    public void assignToNode(String id, SIPNode node) {
        this.callIdMap.put(id, node);
        this.callIdTimestamps.put(id, System.currentTimeMillis());
    }

    public void jvmRouteSwitchover(String fromJvmRoute, String toJvmRoute) {
        SIPNode oldNode = this.getBalancerContext().jvmRouteToSipNode.get(fromJvmRoute);
        SIPNode newNode = this.getBalancerContext().jvmRouteToSipNode.get(toJvmRoute);
        if (oldNode != null && newNode != null) {
            int updatedRoutes = 0;
            for (String key : this.callIdMap.keySet()) {
                SIPNode n = this.callIdMap.get(key);
                if (!n.equals(oldNode)) continue;
                this.callIdMap.replace(key, newNode);
                ++updatedRoutes;
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Switchover occured where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute + " with " + updatedRoutes + " updated routes.");
            }
        } else if (logger.isLoggable(Level.INFO)) {
            logger.info("Switchover failed where fromJvmRoute=" + fromJvmRoute + " and toJvmRoute=" + toJvmRoute);
        }
    }
}

