/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import java.util.Collections;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.DefaultBalancerAlgorithm;
import org.mobicents.tools.sip.balancer.SIPNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderConsistentHashBalancerAlgorithm
extends DefaultBalancerAlgorithm {
    protected String sipHeaderAffinityKey;
    protected String httpAffinityKey;
    private SortedSet nodes = Collections.synchronizedSortedSet(new TreeSet());
    private Object[] nodesArray;
    private boolean nodesAreDirty = true;

    public HeaderConsistentHashBalancerAlgorithm() {
    }

    public HeaderConsistentHashBalancerAlgorithm(String headerName) {
        this.sipHeaderAffinityKey = headerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SIPNode processExternalRequest(Request request) {
        Integer nodeIndex = this.hashHeader((Message)request);
        if (nodeIndex < 0) {
            return null;
        }
        BalancerContext balancerContext = this.getBalancerContext();
        if (this.nodesAreDirty) {
            HeaderConsistentHashBalancerAlgorithm headerConsistentHashBalancerAlgorithm = this;
            synchronized (headerConsistentHashBalancerAlgorithm) {
                this.nodes.clear();
                this.nodes.add(balancerContext.nodes);
                this.nodesArray = this.nodes.toArray(new Object[0]);
                this.nodesAreDirty = false;
            }
        }
        try {
            SIPNode node = (SIPNode)this.nodesArray[nodeIndex];
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public synchronized void nodeAdded(SIPNode node) {
        this.nodes.add(node);
        this.nodesArray = this.nodes.toArray(new Object[0]);
        this.nodesAreDirty = false;
    }

    @Override
    public synchronized void nodeRemoved(SIPNode node) {
        this.nodes.remove(node);
        this.nodesArray = this.nodes.toArray(new Object[0]);
        this.nodesAreDirty = false;
    }

    private void dumpNodes() {
        System.out.println("0----------------------------------------------------0");
        for (Object object : this.nodesArray) {
            SIPNode node = (SIPNode)object;
            System.out.println(node);
        }
    }

    private Integer hashHeader(Message message) {
        String headerValue = null;
        headerValue = this.sipHeaderAffinityKey.equals("from.user") ? ((SipURI)((FromHeader)message.getHeader("From")).getAddress().getURI()).getUser() : (this.sipHeaderAffinityKey.equals("to.user") ? ((SipURI)((ToHeader)message.getHeader("To")).getAddress().getURI()).getUser() : ((SIPHeader)message.getHeader(this.sipHeaderAffinityKey)).getValue());
        if (this.nodes.size() == 0) {
            throw new RuntimeException("No Application Servers registered. All servers are dead.");
        }
        int nodeIndex = this.hashAffinityKeyword(headerValue);
        return nodeIndex;
    }

    @Override
    public SIPNode processHttpRequest(HttpRequest request) {
        String affinityKeyword = this.getUrlParameters(request.getUri()).get(this.httpAffinityKey);
        if (affinityKeyword == null) {
            return super.processHttpRequest(request);
        }
        return (SIPNode)this.nodesArray[this.hashAffinityKeyword(affinityKeyword)];
    }

    protected int hashAffinityKeyword(String keyword) {
        int nodeIndex = Math.abs(keyword.hashCode()) % this.nodes.size();
        return nodeIndex;
    }

    HashMap<String, String> getUrlParameters(String url) {
        String[] tokens;
        HashMap<String, String> parameters = new HashMap<String, String>();
        int start = url.lastIndexOf(63);
        if (start <= 0 || url.length() <= start + 1) {
            return parameters;
        }
        url = url.substring(start + 1);
        for (String token : tokens = url.split("&")) {
            String[] params = token.split("=");
            if (params.length < 2) {
                parameters.put(token, "");
                continue;
            }
            parameters.put(params[0], params[1]);
        }
        return parameters;
    }

    @Override
    public void init() {
        this.httpAffinityKey = this.getProperties().getProperty("httpAffinityKey", "appsession");
        this.sipHeaderAffinityKey = this.getProperties().getProperty("sipHeaderAffinityKey", "Call-ID");
    }
}

