/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.sip.balancer;

import gov.nist.javax.sip.header.SIPHeader;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.RouteHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.tools.sip.balancer.BalancerContext;
import org.mobicents.tools.sip.balancer.ExtraServerNode;
import org.mobicents.tools.sip.balancer.NodeRegister;
import org.mobicents.tools.sip.balancer.RouteHeaderHints;
import org.mobicents.tools.sip.balancer.SIPNode;

public class SIPBalancerForwarder
implements SipListener {
    private static final Logger logger = Logger.getLogger(SIPBalancerForwarder.class.getCanonicalName());
    public static final String ROUTE_PARAM_NODE_HOST = "node_host";
    public static final String ROUTE_PARAM_NODE_PORT = "node_port";
    protected static final HashSet<String> dialogCreationMethods = new HashSet(2);
    public NodeRegister register;
    protected String[] extraServerAddresses;
    protected int[] extraServerPorts;

    public SIPBalancerForwarder(Properties properties, NodeRegister register) throws IllegalStateException {
        BalancerContext.balancerContext.properties = properties;
        this.register = register;
    }

    public void start() {
        String extraServerNodesString;
        SipFactory sipFactory = null;
        BalancerContext.balancerContext.sipStack = null;
        BalancerContext.balancerContext.host = BalancerContext.balancerContext.properties.getProperty("host");
        BalancerContext.balancerContext.externalPort = Integer.parseInt(BalancerContext.balancerContext.properties.getProperty("externalPort"));
        if (BalancerContext.balancerContext.properties.getProperty("internalPort") != null) {
            BalancerContext.balancerContext.internalPort = Integer.parseInt(BalancerContext.balancerContext.properties.getProperty("internalPort"));
        }
        BalancerContext.balancerContext.externalIpLoadBalancerAddress = BalancerContext.balancerContext.properties.getProperty("externalIpLoadBalancerAddress");
        BalancerContext.balancerContext.internalIpLoadBalancerAddress = BalancerContext.balancerContext.properties.getProperty("internalIpLoadBalancerAddress");
        BalancerContext.balancerContext.externalTransport = BalancerContext.balancerContext.properties.getProperty("externalTransport", "UDP");
        BalancerContext.balancerContext.internalTransport = BalancerContext.balancerContext.properties.getProperty("internalTransport", "UDP");
        if (BalancerContext.balancerContext.properties.getProperty("externalLoadBalancerPort") != null) {
            BalancerContext.balancerContext.externalLoadBalancerPort = Integer.parseInt(BalancerContext.balancerContext.properties.getProperty("externalLoadBalancerPort"));
        }
        if (BalancerContext.balancerContext.properties.getProperty("internalLoadBalancerPort") != null) {
            BalancerContext.balancerContext.internalLoadBalancerPort = Integer.parseInt(BalancerContext.balancerContext.properties.getProperty("internalLoadBalancerPort"));
        }
        if ((extraServerNodesString = BalancerContext.balancerContext.properties.getProperty("extraServerNodes")) != null) {
            this.extraServerAddresses = extraServerNodesString.split(",");
            this.extraServerPorts = new int[this.extraServerAddresses.length];
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                int indexOfPort = this.extraServerAddresses[q].indexOf(58);
                if (indexOfPort > 0) {
                    this.extraServerPorts[q] = Integer.parseInt(this.extraServerAddresses[q].substring(indexOfPort + 1, this.extraServerAddresses[q].length()));
                    this.extraServerAddresses[q] = this.extraServerAddresses[q].substring(0, indexOfPort);
                    logger.info("Extra Server: " + this.extraServerAddresses[q] + ":" + this.extraServerPorts[q]);
                    continue;
                }
                this.extraServerPorts[q] = 5060;
            }
        }
        try {
            sipFactory = SipFactory.getInstance();
            sipFactory.setPathName("gov.nist");
            BalancerContext.balancerContext.sipStack = sipFactory.createSipStack(BalancerContext.balancerContext.properties);
        }
        catch (PeerUnavailableException pue) {
            throw new IllegalStateException("Cant create stack due to[" + pue.getMessage() + "]", pue);
        }
        try {
            Address ipLbAdress;
            SipURI ipLbSipUri;
            BalancerContext.balancerContext.headerFactory = sipFactory.createHeaderFactory();
            BalancerContext.balancerContext.addressFactory = sipFactory.createAddressFactory();
            BalancerContext.balancerContext.messageFactory = sipFactory.createMessageFactory();
            ListeningPoint externalLp = BalancerContext.balancerContext.sipStack.createListeningPoint(BalancerContext.balancerContext.host, BalancerContext.balancerContext.externalPort, BalancerContext.balancerContext.externalTransport);
            BalancerContext.balancerContext.externalSipProvider = BalancerContext.balancerContext.sipStack.createSipProvider(externalLp);
            BalancerContext.balancerContext.externalSipProvider.addSipListener((SipListener)this);
            ListeningPoint internalLp = null;
            if (BalancerContext.balancerContext.isTwoEntrypoints()) {
                internalLp = BalancerContext.balancerContext.sipStack.createListeningPoint(BalancerContext.balancerContext.host, BalancerContext.balancerContext.internalPort, BalancerContext.balancerContext.internalTransport);
                BalancerContext.balancerContext.internalSipProvider = BalancerContext.balancerContext.sipStack.createSipProvider(internalLp);
                BalancerContext.balancerContext.internalSipProvider.addSipListener((SipListener)this);
            }
            SipURI externalLocalUri = BalancerContext.balancerContext.addressFactory.createSipURI(null, externalLp.getIPAddress());
            externalLocalUri.setPort(externalLp.getPort());
            externalLocalUri.setTransportParam(BalancerContext.balancerContext.externalTransport);
            externalLocalUri.setLrParam();
            Address externalLocalAddress = BalancerContext.balancerContext.addressFactory.createAddress((URI)externalLocalUri);
            externalLocalAddress.setURI((URI)externalLocalUri);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("adding Record Router Header :" + externalLocalAddress);
            }
            BalancerContext.balancerContext.externalRecordRouteHeader = BalancerContext.balancerContext.headerFactory.createRecordRouteHeader(externalLocalAddress);
            if (BalancerContext.balancerContext.isTwoEntrypoints()) {
                SipURI internalLocalUri = BalancerContext.balancerContext.addressFactory.createSipURI(null, internalLp.getIPAddress());
                internalLocalUri.setPort(internalLp.getPort());
                internalLocalUri.setTransportParam(BalancerContext.balancerContext.internalTransport);
                internalLocalUri.setLrParam();
                Address internalLocalAddress = BalancerContext.balancerContext.addressFactory.createAddress((URI)internalLocalUri);
                internalLocalAddress.setURI((URI)internalLocalUri);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adding Record Router Header :" + internalLocalAddress);
                }
                BalancerContext.balancerContext.internalRecordRouteHeader = BalancerContext.balancerContext.headerFactory.createRecordRouteHeader(internalLocalAddress);
            }
            if (BalancerContext.balancerContext.externalIpLoadBalancerAddress != null) {
                ipLbSipUri = BalancerContext.balancerContext.addressFactory.createSipURI(null, BalancerContext.balancerContext.externalIpLoadBalancerAddress);
                ipLbSipUri.setPort(BalancerContext.balancerContext.externalLoadBalancerPort);
                ipLbSipUri.setTransportParam(BalancerContext.balancerContext.externalTransport);
                ipLbSipUri.setLrParam();
                ipLbAdress = BalancerContext.balancerContext.addressFactory.createAddress((URI)ipLbSipUri);
                ipLbAdress.setURI((URI)ipLbSipUri);
                BalancerContext.balancerContext.externalIpBalancerRecordRouteHeader = BalancerContext.balancerContext.headerFactory.createRecordRouteHeader(ipLbAdress);
            }
            if (BalancerContext.balancerContext.internalIpLoadBalancerAddress != null) {
                ipLbSipUri = BalancerContext.balancerContext.addressFactory.createSipURI(null, BalancerContext.balancerContext.internalIpLoadBalancerAddress);
                ipLbSipUri.setPort(BalancerContext.balancerContext.internalLoadBalancerPort);
                ipLbSipUri.setTransportParam(BalancerContext.balancerContext.internalTransport);
                ipLbSipUri.setLrParam();
                ipLbAdress = BalancerContext.balancerContext.addressFactory.createAddress((URI)ipLbSipUri);
                ipLbAdress.setURI((URI)ipLbSipUri);
                BalancerContext.balancerContext.internalIpBalancerRecordRouteHeader = BalancerContext.balancerContext.headerFactory.createRecordRouteHeader(ipLbAdress);
            }
            BalancerContext.balancerContext.activeExternalHeader = BalancerContext.balancerContext.externalIpBalancerRecordRouteHeader != null ? BalancerContext.balancerContext.externalIpBalancerRecordRouteHeader : BalancerContext.balancerContext.externalRecordRouteHeader;
            BalancerContext.balancerContext.activeInternalHeader = BalancerContext.balancerContext.internalIpBalancerRecordRouteHeader != null ? BalancerContext.balancerContext.internalIpBalancerRecordRouteHeader : BalancerContext.balancerContext.internalRecordRouteHeader;
            BalancerContext.balancerContext.sipStack.start();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Can't create sip objects and lps due to[" + ex.getMessage() + "]", ex);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Sip Balancer started on address " + BalancerContext.balancerContext.host + ", external port : " + BalancerContext.balancerContext.externalPort + "");
        }
    }

    public void stop() {
        Iterator sipProviderIterator = BalancerContext.balancerContext.sipStack.getSipProviders();
        try {
            while (sipProviderIterator.hasNext()) {
                ListeningPoint[] listeningPoints;
                SipProvider sipProvider = (SipProvider)sipProviderIterator.next();
                for (ListeningPoint listeningPoint : listeningPoints = sipProvider.getListeningPoints()) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("Removing the following Listening Point " + listeningPoint);
                    }
                    sipProvider.removeListeningPoint(listeningPoint);
                    BalancerContext.balancerContext.sipStack.deleteListeningPoint(listeningPoint);
                }
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Removing the sip provider");
                }
                sipProvider.removeSipListener((SipListener)this);
                BalancerContext.balancerContext.sipStack.deleteSipProvider(sipProvider);
                sipProviderIterator = BalancerContext.balancerContext.sipStack.getSipProviders();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Cant remove the listening points or sip providers", e);
        }
        BalancerContext.balancerContext.sipStack.stop();
        BalancerContext.balancerContext.sipStack = null;
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Sip Balancer stopped");
        }
    }

    public void processDialogTerminated(DialogTerminatedEvent dialogTerminatedEvent) {
    }

    public void processIOException(IOExceptionEvent exceptionEvent) {
    }

    public void processRequest(RequestEvent requestEvent) {
        block4: {
            SipProvider sipProvider = (SipProvider)requestEvent.getSource();
            Request request = requestEvent.getRequest();
            String requestMethod = request.getMethod();
            try {
                this.updateStats((Message)request);
                this.forwardRequest(sipProvider, request);
            }
            catch (Throwable throwable) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the request " + request, throwable);
                if ("ACK".equalsIgnoreCase(requestMethod)) break block4;
                try {
                    Response response = BalancerContext.balancerContext.messageFactory.createResponse(500, request);
                    sipProvider.sendResponse(response);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Unexpected exception while trying to send the error response for this " + request, e);
                }
            }
        }
    }

    private void updateStats(Message message) {
        if (message instanceof Request) {
            BalancerContext.balancerContext.requestsProcessed.incrementAndGet();
        } else {
            BalancerContext.balancerContext.responsesProcessed.incrementAndGet();
        }
    }

    private SIPNode getNode(String host, int port, String otherTransport) {
        for (SIPNode node : BalancerContext.balancerContext.nodes) {
            if (!node.getHostName().equals(host) && !node.getIp().equals(host) || node.getPort() != port) continue;
            for (String transport : node.getTransports()) {
                if (!transport.equalsIgnoreCase(otherTransport)) continue;
                return node;
            }
        }
        return null;
    }

    private boolean isViaHeaderFromServer(Request request) {
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        String host = viaHeader.getHost();
        String transport = viaHeader.getTransport();
        if (transport == null) {
            transport = "udp";
        }
        int port = viaHeader.getPort();
        if (this.extraServerAddresses != null) {
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                if (!this.extraServerAddresses[q].equals(host) || this.extraServerPorts[q] != port) continue;
                return true;
            }
        }
        return this.getNode(host, port, transport) != null;
    }

    private SIPNode getSourceNode(Response response) {
        ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
        String host = viaHeader.getHost();
        String transport = viaHeader.getTransport();
        if (transport == null) {
            transport = "udp";
        }
        int port = viaHeader.getPort();
        if (this.extraServerAddresses != null) {
            for (int q = 0; q < this.extraServerAddresses.length; ++q) {
                if (!this.extraServerAddresses[q].equals(host) || this.extraServerPorts[q] != port) continue;
                return ExtraServerNode.extraServerNode;
            }
        }
        SIPNode node = this.getNode(host, port, transport);
        if (this.getNode(host, port, transport) != null) {
            return node;
        }
        return null;
    }

    private void forwardRequest(SipProvider sipProvider, Request request) throws ParseException, InvalidArgumentException, SipException, TransactionUnavailableException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("got request:\n" + request);
        }
        boolean isRequestFromServer = false;
        isRequestFromServer = !BalancerContext.balancerContext.isTwoEntrypoints() ? this.isViaHeaderFromServer(request) : sipProvider.equals(BalancerContext.balancerContext.internalSipProvider);
        boolean isCancel = "CANCEL".equals(request.getMethod());
        if (!isCancel) {
            this.decreaseMaxForwardsHeader(sipProvider, request);
        }
        if (dialogCreationMethods.contains(request.getMethod())) {
            this.addLBRecordRoute(sipProvider, request);
        }
        String callID = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        RouteHeaderHints hints = this.removeRouteHeadersMeantForLB(request);
        if (hints.serverAssignedNode != null) {
            String callId = ((SIPHeader)request.getHeader("Call-ID")).getValue();
            BalancerContext.balancerContext.balancerAlgorithm.assignToNode(callId, hints.serverAssignedNode);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Following node information has been found in one of the route Headers " + hints.serverAssignedNode);
            }
        }
        SIPNode nextNode = null;
        if (isRequestFromServer) {
            BalancerContext.balancerContext.balancerAlgorithm.processInternalRequest(request);
        } else {
            URI uri;
            SIPNode assignedNode = null;
            RouteHeader nextNodeHeader = (RouteHeader)request.getHeader("Route");
            if (nextNodeHeader != null && (uri = nextNodeHeader.getAddress().getURI()) instanceof SipURI) {
                SipURI sipUri = (SipURI)uri;
                for (SIPNode next : BalancerContext.balancerContext.nodes) {
                    if (!next.getIp().equals(sipUri.getHost()) || next.getPort() != sipUri.getPort()) continue;
                    assignedNode = next;
                    break;
                }
            }
            SipURI assignedUri = null;
            boolean nextNodeInRequestUri = false;
            if (assignedNode == null) {
                if (hints.subsequentRequest) {
                    RouteHeader header = (RouteHeader)request.getHeader("Route");
                    if (header != null) {
                        assignedUri = (SipURI)header.getAddress().getURI();
                        request.removeFirst("Route");
                    } else {
                        assignedUri = (SipURI)request.getRequestURI();
                        nextNodeInRequestUri = true;
                    }
                }
                if ((nextNode = BalancerContext.balancerContext.balancerAlgorithm.processExternalRequest(request)) != null) {
                    try {
                        SipURI routeSipUri = assignedUri == null ? BalancerContext.balancerContext.addressFactory.createSipURI(null, nextNode.getIp()) : assignedUri;
                        routeSipUri.setPort(nextNode.getPort());
                        routeSipUri.setLrParam();
                        if (nextNodeInRequestUri) {
                            request.setRequestURI((URI)routeSipUri);
                        }
                        RouteHeader route = BalancerContext.balancerContext.headerFactory.createRouteHeader(BalancerContext.balancerContext.addressFactory.createAddress((URI)routeSipUri));
                        request.addFirst((Header)route);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Error adding route header", e);
                    }
                }
            } else {
                nextNode = BalancerContext.balancerContext.balancerAlgorithm.processAssignedExternalRequest(request, assignedNode);
            }
            if (nextNode == null) {
                throw new RuntimeException("No nodes available");
            }
        }
        ViaHeader via = (ViaHeader)request.getHeader("Via");
        String newBranch = via.getBranch() + callID.substring(0, Math.min(callID.length(), 5));
        ViaHeader viaHeader = BalancerContext.balancerContext.headerFactory.createViaHeader(BalancerContext.balancerContext.host, BalancerContext.balancerContext.externalPort, BalancerContext.balancerContext.externalTransport, newBranch);
        request.addHeader((Header)viaHeader);
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("ViaHeader added " + viaHeader);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Sending the request:\n" + request + "\n on the other side");
        }
        if (!isRequestFromServer && BalancerContext.balancerContext.isTwoEntrypoints()) {
            BalancerContext.balancerContext.internalSipProvider.sendRequest(request);
        } else {
            BalancerContext.balancerContext.externalSipProvider.sendRequest(request);
        }
    }

    private void addLBRecordRoute(SipProvider sipProvider, Request request) throws ParseException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("adding Record Router Header :" + BalancerContext.balancerContext.activeExternalHeader);
        }
        if (BalancerContext.balancerContext.isTwoEntrypoints()) {
            if (sipProvider.equals(BalancerContext.balancerContext.externalSipProvider)) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adding Record Router Header :" + BalancerContext.balancerContext.activeExternalHeader);
                }
                request.addHeader((Header)BalancerContext.balancerContext.activeExternalHeader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adding Record Router Header :" + BalancerContext.balancerContext.activeInternalHeader);
                }
                request.addHeader((Header)BalancerContext.balancerContext.activeInternalHeader);
            } else {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adding Record Router Header :" + BalancerContext.balancerContext.activeInternalHeader);
                }
                request.addHeader((Header)BalancerContext.balancerContext.activeInternalHeader);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("adding Record Router Header :" + BalancerContext.balancerContext.activeExternalHeader);
                }
                request.addHeader((Header)BalancerContext.balancerContext.activeExternalHeader);
            }
        } else {
            request.addHeader((Header)BalancerContext.balancerContext.activeExternalHeader);
        }
    }

    private SIPNode checkRouteHeaderForSipNode(SipURI routeSipUri) {
        SIPNode node = null;
        String hostNode = routeSipUri.getParameter(ROUTE_PARAM_NODE_HOST);
        String hostPort = routeSipUri.getParameter(ROUTE_PARAM_NODE_PORT);
        if (hostNode != null && hostPort != null) {
            int port = Integer.parseInt(hostPort);
            node = this.register.getNode(hostNode, port, routeSipUri.getTransportParam());
        }
        return node;
    }

    private RouteHeaderHints removeRouteHeadersMeantForLB(Request request) {
        SipURI routeUri;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Checking if there is any route headers meant for the LB to remove...");
        }
        SIPNode node = null;
        boolean subsequent = false;
        RouteHeader routeHeader = (RouteHeader)request.getHeader("Route");
        if (routeHeader != null && !this.isRouteHeaderExternal((routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost(), routeUri.getPort())) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("this route header is for the LB removing it " + routeUri);
            }
            request.removeFirst("Route");
            routeHeader = (RouteHeader)request.getHeader("Route");
            node = this.checkRouteHeaderForSipNode(routeUri);
            if (routeHeader != null && !this.isRouteHeaderExternal((routeUri = (SipURI)routeHeader.getAddress().getURI()).getHost(), routeUri.getPort())) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("this route header is for the LB removing it " + routeUri);
                }
                request.removeFirst("Route");
                if (node == null) {
                    node = this.checkRouteHeaderForSipNode(routeUri);
                }
                subsequent = true;
            }
        }
        return new RouteHeaderHints(node, subsequent);
    }

    private boolean isRouteHeaderExternal(String host, int port) {
        if (host.equalsIgnoreCase(BalancerContext.balancerContext.host) && (port == BalancerContext.balancerContext.externalPort || port == BalancerContext.balancerContext.internalPort)) {
            return false;
        }
        if (host.equalsIgnoreCase(BalancerContext.balancerContext.externalIpLoadBalancerAddress) && port == BalancerContext.balancerContext.externalLoadBalancerPort) {
            return false;
        }
        return !host.equalsIgnoreCase(BalancerContext.balancerContext.internalIpLoadBalancerAddress) || port != BalancerContext.balancerContext.internalLoadBalancerPort;
    }

    private void decreaseMaxForwardsHeader(SipProvider sipProvider, Request request) throws InvalidArgumentException, ParseException, SipException {
        MaxForwardsHeader maxForwardsHeader;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Decreasing  the Max Forward Header ");
        }
        if ((maxForwardsHeader = (MaxForwardsHeader)request.getHeader("Max-Forwards")) == null) {
            maxForwardsHeader = BalancerContext.balancerContext.headerFactory.createMaxForwardsHeader(70);
            request.addHeader((Header)maxForwardsHeader);
        } else if (maxForwardsHeader.getMaxForwards() - 1 > 0) {
            maxForwardsHeader.setMaxForwards(maxForwardsHeader.getMaxForwards() - 1);
        } else {
            Response response = BalancerContext.balancerContext.messageFactory.createResponse(483, request);
            sipProvider.sendResponse(response);
        }
    }

    public void processResponse(ResponseEvent responseEvent) {
        SIPNode sourceNode;
        SipProvider sipProvider = (SipProvider)responseEvent.getSource();
        Response originalResponse = responseEvent.getResponse();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("got response :\n" + originalResponse);
        }
        this.updateStats((Message)originalResponse);
        Response response = originalResponse;
        ViaHeader viaHeader = (ViaHeader)response.getHeader("Via");
        if (viaHeader != null && !this.isRouteHeaderExternal(viaHeader.getHost(), viaHeader.getPort())) {
            response.removeFirst("Via");
        }
        if ((sourceNode = this.getSourceNode(response)) != null) {
            if ("true".equals(BalancerContext.balancerContext.properties.getProperty("removeNodesOn500Response")) && response.getStatusCode() == 500 && !(sourceNode instanceof ExtraServerNode) && BalancerContext.balancerContext.nodes.size() > 1) {
                BalancerContext.balancerContext.nodes.remove(sourceNode);
                BalancerContext.balancerContext.balancerAlgorithm.nodeRemoved(sourceNode);
            }
            BalancerContext.balancerContext.balancerAlgorithm.processInternalResponse(response);
            try {
                BalancerContext.balancerContext.externalSipProvider.sendResponse(response);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the response \n" + response, ex);
            }
        } else {
            BalancerContext.balancerContext.balancerAlgorithm.processExternalResponse(response);
            try {
                BalancerContext.balancerContext.internalSipProvider.sendResponse(response);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Unexpected exception while forwarding the response \n" + response, ex);
            }
        }
    }

    public void processTimeout(TimeoutEvent timeoutEvent) {
        ServerTransaction transaction = null;
        if (timeoutEvent.isServerTransaction()) {
            transaction = timeoutEvent.getServerTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        } else {
            transaction = timeoutEvent.getClientTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        }
        String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
        this.register.unStickSessionFromNode(callId);
    }

    public void processTransactionTerminated(TransactionTerminatedEvent transactionTerminatedEvent) {
        ServerTransaction transaction = null;
        if (transactionTerminatedEvent.isServerTransaction()) {
            transaction = transactionTerminatedEvent.getServerTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        } else {
            transaction = transactionTerminatedEvent.getClientTransaction();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("timeout => " + transaction.getRequest().toString());
            }
        }
        if ("BYE".equals(transaction.getRequest().getMethod())) {
            String callId = ((CallIdHeader)transaction.getRequest().getHeader("Call-ID")).getCallId();
            this.register.unStickSessionFromNode(callId);
        }
    }

    public long getNumberOfRequestsProcessed() {
        return BalancerContext.balancerContext.requestsProcessed.get();
    }

    public long getNumberOfResponsesProcessed() {
        return BalancerContext.balancerContext.responsesProcessed.get();
    }

    public BalancerContext getBalancerAlgorithmContext() {
        return BalancerContext.balancerContext;
    }

    public void setBalancerAlgorithmContext(BalancerContext balancerAlgorithmContext) {
        BalancerContext.balancerContext = balancerAlgorithmContext;
    }

    static {
        dialogCreationMethods.add("INVITE");
        dialogCreationMethods.add("SUBSCRIBE");
    }
}

