/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v2_2.system_alerts;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mobilitydata.gbfs.v2_2.system_alerts.GBFSTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"alert_id", "type", "times", "station_ids", "region_ids", "url", "summary", "description", "last_updated"})
public class GBFSAlert
implements Serializable {
    @JsonProperty(value="alert_id")
    @JsonPropertyDescription(value="Identifier for this alert.")
    private String alertId;
    @JsonProperty(value="type")
    @JsonPropertyDescription(value="Type of alert.")
    private Type type;
    @JsonProperty(value="times")
    @JsonPropertyDescription(value="Array of objects indicating when the alert is in effect.")
    private List<GBFSTime> times;
    @JsonProperty(value="station_ids")
    @JsonPropertyDescription(value="Array of identifiers of the stations for which this alert applies.")
    private List<String> stationIds;
    @JsonProperty(value="region_ids")
    @JsonPropertyDescription(value="Array of identifiers of the regions for which this alert applies.")
    private List<String> regionIds;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="URL where the customer can learn more information about this alert.")
    private String url;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A short summary of this alert to be displayed to the customer.")
    private String summary;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="Detailed description of the alert.")
    private String description;
    @JsonProperty(value="last_updated")
    @JsonPropertyDescription(value="Indicates the last time the info for the alert was updated.")
    private Double lastUpdated;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = 920193554102312688L;

    @JsonProperty(value="alert_id")
    public String getAlertId() {
        return this.alertId;
    }

    @JsonProperty(value="alert_id")
    public void setAlertId(String alertId) {
        this.alertId = alertId;
    }

    public GBFSAlert withAlertId(String alertId) {
        this.alertId = alertId;
        return this;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    public GBFSAlert withType(Type type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="times")
    public List<GBFSTime> getTimes() {
        return this.times;
    }

    @JsonProperty(value="times")
    public void setTimes(List<GBFSTime> times) {
        this.times = times;
    }

    public GBFSAlert withTimes(List<GBFSTime> times) {
        this.times = times;
        return this;
    }

    @JsonProperty(value="station_ids")
    public List<String> getStationIds() {
        return this.stationIds;
    }

    @JsonProperty(value="station_ids")
    public void setStationIds(List<String> stationIds) {
        this.stationIds = stationIds;
    }

    public GBFSAlert withStationIds(List<String> stationIds) {
        this.stationIds = stationIds;
        return this;
    }

    @JsonProperty(value="region_ids")
    public List<String> getRegionIds() {
        return this.regionIds;
    }

    @JsonProperty(value="region_ids")
    public void setRegionIds(List<String> regionIds) {
        this.regionIds = regionIds;
    }

    public GBFSAlert withRegionIds(List<String> regionIds) {
        this.regionIds = regionIds;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSAlert withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary) {
        this.summary = summary;
    }

    public GBFSAlert withSummary(String summary) {
        this.summary = summary;
        return this;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public GBFSAlert withDescription(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="last_updated")
    public Double getLastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="last_updated")
    public void setLastUpdated(Double lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public GBFSAlert withLastUpdated(Double lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSAlert withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSAlert.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("alertId");
        sb.append('=');
        sb.append(this.alertId == null ? "<null>" : this.alertId);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("times");
        sb.append('=');
        sb.append(this.times == null ? "<null>" : this.times);
        sb.append(',');
        sb.append("stationIds");
        sb.append('=');
        sb.append(this.stationIds == null ? "<null>" : this.stationIds);
        sb.append(',');
        sb.append("regionIds");
        sb.append('=');
        sb.append(this.regionIds == null ? "<null>" : this.regionIds);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("summary");
        sb.append('=');
        sb.append(this.summary == null ? "<null>" : this.summary);
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(this.description == null ? "<null>" : this.description);
        sb.append(',');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(this.lastUpdated == null ? "<null>" : this.lastUpdated);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.summary == null ? 0 : this.summary.hashCode());
        result = result * 31 + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = result * 31 + (this.times == null ? 0 : this.times.hashCode());
        result = result * 31 + (this.stationIds == null ? 0 : this.stationIds.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.regionIds == null ? 0 : this.regionIds.hashCode());
        result = result * 31 + (this.alertId == null ? 0 : this.alertId.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSAlert)) {
            return false;
        }
        GBFSAlert rhs = (GBFSAlert)other;
        return (this.summary == rhs.summary || this.summary != null && this.summary.equals(rhs.summary)) && (this.lastUpdated == rhs.lastUpdated || this.lastUpdated != null && this.lastUpdated.equals(rhs.lastUpdated)) && (this.times == rhs.times || this.times != null && this.times.equals(rhs.times)) && (this.stationIds == rhs.stationIds || this.stationIds != null && this.stationIds.equals(rhs.stationIds)) && (this.description == rhs.description || this.description != null && this.description.equals(rhs.description)) && (this.regionIds == rhs.regionIds || this.regionIds != null && this.regionIds.equals(rhs.regionIds)) && (this.alertId == rhs.alertId || this.alertId != null && this.alertId.equals(rhs.alertId)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url));
    }

    public static enum Type {
        SYSTEM_CLOSURE("system_closure"),
        STATION_CLOSURE("station_closure"),
        STATION_MOVE("station_move"),
        OTHER("other");

        private final String value;
        private static final Map<String, Type> CONSTANTS;

        private Type(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

