/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v3_0.gbfs;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Date;
import org.mobilitydata.gbfs.v3_0.gbfs.GBFSData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"last_updated", "ttl", "version", "data"})
public class GBFSGbfs
implements Serializable {
    @JsonProperty(value="last_updated")
    @JsonPropertyDescription(value="Last time the data in the feed was updated in RFC3339 format.")
    private Date lastUpdated;
    @JsonProperty(value="ttl")
    @JsonPropertyDescription(value="Number of seconds before the data in the feed will be updated again (0 if the data should always be refreshed).")
    private Integer ttl;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="GBFS version number to which the feed conforms, according to the versioning framework (added in v1.1).")
    private String version;
    @JsonProperty(value="data")
    private GBFSData data;
    private static final long serialVersionUID = 4250444807198685006L;

    @JsonProperty(value="last_updated")
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @JsonProperty(value="last_updated")
    public void setLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    public GBFSGbfs withLastUpdated(Date lastUpdated) {
        this.lastUpdated = lastUpdated;
        return this;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="ttl")
    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public GBFSGbfs withTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    public GBFSGbfs withVersion(String version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="data")
    public GBFSData getData() {
        return this.data;
    }

    @JsonProperty(value="data")
    public void setData(GBFSData data) {
        this.data = data;
    }

    public GBFSGbfs withData(GBFSData data) {
        this.data = data;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSGbfs.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("lastUpdated");
        sb.append('=');
        sb.append(this.lastUpdated == null ? "<null>" : this.lastUpdated);
        sb.append(',');
        sb.append("ttl");
        sb.append('=');
        sb.append(this.ttl == null ? "<null>" : this.ttl);
        sb.append(',');
        sb.append("version");
        sb.append('=');
        sb.append(this.version == null ? "<null>" : this.version);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.lastUpdated == null ? 0 : this.lastUpdated.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.ttl == null ? 0 : this.ttl.hashCode());
        result = result * 31 + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSGbfs)) {
            return false;
        }
        GBFSGbfs rhs = (GBFSGbfs)other;
        return (this.lastUpdated == rhs.lastUpdated || this.lastUpdated != null && this.lastUpdated.equals(rhs.lastUpdated)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.ttl == rhs.ttl || this.ttl != null && this.ttl.equals(rhs.ttl)) && (this.version == rhs.version || this.version != null && this.version.equals(rhs.version));
    }
}

