/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v3_0.system_information;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSAttributionOrganizationName;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSBrandAssets;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSName;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSOperator;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSPrivacyUrl;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSRentalApps;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSShortName;
import org.mobilitydata.gbfs.v3_0.system_information.GBFSTermsUrl;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"system_id", "languages", "name", "opening_hours", "short_name", "operator", "url", "purchase_url", "start_date", "termination_date", "phone_number", "email", "feed_contact_email", "manifest_url", "timezone", "license_id", "license_url", "attribution_organization_name", "attribution_url", "brand_assets", "terms_url", "terms_last_updated", "privacy_url", "privacy_last_updated", "rental_apps"})
public class GBFSData
implements Serializable {
    @JsonProperty(value="system_id")
    @JsonPropertyDescription(value="Identifier for this vehicle share system. This should be globally unique (even between different systems).")
    private String systemId;
    @JsonProperty(value="languages")
    @JsonPropertyDescription(value="List of languages used in translated strings. Each element in the list must be of type Language.")
    private List<String> languages;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the system to be displayed to customers. An array with one object per supported language with the following keys:")
    private List<GBFSName> name;
    @JsonProperty(value="opening_hours")
    @JsonPropertyDescription(value="Hours and dates of operation for the system in OSM opening_hours format. (added in v3.0)")
    private String openingHours;
    @JsonProperty(value="short_name")
    @JsonPropertyDescription(value="Abbreviation for a system. An array with one object per supported language with the following keys:")
    private List<GBFSShortName> shortName;
    @JsonProperty(value="operator")
    @JsonPropertyDescription(value="Name of the system operator. An array with one object per supported language with the following keys:")
    private List<GBFSOperator> operator;
    @JsonProperty(value="url")
    @JsonPropertyDescription(value="The URL of the vehicle share system.")
    private String url;
    @JsonProperty(value="purchase_url")
    @JsonPropertyDescription(value="URL where a customer can purchase a membership.")
    private String purchaseUrl;
    @JsonProperty(value="start_date")
    @JsonPropertyDescription(value="Date that the system began operations.")
    private String startDate;
    @JsonProperty(value="termination_date")
    @JsonPropertyDescription(value="Date after which this data source will no longer be available to consuming applications.")
    private String terminationDate;
    @JsonProperty(value="phone_number")
    @JsonPropertyDescription(value="This OPTIONAL field SHOULD contain a single voice telephone number for the specified system\u2019s customer service department. MUST be in E.164 format as defined in Field Types.")
    private String phoneNumber;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="Email address actively monitored by the operator's customer service department.")
    private String email;
    @JsonProperty(value="feed_contact_email")
    @JsonPropertyDescription(value="A single contact email address for consumers of this feed to report technical issues (added in v1.1).")
    private String feedContactEmail;
    @JsonProperty(value="manifest_url")
    @JsonPropertyDescription(value="REQUIRED if the producer publishes datasets for more than one system geography, for example Berlin and Paris. A fully qualified URL pointing to the manifest.json file for the publisher.")
    private String manifestUrl;
    @JsonProperty(value="timezone")
    @JsonPropertyDescription(value="The time zone where the system is located.")
    private Timezone timezone;
    @JsonProperty(value="license_id")
    @JsonPropertyDescription(value="REQUIRED if the dataset is provided under a standard license. An identifier for a standard license from the SPDX License List. Provide license_id rather than license_url if the license is included in the SPDX License List. See the GBFS wiki for a comparison of a subset of standard licenses. If the license_id and license_url fields are blank or omitted, this indicates that the feed is provided under the Creative Commons Universal Public Domain Dedication.")
    private LicenseId licenseId;
    @JsonProperty(value="license_url")
    @JsonPropertyDescription(value="A fully qualified URL of a page that defines the license terms for the GBFS data for this system.")
    private String licenseUrl;
    @JsonProperty(value="attribution_organization_name")
    @JsonPropertyDescription(value="If the feed license requires attribution, name of the organization to which attribution should be provided. An array with one object per supported language with the following keys:")
    private List<GBFSAttributionOrganizationName> attributionOrganizationName;
    @JsonProperty(value="attribution_url")
    @JsonPropertyDescription(value="URL of the organization to which attribution should be provided.")
    private String attributionUrl;
    @JsonProperty(value="brand_assets")
    @JsonPropertyDescription(value="An object where each key defines one of the items listed below (added in v2.3-RC).")
    private GBFSBrandAssets brandAssets;
    @JsonProperty(value="terms_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the terms of service (also often called \"terms of use\" or \"terms and conditions\") for the service. An array with one object per supported language with the following keys:")
    private List<GBFSTermsUrl> termsUrl;
    @JsonProperty(value="terms_last_updated")
    @JsonPropertyDescription(value="The date that the terms of service provided at terms_url were last updated (added in v2.3-RC)")
    private String termsLastUpdated;
    @JsonProperty(value="privacy_url")
    @JsonPropertyDescription(value="A fully qualified URL pointing to the privacy policy for the service. An array with one object per supported language with the following keys:")
    private List<GBFSPrivacyUrl> privacyUrl;
    @JsonProperty(value="privacy_last_updated")
    @JsonPropertyDescription(value="The date that the privacy policy provided at privacy_url was last updated (added in v2.3-RC).")
    private String privacyLastUpdated;
    @JsonProperty(value="rental_apps")
    @JsonPropertyDescription(value="Contains rental app information in the android and ios JSON objects (added in v1.1).")
    private GBFSRentalApps rentalApps;
    private static final long serialVersionUID = 6470195329878396154L;

    @JsonProperty(value="system_id")
    public String getSystemId() {
        return this.systemId;
    }

    @JsonProperty(value="system_id")
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public GBFSData withSystemId(String systemId) {
        this.systemId = systemId;
        return this;
    }

    @JsonProperty(value="languages")
    public List<String> getLanguages() {
        return this.languages;
    }

    @JsonProperty(value="languages")
    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public GBFSData withLanguages(List<String> languages) {
        this.languages = languages;
        return this;
    }

    @JsonProperty(value="name")
    public List<GBFSName> getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(List<GBFSName> name) {
        this.name = name;
    }

    public GBFSData withName(List<GBFSName> name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="opening_hours")
    public String getOpeningHours() {
        return this.openingHours;
    }

    @JsonProperty(value="opening_hours")
    public void setOpeningHours(String openingHours) {
        this.openingHours = openingHours;
    }

    public GBFSData withOpeningHours(String openingHours) {
        this.openingHours = openingHours;
        return this;
    }

    @JsonProperty(value="short_name")
    public List<GBFSShortName> getShortName() {
        return this.shortName;
    }

    @JsonProperty(value="short_name")
    public void setShortName(List<GBFSShortName> shortName) {
        this.shortName = shortName;
    }

    public GBFSData withShortName(List<GBFSShortName> shortName) {
        this.shortName = shortName;
        return this;
    }

    @JsonProperty(value="operator")
    public List<GBFSOperator> getOperator() {
        return this.operator;
    }

    @JsonProperty(value="operator")
    public void setOperator(List<GBFSOperator> operator) {
        this.operator = operator;
    }

    public GBFSData withOperator(List<GBFSOperator> operator) {
        this.operator = operator;
        return this;
    }

    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    public void setUrl(String url) {
        this.url = url;
    }

    public GBFSData withUrl(String url) {
        this.url = url;
        return this;
    }

    @JsonProperty(value="purchase_url")
    public String getPurchaseUrl() {
        return this.purchaseUrl;
    }

    @JsonProperty(value="purchase_url")
    public void setPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
    }

    public GBFSData withPurchaseUrl(String purchaseUrl) {
        this.purchaseUrl = purchaseUrl;
        return this;
    }

    @JsonProperty(value="start_date")
    public String getStartDate() {
        return this.startDate;
    }

    @JsonProperty(value="start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public GBFSData withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }

    @JsonProperty(value="termination_date")
    public String getTerminationDate() {
        return this.terminationDate;
    }

    @JsonProperty(value="termination_date")
    public void setTerminationDate(String terminationDate) {
        this.terminationDate = terminationDate;
    }

    public GBFSData withTerminationDate(String terminationDate) {
        this.terminationDate = terminationDate;
        return this;
    }

    @JsonProperty(value="phone_number")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public GBFSData withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    public GBFSData withEmail(String email) {
        this.email = email;
        return this;
    }

    @JsonProperty(value="feed_contact_email")
    public String getFeedContactEmail() {
        return this.feedContactEmail;
    }

    @JsonProperty(value="feed_contact_email")
    public void setFeedContactEmail(String feedContactEmail) {
        this.feedContactEmail = feedContactEmail;
    }

    public GBFSData withFeedContactEmail(String feedContactEmail) {
        this.feedContactEmail = feedContactEmail;
        return this;
    }

    @JsonProperty(value="manifest_url")
    public String getManifestUrl() {
        return this.manifestUrl;
    }

    @JsonProperty(value="manifest_url")
    public void setManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
    }

    public GBFSData withManifestUrl(String manifestUrl) {
        this.manifestUrl = manifestUrl;
        return this;
    }

    @JsonProperty(value="timezone")
    public Timezone getTimezone() {
        return this.timezone;
    }

    @JsonProperty(value="timezone")
    public void setTimezone(Timezone timezone) {
        this.timezone = timezone;
    }

    public GBFSData withTimezone(Timezone timezone) {
        this.timezone = timezone;
        return this;
    }

    @JsonProperty(value="license_id")
    public LicenseId getLicenseId() {
        return this.licenseId;
    }

    @JsonProperty(value="license_id")
    public void setLicenseId(LicenseId licenseId) {
        this.licenseId = licenseId;
    }

    public GBFSData withLicenseId(LicenseId licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @JsonProperty(value="license_url")
    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    @JsonProperty(value="license_url")
    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public GBFSData withLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
        return this;
    }

    @JsonProperty(value="attribution_organization_name")
    public List<GBFSAttributionOrganizationName> getAttributionOrganizationName() {
        return this.attributionOrganizationName;
    }

    @JsonProperty(value="attribution_organization_name")
    public void setAttributionOrganizationName(List<GBFSAttributionOrganizationName> attributionOrganizationName) {
        this.attributionOrganizationName = attributionOrganizationName;
    }

    public GBFSData withAttributionOrganizationName(List<GBFSAttributionOrganizationName> attributionOrganizationName) {
        this.attributionOrganizationName = attributionOrganizationName;
        return this;
    }

    @JsonProperty(value="attribution_url")
    public String getAttributionUrl() {
        return this.attributionUrl;
    }

    @JsonProperty(value="attribution_url")
    public void setAttributionUrl(String attributionUrl) {
        this.attributionUrl = attributionUrl;
    }

    public GBFSData withAttributionUrl(String attributionUrl) {
        this.attributionUrl = attributionUrl;
        return this;
    }

    @JsonProperty(value="brand_assets")
    public GBFSBrandAssets getBrandAssets() {
        return this.brandAssets;
    }

    @JsonProperty(value="brand_assets")
    public void setBrandAssets(GBFSBrandAssets brandAssets) {
        this.brandAssets = brandAssets;
    }

    public GBFSData withBrandAssets(GBFSBrandAssets brandAssets) {
        this.brandAssets = brandAssets;
        return this;
    }

    @JsonProperty(value="terms_url")
    public List<GBFSTermsUrl> getTermsUrl() {
        return this.termsUrl;
    }

    @JsonProperty(value="terms_url")
    public void setTermsUrl(List<GBFSTermsUrl> termsUrl) {
        this.termsUrl = termsUrl;
    }

    public GBFSData withTermsUrl(List<GBFSTermsUrl> termsUrl) {
        this.termsUrl = termsUrl;
        return this;
    }

    @JsonProperty(value="terms_last_updated")
    public String getTermsLastUpdated() {
        return this.termsLastUpdated;
    }

    @JsonProperty(value="terms_last_updated")
    public void setTermsLastUpdated(String termsLastUpdated) {
        this.termsLastUpdated = termsLastUpdated;
    }

    public GBFSData withTermsLastUpdated(String termsLastUpdated) {
        this.termsLastUpdated = termsLastUpdated;
        return this;
    }

    @JsonProperty(value="privacy_url")
    public List<GBFSPrivacyUrl> getPrivacyUrl() {
        return this.privacyUrl;
    }

    @JsonProperty(value="privacy_url")
    public void setPrivacyUrl(List<GBFSPrivacyUrl> privacyUrl) {
        this.privacyUrl = privacyUrl;
    }

    public GBFSData withPrivacyUrl(List<GBFSPrivacyUrl> privacyUrl) {
        this.privacyUrl = privacyUrl;
        return this;
    }

    @JsonProperty(value="privacy_last_updated")
    public String getPrivacyLastUpdated() {
        return this.privacyLastUpdated;
    }

    @JsonProperty(value="privacy_last_updated")
    public void setPrivacyLastUpdated(String privacyLastUpdated) {
        this.privacyLastUpdated = privacyLastUpdated;
    }

    public GBFSData withPrivacyLastUpdated(String privacyLastUpdated) {
        this.privacyLastUpdated = privacyLastUpdated;
        return this;
    }

    @JsonProperty(value="rental_apps")
    public GBFSRentalApps getRentalApps() {
        return this.rentalApps;
    }

    @JsonProperty(value="rental_apps")
    public void setRentalApps(GBFSRentalApps rentalApps) {
        this.rentalApps = rentalApps;
    }

    public GBFSData withRentalApps(GBFSRentalApps rentalApps) {
        this.rentalApps = rentalApps;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSData.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("systemId");
        sb.append('=');
        sb.append(this.systemId == null ? "<null>" : this.systemId);
        sb.append(',');
        sb.append("languages");
        sb.append('=');
        sb.append(this.languages == null ? "<null>" : this.languages);
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("openingHours");
        sb.append('=');
        sb.append(this.openingHours == null ? "<null>" : this.openingHours);
        sb.append(',');
        sb.append("shortName");
        sb.append('=');
        sb.append(this.shortName == null ? "<null>" : this.shortName);
        sb.append(',');
        sb.append("operator");
        sb.append('=');
        sb.append(this.operator == null ? "<null>" : this.operator);
        sb.append(',');
        sb.append("url");
        sb.append('=');
        sb.append(this.url == null ? "<null>" : this.url);
        sb.append(',');
        sb.append("purchaseUrl");
        sb.append('=');
        sb.append(this.purchaseUrl == null ? "<null>" : this.purchaseUrl);
        sb.append(',');
        sb.append("startDate");
        sb.append('=');
        sb.append(this.startDate == null ? "<null>" : this.startDate);
        sb.append(',');
        sb.append("terminationDate");
        sb.append('=');
        sb.append(this.terminationDate == null ? "<null>" : this.terminationDate);
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(this.phoneNumber == null ? "<null>" : this.phoneNumber);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("feedContactEmail");
        sb.append('=');
        sb.append(this.feedContactEmail == null ? "<null>" : this.feedContactEmail);
        sb.append(',');
        sb.append("manifestUrl");
        sb.append('=');
        sb.append(this.manifestUrl == null ? "<null>" : this.manifestUrl);
        sb.append(',');
        sb.append("timezone");
        sb.append('=');
        sb.append(this.timezone == null ? "<null>" : this.timezone);
        sb.append(',');
        sb.append("licenseId");
        sb.append('=');
        sb.append(this.licenseId == null ? "<null>" : this.licenseId);
        sb.append(',');
        sb.append("licenseUrl");
        sb.append('=');
        sb.append(this.licenseUrl == null ? "<null>" : this.licenseUrl);
        sb.append(',');
        sb.append("attributionOrganizationName");
        sb.append('=');
        sb.append(this.attributionOrganizationName == null ? "<null>" : this.attributionOrganizationName);
        sb.append(',');
        sb.append("attributionUrl");
        sb.append('=');
        sb.append(this.attributionUrl == null ? "<null>" : this.attributionUrl);
        sb.append(',');
        sb.append("brandAssets");
        sb.append('=');
        sb.append(this.brandAssets == null ? "<null>" : this.brandAssets);
        sb.append(',');
        sb.append("termsUrl");
        sb.append('=');
        sb.append(this.termsUrl == null ? "<null>" : this.termsUrl);
        sb.append(',');
        sb.append("termsLastUpdated");
        sb.append('=');
        sb.append(this.termsLastUpdated == null ? "<null>" : this.termsLastUpdated);
        sb.append(',');
        sb.append("privacyUrl");
        sb.append('=');
        sb.append(this.privacyUrl == null ? "<null>" : this.privacyUrl);
        sb.append(',');
        sb.append("privacyLastUpdated");
        sb.append('=');
        sb.append(this.privacyLastUpdated == null ? "<null>" : this.privacyLastUpdated);
        sb.append(',');
        sb.append("rentalApps");
        sb.append('=');
        sb.append(this.rentalApps == null ? "<null>" : this.rentalApps);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.privacyUrl == null ? 0 : this.privacyUrl.hashCode());
        result = result * 31 + (this.licenseUrl == null ? 0 : this.licenseUrl.hashCode());
        result = result * 31 + (this.privacyLastUpdated == null ? 0 : this.privacyLastUpdated.hashCode());
        result = result * 31 + (this.timezone == null ? 0 : this.timezone.hashCode());
        result = result * 31 + (this.operator == null ? 0 : this.operator.hashCode());
        result = result * 31 + (this.purchaseUrl == null ? 0 : this.purchaseUrl.hashCode());
        result = result * 31 + (this.terminationDate == null ? 0 : this.terminationDate.hashCode());
        result = result * 31 + (this.manifestUrl == null ? 0 : this.manifestUrl.hashCode());
        result = result * 31 + (this.attributionOrganizationName == null ? 0 : this.attributionOrganizationName.hashCode());
        result = result * 31 + (this.licenseId == null ? 0 : this.licenseId.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.systemId == null ? 0 : this.systemId.hashCode());
        result = result * 31 + (this.languages == null ? 0 : this.languages.hashCode());
        result = result * 31 + (this.rentalApps == null ? 0 : this.rentalApps.hashCode());
        result = result * 31 + (this.url == null ? 0 : this.url.hashCode());
        result = result * 31 + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = result * 31 + (this.termsUrl == null ? 0 : this.termsUrl.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.feedContactEmail == null ? 0 : this.feedContactEmail.hashCode());
        result = result * 31 + (this.attributionUrl == null ? 0 : this.attributionUrl.hashCode());
        result = result * 31 + (this.openingHours == null ? 0 : this.openingHours.hashCode());
        result = result * 31 + (this.shortName == null ? 0 : this.shortName.hashCode());
        result = result * 31 + (this.termsLastUpdated == null ? 0 : this.termsLastUpdated.hashCode());
        result = result * 31 + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = result * 31 + (this.brandAssets == null ? 0 : this.brandAssets.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSData)) {
            return false;
        }
        GBFSData rhs = (GBFSData)other;
        return (this.privacyUrl == rhs.privacyUrl || this.privacyUrl != null && this.privacyUrl.equals(rhs.privacyUrl)) && (this.licenseUrl == rhs.licenseUrl || this.licenseUrl != null && this.licenseUrl.equals(rhs.licenseUrl)) && (this.privacyLastUpdated == rhs.privacyLastUpdated || this.privacyLastUpdated != null && this.privacyLastUpdated.equals(rhs.privacyLastUpdated)) && (this.timezone == rhs.timezone || this.timezone != null && this.timezone.equals((Object)rhs.timezone)) && (this.operator == rhs.operator || this.operator != null && this.operator.equals(rhs.operator)) && (this.purchaseUrl == rhs.purchaseUrl || this.purchaseUrl != null && this.purchaseUrl.equals(rhs.purchaseUrl)) && (this.terminationDate == rhs.terminationDate || this.terminationDate != null && this.terminationDate.equals(rhs.terminationDate)) && (this.manifestUrl == rhs.manifestUrl || this.manifestUrl != null && this.manifestUrl.equals(rhs.manifestUrl)) && (this.attributionOrganizationName == rhs.attributionOrganizationName || this.attributionOrganizationName != null && this.attributionOrganizationName.equals(rhs.attributionOrganizationName)) && (this.licenseId == rhs.licenseId || this.licenseId != null && this.licenseId.equals((Object)rhs.licenseId)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.systemId == rhs.systemId || this.systemId != null && this.systemId.equals(rhs.systemId)) && (this.languages == rhs.languages || this.languages != null && this.languages.equals(rhs.languages)) && (this.rentalApps == rhs.rentalApps || this.rentalApps != null && this.rentalApps.equals(rhs.rentalApps)) && (this.url == rhs.url || this.url != null && this.url.equals(rhs.url)) && (this.phoneNumber == rhs.phoneNumber || this.phoneNumber != null && this.phoneNumber.equals(rhs.phoneNumber)) && (this.termsUrl == rhs.termsUrl || this.termsUrl != null && this.termsUrl.equals(rhs.termsUrl)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.feedContactEmail == rhs.feedContactEmail || this.feedContactEmail != null && this.feedContactEmail.equals(rhs.feedContactEmail)) && (this.attributionUrl == rhs.attributionUrl || this.attributionUrl != null && this.attributionUrl.equals(rhs.attributionUrl)) && (this.openingHours == rhs.openingHours || this.openingHours != null && this.openingHours.equals(rhs.openingHours)) && (this.shortName == rhs.shortName || this.shortName != null && this.shortName.equals(rhs.shortName)) && (this.termsLastUpdated == rhs.termsLastUpdated || this.termsLastUpdated != null && this.termsLastUpdated.equals(rhs.termsLastUpdated)) && (this.startDate == rhs.startDate || this.startDate != null && this.startDate.equals(rhs.startDate)) && (this.brandAssets == rhs.brandAssets || this.brandAssets != null && this.brandAssets.equals(rhs.brandAssets));
    }

    public static enum Timezone {
        AFRICA_ABIDJAN("Africa/Abidjan"),
        AFRICA_ALGIERS("Africa/Algiers"),
        AFRICA_BISSAU("Africa/Bissau"),
        AFRICA_CAIRO("Africa/Cairo"),
        AFRICA_CASABLANCA("Africa/Casablanca"),
        AFRICA_CEUTA("Africa/Ceuta"),
        AFRICA_EL_AAIUN("Africa/El_Aaiun"),
        AFRICA_JOHANNESBURG("Africa/Johannesburg"),
        AFRICA_JUBA("Africa/Juba"),
        AFRICA_KHARTOUM("Africa/Khartoum"),
        AFRICA_LAGOS("Africa/Lagos"),
        AFRICA_MAPUTO("Africa/Maputo"),
        AFRICA_MONROVIA("Africa/Monrovia"),
        AFRICA_NAIROBI("Africa/Nairobi"),
        AFRICA_NDJAMENA("Africa/Ndjamena"),
        AFRICA_SAO_TOME("Africa/Sao_Tome"),
        AFRICA_TRIPOLI("Africa/Tripoli"),
        AFRICA_TUNIS("Africa/Tunis"),
        AFRICA_WINDHOEK("Africa/Windhoek"),
        AMERICA_ADAK("America/Adak"),
        AMERICA_ANCHORAGE("America/Anchorage"),
        AMERICA_ARAGUAINA("America/Araguaina"),
        AMERICA_ARGENTINA_BUENOS_AIRES("America/Argentina/Buenos_Aires"),
        AMERICA_ARGENTINA_CATAMARCA("America/Argentina/Catamarca"),
        AMERICA_ARGENTINA_CORDOBA("America/Argentina/Cordoba"),
        AMERICA_ARGENTINA_JUJUY("America/Argentina/Jujuy"),
        AMERICA_ARGENTINA_LA_RIOJA("America/Argentina/La_Rioja"),
        AMERICA_ARGENTINA_MENDOZA("America/Argentina/Mendoza"),
        AMERICA_ARGENTINA_RIO_GALLEGOS("America/Argentina/Rio_Gallegos"),
        AMERICA_ARGENTINA_SALTA("America/Argentina/Salta"),
        AMERICA_ARGENTINA_SAN_JUAN("America/Argentina/San_Juan"),
        AMERICA_ARGENTINA_SAN_LUIS("America/Argentina/San_Luis"),
        AMERICA_ARGENTINA_TUCUMAN("America/Argentina/Tucuman"),
        AMERICA_ARGENTINA_USHUAIA("America/Argentina/Ushuaia"),
        AMERICA_ASUNCION("America/Asuncion"),
        AMERICA_BAHIA("America/Bahia"),
        AMERICA_BAHIA_BANDERAS("America/Bahia_Banderas"),
        AMERICA_BARBADOS("America/Barbados"),
        AMERICA_BELEM("America/Belem"),
        AMERICA_BELIZE("America/Belize"),
        AMERICA_BOA_VISTA("America/Boa_Vista"),
        AMERICA_BOGOTA("America/Bogota"),
        AMERICA_BOISE("America/Boise"),
        AMERICA_CAMBRIDGE_BAY("America/Cambridge_Bay"),
        AMERICA_CAMPO_GRANDE("America/Campo_Grande"),
        AMERICA_CANCUN("America/Cancun"),
        AMERICA_CARACAS("America/Caracas"),
        AMERICA_CAYENNE("America/Cayenne"),
        AMERICA_CHICAGO("America/Chicago"),
        AMERICA_CHIHUAHUA("America/Chihuahua"),
        AMERICA_COSTA_RICA("America/Costa_Rica"),
        AMERICA_CUIABA("America/Cuiaba"),
        AMERICA_DANMARKSHAVN("America/Danmarkshavn"),
        AMERICA_DAWSON("America/Dawson"),
        AMERICA_DAWSON_CREEK("America/Dawson_Creek"),
        AMERICA_DENVER("America/Denver"),
        AMERICA_DETROIT("America/Detroit"),
        AMERICA_EDMONTON("America/Edmonton"),
        AMERICA_EIRUNEPE("America/Eirunepe"),
        AMERICA_EL_SALVADOR("America/El_Salvador"),
        AMERICA_FORT_NELSON("America/Fort_Nelson"),
        AMERICA_FORTALEZA("America/Fortaleza"),
        AMERICA_GLACE_BAY("America/Glace_Bay"),
        AMERICA_GOOSE_BAY("America/Goose_Bay"),
        AMERICA_GRAND_TURK("America/Grand_Turk"),
        AMERICA_GUATEMALA("America/Guatemala"),
        AMERICA_GUAYAQUIL("America/Guayaquil"),
        AMERICA_GUYANA("America/Guyana"),
        AMERICA_HALIFAX("America/Halifax"),
        AMERICA_HAVANA("America/Havana"),
        AMERICA_HERMOSILLO("America/Hermosillo"),
        AMERICA_INDIANA_INDIANAPOLIS("America/Indiana/Indianapolis"),
        AMERICA_INDIANA_KNOX("America/Indiana/Knox"),
        AMERICA_INDIANA_MARENGO("America/Indiana/Marengo"),
        AMERICA_INDIANA_PETERSBURG("America/Indiana/Petersburg"),
        AMERICA_INDIANA_TELL_CITY("America/Indiana/Tell_City"),
        AMERICA_INDIANA_VEVAY("America/Indiana/Vevay"),
        AMERICA_INDIANA_VINCENNES("America/Indiana/Vincennes"),
        AMERICA_INDIANA_WINAMAC("America/Indiana/Winamac"),
        AMERICA_INUVIK("America/Inuvik"),
        AMERICA_IQALUIT("America/Iqaluit"),
        AMERICA_JAMAICA("America/Jamaica"),
        AMERICA_JUNEAU("America/Juneau"),
        AMERICA_KENTUCKY_LOUISVILLE("America/Kentucky/Louisville"),
        AMERICA_KENTUCKY_MONTICELLO("America/Kentucky/Monticello"),
        AMERICA_LA_PAZ("America/La_Paz"),
        AMERICA_LIMA("America/Lima"),
        AMERICA_LOS_ANGELES("America/Los_Angeles"),
        AMERICA_MACEIO("America/Maceio"),
        AMERICA_MANAGUA("America/Managua"),
        AMERICA_MANAUS("America/Manaus"),
        AMERICA_MARTINIQUE("America/Martinique"),
        AMERICA_MATAMOROS("America/Matamoros"),
        AMERICA_MAZATLAN("America/Mazatlan"),
        AMERICA_MENOMINEE("America/Menominee"),
        AMERICA_MERIDA("America/Merida"),
        AMERICA_METLAKATLA("America/Metlakatla"),
        AMERICA_MEXICO_CITY("America/Mexico_City"),
        AMERICA_MIQUELON("America/Miquelon"),
        AMERICA_MONCTON("America/Moncton"),
        AMERICA_MONTERREY("America/Monterrey"),
        AMERICA_MONTEVIDEO("America/Montevideo"),
        AMERICA_NEW_YORK("America/New_York"),
        AMERICA_NIPIGON("America/Nipigon"),
        AMERICA_NOME("America/Nome"),
        AMERICA_NORONHA("America/Noronha"),
        AMERICA_NORTH_DAKOTA_BEULAH("America/North_Dakota/Beulah"),
        AMERICA_NORTH_DAKOTA_CENTER("America/North_Dakota/Center"),
        AMERICA_NORTH_DAKOTA_NEW_SALEM("America/North_Dakota/New_Salem"),
        AMERICA_NUUK("America/Nuuk"),
        AMERICA_OJINAGA("America/Ojinaga"),
        AMERICA_PANAMA("America/Panama"),
        AMERICA_PANGNIRTUNG("America/Pangnirtung"),
        AMERICA_PARAMARIBO("America/Paramaribo"),
        AMERICA_PHOENIX("America/Phoenix"),
        AMERICA_PORT_AU_PRINCE("America/Port-au-Prince"),
        AMERICA_PORTO_VELHO("America/Porto_Velho"),
        AMERICA_PUERTO_RICO("America/Puerto_Rico"),
        AMERICA_PUNTA_ARENAS("America/Punta_Arenas"),
        AMERICA_RAINY_RIVER("America/Rainy_River"),
        AMERICA_RANKIN_INLET("America/Rankin_Inlet"),
        AMERICA_RECIFE("America/Recife"),
        AMERICA_REGINA("America/Regina"),
        AMERICA_RESOLUTE("America/Resolute"),
        AMERICA_RIO_BRANCO("America/Rio_Branco"),
        AMERICA_SANTAREM("America/Santarem"),
        AMERICA_SANTIAGO("America/Santiago"),
        AMERICA_SANTO_DOMINGO("America/Santo_Domingo"),
        AMERICA_SAO_PAULO("America/Sao_Paulo"),
        AMERICA_SCORESBYSUND("America/Scoresbysund"),
        AMERICA_SITKA("America/Sitka"),
        AMERICA_ST_JOHNS("America/St_Johns"),
        AMERICA_SWIFT_CURRENT("America/Swift_Current"),
        AMERICA_TEGUCIGALPA("America/Tegucigalpa"),
        AMERICA_THULE("America/Thule"),
        AMERICA_THUNDER_BAY("America/Thunder_Bay"),
        AMERICA_TIJUANA("America/Tijuana"),
        AMERICA_TORONTO("America/Toronto"),
        AMERICA_VANCOUVER("America/Vancouver"),
        AMERICA_WHITEHORSE("America/Whitehorse"),
        AMERICA_WINNIPEG("America/Winnipeg"),
        AMERICA_YAKUTAT("America/Yakutat"),
        AMERICA_YELLOWKNIFE("America/Yellowknife"),
        ANTARCTICA_CASEY("Antarctica/Casey"),
        ANTARCTICA_DAVIS("Antarctica/Davis"),
        ANTARCTICA_MACQUARIE("Antarctica/Macquarie"),
        ANTARCTICA_MAWSON("Antarctica/Mawson"),
        ANTARCTICA_PALMER("Antarctica/Palmer"),
        ANTARCTICA_ROTHERA("Antarctica/Rothera"),
        ANTARCTICA_TROLL("Antarctica/Troll"),
        ANTARCTICA_VOSTOK("Antarctica/Vostok"),
        ASIA_ALMATY("Asia/Almaty"),
        ASIA_AMMAN("Asia/Amman"),
        ASIA_ANADYR("Asia/Anadyr"),
        ASIA_AQTAU("Asia/Aqtau"),
        ASIA_AQTOBE("Asia/Aqtobe"),
        ASIA_ASHGABAT("Asia/Ashgabat"),
        ASIA_ATYRAU("Asia/Atyrau"),
        ASIA_BAGHDAD("Asia/Baghdad"),
        ASIA_BAKU("Asia/Baku"),
        ASIA_BANGKOK("Asia/Bangkok"),
        ASIA_BARNAUL("Asia/Barnaul"),
        ASIA_BEIRUT("Asia/Beirut"),
        ASIA_BISHKEK("Asia/Bishkek"),
        ASIA_BRUNEI("Asia/Brunei"),
        ASIA_CHITA("Asia/Chita"),
        ASIA_CHOIBALSAN("Asia/Choibalsan"),
        ASIA_COLOMBO("Asia/Colombo"),
        ASIA_DAMASCUS("Asia/Damascus"),
        ASIA_DHAKA("Asia/Dhaka"),
        ASIA_DILI("Asia/Dili"),
        ASIA_DUBAI("Asia/Dubai"),
        ASIA_DUSHANBE("Asia/Dushanbe"),
        ASIA_FAMAGUSTA("Asia/Famagusta"),
        ASIA_GAZA("Asia/Gaza"),
        ASIA_HEBRON("Asia/Hebron"),
        ASIA_HO_CHI_MINH("Asia/Ho_Chi_Minh"),
        ASIA_HONG_KONG("Asia/Hong_Kong"),
        ASIA_HOVD("Asia/Hovd"),
        ASIA_IRKUTSK("Asia/Irkutsk"),
        ASIA_JAKARTA("Asia/Jakarta"),
        ASIA_JAYAPURA("Asia/Jayapura"),
        ASIA_JERUSALEM("Asia/Jerusalem"),
        ASIA_KABUL("Asia/Kabul"),
        ASIA_KAMCHATKA("Asia/Kamchatka"),
        ASIA_KARACHI("Asia/Karachi"),
        ASIA_KATHMANDU("Asia/Kathmandu"),
        ASIA_KHANDYGA("Asia/Khandyga"),
        ASIA_KOLKATA("Asia/Kolkata"),
        ASIA_KRASNOYARSK("Asia/Krasnoyarsk"),
        ASIA_KUALA_LUMPUR("Asia/Kuala_Lumpur"),
        ASIA_KUCHING("Asia/Kuching"),
        ASIA_MACAU("Asia/Macau"),
        ASIA_MAGADAN("Asia/Magadan"),
        ASIA_MAKASSAR("Asia/Makassar"),
        ASIA_MANILA("Asia/Manila"),
        ASIA_NICOSIA("Asia/Nicosia"),
        ASIA_NOVOKUZNETSK("Asia/Novokuznetsk"),
        ASIA_NOVOSIBIRSK("Asia/Novosibirsk"),
        ASIA_OMSK("Asia/Omsk"),
        ASIA_ORAL("Asia/Oral"),
        ASIA_PONTIANAK("Asia/Pontianak"),
        ASIA_PYONGYANG("Asia/Pyongyang"),
        ASIA_QATAR("Asia/Qatar"),
        ASIA_QOSTANAY("Asia/Qostanay"),
        ASIA_QYZYLORDA("Asia/Qyzylorda"),
        ASIA_RIYADH("Asia/Riyadh"),
        ASIA_SAKHALIN("Asia/Sakhalin"),
        ASIA_SAMARKAND("Asia/Samarkand"),
        ASIA_SEOUL("Asia/Seoul"),
        ASIA_SHANGHAI("Asia/Shanghai"),
        ASIA_SINGAPORE("Asia/Singapore"),
        ASIA_SREDNEKOLYMSK("Asia/Srednekolymsk"),
        ASIA_TAIPEI("Asia/Taipei"),
        ASIA_TASHKENT("Asia/Tashkent"),
        ASIA_TBILISI("Asia/Tbilisi"),
        ASIA_TEHRAN("Asia/Tehran"),
        ASIA_THIMPHU("Asia/Thimphu"),
        ASIA_TOKYO("Asia/Tokyo"),
        ASIA_TOMSK("Asia/Tomsk"),
        ASIA_ULAANBAATAR("Asia/Ulaanbaatar"),
        ASIA_URUMQI("Asia/Urumqi"),
        ASIA_UST_NERA("Asia/Ust-Nera"),
        ASIA_VLADIVOSTOK("Asia/Vladivostok"),
        ASIA_YAKUTSK("Asia/Yakutsk"),
        ASIA_YANGON("Asia/Yangon"),
        ASIA_YEKATERINBURG("Asia/Yekaterinburg"),
        ASIA_YEREVAN("Asia/Yerevan"),
        ATLANTIC_AZORES("Atlantic/Azores"),
        ATLANTIC_BERMUDA("Atlantic/Bermuda"),
        ATLANTIC_CANARY("Atlantic/Canary"),
        ATLANTIC_CAPE_VERDE("Atlantic/Cape_Verde"),
        ATLANTIC_FAROE("Atlantic/Faroe"),
        ATLANTIC_MADEIRA("Atlantic/Madeira"),
        ATLANTIC_REYKJAVIK("Atlantic/Reykjavik"),
        ATLANTIC_SOUTH_GEORGIA("Atlantic/South_Georgia"),
        ATLANTIC_STANLEY("Atlantic/Stanley"),
        AUSTRALIA_ADELAIDE("Australia/Adelaide"),
        AUSTRALIA_BRISBANE("Australia/Brisbane"),
        AUSTRALIA_BROKEN_HILL("Australia/Broken_Hill"),
        AUSTRALIA_DARWIN("Australia/Darwin"),
        AUSTRALIA_EUCLA("Australia/Eucla"),
        AUSTRALIA_HOBART("Australia/Hobart"),
        AUSTRALIA_LINDEMAN("Australia/Lindeman"),
        AUSTRALIA_LORD_HOWE("Australia/Lord_Howe"),
        AUSTRALIA_MELBOURNE("Australia/Melbourne"),
        AUSTRALIA_PERTH("Australia/Perth"),
        AUSTRALIA_SYDNEY("Australia/Sydney"),
        CET("CET"),
        CST_6_CDT("CST6CDT"),
        EET("EET"),
        EST("EST"),
        EST_5_EDT("EST5EDT"),
        ETC_GMT("Etc/GMT"),
        ETC_GMT_1("Etc/GMT-1"),
        ETC_GMT_10("Etc/GMT-10"),
        ETC_GMT_11("Etc/GMT-11"),
        ETC_GMT_12("Etc/GMT-12"),
        ETC_GMT_13("Etc/GMT-13"),
        ETC_GMT_14("Etc/GMT-14"),
        ETC_GMT_2("Etc/GMT-2"),
        ETC_GMT_3("Etc/GMT-3"),
        ETC_GMT_4("Etc/GMT-4"),
        ETC_GMT_5("Etc/GMT-5"),
        ETC_GMT_6("Etc/GMT-6"),
        ETC_GMT_7("Etc/GMT-7"),
        ETC_GMT_8("Etc/GMT-8"),
        ETC_GMT_9("Etc/GMT-9"),
        ETC_GMT_1_("Etc/GMT+1"),
        ETC_GMT_10_("Etc/GMT+10"),
        ETC_GMT_11_("Etc/GMT+11"),
        ETC_GMT_12_("Etc/GMT+12"),
        ETC_GMT_2_("Etc/GMT+2"),
        ETC_GMT_3_("Etc/GMT+3"),
        ETC_GMT_4_("Etc/GMT+4"),
        ETC_GMT_5_("Etc/GMT+5"),
        ETC_GMT_6_("Etc/GMT+6"),
        ETC_GMT_7_("Etc/GMT+7"),
        ETC_GMT_8_("Etc/GMT+8"),
        ETC_GMT_9_("Etc/GMT+9"),
        ETC_UTC("Etc/UTC"),
        EUROPE_AMSTERDAM("Europe/Amsterdam"),
        EUROPE_ANDORRA("Europe/Andorra"),
        EUROPE_ASTRAKHAN("Europe/Astrakhan"),
        EUROPE_ATHENS("Europe/Athens"),
        EUROPE_BELGRADE("Europe/Belgrade"),
        EUROPE_BERLIN("Europe/Berlin"),
        EUROPE_BRUSSELS("Europe/Brussels"),
        EUROPE_BUCHAREST("Europe/Bucharest"),
        EUROPE_BUDAPEST("Europe/Budapest"),
        EUROPE_CHISINAU("Europe/Chisinau"),
        EUROPE_COPENHAGEN("Europe/Copenhagen"),
        EUROPE_DUBLIN("Europe/Dublin"),
        EUROPE_GIBRALTAR("Europe/Gibraltar"),
        EUROPE_HELSINKI("Europe/Helsinki"),
        EUROPE_ISTANBUL("Europe/Istanbul"),
        EUROPE_KALININGRAD("Europe/Kaliningrad"),
        EUROPE_KIEV("Europe/Kiev"),
        EUROPE_KIROV("Europe/Kirov"),
        EUROPE_LISBON("Europe/Lisbon"),
        EUROPE_LONDON("Europe/London"),
        EUROPE_LUXEMBOURG("Europe/Luxembourg"),
        EUROPE_MADRID("Europe/Madrid"),
        EUROPE_MALTA("Europe/Malta"),
        EUROPE_MINSK("Europe/Minsk"),
        EUROPE_MONACO("Europe/Monaco"),
        EUROPE_MOSCOW("Europe/Moscow"),
        EUROPE_OSLO("Europe/Oslo"),
        EUROPE_PARIS("Europe/Paris"),
        EUROPE_PRAGUE("Europe/Prague"),
        EUROPE_RIGA("Europe/Riga"),
        EUROPE_ROME("Europe/Rome"),
        EUROPE_SAMARA("Europe/Samara"),
        EUROPE_SARATOV("Europe/Saratov"),
        EUROPE_SIMFEROPOL("Europe/Simferopol"),
        EUROPE_SOFIA("Europe/Sofia"),
        EUROPE_STOCKHOLM("Europe/Stockholm"),
        EUROPE_TALLINN("Europe/Tallinn"),
        EUROPE_TIRANE("Europe/Tirane"),
        EUROPE_ULYANOVSK("Europe/Ulyanovsk"),
        EUROPE_UZHGOROD("Europe/Uzhgorod"),
        EUROPE_VIENNA("Europe/Vienna"),
        EUROPE_VILNIUS("Europe/Vilnius"),
        EUROPE_VOLGOGRAD("Europe/Volgograd"),
        EUROPE_WARSAW("Europe/Warsaw"),
        EUROPE_ZAPOROZHYE("Europe/Zaporozhye"),
        EUROPE_ZURICH("Europe/Zurich"),
        HST("HST"),
        INDIAN_CHAGOS("Indian/Chagos"),
        INDIAN_CHRISTMAS("Indian/Christmas"),
        INDIAN_COCOS("Indian/Cocos"),
        INDIAN_KERGUELEN("Indian/Kerguelen"),
        INDIAN_MAHE("Indian/Mahe"),
        INDIAN_MALDIVES("Indian/Maldives"),
        INDIAN_MAURITIUS("Indian/Mauritius"),
        INDIAN_REUNION("Indian/Reunion"),
        MET("MET"),
        MST("MST"),
        MST_7_MDT("MST7MDT"),
        PACIFIC_APIA("Pacific/Apia"),
        PACIFIC_AUCKLAND("Pacific/Auckland"),
        PACIFIC_BOUGAINVILLE("Pacific/Bougainville"),
        PACIFIC_CHATHAM("Pacific/Chatham"),
        PACIFIC_CHUUK("Pacific/Chuuk"),
        PACIFIC_EASTER("Pacific/Easter"),
        PACIFIC_EFATE("Pacific/Efate"),
        PACIFIC_FAKAOFO("Pacific/Fakaofo"),
        PACIFIC_FIJI("Pacific/Fiji"),
        PACIFIC_FUNAFUTI("Pacific/Funafuti"),
        PACIFIC_GALAPAGOS("Pacific/Galapagos"),
        PACIFIC_GAMBIER("Pacific/Gambier"),
        PACIFIC_GUADALCANAL("Pacific/Guadalcanal"),
        PACIFIC_GUAM("Pacific/Guam"),
        PACIFIC_HONOLULU("Pacific/Honolulu"),
        PACIFIC_KANTON("Pacific/Kanton"),
        PACIFIC_KIRITIMATI("Pacific/Kiritimati"),
        PACIFIC_KOSRAE("Pacific/Kosrae"),
        PACIFIC_KWAJALEIN("Pacific/Kwajalein"),
        PACIFIC_MAJURO("Pacific/Majuro"),
        PACIFIC_MARQUESAS("Pacific/Marquesas"),
        PACIFIC_NAURU("Pacific/Nauru"),
        PACIFIC_NIUE("Pacific/Niue"),
        PACIFIC_NORFOLK("Pacific/Norfolk"),
        PACIFIC_NOUMEA("Pacific/Noumea"),
        PACIFIC_PAGO_PAGO("Pacific/Pago_Pago"),
        PACIFIC_PALAU("Pacific/Palau"),
        PACIFIC_PITCAIRN("Pacific/Pitcairn"),
        PACIFIC_POHNPEI("Pacific/Pohnpei"),
        PACIFIC_PORT_MORESBY("Pacific/Port_Moresby"),
        PACIFIC_RAROTONGA("Pacific/Rarotonga"),
        PACIFIC_TAHITI("Pacific/Tahiti"),
        PACIFIC_TARAWA("Pacific/Tarawa"),
        PACIFIC_TONGATAPU("Pacific/Tongatapu"),
        PACIFIC_WAKE("Pacific/Wake"),
        PACIFIC_WALLIS("Pacific/Wallis"),
        PST_8_PDT("PST8PDT"),
        WET("WET");

        private final String value;
        private static final Map<String, Timezone> CONSTANTS;

        private Timezone(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Timezone fromValue(String value) {
            Timezone constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Timezone>();
            for (Timezone c : Timezone.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum LicenseId {
        _0_BSD("0BSD"),
        AAL("AAL"),
        ABSTYLES("Abstyles"),
        ADA_CORE_DOC("AdaCore-doc"),
        ADOBE_2006("Adobe-2006"),
        ADOBE_GLYPH("Adobe-Glyph"),
        ADSL("ADSL"),
        AFL_1_1("AFL-1.1"),
        AFL_1_2("AFL-1.2"),
        AFL_2_0("AFL-2.0"),
        AFL_2_1("AFL-2.1"),
        AFL_3_0("AFL-3.0"),
        AFMPARSE("Afmparse"),
        AGPL_1_0_ONLY("AGPL-1.0-only"),
        AGPL_1_0_OR_LATER("AGPL-1.0-or-later"),
        AGPL_3_0_ONLY("AGPL-3.0-only"),
        AGPL_3_0_OR_LATER("AGPL-3.0-or-later"),
        ALADDIN("Aladdin"),
        AMDPLPA("AMDPLPA"),
        AML("AML"),
        AMPAS("AMPAS"),
        ANTLR_PD("ANTLR-PD"),
        ANTLR_PD_FALLBACK("ANTLR-PD-fallback"),
        APACHE_1_0("Apache-1.0"),
        APACHE_1_1("Apache-1.1"),
        APACHE_2_0("Apache-2.0"),
        APAFML("APAFML"),
        APL_1_0("APL-1.0"),
        APP_S_2_P("App-s2p"),
        APSL_1_0("APSL-1.0"),
        APSL_1_1("APSL-1.1"),
        APSL_1_2("APSL-1.2"),
        APSL_2_0("APSL-2.0"),
        ARPHIC_1999("Arphic-1999"),
        ARTISTIC_1_0("Artistic-1.0"),
        ARTISTIC_1_0_CL_8("Artistic-1.0-cl8"),
        ARTISTIC_1_0_PERL("Artistic-1.0-Perl"),
        ARTISTIC_2_0("Artistic-2.0"),
        BAEKMUK("Baekmuk"),
        BAHYPH("Bahyph"),
        BARR("Barr"),
        BEERWARE("Beerware"),
        BITSTREAM_CHARTER("Bitstream-Charter"),
        BITSTREAM_VERA("Bitstream-Vera"),
        BIT_TORRENT_1_0("BitTorrent-1.0"),
        BIT_TORRENT_1_1("BitTorrent-1.1"),
        BLESSING("blessing"),
        BLUE_OAK_1_0_0("BlueOak-1.0.0"),
        BORCEUX("Borceux"),
        BRIAN_GLADMAN_3_CLAUSE("Brian-Gladman-3-Clause"),
        BSD_1_CLAUSE("BSD-1-Clause"),
        BSD_2_CLAUSE("BSD-2-Clause"),
        BSD_2_CLAUSE_PATENT("BSD-2-Clause-Patent"),
        BSD_2_CLAUSE_VIEWS("BSD-2-Clause-Views"),
        BSD_3_CLAUSE("BSD-3-Clause"),
        BSD_3_CLAUSE_ATTRIBUTION("BSD-3-Clause-Attribution"),
        BSD_3_CLAUSE_CLEAR("BSD-3-Clause-Clear"),
        BSD_3_CLAUSE_LBNL("BSD-3-Clause-LBNL"),
        BSD_3_CLAUSE_MODIFICATION("BSD-3-Clause-Modification"),
        BSD_3_CLAUSE_NO_MILITARY_LICENSE("BSD-3-Clause-No-Military-License"),
        BSD_3_CLAUSE_NO_NUCLEAR_LICENSE("BSD-3-Clause-No-Nuclear-License"),
        BSD_3_CLAUSE_NO_NUCLEAR_LICENSE_2014("BSD-3-Clause-No-Nuclear-License-2014"),
        BSD_3_CLAUSE_NO_NUCLEAR_WARRANTY("BSD-3-Clause-No-Nuclear-Warranty"),
        BSD_3_CLAUSE_OPEN_MPI("BSD-3-Clause-Open-MPI"),
        BSD_4_CLAUSE("BSD-4-Clause"),
        BSD_4_CLAUSE_SHORTENED("BSD-4-Clause-Shortened"),
        BSD_4_CLAUSE_UC("BSD-4-Clause-UC"),
        BSD_4_3_RENO("BSD-4.3RENO"),
        BSD_4_3_TAHOE("BSD-4.3TAHOE"),
        BSD_ADVERTISING_ACKNOWLEDGEMENT("BSD-Advertising-Acknowledgement"),
        BSD_ATTRIBUTION_HPND_DISCLAIMER("BSD-Attribution-HPND-disclaimer"),
        BSD_PROTECTION("BSD-Protection"),
        BSD_SOURCE_CODE("BSD-Source-Code"),
        BSL_1_0("BSL-1.0"),
        BUSL_1_1("BUSL-1.1"),
        BZIP_2_1_0_6("bzip2-1.0.6"),
        C_UDA_1_0("C-UDA-1.0"),
        CAL_1_0("CAL-1.0"),
        CAL_1_0_COMBINED_WORK_EXCEPTION("CAL-1.0-Combined-Work-Exception"),
        CALDERA("Caldera"),
        CATOSL_1_1("CATOSL-1.1"),
        CC_BY_1_0("CC-BY-1.0"),
        CC_BY_2_0("CC-BY-2.0"),
        CC_BY_2_5("CC-BY-2.5"),
        CC_BY_2_5_AU("CC-BY-2.5-AU"),
        CC_BY_3_0("CC-BY-3.0"),
        CC_BY_3_0_AT("CC-BY-3.0-AT"),
        CC_BY_3_0_DE("CC-BY-3.0-DE"),
        CC_BY_3_0_IGO("CC-BY-3.0-IGO"),
        CC_BY_3_0_NL("CC-BY-3.0-NL"),
        CC_BY_3_0_US("CC-BY-3.0-US"),
        CC_BY_4_0("CC-BY-4.0"),
        CC_BY_NC_1_0("CC-BY-NC-1.0"),
        CC_BY_NC_2_0("CC-BY-NC-2.0"),
        CC_BY_NC_2_5("CC-BY-NC-2.5"),
        CC_BY_NC_3_0("CC-BY-NC-3.0"),
        CC_BY_NC_3_0_DE("CC-BY-NC-3.0-DE"),
        CC_BY_NC_4_0("CC-BY-NC-4.0"),
        CC_BY_NC_ND_1_0("CC-BY-NC-ND-1.0"),
        CC_BY_NC_ND_2_0("CC-BY-NC-ND-2.0"),
        CC_BY_NC_ND_2_5("CC-BY-NC-ND-2.5"),
        CC_BY_NC_ND_3_0("CC-BY-NC-ND-3.0"),
        CC_BY_NC_ND_3_0_DE("CC-BY-NC-ND-3.0-DE"),
        CC_BY_NC_ND_3_0_IGO("CC-BY-NC-ND-3.0-IGO"),
        CC_BY_NC_ND_4_0("CC-BY-NC-ND-4.0"),
        CC_BY_NC_SA_1_0("CC-BY-NC-SA-1.0"),
        CC_BY_NC_SA_2_0("CC-BY-NC-SA-2.0"),
        CC_BY_NC_SA_2_0_DE("CC-BY-NC-SA-2.0-DE"),
        CC_BY_NC_SA_2_0_FR("CC-BY-NC-SA-2.0-FR"),
        CC_BY_NC_SA_2_0_UK("CC-BY-NC-SA-2.0-UK"),
        CC_BY_NC_SA_2_5("CC-BY-NC-SA-2.5"),
        CC_BY_NC_SA_3_0("CC-BY-NC-SA-3.0"),
        CC_BY_NC_SA_3_0_DE("CC-BY-NC-SA-3.0-DE"),
        CC_BY_NC_SA_3_0_IGO("CC-BY-NC-SA-3.0-IGO"),
        CC_BY_NC_SA_4_0("CC-BY-NC-SA-4.0"),
        CC_BY_ND_1_0("CC-BY-ND-1.0"),
        CC_BY_ND_2_0("CC-BY-ND-2.0"),
        CC_BY_ND_2_5("CC-BY-ND-2.5"),
        CC_BY_ND_3_0("CC-BY-ND-3.0"),
        CC_BY_ND_3_0_DE("CC-BY-ND-3.0-DE"),
        CC_BY_ND_4_0("CC-BY-ND-4.0"),
        CC_BY_SA_1_0("CC-BY-SA-1.0"),
        CC_BY_SA_2_0("CC-BY-SA-2.0"),
        CC_BY_SA_2_0_UK("CC-BY-SA-2.0-UK"),
        CC_BY_SA_2_1_JP("CC-BY-SA-2.1-JP"),
        CC_BY_SA_2_5("CC-BY-SA-2.5"),
        CC_BY_SA_3_0("CC-BY-SA-3.0"),
        CC_BY_SA_3_0_AT("CC-BY-SA-3.0-AT"),
        CC_BY_SA_3_0_DE("CC-BY-SA-3.0-DE"),
        CC_BY_SA_4_0("CC-BY-SA-4.0"),
        CC_PDDC("CC-PDDC"),
        CC_0_1_0("CC0-1.0"),
        CDDL_1_0("CDDL-1.0"),
        CDDL_1_1("CDDL-1.1"),
        CDL_1_0("CDL-1.0"),
        CDLA_PERMISSIVE_1_0("CDLA-Permissive-1.0"),
        CDLA_PERMISSIVE_2_0("CDLA-Permissive-2.0"),
        CDLA_SHARING_1_0("CDLA-Sharing-1.0"),
        CECILL_1_0("CECILL-1.0"),
        CECILL_1_1("CECILL-1.1"),
        CECILL_2_0("CECILL-2.0"),
        CECILL_2_1("CECILL-2.1"),
        CECILL_B("CECILL-B"),
        CECILL_C("CECILL-C"),
        CERN_OHL_1_1("CERN-OHL-1.1"),
        CERN_OHL_1_2("CERN-OHL-1.2"),
        CERN_OHL_P_2_0("CERN-OHL-P-2.0"),
        CERN_OHL_S_2_0("CERN-OHL-S-2.0"),
        CERN_OHL_W_2_0("CERN-OHL-W-2.0"),
        CFITSIO("CFITSIO"),
        CHECKMK("checkmk"),
        CL_ARTISTIC("ClArtistic"),
        CLIPS("Clips"),
        CMU_MACH("CMU-Mach"),
        CNRI_JYTHON("CNRI-Jython"),
        CNRI_PYTHON("CNRI-Python"),
        CNRI_PYTHON_GPL_COMPATIBLE("CNRI-Python-GPL-Compatible"),
        COIL_1_0("COIL-1.0"),
        COMMUNITY_SPEC_1_0("Community-Spec-1.0"),
        CONDOR_1_1("Condor-1.1"),
        COPYLEFT_NEXT_0_3_0("copyleft-next-0.3.0"),
        COPYLEFT_NEXT_0_3_1("copyleft-next-0.3.1"),
        CORNELL_LOSSLESS_JPEG("Cornell-Lossless-JPEG"),
        CPAL_1_0("CPAL-1.0"),
        CPL_1_0("CPL-1.0"),
        CPOL_1_02("CPOL-1.02"),
        CROSSWORD("Crossword"),
        CRYSTAL_STACKER("CrystalStacker"),
        CUA_OPL_1_0("CUA-OPL-1.0"),
        CUBE("Cube"),
        CURL("curl"),
        D_FSL_1_0("D-FSL-1.0"),
        DIFFMARK("diffmark"),
        DL_DE_BY_2_0("DL-DE-BY-2.0"),
        DOC("DOC"),
        DOTSEQN("Dotseqn"),
        DRL_1_0("DRL-1.0"),
        DSDP("DSDP"),
        DVIPDFM("dvipdfm"),
        ECL_1_0("ECL-1.0"),
        ECL_2_0("ECL-2.0"),
        EFL_1_0("EFL-1.0"),
        EFL_2_0("EFL-2.0"),
        E_GENIX("eGenix"),
        ELASTIC_2_0("Elastic-2.0"),
        ENTESSA("Entessa"),
        EPICS("EPICS"),
        EPL_1_0("EPL-1.0"),
        EPL_2_0("EPL-2.0"),
        ERL_PL_1_1("ErlPL-1.1"),
        ETALAB_2_0("etalab-2.0"),
        EU_DATAGRID("EUDatagrid"),
        EUPL_1_0("EUPL-1.0"),
        EUPL_1_1("EUPL-1.1"),
        EUPL_1_2("EUPL-1.2"),
        EUROSYM("Eurosym"),
        FAIR("Fair"),
        FDK_AAC("FDK-AAC"),
        FRAMEWORX_1_0("Frameworx-1.0"),
        FREE_BSD_DOC("FreeBSD-DOC"),
        FREE_IMAGE("FreeImage"),
        FSFAP("FSFAP"),
        FSFUL("FSFUL"),
        FSFULLR("FSFULLR"),
        FSFULLRWD("FSFULLRWD"),
        FTL("FTL"),
        GD("GD"),
        GFDL_1_1_INVARIANTS_ONLY("GFDL-1.1-invariants-only"),
        GFDL_1_1_INVARIANTS_OR_LATER("GFDL-1.1-invariants-or-later"),
        GFDL_1_1_NO_INVARIANTS_ONLY("GFDL-1.1-no-invariants-only"),
        GFDL_1_1_NO_INVARIANTS_OR_LATER("GFDL-1.1-no-invariants-or-later"),
        GFDL_1_1_ONLY("GFDL-1.1-only"),
        GFDL_1_1_OR_LATER("GFDL-1.1-or-later"),
        GFDL_1_2_INVARIANTS_ONLY("GFDL-1.2-invariants-only"),
        GFDL_1_2_INVARIANTS_OR_LATER("GFDL-1.2-invariants-or-later"),
        GFDL_1_2_NO_INVARIANTS_ONLY("GFDL-1.2-no-invariants-only"),
        GFDL_1_2_NO_INVARIANTS_OR_LATER("GFDL-1.2-no-invariants-or-later"),
        GFDL_1_2_ONLY("GFDL-1.2-only"),
        GFDL_1_2_OR_LATER("GFDL-1.2-or-later"),
        GFDL_1_3_INVARIANTS_ONLY("GFDL-1.3-invariants-only"),
        GFDL_1_3_INVARIANTS_OR_LATER("GFDL-1.3-invariants-or-later"),
        GFDL_1_3_NO_INVARIANTS_ONLY("GFDL-1.3-no-invariants-only"),
        GFDL_1_3_NO_INVARIANTS_OR_LATER("GFDL-1.3-no-invariants-or-later"),
        GFDL_1_3_ONLY("GFDL-1.3-only"),
        GFDL_1_3_OR_LATER("GFDL-1.3-or-later"),
        GIFTWARE("Giftware"),
        GL_2_PS("GL2PS"),
        GLIDE("Glide"),
        GLULXE("Glulxe"),
        GLWTPL("GLWTPL"),
        GNUPLOT("gnuplot"),
        GPL_1_0_ONLY("GPL-1.0-only"),
        GPL_1_0_OR_LATER("GPL-1.0-or-later"),
        GPL_2_0_ONLY("GPL-2.0-only"),
        GPL_2_0_OR_LATER("GPL-2.0-or-later"),
        GPL_3_0_ONLY("GPL-3.0-only"),
        GPL_3_0_OR_LATER("GPL-3.0-or-later"),
        GRAPHICS_GEMS("Graphics-Gems"),
        G_SOAP_1_3_B("gSOAP-1.3b"),
        HASKELL_REPORT("HaskellReport"),
        HIPPOCRATIC_2_1("Hippocratic-2.1"),
        HP_1986("HP-1986"),
        HPND("HPND"),
        HPND_EXPORT_US("HPND-export-US"),
        HPND_MARKUS_KUHN("HPND-Markus-Kuhn"),
        HPND_SELL_VARIANT("HPND-sell-variant"),
        HPND_SELL_VARIANT_MIT_DISCLAIMER("HPND-sell-variant-MIT-disclaimer"),
        HTMLTIDY("HTMLTIDY"),
        IBM_PIBS("IBM-pibs"),
        ICU("ICU"),
        IEC_CODE_COMPONENTS_EULA("IEC-Code-Components-EULA"),
        IJG("IJG"),
        IJG_SHORT("IJG-short"),
        IMAGE_MAGICK("ImageMagick"),
        I_MATIX("iMatix"),
        IMLIB_2("Imlib2"),
        INFO_ZIP("Info-ZIP"),
        INTEL("Intel"),
        INTEL_ACPI("Intel-ACPI"),
        INTERBASE_1_0("Interbase-1.0"),
        IPA("IPA"),
        IPL_1_0("IPL-1.0"),
        ISC("ISC"),
        JAM("Jam"),
        JAS_PER_2_0("JasPer-2.0"),
        JPL_IMAGE("JPL-image"),
        JPNIC("JPNIC"),
        JSON("JSON"),
        KAZLIB("Kazlib"),
        KNUTH_CTAN("Knuth-CTAN"),
        LAL_1_2("LAL-1.2"),
        LAL_1_3("LAL-1.3"),
        LATEX_2_E("Latex2e"),
        LEPTONICA("Leptonica"),
        LGPL_2_0_ONLY("LGPL-2.0-only"),
        LGPL_2_0_OR_LATER("LGPL-2.0-or-later"),
        LGPL_2_1_ONLY("LGPL-2.1-only"),
        LGPL_2_1_OR_LATER("LGPL-2.1-or-later"),
        LGPL_3_0_ONLY("LGPL-3.0-only"),
        LGPL_3_0_OR_LATER("LGPL-3.0-or-later"),
        LGPLLR("LGPLLR"),
        LIBPNG("Libpng"),
        LIBPNG_2_0("libpng-2.0"),
        LIBSELINUX_1_0("libselinux-1.0"),
        LIBTIFF("libtiff"),
        LIBUTIL_DAVID_NUGENT("libutil-David-Nugent"),
        LI_LI_Q_P_1_1("LiLiQ-P-1.1"),
        LI_LI_Q_R_1_1("LiLiQ-R-1.1"),
        LI_LI_Q_RPLUS_1_1("LiLiQ-Rplus-1.1"),
        LINUX_MAN_PAGES_COPYLEFT("Linux-man-pages-copyleft"),
        LINUX_OPEN_IB("Linux-OpenIB"),
        LOOP("LOOP"),
        LPL_1_0("LPL-1.0"),
        LPL_1_02("LPL-1.02"),
        LPPL_1_0("LPPL-1.0"),
        LPPL_1_1("LPPL-1.1"),
        LPPL_1_2("LPPL-1.2"),
        LPPL_1_3_A("LPPL-1.3a"),
        LPPL_1_3_C("LPPL-1.3c"),
        LZMA_SDK_9_11_TO_9_20("LZMA-SDK-9.11-to-9.20"),
        LZMA_SDK_9_22("LZMA-SDK-9.22"),
        MAKE_INDEX("MakeIndex"),
        MARTIN_BIRGMEIER("Martin-Birgmeier"),
        MINPACK("Minpack"),
        MIR_OS("MirOS"),
        MIT("MIT"),
        MIT_0("MIT-0"),
        MIT_ADVERTISING("MIT-advertising"),
        MIT_CMU("MIT-CMU"),
        MIT_ENNA("MIT-enna"),
        MIT_FEH("MIT-feh"),
        MIT_MODERN_VARIANT("MIT-Modern-Variant"),
        MIT_OPEN_GROUP("MIT-open-group"),
        MIT_WU("MIT-Wu"),
        MITNFA("MITNFA"),
        MOTOSOTO("Motosoto"),
        MPI_PERMISSIVE("mpi-permissive"),
        MPICH_2("mpich2"),
        MPL_1_0("MPL-1.0"),
        MPL_1_1("MPL-1.1"),
        MPL_2_0("MPL-2.0"),
        MPL_2_0_NO_COPYLEFT_EXCEPTION("MPL-2.0-no-copyleft-exception"),
        MPLUS("mplus"),
        MS_LPL("MS-LPL"),
        MS_PL("MS-PL"),
        MS_RL("MS-RL"),
        MTLL("MTLL"),
        MULAN_PSL_1_0("MulanPSL-1.0"),
        MULAN_PSL_2_0("MulanPSL-2.0"),
        MULTICS("Multics"),
        MUP("Mup"),
        NAIST_2003("NAIST-2003"),
        NASA_1_3("NASA-1.3"),
        NAUMEN("Naumen"),
        NBPL_1_0("NBPL-1.0"),
        NCGL_UK_2_0("NCGL-UK-2.0"),
        NCSA("NCSA"),
        NET_SNMP("Net-SNMP"),
        NET_CDF("NetCDF"),
        NEWSLETR("Newsletr"),
        NGPL("NGPL"),
        NICTA_1_0("NICTA-1.0"),
        NIST_PD("NIST-PD"),
        NIST_PD_FALLBACK("NIST-PD-fallback"),
        NLOD_1_0("NLOD-1.0"),
        NLOD_2_0("NLOD-2.0"),
        NLPL("NLPL"),
        NOKIA("Nokia"),
        NOSL("NOSL"),
        NOWEB("Noweb"),
        NPL_1_0("NPL-1.0"),
        NPL_1_1("NPL-1.1"),
        NPOSL_3_0("NPOSL-3.0"),
        NRL("NRL"),
        NTP("NTP"),
        NTP_0("NTP-0"),
        O_UDA_1_0("O-UDA-1.0"),
        OCCT_PL("OCCT-PL"),
        OCLC_2_0("OCLC-2.0"),
        O_DB_L_1_0("ODbL-1.0"),
        ODC_BY_1_0("ODC-By-1.0"),
        OFFIS("OFFIS"),
        OFL_1_0("OFL-1.0"),
        OFL_1_0_NO_RFN("OFL-1.0-no-RFN"),
        OFL_1_0_RFN("OFL-1.0-RFN"),
        OFL_1_1("OFL-1.1"),
        OFL_1_1_NO_RFN("OFL-1.1-no-RFN"),
        OFL_1_1_RFN("OFL-1.1-RFN"),
        OGC_1_0("OGC-1.0"),
        OGDL_TAIWAN_1_0("OGDL-Taiwan-1.0"),
        OGL_CANADA_2_0("OGL-Canada-2.0"),
        OGL_UK_1_0("OGL-UK-1.0"),
        OGL_UK_2_0("OGL-UK-2.0"),
        OGL_UK_3_0("OGL-UK-3.0"),
        OGTSL("OGTSL"),
        OLDAP_1_1("OLDAP-1.1"),
        OLDAP_1_2("OLDAP-1.2"),
        OLDAP_1_3("OLDAP-1.3"),
        OLDAP_1_4("OLDAP-1.4"),
        OLDAP_2_0("OLDAP-2.0"),
        OLDAP_2_0_1("OLDAP-2.0.1"),
        OLDAP_2_1("OLDAP-2.1"),
        OLDAP_2_2("OLDAP-2.2"),
        OLDAP_2_2_1("OLDAP-2.2.1"),
        OLDAP_2_2_2("OLDAP-2.2.2"),
        OLDAP_2_3("OLDAP-2.3"),
        OLDAP_2_4("OLDAP-2.4"),
        OLDAP_2_5("OLDAP-2.5"),
        OLDAP_2_6("OLDAP-2.6"),
        OLDAP_2_7("OLDAP-2.7"),
        OLDAP_2_8("OLDAP-2.8"),
        OML("OML"),
        OPEN_PBS_2_3("OpenPBS-2.3"),
        OPEN_SSL("OpenSSL"),
        OPL_1_0("OPL-1.0"),
        OPUBL_1_0("OPUBL-1.0"),
        OSET_PL_2_1("OSET-PL-2.1"),
        OSL_1_0("OSL-1.0"),
        OSL_1_1("OSL-1.1"),
        OSL_2_0("OSL-2.0"),
        OSL_2_1("OSL-2.1"),
        OSL_3_0("OSL-3.0"),
        PARITY_6_0_0("Parity-6.0.0"),
        PARITY_7_0_0("Parity-7.0.0"),
        PDDL_1_0("PDDL-1.0"),
        PHP_3_0("PHP-3.0"),
        PHP_3_01("PHP-3.01"),
        PLEXUS("Plexus"),
        POLY_FORM_NONCOMMERCIAL_1_0_0("PolyForm-Noncommercial-1.0.0"),
        POLY_FORM_SMALL_BUSINESS_1_0_0("PolyForm-Small-Business-1.0.0"),
        POSTGRE_SQL("PostgreSQL"),
        PSF_2_0("PSF-2.0"),
        PSFRAG("psfrag"),
        PSUTILS("psutils"),
        PYTHON_2_0("Python-2.0"),
        PYTHON_2_0_1("Python-2.0.1"),
        QHULL("Qhull"),
        QPL_1_0("QPL-1.0"),
        QPL_1_0_INRIA_2004("QPL-1.0-INRIA-2004"),
        RDISC("Rdisc"),
        R_HE_COS_1_1("RHeCos-1.1"),
        RPL_1_1("RPL-1.1"),
        RPL_1_5("RPL-1.5"),
        RPSL_1_0("RPSL-1.0"),
        RSA_MD("RSA-MD"),
        RSCPL("RSCPL"),
        RUBY("Ruby"),
        SAX_PD("SAX-PD"),
        SAXPATH("Saxpath"),
        SCEA("SCEA"),
        SCHEME_REPORT("SchemeReport"),
        SENDMAIL("Sendmail"),
        SENDMAIL_8_23("Sendmail-8.23"),
        SGI_B_1_0("SGI-B-1.0"),
        SGI_B_1_1("SGI-B-1.1"),
        SGI_B_2_0("SGI-B-2.0"),
        SHL_0_5("SHL-0.5"),
        SHL_0_51("SHL-0.51"),
        SIM_PL_2_0("SimPL-2.0"),
        SISSL("SISSL"),
        SISSL_1_2("SISSL-1.2"),
        SLEEPYCAT("Sleepycat"),
        SMLNJ("SMLNJ"),
        SMPPL("SMPPL"),
        SNIA("SNIA"),
        SNPRINTF("snprintf"),
        SPENCER_86("Spencer-86"),
        SPENCER_94("Spencer-94"),
        SPENCER_99("Spencer-99"),
        SPL_1_0("SPL-1.0"),
        SSH_OPEN_SSH("SSH-OpenSSH"),
        SSH_SHORT("SSH-short"),
        SSPL_1_0("SSPL-1.0"),
        SUGAR_CRM_1_1_3("SugarCRM-1.1.3"),
        SUN_PRO("SunPro"),
        SWL("SWL"),
        SYMLINKS("Symlinks"),
        TAPR_OHL_1_0("TAPR-OHL-1.0"),
        TCL("TCL"),
        TCP_WRAPPERS("TCP-wrappers"),
        T_MATE("TMate"),
        TORQUE_1_1("TORQUE-1.1"),
        TOSL("TOSL"),
        TPDL("TPDL"),
        TPL_1_0("TPL-1.0"),
        TTWL("TTWL"),
        TU_BERLIN_1_0("TU-Berlin-1.0"),
        TU_BERLIN_2_0("TU-Berlin-2.0"),
        UCAR("UCAR"),
        UCL_1_0("UCL-1.0"),
        UNICODE_DFS_2015("Unicode-DFS-2015"),
        UNICODE_DFS_2016("Unicode-DFS-2016"),
        UNICODE_TOU("Unicode-TOU"),
        UNLICENSE("Unlicense"),
        UPL_1_0("UPL-1.0"),
        VIM("Vim"),
        VOSTROM("VOSTROM"),
        VSL_1_0("VSL-1.0"),
        W_3_C("W3C"),
        W_3_C_19980720("W3C-19980720"),
        W_3_C_20150513("W3C-20150513"),
        W_3_M("w3m"),
        WATCOM_1_0("Watcom-1.0"),
        WSUIPA("Wsuipa"),
        WTFPL("WTFPL"),
        X_11("X11"),
        X_11_DISTRIBUTE_MODIFICATIONS_VARIANT("X11-distribute-modifications-variant"),
        XEROX("Xerox"),
        X_FREE_86_1_1("XFree86-1.1"),
        XINETD("xinetd"),
        XLOCK("xlock"),
        XNET("Xnet"),
        XPP("xpp"),
        X_SKAT("XSkat"),
        YPL_1_0("YPL-1.0"),
        YPL_1_1("YPL-1.1"),
        ZED("Zed"),
        ZEND_2_0("Zend-2.0"),
        ZIMBRA_1_3("Zimbra-1.3"),
        ZIMBRA_1_4("Zimbra-1.4"),
        ZLIB("Zlib"),
        ZLIB_ACKNOWLEDGEMENT("zlib-acknowledgement"),
        ZPL_1_1("ZPL-1.1"),
        ZPL_2_0("ZPL-2.0"),
        ZPL_2_1("ZPL-2.1");

        private final String value;
        private static final Map<String, LicenseId> CONSTANTS;

        private LicenseId(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LicenseId fromValue(String value) {
            LicenseId constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, LicenseId>();
            for (LicenseId c : LicenseId.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

