/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v2_2.gbfs;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.mobilitydata.gbfs.v2_2.free_bike_status.GBFSFreeBikeStatus;
import org.mobilitydata.gbfs.v2_2.gbfs.GBFS;
import org.mobilitydata.gbfs.v2_2.gbfs_versions.GBFSGbfsVersions;
import org.mobilitydata.gbfs.v2_2.geofencing_zones.GBFSGeofencingZones;
import org.mobilitydata.gbfs.v2_2.station_information.GBFSStationInformation;
import org.mobilitydata.gbfs.v2_2.station_status.GBFSStationStatus;
import org.mobilitydata.gbfs.v2_2.system_alerts.GBFSSystemAlerts;
import org.mobilitydata.gbfs.v2_2.system_calendar.GBFSSystemCalendar;
import org.mobilitydata.gbfs.v2_2.system_hours.GBFSSystemHours;
import org.mobilitydata.gbfs.v2_2.system_information.GBFSSystemInformation;
import org.mobilitydata.gbfs.v2_2.system_pricing_plans.GBFSSystemPricingPlans;
import org.mobilitydata.gbfs.v2_2.system_regions.GBFSSystemRegions;
import org.mobilitydata.gbfs.v2_2.vehicle_types.GBFSVehicleTypes;

public enum GBFSFeedName {
    GBFS("gbfs", GBFS.class),
    GBFSVersions("gbfs_versions", GBFSGbfsVersions.class),
    SystemInformation("system_information", GBFSSystemInformation.class),
    VehicleTypes("vehicle_types", GBFSVehicleTypes.class),
    StationInformation("station_information", GBFSStationInformation.class),
    StationStatus("station_status", GBFSStationStatus.class),
    FreeBikeStatus("free_bike_status", GBFSFreeBikeStatus.class),
    SystemHours("system_hours", GBFSSystemHours.class),
    SystemAlerts("system_alerts", GBFSSystemAlerts.class),
    SystemCalendar("system_calendar", GBFSSystemCalendar.class),
    SystemRegions("system_regions", GBFSSystemRegions.class),
    SystemPricingPlans("system_pricing_plans", GBFSSystemPricingPlans.class),
    GeofencingZones("geofencing_zones", GBFSGeofencingZones.class);

    private final String value;
    private final Class<?> implementingClass;
    private static final Map<String, GBFSFeedName> CONSTANTS;
    private static final Map<Class<?>, GBFSFeedName> CLASSES;

    private GBFSFeedName(String value, Class<?> implementingClass) {
        this.value = value;
        this.implementingClass = implementingClass;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public Class<?> implementingClass() {
        return this.implementingClass;
    }

    @JsonCreator
    public static GBFSFeedName fromValue(String value) {
        GBFSFeedName constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public static GBFSFeedName fromClass(Class<?> clazz) {
        GBFSFeedName constant = CLASSES.get(clazz);
        if (constant == null) {
            throw new IllegalArgumentException(clazz.getName());
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, GBFSFeedName>();
        CLASSES = new HashMap();
        for (GBFSFeedName c : GBFSFeedName.values()) {
            CONSTANTS.put(c.value, c);
            CLASSES.put(c.implementingClass, c);
        }
    }
}

