/*
 * Decompiled with CFR 0.152.
 */
package org.mobilitydata.gbfs.v3_0.station_status;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mobilitydata.gbfs.v3_0.station_status.GBFSVehicleDocksAvailable;
import org.mobilitydata.gbfs.v3_0.station_status.GBFSVehicleTypesAvailable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"station_id", "num_vehicles_available", "vehicle_types_available", "num_vehicles_disabled", "num_docks_available", "num_docks_disabled", "is_installed", "is_renting", "is_returning", "last_reported", "vehicle_docks_available"})
public class GBFSStation
implements Serializable {
    @JsonProperty(value="station_id")
    @JsonPropertyDescription(value="Identifier of a station.")
    private String stationId;
    @JsonProperty(value="num_vehicles_available")
    @JsonPropertyDescription(value="Number of vehicles of any type physically available for rental at the station.")
    private Integer numVehiclesAvailable;
    @JsonProperty(value="vehicle_types_available")
    @JsonPropertyDescription(value="Array of objects displaying the total number of each vehicle type at the station (added in v2.1-RC).")
    private List<GBFSVehicleTypesAvailable> vehicleTypesAvailable;
    @JsonProperty(value="num_vehicles_disabled")
    @JsonPropertyDescription(value="Number of disabled vehicles of any type at the station.")
    private Integer numVehiclesDisabled;
    @JsonProperty(value="num_docks_available")
    @JsonPropertyDescription(value="Number of functional docks physically at the station.")
    private Integer numDocksAvailable;
    @JsonProperty(value="num_docks_disabled")
    @JsonPropertyDescription(value="Number of empty but disabled docks at the station.")
    private Integer numDocksDisabled;
    @JsonProperty(value="is_installed")
    @JsonPropertyDescription(value="Is the station currently on the street?")
    private Boolean isInstalled;
    @JsonProperty(value="is_renting")
    @JsonPropertyDescription(value="Is the station currently renting vehicles?")
    private Boolean isRenting;
    @JsonProperty(value="is_returning")
    @JsonPropertyDescription(value="Is the station accepting vehicle returns?")
    private Boolean isReturning;
    @JsonProperty(value="last_reported")
    @JsonPropertyDescription(value="The last time this station reported its status to the operator's backend in RFC3339 format.")
    private Date lastReported;
    @JsonProperty(value="vehicle_docks_available")
    @JsonPropertyDescription(value="Object displaying available docks by vehicle type (added in v2.1-RC).")
    private List<GBFSVehicleDocksAvailable> vehicleDocksAvailable;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    private static final long serialVersionUID = -4411957762100741860L;

    @JsonProperty(value="station_id")
    public String getStationId() {
        return this.stationId;
    }

    @JsonProperty(value="station_id")
    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    public GBFSStation withStationId(String stationId) {
        this.stationId = stationId;
        return this;
    }

    @JsonProperty(value="num_vehicles_available")
    public Integer getNumVehiclesAvailable() {
        return this.numVehiclesAvailable;
    }

    @JsonProperty(value="num_vehicles_available")
    public void setNumVehiclesAvailable(Integer numVehiclesAvailable) {
        this.numVehiclesAvailable = numVehiclesAvailable;
    }

    public GBFSStation withNumVehiclesAvailable(Integer numVehiclesAvailable) {
        this.numVehiclesAvailable = numVehiclesAvailable;
        return this;
    }

    @JsonProperty(value="vehicle_types_available")
    public List<GBFSVehicleTypesAvailable> getVehicleTypesAvailable() {
        return this.vehicleTypesAvailable;
    }

    @JsonProperty(value="vehicle_types_available")
    public void setVehicleTypesAvailable(List<GBFSVehicleTypesAvailable> vehicleTypesAvailable) {
        this.vehicleTypesAvailable = vehicleTypesAvailable;
    }

    public GBFSStation withVehicleTypesAvailable(List<GBFSVehicleTypesAvailable> vehicleTypesAvailable) {
        this.vehicleTypesAvailable = vehicleTypesAvailable;
        return this;
    }

    @JsonProperty(value="num_vehicles_disabled")
    public Integer getNumVehiclesDisabled() {
        return this.numVehiclesDisabled;
    }

    @JsonProperty(value="num_vehicles_disabled")
    public void setNumVehiclesDisabled(Integer numVehiclesDisabled) {
        this.numVehiclesDisabled = numVehiclesDisabled;
    }

    public GBFSStation withNumVehiclesDisabled(Integer numVehiclesDisabled) {
        this.numVehiclesDisabled = numVehiclesDisabled;
        return this;
    }

    @JsonProperty(value="num_docks_available")
    public Integer getNumDocksAvailable() {
        return this.numDocksAvailable;
    }

    @JsonProperty(value="num_docks_available")
    public void setNumDocksAvailable(Integer numDocksAvailable) {
        this.numDocksAvailable = numDocksAvailable;
    }

    public GBFSStation withNumDocksAvailable(Integer numDocksAvailable) {
        this.numDocksAvailable = numDocksAvailable;
        return this;
    }

    @JsonProperty(value="num_docks_disabled")
    public Integer getNumDocksDisabled() {
        return this.numDocksDisabled;
    }

    @JsonProperty(value="num_docks_disabled")
    public void setNumDocksDisabled(Integer numDocksDisabled) {
        this.numDocksDisabled = numDocksDisabled;
    }

    public GBFSStation withNumDocksDisabled(Integer numDocksDisabled) {
        this.numDocksDisabled = numDocksDisabled;
        return this;
    }

    @JsonProperty(value="is_installed")
    public Boolean getIsInstalled() {
        return this.isInstalled;
    }

    @JsonProperty(value="is_installed")
    public void setIsInstalled(Boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public GBFSStation withIsInstalled(Boolean isInstalled) {
        this.isInstalled = isInstalled;
        return this;
    }

    @JsonProperty(value="is_renting")
    public Boolean getIsRenting() {
        return this.isRenting;
    }

    @JsonProperty(value="is_renting")
    public void setIsRenting(Boolean isRenting) {
        this.isRenting = isRenting;
    }

    public GBFSStation withIsRenting(Boolean isRenting) {
        this.isRenting = isRenting;
        return this;
    }

    @JsonProperty(value="is_returning")
    public Boolean getIsReturning() {
        return this.isReturning;
    }

    @JsonProperty(value="is_returning")
    public void setIsReturning(Boolean isReturning) {
        this.isReturning = isReturning;
    }

    public GBFSStation withIsReturning(Boolean isReturning) {
        this.isReturning = isReturning;
        return this;
    }

    @JsonProperty(value="last_reported")
    public Date getLastReported() {
        return this.lastReported;
    }

    @JsonProperty(value="last_reported")
    public void setLastReported(Date lastReported) {
        this.lastReported = lastReported;
    }

    public GBFSStation withLastReported(Date lastReported) {
        this.lastReported = lastReported;
        return this;
    }

    @JsonProperty(value="vehicle_docks_available")
    public List<GBFSVehicleDocksAvailable> getVehicleDocksAvailable() {
        return this.vehicleDocksAvailable;
    }

    @JsonProperty(value="vehicle_docks_available")
    public void setVehicleDocksAvailable(List<GBFSVehicleDocksAvailable> vehicleDocksAvailable) {
        this.vehicleDocksAvailable = vehicleDocksAvailable;
    }

    public GBFSStation withVehicleDocksAvailable(List<GBFSVehicleDocksAvailable> vehicleDocksAvailable) {
        this.vehicleDocksAvailable = vehicleDocksAvailable;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public GBFSStation withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(GBFSStation.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("stationId");
        sb.append('=');
        sb.append(this.stationId == null ? "<null>" : this.stationId);
        sb.append(',');
        sb.append("numVehiclesAvailable");
        sb.append('=');
        sb.append(this.numVehiclesAvailable == null ? "<null>" : this.numVehiclesAvailable);
        sb.append(',');
        sb.append("vehicleTypesAvailable");
        sb.append('=');
        sb.append(this.vehicleTypesAvailable == null ? "<null>" : this.vehicleTypesAvailable);
        sb.append(',');
        sb.append("numVehiclesDisabled");
        sb.append('=');
        sb.append(this.numVehiclesDisabled == null ? "<null>" : this.numVehiclesDisabled);
        sb.append(',');
        sb.append("numDocksAvailable");
        sb.append('=');
        sb.append(this.numDocksAvailable == null ? "<null>" : this.numDocksAvailable);
        sb.append(',');
        sb.append("numDocksDisabled");
        sb.append('=');
        sb.append(this.numDocksDisabled == null ? "<null>" : this.numDocksDisabled);
        sb.append(',');
        sb.append("isInstalled");
        sb.append('=');
        sb.append(this.isInstalled == null ? "<null>" : this.isInstalled);
        sb.append(',');
        sb.append("isRenting");
        sb.append('=');
        sb.append(this.isRenting == null ? "<null>" : this.isRenting);
        sb.append(',');
        sb.append("isReturning");
        sb.append('=');
        sb.append(this.isReturning == null ? "<null>" : this.isReturning);
        sb.append(',');
        sb.append("lastReported");
        sb.append('=');
        sb.append(this.lastReported == null ? "<null>" : this.lastReported);
        sb.append(',');
        sb.append("vehicleDocksAvailable");
        sb.append('=');
        sb.append(this.vehicleDocksAvailable == null ? "<null>" : this.vehicleDocksAvailable);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.numDocksAvailable == null ? 0 : this.numDocksAvailable.hashCode());
        result = result * 31 + (this.isInstalled == null ? 0 : this.isInstalled.hashCode());
        result = result * 31 + (this.isReturning == null ? 0 : this.isReturning.hashCode());
        result = result * 31 + (this.isRenting == null ? 0 : this.isRenting.hashCode());
        result = result * 31 + (this.numVehiclesDisabled == null ? 0 : this.numVehiclesDisabled.hashCode());
        result = result * 31 + (this.numDocksDisabled == null ? 0 : this.numDocksDisabled.hashCode());
        result = result * 31 + (this.vehicleTypesAvailable == null ? 0 : this.vehicleTypesAvailable.hashCode());
        result = result * 31 + (this.lastReported == null ? 0 : this.lastReported.hashCode());
        result = result * 31 + (this.numVehiclesAvailable == null ? 0 : this.numVehiclesAvailable.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.vehicleDocksAvailable == null ? 0 : this.vehicleDocksAvailable.hashCode());
        result = result * 31 + (this.stationId == null ? 0 : this.stationId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof GBFSStation)) {
            return false;
        }
        GBFSStation rhs = (GBFSStation)other;
        return (this.numDocksAvailable == rhs.numDocksAvailable || this.numDocksAvailable != null && this.numDocksAvailable.equals(rhs.numDocksAvailable)) && (this.isInstalled == rhs.isInstalled || this.isInstalled != null && this.isInstalled.equals(rhs.isInstalled)) && (this.isReturning == rhs.isReturning || this.isReturning != null && this.isReturning.equals(rhs.isReturning)) && (this.isRenting == rhs.isRenting || this.isRenting != null && this.isRenting.equals(rhs.isRenting)) && (this.numVehiclesDisabled == rhs.numVehiclesDisabled || this.numVehiclesDisabled != null && this.numVehiclesDisabled.equals(rhs.numVehiclesDisabled)) && (this.numDocksDisabled == rhs.numDocksDisabled || this.numDocksDisabled != null && this.numDocksDisabled.equals(rhs.numDocksDisabled)) && (this.vehicleTypesAvailable == rhs.vehicleTypesAvailable || this.vehicleTypesAvailable != null && this.vehicleTypesAvailable.equals(rhs.vehicleTypesAvailable)) && (this.lastReported == rhs.lastReported || this.lastReported != null && this.lastReported.equals(rhs.lastReported)) && (this.numVehiclesAvailable == rhs.numVehiclesAvailable || this.numVehiclesAvailable != null && this.numVehiclesAvailable.equals(rhs.numVehiclesAvailable)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.vehicleDocksAvailable == rhs.vehicleDocksAvailable || this.vehicleDocksAvailable != null && this.vehicleDocksAvailable.equals(rhs.vehicleDocksAvailable)) && (this.stationId == rhs.stationId || this.stationId != null && this.stationId.equals(rhs.stationId));
    }
}

