/**
 * Copyright 2015-2020 Google, Inc., MobilityData
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: gtfs-realtime.proto

package com.google.transit.realtime;

public final class GtfsRealtime {
  private GtfsRealtime() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface FeedMessageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.FeedMessage)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<FeedMessage> {

    /**
     * <pre>
     * Metadata about this feed and feed message.
     * </pre>
     *
     * <code>required .transit_realtime.FeedHeader header = 1;</code>
     */
    boolean hasHeader();
    /**
     * <pre>
     * Metadata about this feed and feed message.
     * </pre>
     *
     * <code>required .transit_realtime.FeedHeader header = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.FeedHeader getHeader();
    /**
     * <pre>
     * Metadata about this feed and feed message.
     * </pre>
     *
     * <code>required .transit_realtime.FeedHeader header = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder getHeaderOrBuilder();

    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    java.util.List<com.google.transit.realtime.GtfsRealtime.FeedEntity> 
        getEntityList();
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    com.google.transit.realtime.GtfsRealtime.FeedEntity getEntity(int index);
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    int getEntityCount();
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    java.util.List<? extends com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder> 
        getEntityOrBuilderList();
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder getEntityOrBuilder(
        int index);
  }
  /**
   * <pre>
   * The contents of a feed message.
   * A feed is a continuous stream of feed messages. Each message in the stream is
   * obtained as a response to an appropriate HTTP GET request.
   * A realtime feed is always defined with relation to an existing GTFS feed.
   * All the entity ids are resolved with respect to the GTFS feed.
   * Note that "required" and "optional" as stated in this file refer to Protocol
   * Buffer cardinality, not semantic cardinality.  See reference.md at
   * https://github.com/google/transit/tree/master/gtfs-realtime for field
   * semantic cardinality.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.FeedMessage}
   */
  public  static final class FeedMessage extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        FeedMessage> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.FeedMessage)
      FeedMessageOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FeedMessage.newBuilder() to construct.
    private FeedMessage(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.FeedMessage, ?> builder) {
      super(builder);
    }
    private FeedMessage() {
      entity_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private FeedMessage(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) != 0)) {
                subBuilder = header_.toBuilder();
              }
              header_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.FeedHeader.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(header_);
                header_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                entity_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.FeedEntity>();
                mutable_bitField0_ |= 0x00000002;
              }
              entity_.add(
                  input.readMessage(com.google.transit.realtime.GtfsRealtime.FeedEntity.PARSER, extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          entity_ = java.util.Collections.unmodifiableList(entity_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedMessage_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.FeedMessage.class, com.google.transit.realtime.GtfsRealtime.FeedMessage.Builder.class);
    }

    private int bitField0_;
    public static final int HEADER_FIELD_NUMBER = 1;
    private com.google.transit.realtime.GtfsRealtime.FeedHeader header_;
    /**
     * <pre>
     * Metadata about this feed and feed message.
     * </pre>
     *
     * <code>required .transit_realtime.FeedHeader header = 1;</code>
     */
    public boolean hasHeader() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Metadata about this feed and feed message.
     * </pre>
     *
     * <code>required .transit_realtime.FeedHeader header = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.FeedHeader getHeader() {
      return header_ == null ? com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance() : header_;
    }
    /**
     * <pre>
     * Metadata about this feed and feed message.
     * </pre>
     *
     * <code>required .transit_realtime.FeedHeader header = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder getHeaderOrBuilder() {
      return header_ == null ? com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance() : header_;
    }

    public static final int ENTITY_FIELD_NUMBER = 2;
    private java.util.List<com.google.transit.realtime.GtfsRealtime.FeedEntity> entity_;
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    public java.util.List<com.google.transit.realtime.GtfsRealtime.FeedEntity> getEntityList() {
      return entity_;
    }
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder> 
        getEntityOrBuilderList() {
      return entity_;
    }
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    public int getEntityCount() {
      return entity_.size();
    }
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.FeedEntity getEntity(int index) {
      return entity_.get(index);
    }
    /**
     * <pre>
     * Contents of the feed.
     * </pre>
     *
     * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder getEntityOrBuilder(
        int index) {
      return entity_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasHeader()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getHeader().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getEntityCount(); i++) {
        if (!getEntity(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.FeedMessage>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getHeader());
      }
      for (int i = 0; i < entity_.size(); i++) {
        output.writeMessage(2, entity_.get(i));
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getHeader());
      }
      for (int i = 0; i < entity_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, entity_.get(i));
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.FeedMessage)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.FeedMessage other = (com.google.transit.realtime.GtfsRealtime.FeedMessage) obj;

      if (hasHeader() != other.hasHeader()) return false;
      if (hasHeader()) {
        if (!getHeader()
            .equals(other.getHeader())) return false;
      }
      if (!getEntityList()
          .equals(other.getEntityList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasHeader()) {
        hash = (37 * hash) + HEADER_FIELD_NUMBER;
        hash = (53 * hash) + getHeader().hashCode();
      }
      if (getEntityCount() > 0) {
        hash = (37 * hash) + ENTITY_FIELD_NUMBER;
        hash = (53 * hash) + getEntityList().hashCode();
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedMessage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.FeedMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * The contents of a feed message.
     * A feed is a continuous stream of feed messages. Each message in the stream is
     * obtained as a response to an appropriate HTTP GET request.
     * A realtime feed is always defined with relation to an existing GTFS feed.
     * All the entity ids are resolved with respect to the GTFS feed.
     * Note that "required" and "optional" as stated in this file refer to Protocol
     * Buffer cardinality, not semantic cardinality.  See reference.md at
     * https://github.com/google/transit/tree/master/gtfs-realtime for field
     * semantic cardinality.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.FeedMessage}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.FeedMessage, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.FeedMessage)
        com.google.transit.realtime.GtfsRealtime.FeedMessageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedMessage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.FeedMessage.class, com.google.transit.realtime.GtfsRealtime.FeedMessage.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.FeedMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getHeaderFieldBuilder();
          getEntityFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (headerBuilder_ == null) {
          header_ = null;
        } else {
          headerBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (entityBuilder_ == null) {
          entity_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          entityBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedMessage_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedMessage getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.FeedMessage.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedMessage build() {
        com.google.transit.realtime.GtfsRealtime.FeedMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedMessage buildPartial() {
        com.google.transit.realtime.GtfsRealtime.FeedMessage result = new com.google.transit.realtime.GtfsRealtime.FeedMessage(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (headerBuilder_ == null) {
            result.header_ = header_;
          } else {
            result.header_ = headerBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (entityBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            entity_ = java.util.Collections.unmodifiableList(entity_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.entity_ = entity_;
        } else {
          result.entity_ = entityBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedMessage, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedMessage, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedMessage, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedMessage, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.FeedMessage) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.FeedMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.FeedMessage other) {
        if (other == com.google.transit.realtime.GtfsRealtime.FeedMessage.getDefaultInstance()) return this;
        if (other.hasHeader()) {
          mergeHeader(other.getHeader());
        }
        if (entityBuilder_ == null) {
          if (!other.entity_.isEmpty()) {
            if (entity_.isEmpty()) {
              entity_ = other.entity_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureEntityIsMutable();
              entity_.addAll(other.entity_);
            }
            onChanged();
          }
        } else {
          if (!other.entity_.isEmpty()) {
            if (entityBuilder_.isEmpty()) {
              entityBuilder_.dispose();
              entityBuilder_ = null;
              entity_ = other.entity_;
              bitField0_ = (bitField0_ & ~0x00000002);
              entityBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getEntityFieldBuilder() : null;
            } else {
              entityBuilder_.addAllMessages(other.entity_);
            }
          }
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasHeader()) {
          return false;
        }
        if (!getHeader().isInitialized()) {
          return false;
        }
        for (int i = 0; i < getEntityCount(); i++) {
          if (!getEntity(i).isInitialized()) {
            return false;
          }
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.FeedMessage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.FeedMessage) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.transit.realtime.GtfsRealtime.FeedHeader header_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.FeedHeader, com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder, com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder> headerBuilder_;
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public boolean hasHeader() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedHeader getHeader() {
        if (headerBuilder_ == null) {
          return header_ == null ? com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance() : header_;
        } else {
          return headerBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public Builder setHeader(com.google.transit.realtime.GtfsRealtime.FeedHeader value) {
        if (headerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          header_ = value;
          onChanged();
        } else {
          headerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public Builder setHeader(
          com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder builderForValue) {
        if (headerBuilder_ == null) {
          header_ = builderForValue.build();
          onChanged();
        } else {
          headerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public Builder mergeHeader(com.google.transit.realtime.GtfsRealtime.FeedHeader value) {
        if (headerBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              header_ != null &&
              header_ != com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance()) {
            header_ =
              com.google.transit.realtime.GtfsRealtime.FeedHeader.newBuilder(header_).mergeFrom(value).buildPartial();
          } else {
            header_ = value;
          }
          onChanged();
        } else {
          headerBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public Builder clearHeader() {
        if (headerBuilder_ == null) {
          header_ = null;
          onChanged();
        } else {
          headerBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder getHeaderBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getHeaderFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder getHeaderOrBuilder() {
        if (headerBuilder_ != null) {
          return headerBuilder_.getMessageOrBuilder();
        } else {
          return header_ == null ?
              com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance() : header_;
        }
      }
      /**
       * <pre>
       * Metadata about this feed and feed message.
       * </pre>
       *
       * <code>required .transit_realtime.FeedHeader header = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.FeedHeader, com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder, com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder> 
          getHeaderFieldBuilder() {
        if (headerBuilder_ == null) {
          headerBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.FeedHeader, com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder, com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder>(
                  getHeader(),
                  getParentForChildren(),
                  isClean());
          header_ = null;
        }
        return headerBuilder_;
      }

      private java.util.List<com.google.transit.realtime.GtfsRealtime.FeedEntity> entity_ =
        java.util.Collections.emptyList();
      private void ensureEntityIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          entity_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.FeedEntity>(entity_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.FeedEntity, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder, com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder> entityBuilder_;

      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.FeedEntity> getEntityList() {
        if (entityBuilder_ == null) {
          return java.util.Collections.unmodifiableList(entity_);
        } else {
          return entityBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public int getEntityCount() {
        if (entityBuilder_ == null) {
          return entity_.size();
        } else {
          return entityBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedEntity getEntity(int index) {
        if (entityBuilder_ == null) {
          return entity_.get(index);
        } else {
          return entityBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder setEntity(
          int index, com.google.transit.realtime.GtfsRealtime.FeedEntity value) {
        if (entityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntityIsMutable();
          entity_.set(index, value);
          onChanged();
        } else {
          entityBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder setEntity(
          int index, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder builderForValue) {
        if (entityBuilder_ == null) {
          ensureEntityIsMutable();
          entity_.set(index, builderForValue.build());
          onChanged();
        } else {
          entityBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder addEntity(com.google.transit.realtime.GtfsRealtime.FeedEntity value) {
        if (entityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntityIsMutable();
          entity_.add(value);
          onChanged();
        } else {
          entityBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder addEntity(
          int index, com.google.transit.realtime.GtfsRealtime.FeedEntity value) {
        if (entityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEntityIsMutable();
          entity_.add(index, value);
          onChanged();
        } else {
          entityBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder addEntity(
          com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder builderForValue) {
        if (entityBuilder_ == null) {
          ensureEntityIsMutable();
          entity_.add(builderForValue.build());
          onChanged();
        } else {
          entityBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder addEntity(
          int index, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder builderForValue) {
        if (entityBuilder_ == null) {
          ensureEntityIsMutable();
          entity_.add(index, builderForValue.build());
          onChanged();
        } else {
          entityBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder addAllEntity(
          java.lang.Iterable<? extends com.google.transit.realtime.GtfsRealtime.FeedEntity> values) {
        if (entityBuilder_ == null) {
          ensureEntityIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, entity_);
          onChanged();
        } else {
          entityBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder clearEntity() {
        if (entityBuilder_ == null) {
          entity_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          entityBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public Builder removeEntity(int index) {
        if (entityBuilder_ == null) {
          ensureEntityIsMutable();
          entity_.remove(index);
          onChanged();
        } else {
          entityBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder getEntityBuilder(
          int index) {
        return getEntityFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder getEntityOrBuilder(
          int index) {
        if (entityBuilder_ == null) {
          return entity_.get(index);  } else {
          return entityBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder> 
           getEntityOrBuilderList() {
        if (entityBuilder_ != null) {
          return entityBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(entity_);
        }
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder addEntityBuilder() {
        return getEntityFieldBuilder().addBuilder(
            com.google.transit.realtime.GtfsRealtime.FeedEntity.getDefaultInstance());
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder addEntityBuilder(
          int index) {
        return getEntityFieldBuilder().addBuilder(
            index, com.google.transit.realtime.GtfsRealtime.FeedEntity.getDefaultInstance());
      }
      /**
       * <pre>
       * Contents of the feed.
       * </pre>
       *
       * <code>repeated .transit_realtime.FeedEntity entity = 2;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder> 
           getEntityBuilderList() {
        return getEntityFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.FeedEntity, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder, com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder> 
          getEntityFieldBuilder() {
        if (entityBuilder_ == null) {
          entityBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.FeedEntity, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder, com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder>(
                  entity_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          entity_ = null;
        }
        return entityBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.FeedMessage)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.FeedMessage)
    private static final com.google.transit.realtime.GtfsRealtime.FeedMessage DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.FeedMessage();
    }

    public static com.google.transit.realtime.GtfsRealtime.FeedMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FeedMessage>
        PARSER = new com.google.protobuf.AbstractParser<FeedMessage>() {
      @java.lang.Override
      public FeedMessage parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FeedMessage(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<FeedMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeedMessage> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.FeedMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FeedHeaderOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.FeedHeader)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<FeedHeader> {

    /**
     * <pre>
     * Version of the feed specification.
     * The current version is 2.0.  Valid versions are "2.0", "1.0".
     * </pre>
     *
     * <code>required string gtfs_realtime_version = 1;</code>
     */
    boolean hasGtfsRealtimeVersion();
    /**
     * <pre>
     * Version of the feed specification.
     * The current version is 2.0.  Valid versions are "2.0", "1.0".
     * </pre>
     *
     * <code>required string gtfs_realtime_version = 1;</code>
     */
    java.lang.String getGtfsRealtimeVersion();
    /**
     * <pre>
     * Version of the feed specification.
     * The current version is 2.0.  Valid versions are "2.0", "1.0".
     * </pre>
     *
     * <code>required string gtfs_realtime_version = 1;</code>
     */
    com.google.protobuf.ByteString
        getGtfsRealtimeVersionBytes();

    /**
     * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
     */
    boolean hasIncrementality();
    /**
     * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
     */
    com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality getIncrementality();

    /**
     * <pre>
     * This timestamp identifies the moment when the content of this feed has been
     * created (in server time). In POSIX time (i.e., number of seconds since
     * January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 3;</code>
     */
    boolean hasTimestamp();
    /**
     * <pre>
     * This timestamp identifies the moment when the content of this feed has been
     * created (in server time). In POSIX time (i.e., number of seconds since
     * January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 3;</code>
     */
    long getTimestamp();
  }
  /**
   * <pre>
   * Metadata about a feed, included in feed messages.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.FeedHeader}
   */
  public  static final class FeedHeader extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        FeedHeader> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.FeedHeader)
      FeedHeaderOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FeedHeader.newBuilder() to construct.
    private FeedHeader(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.FeedHeader, ?> builder) {
      super(builder);
    }
    private FeedHeader() {
      gtfsRealtimeVersion_ = "";
      incrementality_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private FeedHeader(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              gtfsRealtimeVersion_ = bs;
              break;
            }
            case 16: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality value = com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(2, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                incrementality_ = rawValue;
              }
              break;
            }
            case 24: {
              bitField0_ |= 0x00000004;
              timestamp_ = input.readUInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedHeader_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedHeader_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.FeedHeader.class, com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder.class);
    }

    /**
     * <pre>
     * Determines whether the current fetch is incremental.  Currently,
     * DIFFERENTIAL mode is unsupported and behavior is unspecified for feeds
     * that use this mode.  There are discussions on the GTFS Realtime mailing
     * list around fully specifying the behavior of DIFFERENTIAL mode and the
     * documentation will be updated when those discussions are finalized.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.FeedHeader.Incrementality}
     */
    public enum Incrementality
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>FULL_DATASET = 0;</code>
       */
      FULL_DATASET(0),
      /**
       * <code>DIFFERENTIAL = 1;</code>
       */
      DIFFERENTIAL(1),
      ;

      /**
       * <code>FULL_DATASET = 0;</code>
       */
      public static final int FULL_DATASET_VALUE = 0;
      /**
       * <code>DIFFERENTIAL = 1;</code>
       */
      public static final int DIFFERENTIAL_VALUE = 1;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Incrementality valueOf(int value) {
        return forNumber(value);
      }

      public static Incrementality forNumber(int value) {
        switch (value) {
          case 0: return FULL_DATASET;
          case 1: return DIFFERENTIAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Incrementality>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Incrementality> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Incrementality>() {
              public Incrementality findValueByNumber(int number) {
                return Incrementality.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.FeedHeader.getDescriptor().getEnumTypes().get(0);
      }

      private static final Incrementality[] VALUES = values();

      public static Incrementality valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Incrementality(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.FeedHeader.Incrementality)
    }

    private int bitField0_;
    public static final int GTFS_REALTIME_VERSION_FIELD_NUMBER = 1;
    private volatile java.lang.Object gtfsRealtimeVersion_;
    /**
     * <pre>
     * Version of the feed specification.
     * The current version is 2.0.  Valid versions are "2.0", "1.0".
     * </pre>
     *
     * <code>required string gtfs_realtime_version = 1;</code>
     */
    public boolean hasGtfsRealtimeVersion() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Version of the feed specification.
     * The current version is 2.0.  Valid versions are "2.0", "1.0".
     * </pre>
     *
     * <code>required string gtfs_realtime_version = 1;</code>
     */
    public java.lang.String getGtfsRealtimeVersion() {
      java.lang.Object ref = gtfsRealtimeVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          gtfsRealtimeVersion_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Version of the feed specification.
     * The current version is 2.0.  Valid versions are "2.0", "1.0".
     * </pre>
     *
     * <code>required string gtfs_realtime_version = 1;</code>
     */
    public com.google.protobuf.ByteString
        getGtfsRealtimeVersionBytes() {
      java.lang.Object ref = gtfsRealtimeVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        gtfsRealtimeVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INCREMENTALITY_FIELD_NUMBER = 2;
    private int incrementality_;
    /**
     * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
     */
    public boolean hasIncrementality() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
     */
    public com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality getIncrementality() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality result = com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality.valueOf(incrementality_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality.FULL_DATASET : result;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 3;
    private long timestamp_;
    /**
     * <pre>
     * This timestamp identifies the moment when the content of this feed has been
     * created (in server time). In POSIX time (i.e., number of seconds since
     * January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 3;</code>
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * This timestamp identifies the moment when the content of this feed has been
     * created (in server time). In POSIX time (i.e., number of seconds since
     * January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 3;</code>
     */
    public long getTimestamp() {
      return timestamp_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasGtfsRealtimeVersion()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.FeedHeader>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, gtfsRealtimeVersion_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(2, incrementality_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt64(3, timestamp_);
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, gtfsRealtimeVersion_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, incrementality_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, timestamp_);
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.FeedHeader)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.FeedHeader other = (com.google.transit.realtime.GtfsRealtime.FeedHeader) obj;

      if (hasGtfsRealtimeVersion() != other.hasGtfsRealtimeVersion()) return false;
      if (hasGtfsRealtimeVersion()) {
        if (!getGtfsRealtimeVersion()
            .equals(other.getGtfsRealtimeVersion())) return false;
      }
      if (hasIncrementality() != other.hasIncrementality()) return false;
      if (hasIncrementality()) {
        if (incrementality_ != other.incrementality_) return false;
      }
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (getTimestamp()
            != other.getTimestamp()) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasGtfsRealtimeVersion()) {
        hash = (37 * hash) + GTFS_REALTIME_VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getGtfsRealtimeVersion().hashCode();
      }
      if (hasIncrementality()) {
        hash = (37 * hash) + INCREMENTALITY_FIELD_NUMBER;
        hash = (53 * hash) + incrementality_;
      }
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getTimestamp());
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedHeader parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.FeedHeader prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Metadata about a feed, included in feed messages.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.FeedHeader}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.FeedHeader, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.FeedHeader)
        com.google.transit.realtime.GtfsRealtime.FeedHeaderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedHeader_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedHeader_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.FeedHeader.class, com.google.transit.realtime.GtfsRealtime.FeedHeader.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.FeedHeader.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        gtfsRealtimeVersion_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        incrementality_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        timestamp_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedHeader_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedHeader getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedHeader build() {
        com.google.transit.realtime.GtfsRealtime.FeedHeader result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedHeader buildPartial() {
        com.google.transit.realtime.GtfsRealtime.FeedHeader result = new com.google.transit.realtime.GtfsRealtime.FeedHeader(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.gtfsRealtimeVersion_ = gtfsRealtimeVersion_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.incrementality_ = incrementality_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.timestamp_ = timestamp_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedHeader, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedHeader, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedHeader, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedHeader, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.FeedHeader) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.FeedHeader)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.FeedHeader other) {
        if (other == com.google.transit.realtime.GtfsRealtime.FeedHeader.getDefaultInstance()) return this;
        if (other.hasGtfsRealtimeVersion()) {
          bitField0_ |= 0x00000001;
          gtfsRealtimeVersion_ = other.gtfsRealtimeVersion_;
          onChanged();
        }
        if (other.hasIncrementality()) {
          setIncrementality(other.getIncrementality());
        }
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasGtfsRealtimeVersion()) {
          return false;
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.FeedHeader parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.FeedHeader) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object gtfsRealtimeVersion_ = "";
      /**
       * <pre>
       * Version of the feed specification.
       * The current version is 2.0.  Valid versions are "2.0", "1.0".
       * </pre>
       *
       * <code>required string gtfs_realtime_version = 1;</code>
       */
      public boolean hasGtfsRealtimeVersion() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Version of the feed specification.
       * The current version is 2.0.  Valid versions are "2.0", "1.0".
       * </pre>
       *
       * <code>required string gtfs_realtime_version = 1;</code>
       */
      public java.lang.String getGtfsRealtimeVersion() {
        java.lang.Object ref = gtfsRealtimeVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            gtfsRealtimeVersion_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Version of the feed specification.
       * The current version is 2.0.  Valid versions are "2.0", "1.0".
       * </pre>
       *
       * <code>required string gtfs_realtime_version = 1;</code>
       */
      public com.google.protobuf.ByteString
          getGtfsRealtimeVersionBytes() {
        java.lang.Object ref = gtfsRealtimeVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          gtfsRealtimeVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Version of the feed specification.
       * The current version is 2.0.  Valid versions are "2.0", "1.0".
       * </pre>
       *
       * <code>required string gtfs_realtime_version = 1;</code>
       */
      public Builder setGtfsRealtimeVersion(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        gtfsRealtimeVersion_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Version of the feed specification.
       * The current version is 2.0.  Valid versions are "2.0", "1.0".
       * </pre>
       *
       * <code>required string gtfs_realtime_version = 1;</code>
       */
      public Builder clearGtfsRealtimeVersion() {
        bitField0_ = (bitField0_ & ~0x00000001);
        gtfsRealtimeVersion_ = getDefaultInstance().getGtfsRealtimeVersion();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Version of the feed specification.
       * The current version is 2.0.  Valid versions are "2.0", "1.0".
       * </pre>
       *
       * <code>required string gtfs_realtime_version = 1;</code>
       */
      public Builder setGtfsRealtimeVersionBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        gtfsRealtimeVersion_ = value;
        onChanged();
        return this;
      }

      private int incrementality_ = 0;
      /**
       * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
       */
      public boolean hasIncrementality() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality getIncrementality() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality result = com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality.valueOf(incrementality_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality.FULL_DATASET : result;
      }
      /**
       * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
       */
      public Builder setIncrementality(com.google.transit.realtime.GtfsRealtime.FeedHeader.Incrementality value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        incrementality_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.FeedHeader.Incrementality incrementality = 2 [default = FULL_DATASET];</code>
       */
      public Builder clearIncrementality() {
        bitField0_ = (bitField0_ & ~0x00000002);
        incrementality_ = 0;
        onChanged();
        return this;
      }

      private long timestamp_ ;
      /**
       * <pre>
       * This timestamp identifies the moment when the content of this feed has been
       * created (in server time). In POSIX time (i.e., number of seconds since
       * January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 3;</code>
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * This timestamp identifies the moment when the content of this feed has been
       * created (in server time). In POSIX time (i.e., number of seconds since
       * January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 3;</code>
       */
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <pre>
       * This timestamp identifies the moment when the content of this feed has been
       * created (in server time). In POSIX time (i.e., number of seconds since
       * January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 3;</code>
       */
      public Builder setTimestamp(long value) {
        bitField0_ |= 0x00000004;
        timestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * This timestamp identifies the moment when the content of this feed has been
       * created (in server time). In POSIX time (i.e., number of seconds since
       * January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 3;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000004);
        timestamp_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.FeedHeader)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.FeedHeader)
    private static final com.google.transit.realtime.GtfsRealtime.FeedHeader DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.FeedHeader();
    }

    public static com.google.transit.realtime.GtfsRealtime.FeedHeader getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FeedHeader>
        PARSER = new com.google.protobuf.AbstractParser<FeedHeader>() {
      @java.lang.Override
      public FeedHeader parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FeedHeader(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<FeedHeader> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeedHeader> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.FeedHeader getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FeedEntityOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.FeedEntity)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<FeedEntity> {

    /**
     * <pre>
     * The ids are used only to provide incrementality support. The id should be
     * unique within a FeedMessage. Consequent FeedMessages may contain
     * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
     * FeedEntity with some id will replace the old FeedEntity with the same id
     * (or delete it - see is_deleted below).
     * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
     * feed must be specified by explicit selectors (see EntitySelector below for
     * more info).
     * </pre>
     *
     * <code>required string id = 1;</code>
     */
    boolean hasId();
    /**
     * <pre>
     * The ids are used only to provide incrementality support. The id should be
     * unique within a FeedMessage. Consequent FeedMessages may contain
     * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
     * FeedEntity with some id will replace the old FeedEntity with the same id
     * (or delete it - see is_deleted below).
     * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
     * feed must be specified by explicit selectors (see EntitySelector below for
     * more info).
     * </pre>
     *
     * <code>required string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * The ids are used only to provide incrementality support. The id should be
     * unique within a FeedMessage. Consequent FeedMessages may contain
     * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
     * FeedEntity with some id will replace the old FeedEntity with the same id
     * (or delete it - see is_deleted below).
     * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
     * feed must be specified by explicit selectors (see EntitySelector below for
     * more info).
     * </pre>
     *
     * <code>required string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * Whether this entity is to be deleted. Relevant only for incremental
     * fetches.
     * </pre>
     *
     * <code>optional bool is_deleted = 2 [default = false];</code>
     */
    boolean hasIsDeleted();
    /**
     * <pre>
     * Whether this entity is to be deleted. Relevant only for incremental
     * fetches.
     * </pre>
     *
     * <code>optional bool is_deleted = 2 [default = false];</code>
     */
    boolean getIsDeleted();

    /**
     * <pre>
     * Data about the entity itself. Exactly one of the following fields must be
     * present (unless the entity is being deleted).
     * </pre>
     *
     * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
     */
    boolean hasTripUpdate();
    /**
     * <pre>
     * Data about the entity itself. Exactly one of the following fields must be
     * present (unless the entity is being deleted).
     * </pre>
     *
     * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripUpdate getTripUpdate();
    /**
     * <pre>
     * Data about the entity itself. Exactly one of the following fields must be
     * present (unless the entity is being deleted).
     * </pre>
     *
     * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder getTripUpdateOrBuilder();

    /**
     * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
     */
    boolean hasVehicle();
    /**
     * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePosition getVehicle();
    /**
     * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder getVehicleOrBuilder();

    /**
     * <code>optional .transit_realtime.Alert alert = 5;</code>
     */
    boolean hasAlert();
    /**
     * <code>optional .transit_realtime.Alert alert = 5;</code>
     */
    com.google.transit.realtime.GtfsRealtime.Alert getAlert();
    /**
     * <code>optional .transit_realtime.Alert alert = 5;</code>
     */
    com.google.transit.realtime.GtfsRealtime.AlertOrBuilder getAlertOrBuilder();
  }
  /**
   * <pre>
   * A definition (or update) of an entity in the transit feed.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.FeedEntity}
   */
  public  static final class FeedEntity extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        FeedEntity> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.FeedEntity)
      FeedEntityOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use FeedEntity.newBuilder() to construct.
    private FeedEntity(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.FeedEntity, ?> builder) {
      super(builder);
    }
    private FeedEntity() {
      id_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private FeedEntity(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              id_ = bs;
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              isDeleted_ = input.readBool();
              break;
            }
            case 26: {
              com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) != 0)) {
                subBuilder = tripUpdate_.toBuilder();
              }
              tripUpdate_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripUpdate.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tripUpdate_);
                tripUpdate_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 34: {
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) != 0)) {
                subBuilder = vehicle_.toBuilder();
              }
              vehicle_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.VehiclePosition.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(vehicle_);
                vehicle_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 42: {
              com.google.transit.realtime.GtfsRealtime.Alert.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) != 0)) {
                subBuilder = alert_.toBuilder();
              }
              alert_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.Alert.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(alert_);
                alert_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedEntity_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedEntity_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.FeedEntity.class, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * The ids are used only to provide incrementality support. The id should be
     * unique within a FeedMessage. Consequent FeedMessages may contain
     * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
     * FeedEntity with some id will replace the old FeedEntity with the same id
     * (or delete it - see is_deleted below).
     * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
     * feed must be specified by explicit selectors (see EntitySelector below for
     * more info).
     * </pre>
     *
     * <code>required string id = 1;</code>
     */
    public boolean hasId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The ids are used only to provide incrementality support. The id should be
     * unique within a FeedMessage. Consequent FeedMessages may contain
     * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
     * FeedEntity with some id will replace the old FeedEntity with the same id
     * (or delete it - see is_deleted below).
     * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
     * feed must be specified by explicit selectors (see EntitySelector below for
     * more info).
     * </pre>
     *
     * <code>required string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          id_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The ids are used only to provide incrementality support. The id should be
     * unique within a FeedMessage. Consequent FeedMessages may contain
     * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
     * FeedEntity with some id will replace the old FeedEntity with the same id
     * (or delete it - see is_deleted below).
     * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
     * feed must be specified by explicit selectors (see EntitySelector below for
     * more info).
     * </pre>
     *
     * <code>required string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_DELETED_FIELD_NUMBER = 2;
    private boolean isDeleted_;
    /**
     * <pre>
     * Whether this entity is to be deleted. Relevant only for incremental
     * fetches.
     * </pre>
     *
     * <code>optional bool is_deleted = 2 [default = false];</code>
     */
    public boolean hasIsDeleted() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Whether this entity is to be deleted. Relevant only for incremental
     * fetches.
     * </pre>
     *
     * <code>optional bool is_deleted = 2 [default = false];</code>
     */
    public boolean getIsDeleted() {
      return isDeleted_;
    }

    public static final int TRIP_UPDATE_FIELD_NUMBER = 3;
    private com.google.transit.realtime.GtfsRealtime.TripUpdate tripUpdate_;
    /**
     * <pre>
     * Data about the entity itself. Exactly one of the following fields must be
     * present (unless the entity is being deleted).
     * </pre>
     *
     * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
     */
    public boolean hasTripUpdate() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Data about the entity itself. Exactly one of the following fields must be
     * present (unless the entity is being deleted).
     * </pre>
     *
     * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripUpdate getTripUpdate() {
      return tripUpdate_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance() : tripUpdate_;
    }
    /**
     * <pre>
     * Data about the entity itself. Exactly one of the following fields must be
     * present (unless the entity is being deleted).
     * </pre>
     *
     * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder getTripUpdateOrBuilder() {
      return tripUpdate_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance() : tripUpdate_;
    }

    public static final int VEHICLE_FIELD_NUMBER = 4;
    private com.google.transit.realtime.GtfsRealtime.VehiclePosition vehicle_;
    /**
     * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
     */
    public boolean hasVehicle() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition getVehicle() {
      return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance() : vehicle_;
    }
    /**
     * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder getVehicleOrBuilder() {
      return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance() : vehicle_;
    }

    public static final int ALERT_FIELD_NUMBER = 5;
    private com.google.transit.realtime.GtfsRealtime.Alert alert_;
    /**
     * <code>optional .transit_realtime.Alert alert = 5;</code>
     */
    public boolean hasAlert() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional .transit_realtime.Alert alert = 5;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.Alert getAlert() {
      return alert_ == null ? com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance() : alert_;
    }
    /**
     * <code>optional .transit_realtime.Alert alert = 5;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.AlertOrBuilder getAlertOrBuilder() {
      return alert_ == null ? com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance() : alert_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasTripUpdate()) {
        if (!getTripUpdate().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasVehicle()) {
        if (!getVehicle().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasAlert()) {
        if (!getAlert().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.FeedEntity>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeBool(2, isDeleted_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getTripUpdate());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getVehicle());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(5, getAlert());
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, isDeleted_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getTripUpdate());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getVehicle());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getAlert());
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.FeedEntity)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.FeedEntity other = (com.google.transit.realtime.GtfsRealtime.FeedEntity) obj;

      if (hasId() != other.hasId()) return false;
      if (hasId()) {
        if (!getId()
            .equals(other.getId())) return false;
      }
      if (hasIsDeleted() != other.hasIsDeleted()) return false;
      if (hasIsDeleted()) {
        if (getIsDeleted()
            != other.getIsDeleted()) return false;
      }
      if (hasTripUpdate() != other.hasTripUpdate()) return false;
      if (hasTripUpdate()) {
        if (!getTripUpdate()
            .equals(other.getTripUpdate())) return false;
      }
      if (hasVehicle() != other.hasVehicle()) return false;
      if (hasVehicle()) {
        if (!getVehicle()
            .equals(other.getVehicle())) return false;
      }
      if (hasAlert() != other.hasAlert()) return false;
      if (hasAlert()) {
        if (!getAlert()
            .equals(other.getAlert())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasId()) {
        hash = (37 * hash) + ID_FIELD_NUMBER;
        hash = (53 * hash) + getId().hashCode();
      }
      if (hasIsDeleted()) {
        hash = (37 * hash) + IS_DELETED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getIsDeleted());
      }
      if (hasTripUpdate()) {
        hash = (37 * hash) + TRIP_UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getTripUpdate().hashCode();
      }
      if (hasVehicle()) {
        hash = (37 * hash) + VEHICLE_FIELD_NUMBER;
        hash = (53 * hash) + getVehicle().hashCode();
      }
      if (hasAlert()) {
        hash = (37 * hash) + ALERT_FIELD_NUMBER;
        hash = (53 * hash) + getAlert().hashCode();
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.FeedEntity parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.FeedEntity prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A definition (or update) of an entity in the transit feed.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.FeedEntity}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.FeedEntity, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.FeedEntity)
        com.google.transit.realtime.GtfsRealtime.FeedEntityOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedEntity_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedEntity_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.FeedEntity.class, com.google.transit.realtime.GtfsRealtime.FeedEntity.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.FeedEntity.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTripUpdateFieldBuilder();
          getVehicleFieldBuilder();
          getAlertFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        id_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        isDeleted_ = false;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (tripUpdateBuilder_ == null) {
          tripUpdate_ = null;
        } else {
          tripUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (vehicleBuilder_ == null) {
          vehicle_ = null;
        } else {
          vehicleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (alertBuilder_ == null) {
          alert_ = null;
        } else {
          alertBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_FeedEntity_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedEntity getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.FeedEntity.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedEntity build() {
        com.google.transit.realtime.GtfsRealtime.FeedEntity result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.FeedEntity buildPartial() {
        com.google.transit.realtime.GtfsRealtime.FeedEntity result = new com.google.transit.realtime.GtfsRealtime.FeedEntity(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.id_ = id_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.isDeleted_ = isDeleted_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (tripUpdateBuilder_ == null) {
            result.tripUpdate_ = tripUpdate_;
          } else {
            result.tripUpdate_ = tripUpdateBuilder_.build();
          }
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          if (vehicleBuilder_ == null) {
            result.vehicle_ = vehicle_;
          } else {
            result.vehicle_ = vehicleBuilder_.build();
          }
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          if (alertBuilder_ == null) {
            result.alert_ = alert_;
          } else {
            result.alert_ = alertBuilder_.build();
          }
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedEntity, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedEntity, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedEntity, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.FeedEntity, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.FeedEntity) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.FeedEntity)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.FeedEntity other) {
        if (other == com.google.transit.realtime.GtfsRealtime.FeedEntity.getDefaultInstance()) return this;
        if (other.hasId()) {
          bitField0_ |= 0x00000001;
          id_ = other.id_;
          onChanged();
        }
        if (other.hasIsDeleted()) {
          setIsDeleted(other.getIsDeleted());
        }
        if (other.hasTripUpdate()) {
          mergeTripUpdate(other.getTripUpdate());
        }
        if (other.hasVehicle()) {
          mergeVehicle(other.getVehicle());
        }
        if (other.hasAlert()) {
          mergeAlert(other.getAlert());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasId()) {
          return false;
        }
        if (hasTripUpdate()) {
          if (!getTripUpdate().isInitialized()) {
            return false;
          }
        }
        if (hasVehicle()) {
          if (!getVehicle().isInitialized()) {
            return false;
          }
        }
        if (hasAlert()) {
          if (!getAlert().isInitialized()) {
            return false;
          }
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.FeedEntity parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.FeedEntity) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * The ids are used only to provide incrementality support. The id should be
       * unique within a FeedMessage. Consequent FeedMessages may contain
       * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
       * FeedEntity with some id will replace the old FeedEntity with the same id
       * (or delete it - see is_deleted below).
       * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
       * feed must be specified by explicit selectors (see EntitySelector below for
       * more info).
       * </pre>
       *
       * <code>required string id = 1;</code>
       */
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The ids are used only to provide incrementality support. The id should be
       * unique within a FeedMessage. Consequent FeedMessages may contain
       * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
       * FeedEntity with some id will replace the old FeedEntity with the same id
       * (or delete it - see is_deleted below).
       * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
       * feed must be specified by explicit selectors (see EntitySelector below for
       * more info).
       * </pre>
       *
       * <code>required string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            id_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The ids are used only to provide incrementality support. The id should be
       * unique within a FeedMessage. Consequent FeedMessages may contain
       * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
       * FeedEntity with some id will replace the old FeedEntity with the same id
       * (or delete it - see is_deleted below).
       * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
       * feed must be specified by explicit selectors (see EntitySelector below for
       * more info).
       * </pre>
       *
       * <code>required string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The ids are used only to provide incrementality support. The id should be
       * unique within a FeedMessage. Consequent FeedMessages may contain
       * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
       * FeedEntity with some id will replace the old FeedEntity with the same id
       * (or delete it - see is_deleted below).
       * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
       * feed must be specified by explicit selectors (see EntitySelector below for
       * more info).
       * </pre>
       *
       * <code>required string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ids are used only to provide incrementality support. The id should be
       * unique within a FeedMessage. Consequent FeedMessages may contain
       * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
       * FeedEntity with some id will replace the old FeedEntity with the same id
       * (or delete it - see is_deleted below).
       * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
       * feed must be specified by explicit selectors (see EntitySelector below for
       * more info).
       * </pre>
       *
       * <code>required string id = 1;</code>
       */
      public Builder clearId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The ids are used only to provide incrementality support. The id should be
       * unique within a FeedMessage. Consequent FeedMessages may contain
       * FeedEntities with the same id. In case of a DIFFERENTIAL update the new
       * FeedEntity with some id will replace the old FeedEntity with the same id
       * (or delete it - see is_deleted below).
       * The actual GTFS entities (e.g. stations, routes, trips) referenced by the
       * feed must be specified by explicit selectors (see EntitySelector below for
       * more info).
       * </pre>
       *
       * <code>required string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        id_ = value;
        onChanged();
        return this;
      }

      private boolean isDeleted_ ;
      /**
       * <pre>
       * Whether this entity is to be deleted. Relevant only for incremental
       * fetches.
       * </pre>
       *
       * <code>optional bool is_deleted = 2 [default = false];</code>
       */
      public boolean hasIsDeleted() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Whether this entity is to be deleted. Relevant only for incremental
       * fetches.
       * </pre>
       *
       * <code>optional bool is_deleted = 2 [default = false];</code>
       */
      public boolean getIsDeleted() {
        return isDeleted_;
      }
      /**
       * <pre>
       * Whether this entity is to be deleted. Relevant only for incremental
       * fetches.
       * </pre>
       *
       * <code>optional bool is_deleted = 2 [default = false];</code>
       */
      public Builder setIsDeleted(boolean value) {
        bitField0_ |= 0x00000002;
        isDeleted_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Whether this entity is to be deleted. Relevant only for incremental
       * fetches.
       * </pre>
       *
       * <code>optional bool is_deleted = 2 [default = false];</code>
       */
      public Builder clearIsDeleted() {
        bitField0_ = (bitField0_ & ~0x00000002);
        isDeleted_ = false;
        onChanged();
        return this;
      }

      private com.google.transit.realtime.GtfsRealtime.TripUpdate tripUpdate_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripUpdate, com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder> tripUpdateBuilder_;
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public boolean hasTripUpdate() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate getTripUpdate() {
        if (tripUpdateBuilder_ == null) {
          return tripUpdate_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance() : tripUpdate_;
        } else {
          return tripUpdateBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public Builder setTripUpdate(com.google.transit.realtime.GtfsRealtime.TripUpdate value) {
        if (tripUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tripUpdate_ = value;
          onChanged();
        } else {
          tripUpdateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public Builder setTripUpdate(
          com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder builderForValue) {
        if (tripUpdateBuilder_ == null) {
          tripUpdate_ = builderForValue.build();
          onChanged();
        } else {
          tripUpdateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public Builder mergeTripUpdate(com.google.transit.realtime.GtfsRealtime.TripUpdate value) {
        if (tripUpdateBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              tripUpdate_ != null &&
              tripUpdate_ != com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance()) {
            tripUpdate_ =
              com.google.transit.realtime.GtfsRealtime.TripUpdate.newBuilder(tripUpdate_).mergeFrom(value).buildPartial();
          } else {
            tripUpdate_ = value;
          }
          onChanged();
        } else {
          tripUpdateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public Builder clearTripUpdate() {
        if (tripUpdateBuilder_ == null) {
          tripUpdate_ = null;
          onChanged();
        } else {
          tripUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder getTripUpdateBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTripUpdateFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder getTripUpdateOrBuilder() {
        if (tripUpdateBuilder_ != null) {
          return tripUpdateBuilder_.getMessageOrBuilder();
        } else {
          return tripUpdate_ == null ?
              com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance() : tripUpdate_;
        }
      }
      /**
       * <pre>
       * Data about the entity itself. Exactly one of the following fields must be
       * present (unless the entity is being deleted).
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate trip_update = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripUpdate, com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder> 
          getTripUpdateFieldBuilder() {
        if (tripUpdateBuilder_ == null) {
          tripUpdateBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TripUpdate, com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder>(
                  getTripUpdate(),
                  getParentForChildren(),
                  isClean());
          tripUpdate_ = null;
        }
        return tripUpdateBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.VehiclePosition vehicle_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehiclePosition, com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder, com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder> vehicleBuilder_;
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public boolean hasVehicle() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition getVehicle() {
        if (vehicleBuilder_ == null) {
          return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance() : vehicle_;
        } else {
          return vehicleBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public Builder setVehicle(com.google.transit.realtime.GtfsRealtime.VehiclePosition value) {
        if (vehicleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vehicle_ = value;
          onChanged();
        } else {
          vehicleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public Builder setVehicle(
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder builderForValue) {
        if (vehicleBuilder_ == null) {
          vehicle_ = builderForValue.build();
          onChanged();
        } else {
          vehicleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public Builder mergeVehicle(com.google.transit.realtime.GtfsRealtime.VehiclePosition value) {
        if (vehicleBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
              vehicle_ != null &&
              vehicle_ != com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance()) {
            vehicle_ =
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.newBuilder(vehicle_).mergeFrom(value).buildPartial();
          } else {
            vehicle_ = value;
          }
          onChanged();
        } else {
          vehicleBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public Builder clearVehicle() {
        if (vehicleBuilder_ == null) {
          vehicle_ = null;
          onChanged();
        } else {
          vehicleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder getVehicleBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getVehicleFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder getVehicleOrBuilder() {
        if (vehicleBuilder_ != null) {
          return vehicleBuilder_.getMessageOrBuilder();
        } else {
          return vehicle_ == null ?
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance() : vehicle_;
        }
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition vehicle = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehiclePosition, com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder, com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder> 
          getVehicleFieldBuilder() {
        if (vehicleBuilder_ == null) {
          vehicleBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.VehiclePosition, com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder, com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder>(
                  getVehicle(),
                  getParentForChildren(),
                  isClean());
          vehicle_ = null;
        }
        return vehicleBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.Alert alert_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.Alert, com.google.transit.realtime.GtfsRealtime.Alert.Builder, com.google.transit.realtime.GtfsRealtime.AlertOrBuilder> alertBuilder_;
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public boolean hasAlert() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Alert getAlert() {
        if (alertBuilder_ == null) {
          return alert_ == null ? com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance() : alert_;
        } else {
          return alertBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public Builder setAlert(com.google.transit.realtime.GtfsRealtime.Alert value) {
        if (alertBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          alert_ = value;
          onChanged();
        } else {
          alertBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public Builder setAlert(
          com.google.transit.realtime.GtfsRealtime.Alert.Builder builderForValue) {
        if (alertBuilder_ == null) {
          alert_ = builderForValue.build();
          onChanged();
        } else {
          alertBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public Builder mergeAlert(com.google.transit.realtime.GtfsRealtime.Alert value) {
        if (alertBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
              alert_ != null &&
              alert_ != com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance()) {
            alert_ =
              com.google.transit.realtime.GtfsRealtime.Alert.newBuilder(alert_).mergeFrom(value).buildPartial();
          } else {
            alert_ = value;
          }
          onChanged();
        } else {
          alertBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public Builder clearAlert() {
        if (alertBuilder_ == null) {
          alert_ = null;
          onChanged();
        } else {
          alertBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Alert.Builder getAlertBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getAlertFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.AlertOrBuilder getAlertOrBuilder() {
        if (alertBuilder_ != null) {
          return alertBuilder_.getMessageOrBuilder();
        } else {
          return alert_ == null ?
              com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance() : alert_;
        }
      }
      /**
       * <code>optional .transit_realtime.Alert alert = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.Alert, com.google.transit.realtime.GtfsRealtime.Alert.Builder, com.google.transit.realtime.GtfsRealtime.AlertOrBuilder> 
          getAlertFieldBuilder() {
        if (alertBuilder_ == null) {
          alertBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.Alert, com.google.transit.realtime.GtfsRealtime.Alert.Builder, com.google.transit.realtime.GtfsRealtime.AlertOrBuilder>(
                  getAlert(),
                  getParentForChildren(),
                  isClean());
          alert_ = null;
        }
        return alertBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.FeedEntity)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.FeedEntity)
    private static final com.google.transit.realtime.GtfsRealtime.FeedEntity DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.FeedEntity();
    }

    public static com.google.transit.realtime.GtfsRealtime.FeedEntity getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<FeedEntity>
        PARSER = new com.google.protobuf.AbstractParser<FeedEntity>() {
      @java.lang.Override
      public FeedEntity parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new FeedEntity(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<FeedEntity> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FeedEntity> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.FeedEntity getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TripUpdateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.TripUpdate)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<TripUpdate> {

    /**
     * <pre>
     * The Trip that this message applies to. There can be at most one
     * TripUpdate entity for each actual trip instance.
     * If there is none, that means there is no prediction information available.
     * It does *not* mean that the trip is progressing according to schedule.
     * </pre>
     *
     * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
     */
    boolean hasTrip();
    /**
     * <pre>
     * The Trip that this message applies to. There can be at most one
     * TripUpdate entity for each actual trip instance.
     * If there is none, that means there is no prediction information available.
     * It does *not* mean that the trip is progressing according to schedule.
     * </pre>
     *
     * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripDescriptor getTrip();
    /**
     * <pre>
     * The Trip that this message applies to. There can be at most one
     * TripUpdate entity for each actual trip instance.
     * If there is none, that means there is no prediction information available.
     * It does *not* mean that the trip is progressing according to schedule.
     * </pre>
     *
     * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder getTripOrBuilder();

    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
     */
    boolean hasVehicle();
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getVehicle();
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder getVehicleOrBuilder();

    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    java.util.List<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate> 
        getStopTimeUpdateList();
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate getStopTimeUpdate(int index);
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    int getStopTimeUpdateCount();
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    java.util.List<? extends com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder> 
        getStopTimeUpdateOrBuilderList();
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder getStopTimeUpdateOrBuilder(
        int index);

    /**
     * <pre>
     * Moment at which the vehicle's real-time progress was measured. In POSIX
     * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 4;</code>
     */
    boolean hasTimestamp();
    /**
     * <pre>
     * Moment at which the vehicle's real-time progress was measured. In POSIX
     * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 4;</code>
     */
    long getTimestamp();

    /**
     * <pre>
     * The current schedule deviation for the trip.  Delay should only be
     * specified when the prediction is given relative to some existing schedule
     * in GTFS.
     * Delay (in seconds) can be positive (meaning that the vehicle is late) or
     * negative (meaning that the vehicle is ahead of schedule). Delay of 0
     * means that the vehicle is exactly on time.
     * Delay information in StopTimeUpdates take precedent of trip-level delay
     * information, such that trip-level delay is only propagated until the next
     * stop along the trip with a StopTimeUpdate delay value specified.
     * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
     * value indicating when the delay value was last updated, in order to
     * evaluate the freshness of the data.
     * NOTE: This field is still experimental, and subject to change. It may be
     * formally adopted in the future.
     * </pre>
     *
     * <code>optional int32 delay = 5;</code>
     */
    boolean hasDelay();
    /**
     * <pre>
     * The current schedule deviation for the trip.  Delay should only be
     * specified when the prediction is given relative to some existing schedule
     * in GTFS.
     * Delay (in seconds) can be positive (meaning that the vehicle is late) or
     * negative (meaning that the vehicle is ahead of schedule). Delay of 0
     * means that the vehicle is exactly on time.
     * Delay information in StopTimeUpdates take precedent of trip-level delay
     * information, such that trip-level delay is only propagated until the next
     * stop along the trip with a StopTimeUpdate delay value specified.
     * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
     * value indicating when the delay value was last updated, in order to
     * evaluate the freshness of the data.
     * NOTE: This field is still experimental, and subject to change. It may be
     * formally adopted in the future.
     * </pre>
     *
     * <code>optional int32 delay = 5;</code>
     */
    int getDelay();

    /**
     * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
     */
    boolean hasTripProperties();
    /**
     * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties getTripProperties();
    /**
     * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder getTripPropertiesOrBuilder();
  }
  /**
   * <pre>
   * Realtime update of the progress of a vehicle along a trip.
   * Depending on the value of ScheduleRelationship, a TripUpdate can specify:
   * - A trip that proceeds along the schedule.
   * - A trip that proceeds along a route but has no fixed schedule.
   * - A trip that have been added or removed with regard to schedule.
   * The updates can be for future, predicted arrival/departure events, or for
   * past events that already occurred.
   * Normally, updates should get more precise and more certain (see
   * uncertainty below) as the events gets closer to current time.
   * Even if that is not possible, the information for past events should be
   * precise and certain. In particular, if an update points to time in the past
   * but its update's uncertainty is not 0, the client should conclude that the
   * update is a (wrong) prediction and that the trip has not completed yet.
   * Note that the update can describe a trip that is already completed.
   * To this end, it is enough to provide an update for the last stop of the trip.
   * If the time of that is in the past, the client will conclude from that that
   * the whole trip is in the past (it is possible, although inconsequential, to
   * also provide updates for preceding stops).
   * This option is most relevant for a trip that has completed ahead of schedule,
   * but according to the schedule, the trip is still proceeding at the current
   * time. Removing the updates for this trip could make the client assume
   * that the trip is still proceeding.
   * Note that the feed provider is allowed, but not required, to purge past
   * updates - this is one case where this would be practically useful.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.TripUpdate}
   */
  public  static final class TripUpdate extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        TripUpdate> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.TripUpdate)
      TripUpdateOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TripUpdate.newBuilder() to construct.
    private TripUpdate(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TripUpdate, ?> builder) {
      super(builder);
    }
    private TripUpdate() {
      stopTimeUpdate_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TripUpdate(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) != 0)) {
                subBuilder = trip_.toBuilder();
              }
              trip_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripDescriptor.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(trip_);
                trip_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000004) != 0)) {
                stopTimeUpdate_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate>();
                mutable_bitField0_ |= 0x00000004;
              }
              stopTimeUpdate_.add(
                  input.readMessage(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) != 0)) {
                subBuilder = vehicle_.toBuilder();
              }
              vehicle_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(vehicle_);
                vehicle_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000004;
              timestamp_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000008;
              delay_ = input.readInt32();
              break;
            }
            case 50: {
              com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) != 0)) {
                subBuilder = tripProperties_.toBuilder();
              }
              tripProperties_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(tripProperties_);
                tripProperties_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) != 0)) {
          stopTimeUpdate_ = java.util.Collections.unmodifiableList(stopTimeUpdate_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.TripUpdate.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder.class);
    }

    public interface StopTimeEventOrBuilder extends
        // @@protoc_insertion_point(interface_extends:transit_realtime.TripUpdate.StopTimeEvent)
        com.google.protobuf.GeneratedMessageV3.
            ExtendableMessageOrBuilder<StopTimeEvent> {

      /**
       * <pre>
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * </pre>
       *
       * <code>optional int32 delay = 1;</code>
       */
      boolean hasDelay();
      /**
       * <pre>
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * </pre>
       *
       * <code>optional int32 delay = 1;</code>
       */
      int getDelay();

      /**
       * <pre>
       * Event as absolute time.
       * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
       * UTC).
       * </pre>
       *
       * <code>optional int64 time = 2;</code>
       */
      boolean hasTime();
      /**
       * <pre>
       * Event as absolute time.
       * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
       * UTC).
       * </pre>
       *
       * <code>optional int64 time = 2;</code>
       */
      long getTime();

      /**
       * <pre>
       * If uncertainty is omitted, it is interpreted as unknown.
       * If the prediction is unknown or too uncertain, the delay (or time) field
       * should be empty. In such case, the uncertainty field is ignored.
       * To specify a completely certain prediction, set its uncertainty to 0.
       * </pre>
       *
       * <code>optional int32 uncertainty = 3;</code>
       */
      boolean hasUncertainty();
      /**
       * <pre>
       * If uncertainty is omitted, it is interpreted as unknown.
       * If the prediction is unknown or too uncertain, the delay (or time) field
       * should be empty. In such case, the uncertainty field is ignored.
       * To specify a completely certain prediction, set its uncertainty to 0.
       * </pre>
       *
       * <code>optional int32 uncertainty = 3;</code>
       */
      int getUncertainty();
    }
    /**
     * <pre>
     * Timing information for a single predicted event (either arrival or
     * departure).
     * Timing consists of delay and/or estimated time, and uncertainty.
     * - delay should be used when the prediction is given relative to some
     *   existing schedule in GTFS.
     * - time should be given whether there is a predicted schedule or not. If
     *   both time and delay are specified, time will take precedence
     *   (although normally, time, if given for a scheduled trip, should be
     *   equal to scheduled time in GTFS + delay).
     * Uncertainty applies equally to both time and delay.
     * The uncertainty roughly specifies the expected error in true delay (but
     * note, we don't yet define its precise statistical meaning). It's possible
     * for the uncertainty to be 0, for example for trains that are driven under
     * computer timing control.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.TripUpdate.StopTimeEvent}
     */
    public  static final class StopTimeEvent extends
        com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
          StopTimeEvent> implements
        // @@protoc_insertion_point(message_implements:transit_realtime.TripUpdate.StopTimeEvent)
        StopTimeEventOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use StopTimeEvent.newBuilder() to construct.
      private StopTimeEvent(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, ?> builder) {
        super(builder);
      }
      private StopTimeEvent() {
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private StopTimeEvent(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                bitField0_ |= 0x00000001;
                delay_ = input.readInt32();
                break;
              }
              case 16: {
                bitField0_ |= 0x00000002;
                time_ = input.readInt64();
                break;
              }
              case 24: {
                bitField0_ |= 0x00000004;
                uncertainty_ = input.readInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeEvent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder.class);
      }

      private int bitField0_;
      public static final int DELAY_FIELD_NUMBER = 1;
      private int delay_;
      /**
       * <pre>
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * </pre>
       *
       * <code>optional int32 delay = 1;</code>
       */
      public boolean hasDelay() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * </pre>
       *
       * <code>optional int32 delay = 1;</code>
       */
      public int getDelay() {
        return delay_;
      }

      public static final int TIME_FIELD_NUMBER = 2;
      private long time_;
      /**
       * <pre>
       * Event as absolute time.
       * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
       * UTC).
       * </pre>
       *
       * <code>optional int64 time = 2;</code>
       */
      public boolean hasTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Event as absolute time.
       * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
       * UTC).
       * </pre>
       *
       * <code>optional int64 time = 2;</code>
       */
      public long getTime() {
        return time_;
      }

      public static final int UNCERTAINTY_FIELD_NUMBER = 3;
      private int uncertainty_;
      /**
       * <pre>
       * If uncertainty is omitted, it is interpreted as unknown.
       * If the prediction is unknown or too uncertain, the delay (or time) field
       * should be empty. In such case, the uncertainty field is ignored.
       * To specify a completely certain prediction, set its uncertainty to 0.
       * </pre>
       *
       * <code>optional int32 uncertainty = 3;</code>
       */
      public boolean hasUncertainty() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * If uncertainty is omitted, it is interpreted as unknown.
       * If the prediction is unknown or too uncertain, the delay (or time) field
       * should be empty. In such case, the uncertainty field is ignored.
       * To specify a completely certain prediction, set its uncertainty to 0.
       * </pre>
       *
       * <code>optional int32 uncertainty = 3;</code>
       */
      public int getUncertainty() {
        return uncertainty_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!extensionsAreInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3
          .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent>.ExtensionWriter
            extensionWriter = newExtensionWriter();
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt32(1, delay_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeInt64(2, time_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeInt32(3, uncertainty_);
        }
        extensionWriter.writeUntil(2000, output);
        extensionWriter.writeUntil(10000, output);
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(1, delay_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt64Size(2, time_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(3, uncertainty_);
        }
        size += extensionsSerializedSize();
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent)) {
          return super.equals(obj);
        }
        com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent other = (com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent) obj;

        if (hasDelay() != other.hasDelay()) return false;
        if (hasDelay()) {
          if (getDelay()
              != other.getDelay()) return false;
        }
        if (hasTime() != other.hasTime()) return false;
        if (hasTime()) {
          if (getTime()
              != other.getTime()) return false;
        }
        if (hasUncertainty() != other.hasUncertainty()) return false;
        if (hasUncertainty()) {
          if (getUncertainty()
              != other.getUncertainty()) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        if (!getExtensionFields().equals(other.getExtensionFields()))
          return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasDelay()) {
          hash = (37 * hash) + DELAY_FIELD_NUMBER;
          hash = (53 * hash) + getDelay();
        }
        if (hasTime()) {
          hash = (37 * hash) + TIME_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getTime());
        }
        if (hasUncertainty()) {
          hash = (37 * hash) + UNCERTAINTY_FIELD_NUMBER;
          hash = (53 * hash) + getUncertainty();
        }
        hash = hashFields(hash, getExtensionFields());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Timing information for a single predicted event (either arrival or
       * departure).
       * Timing consists of delay and/or estimated time, and uncertainty.
       * - delay should be used when the prediction is given relative to some
       *   existing schedule in GTFS.
       * - time should be given whether there is a predicted schedule or not. If
       *   both time and delay are specified, time will take precedence
       *   (although normally, time, if given for a scheduled trip, should be
       *   equal to scheduled time in GTFS + delay).
       * Uncertainty applies equally to both time and delay.
       * The uncertainty roughly specifies the expected error in true delay (but
       * note, we don't yet define its precise statistical meaning). It's possible
       * for the uncertainty to be 0, for example for trains that are driven under
       * computer timing control.
       * </pre>
       *
       * Protobuf type {@code transit_realtime.TripUpdate.StopTimeEvent}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, Builder> implements
          // @@protoc_insertion_point(builder_implements:transit_realtime.TripUpdate.StopTimeEvent)
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeEvent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeEvent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder.class);
        }

        // Construct using com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          delay_ = 0;
          bitField0_ = (bitField0_ & ~0x00000001);
          time_ = 0L;
          bitField0_ = (bitField0_ & ~0x00000002);
          uncertainty_ = 0;
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeEvent_descriptor;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getDefaultInstanceForType() {
          return com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent build() {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent buildPartial() {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent result = new com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.delay_ = delay_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.time_ = time_;
            to_bitField0_ |= 0x00000002;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.uncertainty_ = uncertainty_;
            to_bitField0_ |= 0x00000004;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, Type> extension,
            Type value) {
          return super.setExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, java.util.List<Type>> extension,
            int index, Type value) {
          return super.setExtension(extension, index, value);
        }
        @java.lang.Override
        public <Type> Builder addExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, java.util.List<Type>> extension,
            Type value) {
          return super.addExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder clearExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, ?> extension) {
          return super.clearExtension(extension);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent) {
            return mergeFrom((com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent other) {
          if (other == com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance()) return this;
          if (other.hasDelay()) {
            setDelay(other.getDelay());
          }
          if (other.hasTime()) {
            setTime(other.getTime());
          }
          if (other.hasUncertainty()) {
            setUncertainty(other.getUncertainty());
          }
          this.mergeExtensionFields(other);
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!extensionsAreInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private int delay_ ;
        /**
         * <pre>
         * Delay (in seconds) can be positive (meaning that the vehicle is late) or
         * negative (meaning that the vehicle is ahead of schedule). Delay of 0
         * means that the vehicle is exactly on time.
         * </pre>
         *
         * <code>optional int32 delay = 1;</code>
         */
        public boolean hasDelay() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Delay (in seconds) can be positive (meaning that the vehicle is late) or
         * negative (meaning that the vehicle is ahead of schedule). Delay of 0
         * means that the vehicle is exactly on time.
         * </pre>
         *
         * <code>optional int32 delay = 1;</code>
         */
        public int getDelay() {
          return delay_;
        }
        /**
         * <pre>
         * Delay (in seconds) can be positive (meaning that the vehicle is late) or
         * negative (meaning that the vehicle is ahead of schedule). Delay of 0
         * means that the vehicle is exactly on time.
         * </pre>
         *
         * <code>optional int32 delay = 1;</code>
         */
        public Builder setDelay(int value) {
          bitField0_ |= 0x00000001;
          delay_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Delay (in seconds) can be positive (meaning that the vehicle is late) or
         * negative (meaning that the vehicle is ahead of schedule). Delay of 0
         * means that the vehicle is exactly on time.
         * </pre>
         *
         * <code>optional int32 delay = 1;</code>
         */
        public Builder clearDelay() {
          bitField0_ = (bitField0_ & ~0x00000001);
          delay_ = 0;
          onChanged();
          return this;
        }

        private long time_ ;
        /**
         * <pre>
         * Event as absolute time.
         * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
         * UTC).
         * </pre>
         *
         * <code>optional int64 time = 2;</code>
         */
        public boolean hasTime() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Event as absolute time.
         * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
         * UTC).
         * </pre>
         *
         * <code>optional int64 time = 2;</code>
         */
        public long getTime() {
          return time_;
        }
        /**
         * <pre>
         * Event as absolute time.
         * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
         * UTC).
         * </pre>
         *
         * <code>optional int64 time = 2;</code>
         */
        public Builder setTime(long value) {
          bitField0_ |= 0x00000002;
          time_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Event as absolute time.
         * In Unix time (i.e., number of seconds since January 1st 1970 00:00:00
         * UTC).
         * </pre>
         *
         * <code>optional int64 time = 2;</code>
         */
        public Builder clearTime() {
          bitField0_ = (bitField0_ & ~0x00000002);
          time_ = 0L;
          onChanged();
          return this;
        }

        private int uncertainty_ ;
        /**
         * <pre>
         * If uncertainty is omitted, it is interpreted as unknown.
         * If the prediction is unknown or too uncertain, the delay (or time) field
         * should be empty. In such case, the uncertainty field is ignored.
         * To specify a completely certain prediction, set its uncertainty to 0.
         * </pre>
         *
         * <code>optional int32 uncertainty = 3;</code>
         */
        public boolean hasUncertainty() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * If uncertainty is omitted, it is interpreted as unknown.
         * If the prediction is unknown or too uncertain, the delay (or time) field
         * should be empty. In such case, the uncertainty field is ignored.
         * To specify a completely certain prediction, set its uncertainty to 0.
         * </pre>
         *
         * <code>optional int32 uncertainty = 3;</code>
         */
        public int getUncertainty() {
          return uncertainty_;
        }
        /**
         * <pre>
         * If uncertainty is omitted, it is interpreted as unknown.
         * If the prediction is unknown or too uncertain, the delay (or time) field
         * should be empty. In such case, the uncertainty field is ignored.
         * To specify a completely certain prediction, set its uncertainty to 0.
         * </pre>
         *
         * <code>optional int32 uncertainty = 3;</code>
         */
        public Builder setUncertainty(int value) {
          bitField0_ |= 0x00000004;
          uncertainty_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * If uncertainty is omitted, it is interpreted as unknown.
         * If the prediction is unknown or too uncertain, the delay (or time) field
         * should be empty. In such case, the uncertainty field is ignored.
         * To specify a completely certain prediction, set its uncertainty to 0.
         * </pre>
         *
         * <code>optional int32 uncertainty = 3;</code>
         */
        public Builder clearUncertainty() {
          bitField0_ = (bitField0_ & ~0x00000004);
          uncertainty_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:transit_realtime.TripUpdate.StopTimeEvent)
      }

      // @@protoc_insertion_point(class_scope:transit_realtime.TripUpdate.StopTimeEvent)
      private static final com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent();
      }

      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<StopTimeEvent>
          PARSER = new com.google.protobuf.AbstractParser<StopTimeEvent>() {
        @java.lang.Override
        public StopTimeEvent parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StopTimeEvent(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<StopTimeEvent> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<StopTimeEvent> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface StopTimeUpdateOrBuilder extends
        // @@protoc_insertion_point(interface_extends:transit_realtime.TripUpdate.StopTimeUpdate)
        com.google.protobuf.GeneratedMessageV3.
            ExtendableMessageOrBuilder<StopTimeUpdate> {

      /**
       * <pre>
       * Must be the same as in stop_times.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional uint32 stop_sequence = 1;</code>
       */
      boolean hasStopSequence();
      /**
       * <pre>
       * Must be the same as in stop_times.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional uint32 stop_sequence = 1;</code>
       */
      int getStopSequence();

      /**
       * <pre>
       * Must be the same as in stops.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 4;</code>
       */
      boolean hasStopId();
      /**
       * <pre>
       * Must be the same as in stops.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 4;</code>
       */
      java.lang.String getStopId();
      /**
       * <pre>
       * Must be the same as in stops.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 4;</code>
       */
      com.google.protobuf.ByteString
          getStopIdBytes();

      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
       */
      boolean hasArrival();
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getArrival();
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder getArrivalOrBuilder();

      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
       */
      boolean hasDeparture();
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getDeparture();
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder getDepartureOrBuilder();

      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
       */
      boolean hasScheduleRelationship();
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship getScheduleRelationship();

      /**
       * <pre>
       * Realtime updates for certain properties defined within GTFS stop_times.txt
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
       */
      boolean hasStopTimeProperties();
      /**
       * <pre>
       * Realtime updates for certain properties defined within GTFS stop_times.txt
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties getStopTimeProperties();
      /**
       * <pre>
       * Realtime updates for certain properties defined within GTFS stop_times.txt
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
       */
      com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder getStopTimePropertiesOrBuilder();
    }
    /**
     * <pre>
     * Realtime update for arrival and/or departure events for a given stop on a
     * trip. Updates can be supplied for both past and future events.
     * The producer is allowed, although not required, to drop past events.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.TripUpdate.StopTimeUpdate}
     */
    public  static final class StopTimeUpdate extends
        com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
          StopTimeUpdate> implements
        // @@protoc_insertion_point(message_implements:transit_realtime.TripUpdate.StopTimeUpdate)
        StopTimeUpdateOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use StopTimeUpdate.newBuilder() to construct.
      private StopTimeUpdate(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, ?> builder) {
        super(builder);
      }
      private StopTimeUpdate() {
        stopId_ = "";
        scheduleRelationship_ = 0;
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private StopTimeUpdate(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                bitField0_ |= 0x00000001;
                stopSequence_ = input.readUInt32();
                break;
              }
              case 18: {
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) != 0)) {
                  subBuilder = arrival_.toBuilder();
                }
                arrival_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(arrival_);
                  arrival_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
              case 26: {
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder subBuilder = null;
                if (((bitField0_ & 0x00000008) != 0)) {
                  subBuilder = departure_.toBuilder();
                }
                departure_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(departure_);
                  departure_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000008;
                break;
              }
              case 34: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                stopId_ = bs;
                break;
              }
              case 40: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship value = com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(5, rawValue);
                } else {
                  bitField0_ |= 0x00000010;
                  scheduleRelationship_ = rawValue;
                }
                break;
              }
              case 50: {
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder subBuilder = null;
                if (((bitField0_ & 0x00000020) != 0)) {
                  subBuilder = stopTimeProperties_.toBuilder();
                }
                stopTimeProperties_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(stopTimeProperties_);
                  stopTimeProperties_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000020;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder.class);
      }

      /**
       * <pre>
       * The relation between this StopTime and the static schedule.
       * </pre>
       *
       * Protobuf enum {@code transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship}
       */
      public enum ScheduleRelationship
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <pre>
         * The vehicle is proceeding in accordance with its static schedule of
         * stops, although not necessarily according to the times of the schedule.
         * At least one of arrival and departure must be provided. If the schedule
         * for this stop contains both arrival and departure times then so must
         * this update. Frequency-based trips (GTFS frequencies.txt with exact_times = 0)
         * should not have a SCHEDULED value and should use UNSCHEDULED instead.
         * </pre>
         *
         * <code>SCHEDULED = 0;</code>
         */
        SCHEDULED(0),
        /**
         * <pre>
         * The stop is skipped, i.e., the vehicle will not stop at this stop.
         * Arrival and departure are optional.
         * </pre>
         *
         * <code>SKIPPED = 1;</code>
         */
        SKIPPED(1),
        /**
         * <pre>
         * No data is given for this stop. The main intention for this value is to
         * give the predictions only for part of a trip, i.e., if the last update
         * for a trip has a NO_DATA specifier, then StopTimes for the rest of the
         * stops in the trip are considered to be unspecified as well.
         * Neither arrival nor departure should be supplied.
         * </pre>
         *
         * <code>NO_DATA = 2;</code>
         */
        NO_DATA(2),
        /**
         * <pre>
         * The vehicle is operating a trip defined in GTFS frequencies.txt with exact_times = 0.
         * This value should not be used for trips that are not defined in GTFS frequencies.txt,
         * or trips in GTFS frequencies.txt with exact_times = 1. Trips containing StopTimeUpdates
         * with ScheduleRelationship=UNSCHEDULED must also set TripDescriptor.ScheduleRelationship=UNSCHEDULED.
         * NOTE: This field is still experimental, and subject to change. It may be
         * formally adopted in the future.
         * </pre>
         *
         * <code>UNSCHEDULED = 3;</code>
         */
        UNSCHEDULED(3),
        ;

        /**
         * <pre>
         * The vehicle is proceeding in accordance with its static schedule of
         * stops, although not necessarily according to the times of the schedule.
         * At least one of arrival and departure must be provided. If the schedule
         * for this stop contains both arrival and departure times then so must
         * this update. Frequency-based trips (GTFS frequencies.txt with exact_times = 0)
         * should not have a SCHEDULED value and should use UNSCHEDULED instead.
         * </pre>
         *
         * <code>SCHEDULED = 0;</code>
         */
        public static final int SCHEDULED_VALUE = 0;
        /**
         * <pre>
         * The stop is skipped, i.e., the vehicle will not stop at this stop.
         * Arrival and departure are optional.
         * </pre>
         *
         * <code>SKIPPED = 1;</code>
         */
        public static final int SKIPPED_VALUE = 1;
        /**
         * <pre>
         * No data is given for this stop. The main intention for this value is to
         * give the predictions only for part of a trip, i.e., if the last update
         * for a trip has a NO_DATA specifier, then StopTimes for the rest of the
         * stops in the trip are considered to be unspecified as well.
         * Neither arrival nor departure should be supplied.
         * </pre>
         *
         * <code>NO_DATA = 2;</code>
         */
        public static final int NO_DATA_VALUE = 2;
        /**
         * <pre>
         * The vehicle is operating a trip defined in GTFS frequencies.txt with exact_times = 0.
         * This value should not be used for trips that are not defined in GTFS frequencies.txt,
         * or trips in GTFS frequencies.txt with exact_times = 1. Trips containing StopTimeUpdates
         * with ScheduleRelationship=UNSCHEDULED must also set TripDescriptor.ScheduleRelationship=UNSCHEDULED.
         * NOTE: This field is still experimental, and subject to change. It may be
         * formally adopted in the future.
         * </pre>
         *
         * <code>UNSCHEDULED = 3;</code>
         */
        public static final int UNSCHEDULED_VALUE = 3;


        public final int getNumber() {
          return value;
        }

        /**
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ScheduleRelationship valueOf(int value) {
          return forNumber(value);
        }

        public static ScheduleRelationship forNumber(int value) {
          switch (value) {
            case 0: return SCHEDULED;
            case 1: return SKIPPED;
            case 2: return NO_DATA;
            case 3: return UNSCHEDULED;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<ScheduleRelationship>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            ScheduleRelationship> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ScheduleRelationship>() {
                public ScheduleRelationship findValueByNumber(int number) {
                  return ScheduleRelationship.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.getDescriptor().getEnumTypes().get(0);
        }

        private static final ScheduleRelationship[] VALUES = values();

        public static ScheduleRelationship valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private ScheduleRelationship(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship)
      }

      public interface StopTimePropertiesOrBuilder extends
          // @@protoc_insertion_point(interface_extends:transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties)
          com.google.protobuf.GeneratedMessageV3.
              ExtendableMessageOrBuilder<StopTimeProperties> {

        /**
         * <pre>
         * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
         * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
         * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
         * "unusual change" if the new stop was presented within an app without any additional context.
         * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
         * same station as the stop originally defined in GTFS stop_times.txt.
         * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
         * StopTimeUpdate.schedule_relationship = NO_DATA.
         * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
         * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
         * Platform assignments should be reflected in other GTFS-realtime fields as well
         * (e.g., `VehiclePosition.stop_id`).
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string assigned_stop_id = 1;</code>
         */
        boolean hasAssignedStopId();
        /**
         * <pre>
         * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
         * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
         * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
         * "unusual change" if the new stop was presented within an app without any additional context.
         * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
         * same station as the stop originally defined in GTFS stop_times.txt.
         * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
         * StopTimeUpdate.schedule_relationship = NO_DATA.
         * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
         * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
         * Platform assignments should be reflected in other GTFS-realtime fields as well
         * (e.g., `VehiclePosition.stop_id`).
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string assigned_stop_id = 1;</code>
         */
        java.lang.String getAssignedStopId();
        /**
         * <pre>
         * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
         * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
         * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
         * "unusual change" if the new stop was presented within an app without any additional context.
         * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
         * same station as the stop originally defined in GTFS stop_times.txt.
         * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
         * StopTimeUpdate.schedule_relationship = NO_DATA.
         * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
         * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
         * Platform assignments should be reflected in other GTFS-realtime fields as well
         * (e.g., `VehiclePosition.stop_id`).
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string assigned_stop_id = 1;</code>
         */
        com.google.protobuf.ByteString
            getAssignedStopIdBytes();
      }
      /**
       * <pre>
       * Provides the updated values for the stop time.
       * NOTE: This message is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * Protobuf type {@code transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties}
       */
      public  static final class StopTimeProperties extends
          com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
            StopTimeProperties> implements
          // @@protoc_insertion_point(message_implements:transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties)
          StopTimePropertiesOrBuilder {
      private static final long serialVersionUID = 0L;
        // Use StopTimeProperties.newBuilder() to construct.
        private StopTimeProperties(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, ?> builder) {
          super(builder);
        }
        private StopTimeProperties() {
          assignedStopId_ = "";
        }

        @java.lang.Override
        public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
          return this.unknownFields;
        }
        private StopTimeProperties(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          this();
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          int mutable_bitField0_ = 0;
          com.google.protobuf.UnknownFieldSet.Builder unknownFields =
              com.google.protobuf.UnknownFieldSet.newBuilder();
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  com.google.protobuf.ByteString bs = input.readBytes();
                  bitField0_ |= 0x00000001;
                  assignedStopId_ = bs;
                  break;
                }
                default: {
                  if (!parseUnknownField(
                      input, unknownFields, extensionRegistry, tag)) {
                    done = true;
                  }
                  break;
                }
              }
            }
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(this);
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(
                e).setUnfinishedMessage(this);
          } finally {
            this.unknownFields = unknownFields.build();
            makeExtensionsImmutable();
          }
        }
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_StopTimeProperties_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_StopTimeProperties_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder.class);
        }

        private int bitField0_;
        public static final int ASSIGNED_STOP_ID_FIELD_NUMBER = 1;
        private volatile java.lang.Object assignedStopId_;
        /**
         * <pre>
         * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
         * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
         * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
         * "unusual change" if the new stop was presented within an app without any additional context.
         * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
         * same station as the stop originally defined in GTFS stop_times.txt.
         * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
         * StopTimeUpdate.schedule_relationship = NO_DATA.
         * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
         * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
         * Platform assignments should be reflected in other GTFS-realtime fields as well
         * (e.g., `VehiclePosition.stop_id`).
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string assigned_stop_id = 1;</code>
         */
        public boolean hasAssignedStopId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
         * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
         * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
         * "unusual change" if the new stop was presented within an app without any additional context.
         * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
         * same station as the stop originally defined in GTFS stop_times.txt.
         * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
         * StopTimeUpdate.schedule_relationship = NO_DATA.
         * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
         * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
         * Platform assignments should be reflected in other GTFS-realtime fields as well
         * (e.g., `VehiclePosition.stop_id`).
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string assigned_stop_id = 1;</code>
         */
        public java.lang.String getAssignedStopId() {
          java.lang.Object ref = assignedStopId_;
          if (ref instanceof java.lang.String) {
            return (java.lang.String) ref;
          } else {
            com.google.protobuf.ByteString bs = 
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              assignedStopId_ = s;
            }
            return s;
          }
        }
        /**
         * <pre>
         * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
         * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
         * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
         * "unusual change" if the new stop was presented within an app without any additional context.
         * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
         * same station as the stop originally defined in GTFS stop_times.txt.
         * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
         * StopTimeUpdate.schedule_relationship = NO_DATA.
         * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
         * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
         * Platform assignments should be reflected in other GTFS-realtime fields as well
         * (e.g., `VehiclePosition.stop_id`).
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string assigned_stop_id = 1;</code>
         */
        public com.google.protobuf.ByteString
            getAssignedStopIdBytes() {
          java.lang.Object ref = assignedStopId_;
          if (ref instanceof java.lang.String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            assignedStopId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        private byte memoizedIsInitialized = -1;
        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          if (!extensionsAreInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
                            throws java.io.IOException {
          com.google.protobuf.GeneratedMessageV3
            .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties>.ExtensionWriter
              extensionWriter = newExtensionWriter();
          if (((bitField0_ & 0x00000001) != 0)) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, assignedStopId_);
          }
          extensionWriter.writeUntil(2000, output);
          extensionWriter.writeUntil(10000, output);
          unknownFields.writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          if (((bitField0_ & 0x00000001) != 0)) {
            size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, assignedStopId_);
          }
          size += extensionsSerializedSize();
          size += unknownFields.getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
           return true;
          }
          if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties)) {
            return super.equals(obj);
          }
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties other = (com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties) obj;

          if (hasAssignedStopId() != other.hasAssignedStopId()) return false;
          if (hasAssignedStopId()) {
            if (!getAssignedStopId()
                .equals(other.getAssignedStopId())) return false;
          }
          if (!unknownFields.equals(other.unknownFields)) return false;
          if (!getExtensionFields().equals(other.getExtensionFields()))
            return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (hasAssignedStopId()) {
            hash = (37 * hash) + ASSIGNED_STOP_ID_FIELD_NUMBER;
            hash = (53 * hash) + getAssignedStopId().hashCode();
          }
          hash = hashFields(hash, getExtensionFields());
          hash = (29 * hash) + unknownFields.hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            java.nio.ByteBuffer data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(byte[] data)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            byte[] data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseDelimitedFrom(java.io.InputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseDelimitedFrom(
            java.io.InputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            com.google.protobuf.CodedInputStream input)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input);
        }
        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3
              .parseWithIOException(PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() { return newBuilder(); }
        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }
        public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }
        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE
              ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         * <pre>
         * Provides the updated values for the stop time.
         * NOTE: This message is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * Protobuf type {@code transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties}
         */
        public static final class Builder extends
            com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
              com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, Builder> implements
            // @@protoc_insertion_point(builder_implements:transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties)
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor
              getDescriptor() {
            return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_StopTimeProperties_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_StopTimeProperties_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder.class);
          }

          // Construct using com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.newBuilder()
          private Builder() {
            maybeForceBuilderInitialization();
          }

          private Builder(
              com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            maybeForceBuilderInitialization();
          }
          private void maybeForceBuilderInitialization() {
            if (com.google.protobuf.GeneratedMessageV3
                    .alwaysUseFieldBuilders) {
            }
          }
          @java.lang.Override
          public Builder clear() {
            super.clear();
            assignedStopId_ = "";
            bitField0_ = (bitField0_ & ~0x00000001);
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor
              getDescriptorForType() {
            return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_StopTimeProperties_descriptor;
          }

          @java.lang.Override
          public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties getDefaultInstanceForType() {
            return com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties build() {
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties buildPartial() {
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties result = new com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties(this);
            int from_bitField0_ = bitField0_;
            int to_bitField0_ = 0;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              to_bitField0_ |= 0x00000001;
            }
            result.assignedStopId_ = assignedStopId_;
            result.bitField0_ = to_bitField0_;
            onBuilt();
            return result;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }
          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.setField(field, value);
          }
          @java.lang.Override
          public Builder clearField(
              com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }
          @java.lang.Override
          public Builder clearOneof(
              com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }
          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index, java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }
          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }
          @java.lang.Override
          public <Type> Builder setExtension(
              com.google.protobuf.GeneratedMessage.GeneratedExtension<
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, Type> extension,
              Type value) {
            return super.setExtension(extension, value);
          }
          @java.lang.Override
          public <Type> Builder setExtension(
              com.google.protobuf.GeneratedMessage.GeneratedExtension<
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, java.util.List<Type>> extension,
              int index, Type value) {
            return super.setExtension(extension, index, value);
          }
          @java.lang.Override
          public <Type> Builder addExtension(
              com.google.protobuf.GeneratedMessage.GeneratedExtension<
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, java.util.List<Type>> extension,
              Type value) {
            return super.addExtension(extension, value);
          }
          @java.lang.Override
          public <Type> Builder clearExtension(
              com.google.protobuf.GeneratedMessage.GeneratedExtension<
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, ?> extension) {
            return super.clearExtension(extension);
          }
          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties) {
              return mergeFrom((com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties)other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties other) {
            if (other == com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance()) return this;
            if (other.hasAssignedStopId()) {
              bitField0_ |= 0x00000001;
              assignedStopId_ = other.assignedStopId_;
              onChanged();
            }
            this.mergeExtensionFields(other);
            this.mergeUnknownFields(other.unknownFields);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            if (!extensionsAreInitialized()) {
              return false;
            }
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties parsedMessage = null;
            try {
              parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              parsedMessage = (com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties) e.getUnfinishedMessage();
              throw e.unwrapIOException();
            } finally {
              if (parsedMessage != null) {
                mergeFrom(parsedMessage);
              }
            }
            return this;
          }
          private int bitField0_;

          private java.lang.Object assignedStopId_ = "";
          /**
           * <pre>
           * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
           * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
           * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
           * "unusual change" if the new stop was presented within an app without any additional context.
           * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
           * same station as the stop originally defined in GTFS stop_times.txt.
           * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
           * StopTimeUpdate.schedule_relationship = NO_DATA.
           * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
           * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
           * Platform assignments should be reflected in other GTFS-realtime fields as well
           * (e.g., `VehiclePosition.stop_id`).
           * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
           * </pre>
           *
           * <code>optional string assigned_stop_id = 1;</code>
           */
          public boolean hasAssignedStopId() {
            return ((bitField0_ & 0x00000001) != 0);
          }
          /**
           * <pre>
           * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
           * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
           * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
           * "unusual change" if the new stop was presented within an app without any additional context.
           * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
           * same station as the stop originally defined in GTFS stop_times.txt.
           * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
           * StopTimeUpdate.schedule_relationship = NO_DATA.
           * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
           * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
           * Platform assignments should be reflected in other GTFS-realtime fields as well
           * (e.g., `VehiclePosition.stop_id`).
           * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
           * </pre>
           *
           * <code>optional string assigned_stop_id = 1;</code>
           */
          public java.lang.String getAssignedStopId() {
            java.lang.Object ref = assignedStopId_;
            if (!(ref instanceof java.lang.String)) {
              com.google.protobuf.ByteString bs =
                  (com.google.protobuf.ByteString) ref;
              java.lang.String s = bs.toStringUtf8();
              if (bs.isValidUtf8()) {
                assignedStopId_ = s;
              }
              return s;
            } else {
              return (java.lang.String) ref;
            }
          }
          /**
           * <pre>
           * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
           * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
           * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
           * "unusual change" if the new stop was presented within an app without any additional context.
           * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
           * same station as the stop originally defined in GTFS stop_times.txt.
           * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
           * StopTimeUpdate.schedule_relationship = NO_DATA.
           * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
           * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
           * Platform assignments should be reflected in other GTFS-realtime fields as well
           * (e.g., `VehiclePosition.stop_id`).
           * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
           * </pre>
           *
           * <code>optional string assigned_stop_id = 1;</code>
           */
          public com.google.protobuf.ByteString
              getAssignedStopIdBytes() {
            java.lang.Object ref = assignedStopId_;
            if (ref instanceof String) {
              com.google.protobuf.ByteString b = 
                  com.google.protobuf.ByteString.copyFromUtf8(
                      (java.lang.String) ref);
              assignedStopId_ = b;
              return b;
            } else {
              return (com.google.protobuf.ByteString) ref;
            }
          }
          /**
           * <pre>
           * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
           * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
           * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
           * "unusual change" if the new stop was presented within an app without any additional context.
           * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
           * same station as the stop originally defined in GTFS stop_times.txt.
           * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
           * StopTimeUpdate.schedule_relationship = NO_DATA.
           * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
           * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
           * Platform assignments should be reflected in other GTFS-realtime fields as well
           * (e.g., `VehiclePosition.stop_id`).
           * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
           * </pre>
           *
           * <code>optional string assigned_stop_id = 1;</code>
           */
          public Builder setAssignedStopId(
              java.lang.String value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            assignedStopId_ = value;
            onChanged();
            return this;
          }
          /**
           * <pre>
           * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
           * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
           * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
           * "unusual change" if the new stop was presented within an app without any additional context.
           * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
           * same station as the stop originally defined in GTFS stop_times.txt.
           * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
           * StopTimeUpdate.schedule_relationship = NO_DATA.
           * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
           * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
           * Platform assignments should be reflected in other GTFS-realtime fields as well
           * (e.g., `VehiclePosition.stop_id`).
           * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
           * </pre>
           *
           * <code>optional string assigned_stop_id = 1;</code>
           */
          public Builder clearAssignedStopId() {
            bitField0_ = (bitField0_ & ~0x00000001);
            assignedStopId_ = getDefaultInstance().getAssignedStopId();
            onChanged();
            return this;
          }
          /**
           * <pre>
           * Supports real-time stop assignments. Refers to a stop_id defined in the GTFS stops.txt.
           * The new assigned_stop_id should not result in a significantly different trip experience for the end user than
           * the stop_id defined in GTFS stop_times.txt. In other words, the end user should not view this new stop_id as an
           * "unusual change" if the new stop was presented within an app without any additional context.
           * For example, this field is intended to be used for platform assignments by using a stop_id that belongs to the
           * same station as the stop originally defined in GTFS stop_times.txt.
           * To assign a stop without providing any real-time arrival or departure predictions, populate this field and set
           * StopTimeUpdate.schedule_relationship = NO_DATA.
           * If this field is populated, it is preferred to omit `StopTimeUpdate.stop_id` and use only `StopTimeUpdate.stop_sequence`. If
           * `StopTimeProperties.assigned_stop_id` and `StopTimeUpdate.stop_id` are populated, `StopTimeUpdate.stop_id` must match `assigned_stop_id`.
           * Platform assignments should be reflected in other GTFS-realtime fields as well
           * (e.g., `VehiclePosition.stop_id`).
           * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
           * </pre>
           *
           * <code>optional string assigned_stop_id = 1;</code>
           */
          public Builder setAssignedStopIdBytes(
              com.google.protobuf.ByteString value) {
            if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
            assignedStopId_ = value;
            onChanged();
            return this;
          }
          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }


          // @@protoc_insertion_point(builder_scope:transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties)
        }

        // @@protoc_insertion_point(class_scope:transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties)
        private static final com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties DEFAULT_INSTANCE;
        static {
          DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties();
        }

        public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        @java.lang.Deprecated public static final com.google.protobuf.Parser<StopTimeProperties>
            PARSER = new com.google.protobuf.AbstractParser<StopTimeProperties>() {
          @java.lang.Override
          public StopTimeProperties parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new StopTimeProperties(input, extensionRegistry);
          }
        };

        public static com.google.protobuf.Parser<StopTimeProperties> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<StopTimeProperties> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }

      }

      private int bitField0_;
      public static final int STOP_SEQUENCE_FIELD_NUMBER = 1;
      private int stopSequence_;
      /**
       * <pre>
       * Must be the same as in stop_times.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional uint32 stop_sequence = 1;</code>
       */
      public boolean hasStopSequence() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Must be the same as in stop_times.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional uint32 stop_sequence = 1;</code>
       */
      public int getStopSequence() {
        return stopSequence_;
      }

      public static final int STOP_ID_FIELD_NUMBER = 4;
      private volatile java.lang.Object stopId_;
      /**
       * <pre>
       * Must be the same as in stops.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 4;</code>
       */
      public boolean hasStopId() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Must be the same as in stops.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 4;</code>
       */
      public java.lang.String getStopId() {
        java.lang.Object ref = stopId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stopId_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Must be the same as in stops.txt in the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 4;</code>
       */
      public com.google.protobuf.ByteString
          getStopIdBytes() {
        java.lang.Object ref = stopId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stopId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ARRIVAL_FIELD_NUMBER = 2;
      private com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent arrival_;
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
       */
      public boolean hasArrival() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getArrival() {
        return arrival_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : arrival_;
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder getArrivalOrBuilder() {
        return arrival_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : arrival_;
      }

      public static final int DEPARTURE_FIELD_NUMBER = 3;
      private com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent departure_;
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
       */
      public boolean hasDeparture() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getDeparture() {
        return departure_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : departure_;
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder getDepartureOrBuilder() {
        return departure_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : departure_;
      }

      public static final int SCHEDULE_RELATIONSHIP_FIELD_NUMBER = 5;
      private int scheduleRelationship_;
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
       */
      public boolean hasScheduleRelationship() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship getScheduleRelationship() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship result = com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.valueOf(scheduleRelationship_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SCHEDULED : result;
      }

      public static final int STOP_TIME_PROPERTIES_FIELD_NUMBER = 6;
      private com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties stopTimeProperties_;
      /**
       * <pre>
       * Realtime updates for certain properties defined within GTFS stop_times.txt
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
       */
      public boolean hasStopTimeProperties() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * Realtime updates for certain properties defined within GTFS stop_times.txt
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties getStopTimeProperties() {
        return stopTimeProperties_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance() : stopTimeProperties_;
      }
      /**
       * <pre>
       * Realtime updates for certain properties defined within GTFS stop_times.txt
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder getStopTimePropertiesOrBuilder() {
        return stopTimeProperties_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance() : stopTimeProperties_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (hasArrival()) {
          if (!getArrival().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasDeparture()) {
          if (!getDeparture().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (hasStopTimeProperties()) {
          if (!getStopTimeProperties().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        if (!extensionsAreInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3
          .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate>.ExtensionWriter
            extensionWriter = newExtensionWriter();
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeUInt32(1, stopSequence_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeMessage(2, getArrival());
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeMessage(3, getDeparture());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, stopId_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeEnum(5, scheduleRelationship_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          output.writeMessage(6, getStopTimeProperties());
        }
        extensionWriter.writeUntil(2000, output);
        extensionWriter.writeUntil(10000, output);
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(1, stopSequence_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getArrival());
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(3, getDeparture());
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, stopId_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(5, scheduleRelationship_);
        }
        if (((bitField0_ & 0x00000020) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(6, getStopTimeProperties());
        }
        size += extensionsSerializedSize();
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate)) {
          return super.equals(obj);
        }
        com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate other = (com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate) obj;

        if (hasStopSequence() != other.hasStopSequence()) return false;
        if (hasStopSequence()) {
          if (getStopSequence()
              != other.getStopSequence()) return false;
        }
        if (hasStopId() != other.hasStopId()) return false;
        if (hasStopId()) {
          if (!getStopId()
              .equals(other.getStopId())) return false;
        }
        if (hasArrival() != other.hasArrival()) return false;
        if (hasArrival()) {
          if (!getArrival()
              .equals(other.getArrival())) return false;
        }
        if (hasDeparture() != other.hasDeparture()) return false;
        if (hasDeparture()) {
          if (!getDeparture()
              .equals(other.getDeparture())) return false;
        }
        if (hasScheduleRelationship() != other.hasScheduleRelationship()) return false;
        if (hasScheduleRelationship()) {
          if (scheduleRelationship_ != other.scheduleRelationship_) return false;
        }
        if (hasStopTimeProperties() != other.hasStopTimeProperties()) return false;
        if (hasStopTimeProperties()) {
          if (!getStopTimeProperties()
              .equals(other.getStopTimeProperties())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        if (!getExtensionFields().equals(other.getExtensionFields()))
          return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasStopSequence()) {
          hash = (37 * hash) + STOP_SEQUENCE_FIELD_NUMBER;
          hash = (53 * hash) + getStopSequence();
        }
        if (hasStopId()) {
          hash = (37 * hash) + STOP_ID_FIELD_NUMBER;
          hash = (53 * hash) + getStopId().hashCode();
        }
        if (hasArrival()) {
          hash = (37 * hash) + ARRIVAL_FIELD_NUMBER;
          hash = (53 * hash) + getArrival().hashCode();
        }
        if (hasDeparture()) {
          hash = (37 * hash) + DEPARTURE_FIELD_NUMBER;
          hash = (53 * hash) + getDeparture().hashCode();
        }
        if (hasScheduleRelationship()) {
          hash = (37 * hash) + SCHEDULE_RELATIONSHIP_FIELD_NUMBER;
          hash = (53 * hash) + scheduleRelationship_;
        }
        if (hasStopTimeProperties()) {
          hash = (37 * hash) + STOP_TIME_PROPERTIES_FIELD_NUMBER;
          hash = (53 * hash) + getStopTimeProperties().hashCode();
        }
        hash = hashFields(hash, getExtensionFields());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Realtime update for arrival and/or departure events for a given stop on a
       * trip. Updates can be supplied for both past and future events.
       * The producer is allowed, although not required, to drop past events.
       * </pre>
       *
       * Protobuf type {@code transit_realtime.TripUpdate.StopTimeUpdate}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, Builder> implements
          // @@protoc_insertion_point(builder_implements:transit_realtime.TripUpdate.StopTimeUpdate)
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder.class);
        }

        // Construct using com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
            getArrivalFieldBuilder();
            getDepartureFieldBuilder();
            getStopTimePropertiesFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          stopSequence_ = 0;
          bitField0_ = (bitField0_ & ~0x00000001);
          stopId_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          if (arrivalBuilder_ == null) {
            arrival_ = null;
          } else {
            arrivalBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          if (departureBuilder_ == null) {
            departure_ = null;
          } else {
            departureBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          scheduleRelationship_ = 0;
          bitField0_ = (bitField0_ & ~0x00000010);
          if (stopTimePropertiesBuilder_ == null) {
            stopTimeProperties_ = null;
          } else {
            stopTimePropertiesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000020);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_StopTimeUpdate_descriptor;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate getDefaultInstanceForType() {
          return com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate build() {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate buildPartial() {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate result = new com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.stopSequence_ = stopSequence_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.stopId_ = stopId_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            if (arrivalBuilder_ == null) {
              result.arrival_ = arrival_;
            } else {
              result.arrival_ = arrivalBuilder_.build();
            }
            to_bitField0_ |= 0x00000004;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            if (departureBuilder_ == null) {
              result.departure_ = departure_;
            } else {
              result.departure_ = departureBuilder_.build();
            }
            to_bitField0_ |= 0x00000008;
          }
          if (((from_bitField0_ & 0x00000010) != 0)) {
            to_bitField0_ |= 0x00000010;
          }
          result.scheduleRelationship_ = scheduleRelationship_;
          if (((from_bitField0_ & 0x00000020) != 0)) {
            if (stopTimePropertiesBuilder_ == null) {
              result.stopTimeProperties_ = stopTimeProperties_;
            } else {
              result.stopTimeProperties_ = stopTimePropertiesBuilder_.build();
            }
            to_bitField0_ |= 0x00000020;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, Type> extension,
            Type value) {
          return super.setExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, java.util.List<Type>> extension,
            int index, Type value) {
          return super.setExtension(extension, index, value);
        }
        @java.lang.Override
        public <Type> Builder addExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, java.util.List<Type>> extension,
            Type value) {
          return super.addExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder clearExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, ?> extension) {
          return super.clearExtension(extension);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate) {
            return mergeFrom((com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate other) {
          if (other == com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.getDefaultInstance()) return this;
          if (other.hasStopSequence()) {
            setStopSequence(other.getStopSequence());
          }
          if (other.hasStopId()) {
            bitField0_ |= 0x00000002;
            stopId_ = other.stopId_;
            onChanged();
          }
          if (other.hasArrival()) {
            mergeArrival(other.getArrival());
          }
          if (other.hasDeparture()) {
            mergeDeparture(other.getDeparture());
          }
          if (other.hasScheduleRelationship()) {
            setScheduleRelationship(other.getScheduleRelationship());
          }
          if (other.hasStopTimeProperties()) {
            mergeStopTimeProperties(other.getStopTimeProperties());
          }
          this.mergeExtensionFields(other);
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (hasArrival()) {
            if (!getArrival().isInitialized()) {
              return false;
            }
          }
          if (hasDeparture()) {
            if (!getDeparture().isInitialized()) {
              return false;
            }
          }
          if (hasStopTimeProperties()) {
            if (!getStopTimeProperties().isInitialized()) {
              return false;
            }
          }
          if (!extensionsAreInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private int stopSequence_ ;
        /**
         * <pre>
         * Must be the same as in stop_times.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional uint32 stop_sequence = 1;</code>
         */
        public boolean hasStopSequence() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Must be the same as in stop_times.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional uint32 stop_sequence = 1;</code>
         */
        public int getStopSequence() {
          return stopSequence_;
        }
        /**
         * <pre>
         * Must be the same as in stop_times.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional uint32 stop_sequence = 1;</code>
         */
        public Builder setStopSequence(int value) {
          bitField0_ |= 0x00000001;
          stopSequence_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be the same as in stop_times.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional uint32 stop_sequence = 1;</code>
         */
        public Builder clearStopSequence() {
          bitField0_ = (bitField0_ & ~0x00000001);
          stopSequence_ = 0;
          onChanged();
          return this;
        }

        private java.lang.Object stopId_ = "";
        /**
         * <pre>
         * Must be the same as in stops.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional string stop_id = 4;</code>
         */
        public boolean hasStopId() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Must be the same as in stops.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional string stop_id = 4;</code>
         */
        public java.lang.String getStopId() {
          java.lang.Object ref = stopId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              stopId_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Must be the same as in stops.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional string stop_id = 4;</code>
         */
        public com.google.protobuf.ByteString
            getStopIdBytes() {
          java.lang.Object ref = stopId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            stopId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Must be the same as in stops.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional string stop_id = 4;</code>
         */
        public Builder setStopId(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          stopId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be the same as in stops.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional string stop_id = 4;</code>
         */
        public Builder clearStopId() {
          bitField0_ = (bitField0_ & ~0x00000002);
          stopId_ = getDefaultInstance().getStopId();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Must be the same as in stops.txt in the corresponding GTFS feed.
         * </pre>
         *
         * <code>optional string stop_id = 4;</code>
         */
        public Builder setStopIdBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          stopId_ = value;
          onChanged();
          return this;
        }

        private com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent arrival_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder> arrivalBuilder_;
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public boolean hasArrival() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getArrival() {
          if (arrivalBuilder_ == null) {
            return arrival_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : arrival_;
          } else {
            return arrivalBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public Builder setArrival(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent value) {
          if (arrivalBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            arrival_ = value;
            onChanged();
          } else {
            arrivalBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public Builder setArrival(
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder builderForValue) {
          if (arrivalBuilder_ == null) {
            arrival_ = builderForValue.build();
            onChanged();
          } else {
            arrivalBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public Builder mergeArrival(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent value) {
          if (arrivalBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0) &&
                arrival_ != null &&
                arrival_ != com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance()) {
              arrival_ =
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.newBuilder(arrival_).mergeFrom(value).buildPartial();
            } else {
              arrival_ = value;
            }
            onChanged();
          } else {
            arrivalBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000004;
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public Builder clearArrival() {
          if (arrivalBuilder_ == null) {
            arrival_ = null;
            onChanged();
          } else {
            arrivalBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder getArrivalBuilder() {
          bitField0_ |= 0x00000004;
          onChanged();
          return getArrivalFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder getArrivalOrBuilder() {
          if (arrivalBuilder_ != null) {
            return arrivalBuilder_.getMessageOrBuilder();
          } else {
            return arrival_ == null ?
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : arrival_;
          }
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent arrival = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder> 
            getArrivalFieldBuilder() {
          if (arrivalBuilder_ == null) {
            arrivalBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder>(
                    getArrival(),
                    getParentForChildren(),
                    isClean());
            arrival_ = null;
          }
          return arrivalBuilder_;
        }

        private com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent departure_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder> departureBuilder_;
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public boolean hasDeparture() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent getDeparture() {
          if (departureBuilder_ == null) {
            return departure_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : departure_;
          } else {
            return departureBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public Builder setDeparture(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent value) {
          if (departureBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            departure_ = value;
            onChanged();
          } else {
            departureBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public Builder setDeparture(
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder builderForValue) {
          if (departureBuilder_ == null) {
            departure_ = builderForValue.build();
            onChanged();
          } else {
            departureBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public Builder mergeDeparture(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent value) {
          if (departureBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0) &&
                departure_ != null &&
                departure_ != com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance()) {
              departure_ =
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.newBuilder(departure_).mergeFrom(value).buildPartial();
            } else {
              departure_ = value;
            }
            onChanged();
          } else {
            departureBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000008;
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public Builder clearDeparture() {
          if (departureBuilder_ == null) {
            departure_ = null;
            onChanged();
          } else {
            departureBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000008);
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder getDepartureBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getDepartureFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder getDepartureOrBuilder() {
          if (departureBuilder_ != null) {
            return departureBuilder_.getMessageOrBuilder();
          } else {
            return departure_ == null ?
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.getDefaultInstance() : departure_;
          }
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeEvent departure = 3;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder> 
            getDepartureFieldBuilder() {
          if (departureBuilder_ == null) {
            departureBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEvent.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeEventOrBuilder>(
                    getDeparture(),
                    getParentForChildren(),
                    isClean());
            departure_ = null;
          }
          return departureBuilder_;
        }

        private int scheduleRelationship_ = 0;
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
         */
        public boolean hasScheduleRelationship() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship getScheduleRelationship() {
          @SuppressWarnings("deprecation")
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship result = com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.valueOf(scheduleRelationship_);
          return result == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship.SCHEDULED : result;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
         */
        public Builder setScheduleRelationship(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.ScheduleRelationship value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000010;
          scheduleRelationship_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.ScheduleRelationship schedule_relationship = 5 [default = SCHEDULED];</code>
         */
        public Builder clearScheduleRelationship() {
          bitField0_ = (bitField0_ & ~0x00000010);
          scheduleRelationship_ = 0;
          onChanged();
          return this;
        }

        private com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties stopTimeProperties_;
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder> stopTimePropertiesBuilder_;
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public boolean hasStopTimeProperties() {
          return ((bitField0_ & 0x00000020) != 0);
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties getStopTimeProperties() {
          if (stopTimePropertiesBuilder_ == null) {
            return stopTimeProperties_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance() : stopTimeProperties_;
          } else {
            return stopTimePropertiesBuilder_.getMessage();
          }
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public Builder setStopTimeProperties(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties value) {
          if (stopTimePropertiesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            stopTimeProperties_ = value;
            onChanged();
          } else {
            stopTimePropertiesBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000020;
          return this;
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public Builder setStopTimeProperties(
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder builderForValue) {
          if (stopTimePropertiesBuilder_ == null) {
            stopTimeProperties_ = builderForValue.build();
            onChanged();
          } else {
            stopTimePropertiesBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000020;
          return this;
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public Builder mergeStopTimeProperties(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties value) {
          if (stopTimePropertiesBuilder_ == null) {
            if (((bitField0_ & 0x00000020) != 0) &&
                stopTimeProperties_ != null &&
                stopTimeProperties_ != com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance()) {
              stopTimeProperties_ =
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.newBuilder(stopTimeProperties_).mergeFrom(value).buildPartial();
            } else {
              stopTimeProperties_ = value;
            }
            onChanged();
          } else {
            stopTimePropertiesBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000020;
          return this;
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public Builder clearStopTimeProperties() {
          if (stopTimePropertiesBuilder_ == null) {
            stopTimeProperties_ = null;
            onChanged();
          } else {
            stopTimePropertiesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000020);
          return this;
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder getStopTimePropertiesBuilder() {
          bitField0_ |= 0x00000020;
          onChanged();
          return getStopTimePropertiesFieldBuilder().getBuilder();
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder getStopTimePropertiesOrBuilder() {
          if (stopTimePropertiesBuilder_ != null) {
            return stopTimePropertiesBuilder_.getMessageOrBuilder();
          } else {
            return stopTimeProperties_ == null ?
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.getDefaultInstance() : stopTimeProperties_;
          }
        }
        /**
         * <pre>
         * Realtime updates for certain properties defined within GTFS stop_times.txt
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.TripUpdate.StopTimeUpdate.StopTimeProperties stop_time_properties = 6;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder> 
            getStopTimePropertiesFieldBuilder() {
          if (stopTimePropertiesBuilder_ == null) {
            stopTimePropertiesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimeProperties.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.StopTimePropertiesOrBuilder>(
                    getStopTimeProperties(),
                    getParentForChildren(),
                    isClean());
            stopTimeProperties_ = null;
          }
          return stopTimePropertiesBuilder_;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:transit_realtime.TripUpdate.StopTimeUpdate)
      }

      // @@protoc_insertion_point(class_scope:transit_realtime.TripUpdate.StopTimeUpdate)
      private static final com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate();
      }

      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<StopTimeUpdate>
          PARSER = new com.google.protobuf.AbstractParser<StopTimeUpdate>() {
        @java.lang.Override
        public StopTimeUpdate parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StopTimeUpdate(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<StopTimeUpdate> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<StopTimeUpdate> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface TripPropertiesOrBuilder extends
        // @@protoc_insertion_point(interface_extends:transit_realtime.TripUpdate.TripProperties)
        com.google.protobuf.GeneratedMessageV3.
            ExtendableMessageOrBuilder<TripProperties> {

      /**
       * <pre>
       * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
       * but will start at a different service date and/or time (defined using the TripProperties.start_date and
       * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
       * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
       * be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      boolean hasTripId();
      /**
       * <pre>
       * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
       * but will start at a different service date and/or time (defined using the TripProperties.start_date and
       * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
       * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
       * be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      java.lang.String getTripId();
      /**
       * <pre>
       * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
       * but will start at a different service date and/or time (defined using the TripProperties.start_date and
       * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
       * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
       * be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      com.google.protobuf.ByteString
          getTripIdBytes();

      /**
       * <pre>
       * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
       * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_date = 2;</code>
       */
      boolean hasStartDate();
      /**
       * <pre>
       * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
       * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_date = 2;</code>
       */
      java.lang.String getStartDate();
      /**
       * <pre>
       * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
       * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_date = 2;</code>
       */
      com.google.protobuf.ByteString
          getStartDateBytes();

      /**
       * <pre>
       * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
       * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
       * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
       * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
       * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
       * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
       * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
       * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
       * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
       * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
       * populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_time = 3;</code>
       */
      boolean hasStartTime();
      /**
       * <pre>
       * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
       * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
       * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
       * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
       * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
       * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
       * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
       * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
       * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
       * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
       * populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_time = 3;</code>
       */
      java.lang.String getStartTime();
      /**
       * <pre>
       * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
       * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
       * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
       * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
       * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
       * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
       * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
       * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
       * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
       * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
       * populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_time = 3;</code>
       */
      com.google.protobuf.ByteString
          getStartTimeBytes();
    }
    /**
     * <pre>
     * Defines updated properties of the trip
     * NOTE: This message is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.TripUpdate.TripProperties}
     */
    public  static final class TripProperties extends
        com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
          TripProperties> implements
        // @@protoc_insertion_point(message_implements:transit_realtime.TripUpdate.TripProperties)
        TripPropertiesOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use TripProperties.newBuilder() to construct.
      private TripProperties(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, ?> builder) {
        super(builder);
      }
      private TripProperties() {
        tripId_ = "";
        startDate_ = "";
        startTime_ = "";
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private TripProperties(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                tripId_ = bs;
                break;
              }
              case 18: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                startDate_ = bs;
                break;
              }
              case 26: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000004;
                startTime_ = bs;
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_TripProperties_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_TripProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder.class);
      }

      private int bitField0_;
      public static final int TRIP_ID_FIELD_NUMBER = 1;
      private volatile java.lang.Object tripId_;
      /**
       * <pre>
       * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
       * but will start at a different service date and/or time (defined using the TripProperties.start_date and
       * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
       * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
       * be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public boolean hasTripId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
       * but will start at a different service date and/or time (defined using the TripProperties.start_date and
       * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
       * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
       * be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public java.lang.String getTripId() {
        java.lang.Object ref = tripId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tripId_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
       * but will start at a different service date and/or time (defined using the TripProperties.start_date and
       * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
       * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
       * be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getTripIdBytes() {
        java.lang.Object ref = tripId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tripId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int START_DATE_FIELD_NUMBER = 2;
      private volatile java.lang.Object startDate_;
      /**
       * <pre>
       * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
       * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_date = 2;</code>
       */
      public boolean hasStartDate() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
       * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_date = 2;</code>
       */
      public java.lang.String getStartDate() {
        java.lang.Object ref = startDate_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            startDate_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
       * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_date = 2;</code>
       */
      public com.google.protobuf.ByteString
          getStartDateBytes() {
        java.lang.Object ref = startDate_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          startDate_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int START_TIME_FIELD_NUMBER = 3;
      private volatile java.lang.Object startTime_;
      /**
       * <pre>
       * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
       * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
       * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
       * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
       * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
       * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
       * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
       * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
       * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
       * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
       * populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_time = 3;</code>
       */
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
       * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
       * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
       * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
       * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
       * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
       * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
       * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
       * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
       * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
       * populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_time = 3;</code>
       */
      public java.lang.String getStartTime() {
        java.lang.Object ref = startTime_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            startTime_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
       * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
       * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
       * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
       * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
       * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
       * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
       * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
       * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
       * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
       * populated and will be ignored by consumers.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string start_time = 3;</code>
       */
      public com.google.protobuf.ByteString
          getStartTimeBytes() {
        java.lang.Object ref = startTime_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          startTime_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!extensionsAreInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3
          .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties>.ExtensionWriter
            extensionWriter = newExtensionWriter();
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tripId_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, startDate_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, startTime_);
        }
        extensionWriter.writeUntil(2000, output);
        extensionWriter.writeUntil(10000, output);
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tripId_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, startDate_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, startTime_);
        }
        size += extensionsSerializedSize();
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties)) {
          return super.equals(obj);
        }
        com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties other = (com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties) obj;

        if (hasTripId() != other.hasTripId()) return false;
        if (hasTripId()) {
          if (!getTripId()
              .equals(other.getTripId())) return false;
        }
        if (hasStartDate() != other.hasStartDate()) return false;
        if (hasStartDate()) {
          if (!getStartDate()
              .equals(other.getStartDate())) return false;
        }
        if (hasStartTime() != other.hasStartTime()) return false;
        if (hasStartTime()) {
          if (!getStartTime()
              .equals(other.getStartTime())) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        if (!getExtensionFields().equals(other.getExtensionFields()))
          return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasTripId()) {
          hash = (37 * hash) + TRIP_ID_FIELD_NUMBER;
          hash = (53 * hash) + getTripId().hashCode();
        }
        if (hasStartDate()) {
          hash = (37 * hash) + START_DATE_FIELD_NUMBER;
          hash = (53 * hash) + getStartDate().hashCode();
        }
        if (hasStartTime()) {
          hash = (37 * hash) + START_TIME_FIELD_NUMBER;
          hash = (53 * hash) + getStartTime().hashCode();
        }
        hash = hashFields(hash, getExtensionFields());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Defines updated properties of the trip
       * NOTE: This message is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * Protobuf type {@code transit_realtime.TripUpdate.TripProperties}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
            com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, Builder> implements
          // @@protoc_insertion_point(builder_implements:transit_realtime.TripUpdate.TripProperties)
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_TripProperties_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_TripProperties_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder.class);
        }

        // Construct using com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          tripId_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          startDate_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          startTime_ = "";
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_TripProperties_descriptor;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties getDefaultInstanceForType() {
          return com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties build() {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties buildPartial() {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties result = new com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.tripId_ = tripId_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.startDate_ = startDate_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            to_bitField0_ |= 0x00000004;
          }
          result.startTime_ = startTime_;
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, Type> extension,
            Type value) {
          return super.setExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, java.util.List<Type>> extension,
            int index, Type value) {
          return super.setExtension(extension, index, value);
        }
        @java.lang.Override
        public <Type> Builder addExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, java.util.List<Type>> extension,
            Type value) {
          return super.addExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder clearExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, ?> extension) {
          return super.clearExtension(extension);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties) {
            return mergeFrom((com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties other) {
          if (other == com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance()) return this;
          if (other.hasTripId()) {
            bitField0_ |= 0x00000001;
            tripId_ = other.tripId_;
            onChanged();
          }
          if (other.hasStartDate()) {
            bitField0_ |= 0x00000002;
            startDate_ = other.startDate_;
            onChanged();
          }
          if (other.hasStartTime()) {
            bitField0_ |= 0x00000004;
            startTime_ = other.startTime_;
            onChanged();
          }
          this.mergeExtensionFields(other);
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!extensionsAreInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object tripId_ = "";
        /**
         * <pre>
         * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
         * but will start at a different service date and/or time (defined using the TripProperties.start_date and
         * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
         * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
         * be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string trip_id = 1;</code>
         */
        public boolean hasTripId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
         * but will start at a different service date and/or time (defined using the TripProperties.start_date and
         * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
         * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
         * be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string trip_id = 1;</code>
         */
        public java.lang.String getTripId() {
          java.lang.Object ref = tripId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              tripId_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
         * but will start at a different service date and/or time (defined using the TripProperties.start_date and
         * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
         * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
         * be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string trip_id = 1;</code>
         */
        public com.google.protobuf.ByteString
            getTripIdBytes() {
          java.lang.Object ref = tripId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            tripId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
         * but will start at a different service date and/or time (defined using the TripProperties.start_date and
         * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
         * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
         * be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string trip_id = 1;</code>
         */
        public Builder setTripId(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          tripId_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
         * but will start at a different service date and/or time (defined using the TripProperties.start_date and
         * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
         * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
         * be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string trip_id = 1;</code>
         */
        public Builder clearTripId() {
          bitField0_ = (bitField0_ & ~0x00000001);
          tripId_ = getDefaultInstance().getTripId();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Defines the identifier of a new trip that is a duplicate of an existing trip defined in (CSV) GTFS trips.txt
         * but will start at a different service date and/or time (defined using the TripProperties.start_date and
         * TripProperties.start_time fields). See definition of trips.trip_id in (CSV) GTFS. Its value must be different
         * than the ones used in the (CSV) GTFS. Required if schedule_relationship=DUPLICATED, otherwise this field must not
         * be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string trip_id = 1;</code>
         */
        public Builder setTripIdBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          tripId_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object startDate_ = "";
        /**
         * <pre>
         * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
         * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_date = 2;</code>
         */
        public boolean hasStartDate() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
         * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_date = 2;</code>
         */
        public java.lang.String getStartDate() {
          java.lang.Object ref = startDate_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              startDate_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
         * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_date = 2;</code>
         */
        public com.google.protobuf.ByteString
            getStartDateBytes() {
          java.lang.Object ref = startDate_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            startDate_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
         * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_date = 2;</code>
         */
        public Builder setStartDate(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          startDate_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
         * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_date = 2;</code>
         */
        public Builder clearStartDate() {
          bitField0_ = (bitField0_ & ~0x00000002);
          startDate_ = getDefaultInstance().getStartDate();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Service date on which the DUPLICATED trip will be run, in YYYYMMDD format. Required if
         * schedule_relationship=DUPLICATED, otherwise this field must not be populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_date = 2;</code>
         */
        public Builder setStartDateBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          startDate_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object startTime_ = "";
        /**
         * <pre>
         * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
         * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
         * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
         * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
         * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
         * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
         * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
         * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
         * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
         * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
         * populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_time = 3;</code>
         */
        public boolean hasStartTime() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
         * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
         * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
         * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
         * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
         * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
         * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
         * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
         * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
         * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
         * populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_time = 3;</code>
         */
        public java.lang.String getStartTime() {
          java.lang.Object ref = startTime_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              startTime_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
         * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
         * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
         * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
         * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
         * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
         * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
         * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
         * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
         * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
         * populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_time = 3;</code>
         */
        public com.google.protobuf.ByteString
            getStartTimeBytes() {
          java.lang.Object ref = startTime_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            startTime_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
         * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
         * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
         * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
         * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
         * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
         * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
         * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
         * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
         * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
         * populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_time = 3;</code>
         */
        public Builder setStartTime(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
          startTime_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
         * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
         * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
         * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
         * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
         * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
         * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
         * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
         * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
         * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
         * populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_time = 3;</code>
         */
        public Builder clearStartTime() {
          bitField0_ = (bitField0_ & ~0x00000004);
          startTime_ = getDefaultInstance().getStartTime();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Defines the departure start time of the trip when it’s duplicated. See definition of stop_times.departure_time
         * in (CSV) GTFS. Scheduled arrival and departure times for the duplicated trip are calculated based on the offset
         * between the original trip departure_time and this field. For example, if a GTFS trip has stop A with a
         * departure_time of 10:00:00 and stop B with departure_time of 10:01:00, and this field is populated with the value
         * of 10:30:00, stop B on the duplicated trip will have a scheduled departure_time of 10:31:00. Real-time prediction
         * delay values are applied to this calculated schedule time to determine the predicted time. For example, if a
         * departure delay of 30 is provided for stop B, then the predicted departure time is 10:31:30. Real-time
         * prediction time values do not have any offset applied to them and indicate the predicted time as provided.
         * For example, if a departure time representing 10:31:30 is provided for stop B, then the predicted departure time
         * is 10:31:30. This field is required if schedule_relationship is DUPLICATED, otherwise this field must not be
         * populated and will be ignored by consumers.
         * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string start_time = 3;</code>
         */
        public Builder setStartTimeBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
          startTime_ = value;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:transit_realtime.TripUpdate.TripProperties)
      }

      // @@protoc_insertion_point(class_scope:transit_realtime.TripUpdate.TripProperties)
      private static final com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties();
      }

      public static com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<TripProperties>
          PARSER = new com.google.protobuf.AbstractParser<TripProperties>() {
        @java.lang.Override
        public TripProperties parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new TripProperties(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<TripProperties> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<TripProperties> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int TRIP_FIELD_NUMBER = 1;
    private com.google.transit.realtime.GtfsRealtime.TripDescriptor trip_;
    /**
     * <pre>
     * The Trip that this message applies to. There can be at most one
     * TripUpdate entity for each actual trip instance.
     * If there is none, that means there is no prediction information available.
     * It does *not* mean that the trip is progressing according to schedule.
     * </pre>
     *
     * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
     */
    public boolean hasTrip() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The Trip that this message applies to. There can be at most one
     * TripUpdate entity for each actual trip instance.
     * If there is none, that means there is no prediction information available.
     * It does *not* mean that the trip is progressing according to schedule.
     * </pre>
     *
     * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripDescriptor getTrip() {
      return trip_ == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
    }
    /**
     * <pre>
     * The Trip that this message applies to. There can be at most one
     * TripUpdate entity for each actual trip instance.
     * If there is none, that means there is no prediction information available.
     * It does *not* mean that the trip is progressing according to schedule.
     * </pre>
     *
     * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder getTripOrBuilder() {
      return trip_ == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
    }

    public static final int VEHICLE_FIELD_NUMBER = 3;
    private com.google.transit.realtime.GtfsRealtime.VehicleDescriptor vehicle_;
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
     */
    public boolean hasVehicle() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getVehicle() {
      return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
    }
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder getVehicleOrBuilder() {
      return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
    }

    public static final int STOP_TIME_UPDATE_FIELD_NUMBER = 2;
    private java.util.List<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate> stopTimeUpdate_;
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    public java.util.List<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate> getStopTimeUpdateList() {
      return stopTimeUpdate_;
    }
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder> 
        getStopTimeUpdateOrBuilderList() {
      return stopTimeUpdate_;
    }
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    public int getStopTimeUpdateCount() {
      return stopTimeUpdate_.size();
    }
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate getStopTimeUpdate(int index) {
      return stopTimeUpdate_.get(index);
    }
    /**
     * <pre>
     * Updates to StopTimes for the trip (both future, i.e., predictions, and in
     * some cases, past ones, i.e., those that already happened).
     * The updates must be sorted by stop_sequence, and apply for all the
     * following stops of the trip up to the next specified one.
     * Example 1:
     * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
     * delay of 0 for stop_sequence of the current stop means that the trip is
     * exactly on time.
     * Example 2:
     * For the same trip instance, 3 StopTimeUpdates are provided:
     * - delay of 5 min for stop_sequence 3
     * - delay of 1 min for stop_sequence 8
     * - delay of unspecified duration for stop_sequence 10
     * This will be interpreted as:
     * - stop_sequences 3,4,5,6,7 have delay of 5 min.
     * - stop_sequences 8,9 have delay of 1 min.
     * - stop_sequences 10,... have unknown delay.
     * </pre>
     *
     * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder getStopTimeUpdateOrBuilder(
        int index) {
      return stopTimeUpdate_.get(index);
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 4;
    private long timestamp_;
    /**
     * <pre>
     * Moment at which the vehicle's real-time progress was measured. In POSIX
     * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 4;</code>
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Moment at which the vehicle's real-time progress was measured. In POSIX
     * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 4;</code>
     */
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int DELAY_FIELD_NUMBER = 5;
    private int delay_;
    /**
     * <pre>
     * The current schedule deviation for the trip.  Delay should only be
     * specified when the prediction is given relative to some existing schedule
     * in GTFS.
     * Delay (in seconds) can be positive (meaning that the vehicle is late) or
     * negative (meaning that the vehicle is ahead of schedule). Delay of 0
     * means that the vehicle is exactly on time.
     * Delay information in StopTimeUpdates take precedent of trip-level delay
     * information, such that trip-level delay is only propagated until the next
     * stop along the trip with a StopTimeUpdate delay value specified.
     * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
     * value indicating when the delay value was last updated, in order to
     * evaluate the freshness of the data.
     * NOTE: This field is still experimental, and subject to change. It may be
     * formally adopted in the future.
     * </pre>
     *
     * <code>optional int32 delay = 5;</code>
     */
    public boolean hasDelay() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * The current schedule deviation for the trip.  Delay should only be
     * specified when the prediction is given relative to some existing schedule
     * in GTFS.
     * Delay (in seconds) can be positive (meaning that the vehicle is late) or
     * negative (meaning that the vehicle is ahead of schedule). Delay of 0
     * means that the vehicle is exactly on time.
     * Delay information in StopTimeUpdates take precedent of trip-level delay
     * information, such that trip-level delay is only propagated until the next
     * stop along the trip with a StopTimeUpdate delay value specified.
     * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
     * value indicating when the delay value was last updated, in order to
     * evaluate the freshness of the data.
     * NOTE: This field is still experimental, and subject to change. It may be
     * formally adopted in the future.
     * </pre>
     *
     * <code>optional int32 delay = 5;</code>
     */
    public int getDelay() {
      return delay_;
    }

    public static final int TRIP_PROPERTIES_FIELD_NUMBER = 6;
    private com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties tripProperties_;
    /**
     * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
     */
    public boolean hasTripProperties() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties getTripProperties() {
      return tripProperties_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance() : tripProperties_;
    }
    /**
     * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder getTripPropertiesOrBuilder() {
      return tripProperties_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance() : tripProperties_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasTrip()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getTrip().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasVehicle()) {
        if (!getVehicle().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getStopTimeUpdateCount(); i++) {
        if (!getStopTimeUpdate(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasTripProperties()) {
        if (!getTripProperties().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TripUpdate>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTrip());
      }
      for (int i = 0; i < stopTimeUpdate_.size(); i++) {
        output.writeMessage(2, stopTimeUpdate_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(3, getVehicle());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt64(4, timestamp_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeInt32(5, delay_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(6, getTripProperties());
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getTrip());
      }
      for (int i = 0; i < stopTimeUpdate_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, stopTimeUpdate_.get(i));
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getVehicle());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, timestamp_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(5, delay_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(6, getTripProperties());
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.TripUpdate other = (com.google.transit.realtime.GtfsRealtime.TripUpdate) obj;

      if (hasTrip() != other.hasTrip()) return false;
      if (hasTrip()) {
        if (!getTrip()
            .equals(other.getTrip())) return false;
      }
      if (hasVehicle() != other.hasVehicle()) return false;
      if (hasVehicle()) {
        if (!getVehicle()
            .equals(other.getVehicle())) return false;
      }
      if (!getStopTimeUpdateList()
          .equals(other.getStopTimeUpdateList())) return false;
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (getTimestamp()
            != other.getTimestamp()) return false;
      }
      if (hasDelay() != other.hasDelay()) return false;
      if (hasDelay()) {
        if (getDelay()
            != other.getDelay()) return false;
      }
      if (hasTripProperties() != other.hasTripProperties()) return false;
      if (hasTripProperties()) {
        if (!getTripProperties()
            .equals(other.getTripProperties())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTrip()) {
        hash = (37 * hash) + TRIP_FIELD_NUMBER;
        hash = (53 * hash) + getTrip().hashCode();
      }
      if (hasVehicle()) {
        hash = (37 * hash) + VEHICLE_FIELD_NUMBER;
        hash = (53 * hash) + getVehicle().hashCode();
      }
      if (getStopTimeUpdateCount() > 0) {
        hash = (37 * hash) + STOP_TIME_UPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getStopTimeUpdateList().hashCode();
      }
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getTimestamp());
      }
      if (hasDelay()) {
        hash = (37 * hash) + DELAY_FIELD_NUMBER;
        hash = (53 * hash) + getDelay();
      }
      if (hasTripProperties()) {
        hash = (37 * hash) + TRIP_PROPERTIES_FIELD_NUMBER;
        hash = (53 * hash) + getTripProperties().hashCode();
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripUpdate parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TripUpdate prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Realtime update of the progress of a vehicle along a trip.
     * Depending on the value of ScheduleRelationship, a TripUpdate can specify:
     * - A trip that proceeds along the schedule.
     * - A trip that proceeds along a route but has no fixed schedule.
     * - A trip that have been added or removed with regard to schedule.
     * The updates can be for future, predicted arrival/departure events, or for
     * past events that already occurred.
     * Normally, updates should get more precise and more certain (see
     * uncertainty below) as the events gets closer to current time.
     * Even if that is not possible, the information for past events should be
     * precise and certain. In particular, if an update points to time in the past
     * but its update's uncertainty is not 0, the client should conclude that the
     * update is a (wrong) prediction and that the trip has not completed yet.
     * Note that the update can describe a trip that is already completed.
     * To this end, it is enough to provide an update for the last stop of the trip.
     * If the time of that is in the past, the client will conclude from that that
     * the whole trip is in the past (it is possible, although inconsequential, to
     * also provide updates for preceding stops).
     * This option is most relevant for a trip that has completed ahead of schedule,
     * but according to the schedule, the trip is still proceeding at the current
     * time. Removing the updates for this trip could make the client assume
     * that the trip is still proceeding.
     * Note that the feed provider is allowed, but not required, to purge past
     * updates - this is one case where this would be practically useful.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.TripUpdate}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.TripUpdate, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.TripUpdate)
        com.google.transit.realtime.GtfsRealtime.TripUpdateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.TripUpdate.class, com.google.transit.realtime.GtfsRealtime.TripUpdate.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.TripUpdate.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTripFieldBuilder();
          getVehicleFieldBuilder();
          getStopTimeUpdateFieldBuilder();
          getTripPropertiesFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (tripBuilder_ == null) {
          trip_ = null;
        } else {
          tripBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (vehicleBuilder_ == null) {
          vehicle_ = null;
        } else {
          vehicleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (stopTimeUpdateBuilder_ == null) {
          stopTimeUpdate_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          stopTimeUpdateBuilder_.clear();
        }
        timestamp_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        delay_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        if (tripPropertiesBuilder_ == null) {
          tripProperties_ = null;
        } else {
          tripPropertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripUpdate_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripUpdate getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripUpdate build() {
        com.google.transit.realtime.GtfsRealtime.TripUpdate result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripUpdate buildPartial() {
        com.google.transit.realtime.GtfsRealtime.TripUpdate result = new com.google.transit.realtime.GtfsRealtime.TripUpdate(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (tripBuilder_ == null) {
            result.trip_ = trip_;
          } else {
            result.trip_ = tripBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (vehicleBuilder_ == null) {
            result.vehicle_ = vehicle_;
          } else {
            result.vehicle_ = vehicleBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        if (stopTimeUpdateBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)) {
            stopTimeUpdate_ = java.util.Collections.unmodifiableList(stopTimeUpdate_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.stopTimeUpdate_ = stopTimeUpdate_;
        } else {
          result.stopTimeUpdate_ = stopTimeUpdateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.timestamp_ = timestamp_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.delay_ = delay_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          if (tripPropertiesBuilder_ == null) {
            result.tripProperties_ = tripProperties_;
          } else {
            result.tripProperties_ = tripPropertiesBuilder_.build();
          }
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripUpdate, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripUpdate, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripUpdate, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripUpdate, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.TripUpdate) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.TripUpdate)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TripUpdate other) {
        if (other == com.google.transit.realtime.GtfsRealtime.TripUpdate.getDefaultInstance()) return this;
        if (other.hasTrip()) {
          mergeTrip(other.getTrip());
        }
        if (other.hasVehicle()) {
          mergeVehicle(other.getVehicle());
        }
        if (stopTimeUpdateBuilder_ == null) {
          if (!other.stopTimeUpdate_.isEmpty()) {
            if (stopTimeUpdate_.isEmpty()) {
              stopTimeUpdate_ = other.stopTimeUpdate_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureStopTimeUpdateIsMutable();
              stopTimeUpdate_.addAll(other.stopTimeUpdate_);
            }
            onChanged();
          }
        } else {
          if (!other.stopTimeUpdate_.isEmpty()) {
            if (stopTimeUpdateBuilder_.isEmpty()) {
              stopTimeUpdateBuilder_.dispose();
              stopTimeUpdateBuilder_ = null;
              stopTimeUpdate_ = other.stopTimeUpdate_;
              bitField0_ = (bitField0_ & ~0x00000004);
              stopTimeUpdateBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getStopTimeUpdateFieldBuilder() : null;
            } else {
              stopTimeUpdateBuilder_.addAllMessages(other.stopTimeUpdate_);
            }
          }
        }
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasDelay()) {
          setDelay(other.getDelay());
        }
        if (other.hasTripProperties()) {
          mergeTripProperties(other.getTripProperties());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasTrip()) {
          return false;
        }
        if (!getTrip().isInitialized()) {
          return false;
        }
        if (hasVehicle()) {
          if (!getVehicle().isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getStopTimeUpdateCount(); i++) {
          if (!getStopTimeUpdate(i).isInitialized()) {
            return false;
          }
        }
        if (hasTripProperties()) {
          if (!getTripProperties().isInitialized()) {
            return false;
          }
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.TripUpdate parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.TripUpdate) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.transit.realtime.GtfsRealtime.TripDescriptor trip_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripDescriptor, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder> tripBuilder_;
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public boolean hasTrip() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor getTrip() {
        if (tripBuilder_ == null) {
          return trip_ == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
        } else {
          return tripBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder setTrip(com.google.transit.realtime.GtfsRealtime.TripDescriptor value) {
        if (tripBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trip_ = value;
          onChanged();
        } else {
          tripBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder setTrip(
          com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder builderForValue) {
        if (tripBuilder_ == null) {
          trip_ = builderForValue.build();
          onChanged();
        } else {
          tripBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder mergeTrip(com.google.transit.realtime.GtfsRealtime.TripDescriptor value) {
        if (tripBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              trip_ != null &&
              trip_ != com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance()) {
            trip_ =
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.newBuilder(trip_).mergeFrom(value).buildPartial();
          } else {
            trip_ = value;
          }
          onChanged();
        } else {
          tripBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder clearTrip() {
        if (tripBuilder_ == null) {
          trip_ = null;
          onChanged();
        } else {
          tripBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder getTripBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTripFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder getTripOrBuilder() {
        if (tripBuilder_ != null) {
          return tripBuilder_.getMessageOrBuilder();
        } else {
          return trip_ == null ?
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
        }
      }
      /**
       * <pre>
       * The Trip that this message applies to. There can be at most one
       * TripUpdate entity for each actual trip instance.
       * If there is none, that means there is no prediction information available.
       * It does *not* mean that the trip is progressing according to schedule.
       * </pre>
       *
       * <code>required .transit_realtime.TripDescriptor trip = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripDescriptor, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder> 
          getTripFieldBuilder() {
        if (tripBuilder_ == null) {
          tripBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TripDescriptor, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder>(
                  getTrip(),
                  getParentForChildren(),
                  isClean());
          trip_ = null;
        }
        return tripBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.VehicleDescriptor vehicle_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder> vehicleBuilder_;
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public boolean hasVehicle() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getVehicle() {
        if (vehicleBuilder_ == null) {
          return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
        } else {
          return vehicleBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public Builder setVehicle(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor value) {
        if (vehicleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vehicle_ = value;
          onChanged();
        } else {
          vehicleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public Builder setVehicle(
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder builderForValue) {
        if (vehicleBuilder_ == null) {
          vehicle_ = builderForValue.build();
          onChanged();
        } else {
          vehicleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public Builder mergeVehicle(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor value) {
        if (vehicleBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              vehicle_ != null &&
              vehicle_ != com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance()) {
            vehicle_ =
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.newBuilder(vehicle_).mergeFrom(value).buildPartial();
          } else {
            vehicle_ = value;
          }
          onChanged();
        } else {
          vehicleBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public Builder clearVehicle() {
        if (vehicleBuilder_ == null) {
          vehicle_ = null;
          onChanged();
        } else {
          vehicleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder getVehicleBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getVehicleFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder getVehicleOrBuilder() {
        if (vehicleBuilder_ != null) {
          return vehicleBuilder_.getMessageOrBuilder();
        } else {
          return vehicle_ == null ?
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
        }
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder> 
          getVehicleFieldBuilder() {
        if (vehicleBuilder_ == null) {
          vehicleBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder>(
                  getVehicle(),
                  getParentForChildren(),
                  isClean());
          vehicle_ = null;
        }
        return vehicleBuilder_;
      }

      private java.util.List<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate> stopTimeUpdate_ =
        java.util.Collections.emptyList();
      private void ensureStopTimeUpdateIsMutable() {
        if (!((bitField0_ & 0x00000004) != 0)) {
          stopTimeUpdate_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate>(stopTimeUpdate_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder> stopTimeUpdateBuilder_;

      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate> getStopTimeUpdateList() {
        if (stopTimeUpdateBuilder_ == null) {
          return java.util.Collections.unmodifiableList(stopTimeUpdate_);
        } else {
          return stopTimeUpdateBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public int getStopTimeUpdateCount() {
        if (stopTimeUpdateBuilder_ == null) {
          return stopTimeUpdate_.size();
        } else {
          return stopTimeUpdateBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate getStopTimeUpdate(int index) {
        if (stopTimeUpdateBuilder_ == null) {
          return stopTimeUpdate_.get(index);
        } else {
          return stopTimeUpdateBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder setStopTimeUpdate(
          int index, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate value) {
        if (stopTimeUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.set(index, value);
          onChanged();
        } else {
          stopTimeUpdateBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder setStopTimeUpdate(
          int index, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder builderForValue) {
        if (stopTimeUpdateBuilder_ == null) {
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.set(index, builderForValue.build());
          onChanged();
        } else {
          stopTimeUpdateBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder addStopTimeUpdate(com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate value) {
        if (stopTimeUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.add(value);
          onChanged();
        } else {
          stopTimeUpdateBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder addStopTimeUpdate(
          int index, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate value) {
        if (stopTimeUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.add(index, value);
          onChanged();
        } else {
          stopTimeUpdateBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder addStopTimeUpdate(
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder builderForValue) {
        if (stopTimeUpdateBuilder_ == null) {
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.add(builderForValue.build());
          onChanged();
        } else {
          stopTimeUpdateBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder addStopTimeUpdate(
          int index, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder builderForValue) {
        if (stopTimeUpdateBuilder_ == null) {
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.add(index, builderForValue.build());
          onChanged();
        } else {
          stopTimeUpdateBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder addAllStopTimeUpdate(
          java.lang.Iterable<? extends com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate> values) {
        if (stopTimeUpdateBuilder_ == null) {
          ensureStopTimeUpdateIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, stopTimeUpdate_);
          onChanged();
        } else {
          stopTimeUpdateBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder clearStopTimeUpdate() {
        if (stopTimeUpdateBuilder_ == null) {
          stopTimeUpdate_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          stopTimeUpdateBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public Builder removeStopTimeUpdate(int index) {
        if (stopTimeUpdateBuilder_ == null) {
          ensureStopTimeUpdateIsMutable();
          stopTimeUpdate_.remove(index);
          onChanged();
        } else {
          stopTimeUpdateBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder getStopTimeUpdateBuilder(
          int index) {
        return getStopTimeUpdateFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder getStopTimeUpdateOrBuilder(
          int index) {
        if (stopTimeUpdateBuilder_ == null) {
          return stopTimeUpdate_.get(index);  } else {
          return stopTimeUpdateBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder> 
           getStopTimeUpdateOrBuilderList() {
        if (stopTimeUpdateBuilder_ != null) {
          return stopTimeUpdateBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(stopTimeUpdate_);
        }
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder addStopTimeUpdateBuilder() {
        return getStopTimeUpdateFieldBuilder().addBuilder(
            com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.getDefaultInstance());
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder addStopTimeUpdateBuilder(
          int index) {
        return getStopTimeUpdateFieldBuilder().addBuilder(
            index, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.getDefaultInstance());
      }
      /**
       * <pre>
       * Updates to StopTimes for the trip (both future, i.e., predictions, and in
       * some cases, past ones, i.e., those that already happened).
       * The updates must be sorted by stop_sequence, and apply for all the
       * following stops of the trip up to the next specified one.
       * Example 1:
       * For a trip with 20 stops, a StopTimeUpdate with arrival delay and departure
       * delay of 0 for stop_sequence of the current stop means that the trip is
       * exactly on time.
       * Example 2:
       * For the same trip instance, 3 StopTimeUpdates are provided:
       * - delay of 5 min for stop_sequence 3
       * - delay of 1 min for stop_sequence 8
       * - delay of unspecified duration for stop_sequence 10
       * This will be interpreted as:
       * - stop_sequences 3,4,5,6,7 have delay of 5 min.
       * - stop_sequences 8,9 have delay of 1 min.
       * - stop_sequences 10,... have unknown delay.
       * </pre>
       *
       * <code>repeated .transit_realtime.TripUpdate.StopTimeUpdate stop_time_update = 2;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder> 
           getStopTimeUpdateBuilderList() {
        return getStopTimeUpdateFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder> 
          getStopTimeUpdateFieldBuilder() {
        if (stopTimeUpdateBuilder_ == null) {
          stopTimeUpdateBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdate.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.StopTimeUpdateOrBuilder>(
                  stopTimeUpdate_,
                  ((bitField0_ & 0x00000004) != 0),
                  getParentForChildren(),
                  isClean());
          stopTimeUpdate_ = null;
        }
        return stopTimeUpdateBuilder_;
      }

      private long timestamp_ ;
      /**
       * <pre>
       * Moment at which the vehicle's real-time progress was measured. In POSIX
       * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 4;</code>
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Moment at which the vehicle's real-time progress was measured. In POSIX
       * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 4;</code>
       */
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <pre>
       * Moment at which the vehicle's real-time progress was measured. In POSIX
       * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 4;</code>
       */
      public Builder setTimestamp(long value) {
        bitField0_ |= 0x00000008;
        timestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Moment at which the vehicle's real-time progress was measured. In POSIX
       * time (i.e., the number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 4;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000008);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private int delay_ ;
      /**
       * <pre>
       * The current schedule deviation for the trip.  Delay should only be
       * specified when the prediction is given relative to some existing schedule
       * in GTFS.
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * Delay information in StopTimeUpdates take precedent of trip-level delay
       * information, such that trip-level delay is only propagated until the next
       * stop along the trip with a StopTimeUpdate delay value specified.
       * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
       * value indicating when the delay value was last updated, in order to
       * evaluate the freshness of the data.
       * NOTE: This field is still experimental, and subject to change. It may be
       * formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 delay = 5;</code>
       */
      public boolean hasDelay() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * The current schedule deviation for the trip.  Delay should only be
       * specified when the prediction is given relative to some existing schedule
       * in GTFS.
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * Delay information in StopTimeUpdates take precedent of trip-level delay
       * information, such that trip-level delay is only propagated until the next
       * stop along the trip with a StopTimeUpdate delay value specified.
       * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
       * value indicating when the delay value was last updated, in order to
       * evaluate the freshness of the data.
       * NOTE: This field is still experimental, and subject to change. It may be
       * formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 delay = 5;</code>
       */
      public int getDelay() {
        return delay_;
      }
      /**
       * <pre>
       * The current schedule deviation for the trip.  Delay should only be
       * specified when the prediction is given relative to some existing schedule
       * in GTFS.
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * Delay information in StopTimeUpdates take precedent of trip-level delay
       * information, such that trip-level delay is only propagated until the next
       * stop along the trip with a StopTimeUpdate delay value specified.
       * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
       * value indicating when the delay value was last updated, in order to
       * evaluate the freshness of the data.
       * NOTE: This field is still experimental, and subject to change. It may be
       * formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 delay = 5;</code>
       */
      public Builder setDelay(int value) {
        bitField0_ |= 0x00000010;
        delay_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The current schedule deviation for the trip.  Delay should only be
       * specified when the prediction is given relative to some existing schedule
       * in GTFS.
       * Delay (in seconds) can be positive (meaning that the vehicle is late) or
       * negative (meaning that the vehicle is ahead of schedule). Delay of 0
       * means that the vehicle is exactly on time.
       * Delay information in StopTimeUpdates take precedent of trip-level delay
       * information, such that trip-level delay is only propagated until the next
       * stop along the trip with a StopTimeUpdate delay value specified.
       * Feed providers are strongly encouraged to provide a TripUpdate.timestamp
       * value indicating when the delay value was last updated, in order to
       * evaluate the freshness of the data.
       * NOTE: This field is still experimental, and subject to change. It may be
       * formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 delay = 5;</code>
       */
      public Builder clearDelay() {
        bitField0_ = (bitField0_ & ~0x00000010);
        delay_ = 0;
        onChanged();
        return this;
      }

      private com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties tripProperties_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder> tripPropertiesBuilder_;
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public boolean hasTripProperties() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties getTripProperties() {
        if (tripPropertiesBuilder_ == null) {
          return tripProperties_ == null ? com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance() : tripProperties_;
        } else {
          return tripPropertiesBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public Builder setTripProperties(com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties value) {
        if (tripPropertiesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          tripProperties_ = value;
          onChanged();
        } else {
          tripPropertiesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public Builder setTripProperties(
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder builderForValue) {
        if (tripPropertiesBuilder_ == null) {
          tripProperties_ = builderForValue.build();
          onChanged();
        } else {
          tripPropertiesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public Builder mergeTripProperties(com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties value) {
        if (tripPropertiesBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0) &&
              tripProperties_ != null &&
              tripProperties_ != com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance()) {
            tripProperties_ =
              com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.newBuilder(tripProperties_).mergeFrom(value).buildPartial();
          } else {
            tripProperties_ = value;
          }
          onChanged();
        } else {
          tripPropertiesBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public Builder clearTripProperties() {
        if (tripPropertiesBuilder_ == null) {
          tripProperties_ = null;
          onChanged();
        } else {
          tripPropertiesBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder getTripPropertiesBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getTripPropertiesFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder getTripPropertiesOrBuilder() {
        if (tripPropertiesBuilder_ != null) {
          return tripPropertiesBuilder_.getMessageOrBuilder();
        } else {
          return tripProperties_ == null ?
              com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.getDefaultInstance() : tripProperties_;
        }
      }
      /**
       * <code>optional .transit_realtime.TripUpdate.TripProperties trip_properties = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder> 
          getTripPropertiesFieldBuilder() {
        if (tripPropertiesBuilder_ == null) {
          tripPropertiesBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripProperties.Builder, com.google.transit.realtime.GtfsRealtime.TripUpdate.TripPropertiesOrBuilder>(
                  getTripProperties(),
                  getParentForChildren(),
                  isClean());
          tripProperties_ = null;
        }
        return tripPropertiesBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.TripUpdate)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.TripUpdate)
    private static final com.google.transit.realtime.GtfsRealtime.TripUpdate DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TripUpdate();
    }

    public static com.google.transit.realtime.GtfsRealtime.TripUpdate getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<TripUpdate>
        PARSER = new com.google.protobuf.AbstractParser<TripUpdate>() {
      @java.lang.Override
      public TripUpdate parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TripUpdate(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TripUpdate> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TripUpdate> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.TripUpdate getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface VehiclePositionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.VehiclePosition)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<VehiclePosition> {

    /**
     * <pre>
     * The Trip that this vehicle is serving.
     * Can be empty or partial if the vehicle can not be identified with a given
     * trip instance.
     * </pre>
     *
     * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
     */
    boolean hasTrip();
    /**
     * <pre>
     * The Trip that this vehicle is serving.
     * Can be empty or partial if the vehicle can not be identified with a given
     * trip instance.
     * </pre>
     *
     * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripDescriptor getTrip();
    /**
     * <pre>
     * The Trip that this vehicle is serving.
     * Can be empty or partial if the vehicle can not be identified with a given
     * trip instance.
     * </pre>
     *
     * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder getTripOrBuilder();

    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
     */
    boolean hasVehicle();
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getVehicle();
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder getVehicleOrBuilder();

    /**
     * <pre>
     * Current position of this vehicle.
     * </pre>
     *
     * <code>optional .transit_realtime.Position position = 2;</code>
     */
    boolean hasPosition();
    /**
     * <pre>
     * Current position of this vehicle.
     * </pre>
     *
     * <code>optional .transit_realtime.Position position = 2;</code>
     */
    com.google.transit.realtime.GtfsRealtime.Position getPosition();
    /**
     * <pre>
     * Current position of this vehicle.
     * </pre>
     *
     * <code>optional .transit_realtime.Position position = 2;</code>
     */
    com.google.transit.realtime.GtfsRealtime.PositionOrBuilder getPositionOrBuilder();

    /**
     * <pre>
     * The stop sequence index of the current stop. The meaning of
     * current_stop_sequence (i.e., the stop that it refers to) is determined by
     * current_status.
     * If current_status is missing IN_TRANSIT_TO is assumed.
     * </pre>
     *
     * <code>optional uint32 current_stop_sequence = 3;</code>
     */
    boolean hasCurrentStopSequence();
    /**
     * <pre>
     * The stop sequence index of the current stop. The meaning of
     * current_stop_sequence (i.e., the stop that it refers to) is determined by
     * current_status.
     * If current_status is missing IN_TRANSIT_TO is assumed.
     * </pre>
     *
     * <code>optional uint32 current_stop_sequence = 3;</code>
     */
    int getCurrentStopSequence();

    /**
     * <pre>
     * Identifies the current stop. The value must be the same as in stops.txt in
     * the corresponding GTFS feed.
     * </pre>
     *
     * <code>optional string stop_id = 7;</code>
     */
    boolean hasStopId();
    /**
     * <pre>
     * Identifies the current stop. The value must be the same as in stops.txt in
     * the corresponding GTFS feed.
     * </pre>
     *
     * <code>optional string stop_id = 7;</code>
     */
    java.lang.String getStopId();
    /**
     * <pre>
     * Identifies the current stop. The value must be the same as in stops.txt in
     * the corresponding GTFS feed.
     * </pre>
     *
     * <code>optional string stop_id = 7;</code>
     */
    com.google.protobuf.ByteString
        getStopIdBytes();

    /**
     * <pre>
     * The exact status of the vehicle with respect to the current stop.
     * Ignored if current_stop_sequence is missing.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
     */
    boolean hasCurrentStatus();
    /**
     * <pre>
     * The exact status of the vehicle with respect to the current stop.
     * Ignored if current_stop_sequence is missing.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus getCurrentStatus();

    /**
     * <pre>
     * Moment at which the vehicle's position was measured. In POSIX time
     * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 5;</code>
     */
    boolean hasTimestamp();
    /**
     * <pre>
     * Moment at which the vehicle's position was measured. In POSIX time
     * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 5;</code>
     */
    long getTimestamp();

    /**
     * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
     */
    boolean hasCongestionLevel();
    /**
     * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel getCongestionLevel();

    /**
     * <pre>
     * If multi_carriage_status is populated with per-carriage OccupancyStatus,
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
     */
    boolean hasOccupancyStatus();
    /**
     * <pre>
     * If multi_carriage_status is populated with per-carriage OccupancyStatus,
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus getOccupancyStatus();

    /**
     * <pre>
     * A percentage value representing the degree of passenger occupancy of the vehicle.
     * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
     * The value 100 should represent the total maximum occupancy the vehicle was designed for,
     * including both seated and standing capacity, and current operating regulations allow.
     * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
     * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
     * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * This field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>optional uint32 occupancy_percentage = 10;</code>
     */
    boolean hasOccupancyPercentage();
    /**
     * <pre>
     * A percentage value representing the degree of passenger occupancy of the vehicle.
     * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
     * The value 100 should represent the total maximum occupancy the vehicle was designed for,
     * including both seated and standing capacity, and current operating regulations allow.
     * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
     * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
     * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * This field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>optional uint32 occupancy_percentage = 10;</code>
     */
    int getOccupancyPercentage();

    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    java.util.List<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails> 
        getMultiCarriageDetailsList();
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails getMultiCarriageDetails(int index);
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    int getMultiCarriageDetailsCount();
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    java.util.List<? extends com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder> 
        getMultiCarriageDetailsOrBuilderList();
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder getMultiCarriageDetailsOrBuilder(
        int index);
  }
  /**
   * <pre>
   * Realtime positioning information for a given vehicle.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.VehiclePosition}
   */
  public  static final class VehiclePosition extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        VehiclePosition> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.VehiclePosition)
      VehiclePositionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use VehiclePosition.newBuilder() to construct.
    private VehiclePosition(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.VehiclePosition, ?> builder) {
      super(builder);
    }
    private VehiclePosition() {
      stopId_ = "";
      currentStatus_ = 2;
      congestionLevel_ = 0;
      occupancyStatus_ = 0;
      multiCarriageDetails_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private VehiclePosition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder subBuilder = null;
              if (((bitField0_ & 0x00000001) != 0)) {
                subBuilder = trip_.toBuilder();
              }
              trip_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TripDescriptor.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(trip_);
                trip_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000001;
              break;
            }
            case 18: {
              com.google.transit.realtime.GtfsRealtime.Position.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) != 0)) {
                subBuilder = position_.toBuilder();
              }
              position_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.Position.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(position_);
                position_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 24: {
              bitField0_ |= 0x00000008;
              currentStopSequence_ = input.readUInt32();
              break;
            }
            case 32: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus value = com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(4, rawValue);
              } else {
                bitField0_ |= 0x00000020;
                currentStatus_ = rawValue;
              }
              break;
            }
            case 40: {
              bitField0_ |= 0x00000040;
              timestamp_ = input.readUInt64();
              break;
            }
            case 48: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel value = com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(6, rawValue);
              } else {
                bitField0_ |= 0x00000080;
                congestionLevel_ = rawValue;
              }
              break;
            }
            case 58: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000010;
              stopId_ = bs;
              break;
            }
            case 66: {
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) != 0)) {
                subBuilder = vehicle_.toBuilder();
              }
              vehicle_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(vehicle_);
                vehicle_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 72: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus value = com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(9, rawValue);
              } else {
                bitField0_ |= 0x00000100;
                occupancyStatus_ = rawValue;
              }
              break;
            }
            case 80: {
              bitField0_ |= 0x00000200;
              occupancyPercentage_ = input.readUInt32();
              break;
            }
            case 90: {
              if (!((mutable_bitField0_ & 0x00000400) != 0)) {
                multiCarriageDetails_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails>();
                mutable_bitField0_ |= 0x00000400;
              }
              multiCarriageDetails_.add(
                  input.readMessage(com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.PARSER, extensionRegistry));
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000400) != 0)) {
          multiCarriageDetails_ = java.util.Collections.unmodifiableList(multiCarriageDetails_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.class, com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder.class);
    }

    /**
     * Protobuf enum {@code transit_realtime.VehiclePosition.VehicleStopStatus}
     */
    public enum VehicleStopStatus
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * The vehicle is just about to arrive at the stop (on a stop
       * display, the vehicle symbol typically flashes).
       * </pre>
       *
       * <code>INCOMING_AT = 0;</code>
       */
      INCOMING_AT(0),
      /**
       * <pre>
       * The vehicle is standing at the stop.
       * </pre>
       *
       * <code>STOPPED_AT = 1;</code>
       */
      STOPPED_AT(1),
      /**
       * <pre>
       * The vehicle has departed and is in transit to the next stop.
       * </pre>
       *
       * <code>IN_TRANSIT_TO = 2;</code>
       */
      IN_TRANSIT_TO(2),
      ;

      /**
       * <pre>
       * The vehicle is just about to arrive at the stop (on a stop
       * display, the vehicle symbol typically flashes).
       * </pre>
       *
       * <code>INCOMING_AT = 0;</code>
       */
      public static final int INCOMING_AT_VALUE = 0;
      /**
       * <pre>
       * The vehicle is standing at the stop.
       * </pre>
       *
       * <code>STOPPED_AT = 1;</code>
       */
      public static final int STOPPED_AT_VALUE = 1;
      /**
       * <pre>
       * The vehicle has departed and is in transit to the next stop.
       * </pre>
       *
       * <code>IN_TRANSIT_TO = 2;</code>
       */
      public static final int IN_TRANSIT_TO_VALUE = 2;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static VehicleStopStatus valueOf(int value) {
        return forNumber(value);
      }

      public static VehicleStopStatus forNumber(int value) {
        switch (value) {
          case 0: return INCOMING_AT;
          case 1: return STOPPED_AT;
          case 2: return IN_TRANSIT_TO;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<VehicleStopStatus>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          VehicleStopStatus> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<VehicleStopStatus>() {
              public VehicleStopStatus findValueByNumber(int number) {
                return VehicleStopStatus.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDescriptor().getEnumTypes().get(0);
      }

      private static final VehicleStopStatus[] VALUES = values();

      public static VehicleStopStatus valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private VehicleStopStatus(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.VehiclePosition.VehicleStopStatus)
    }

    /**
     * <pre>
     * Congestion level that is affecting this vehicle.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.VehiclePosition.CongestionLevel}
     */
    public enum CongestionLevel
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>UNKNOWN_CONGESTION_LEVEL = 0;</code>
       */
      UNKNOWN_CONGESTION_LEVEL(0),
      /**
       * <code>RUNNING_SMOOTHLY = 1;</code>
       */
      RUNNING_SMOOTHLY(1),
      /**
       * <code>STOP_AND_GO = 2;</code>
       */
      STOP_AND_GO(2),
      /**
       * <code>CONGESTION = 3;</code>
       */
      CONGESTION(3),
      /**
       * <pre>
       * People leaving their cars.
       * </pre>
       *
       * <code>SEVERE_CONGESTION = 4;</code>
       */
      SEVERE_CONGESTION(4),
      ;

      /**
       * <code>UNKNOWN_CONGESTION_LEVEL = 0;</code>
       */
      public static final int UNKNOWN_CONGESTION_LEVEL_VALUE = 0;
      /**
       * <code>RUNNING_SMOOTHLY = 1;</code>
       */
      public static final int RUNNING_SMOOTHLY_VALUE = 1;
      /**
       * <code>STOP_AND_GO = 2;</code>
       */
      public static final int STOP_AND_GO_VALUE = 2;
      /**
       * <code>CONGESTION = 3;</code>
       */
      public static final int CONGESTION_VALUE = 3;
      /**
       * <pre>
       * People leaving their cars.
       * </pre>
       *
       * <code>SEVERE_CONGESTION = 4;</code>
       */
      public static final int SEVERE_CONGESTION_VALUE = 4;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static CongestionLevel valueOf(int value) {
        return forNumber(value);
      }

      public static CongestionLevel forNumber(int value) {
        switch (value) {
          case 0: return UNKNOWN_CONGESTION_LEVEL;
          case 1: return RUNNING_SMOOTHLY;
          case 2: return STOP_AND_GO;
          case 3: return CONGESTION;
          case 4: return SEVERE_CONGESTION;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<CongestionLevel>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          CongestionLevel> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<CongestionLevel>() {
              public CongestionLevel findValueByNumber(int number) {
                return CongestionLevel.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDescriptor().getEnumTypes().get(1);
      }

      private static final CongestionLevel[] VALUES = values();

      public static CongestionLevel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private CongestionLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.VehiclePosition.CongestionLevel)
    }

    /**
     * <pre>
     * The degree of passenger occupancy of the vehicle or carriage. This field is still
     * experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.VehiclePosition.OccupancyStatus}
     */
    public enum OccupancyStatus
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * The vehicle or carriage is considered empty by most measures, and has few or no
       * passengers onboard, but is still accepting passengers.
       * </pre>
       *
       * <code>EMPTY = 0;</code>
       */
      EMPTY(0),
      /**
       * <pre>
       * The vehicle or carriage has a relatively large percentage of seats available.
       * What percentage of free seats out of the total seats available is to be
       * considered large enough to fall into this category is determined at the
       * discretion of the producer.
       * </pre>
       *
       * <code>MANY_SEATS_AVAILABLE = 1;</code>
       */
      MANY_SEATS_AVAILABLE(1),
      /**
       * <pre>
       * The vehicle or carriage has a relatively small percentage of seats available.
       * What percentage of free seats out of the total seats available is to be
       * considered small enough to fall into this category is determined at the
       * discretion of the feed producer.
       * </pre>
       *
       * <code>FEW_SEATS_AVAILABLE = 2;</code>
       */
      FEW_SEATS_AVAILABLE(2),
      /**
       * <pre>
       * The vehicle or carriage can currently accommodate only standing passengers.
       * </pre>
       *
       * <code>STANDING_ROOM_ONLY = 3;</code>
       */
      STANDING_ROOM_ONLY(3),
      /**
       * <pre>
       * The vehicle or carriage can currently accommodate only standing passengers
       * and has limited space for them.
       * </pre>
       *
       * <code>CRUSHED_STANDING_ROOM_ONLY = 4;</code>
       */
      CRUSHED_STANDING_ROOM_ONLY(4),
      /**
       * <pre>
       * The vehicle or carriage is considered full by most measures, but may still be
       * allowing passengers to board.
       * </pre>
       *
       * <code>FULL = 5;</code>
       */
      FULL(5),
      /**
       * <pre>
       * The vehicle or carriage is not accepting passengers, but usually accepts passengers for boarding.
       * </pre>
       *
       * <code>NOT_ACCEPTING_PASSENGERS = 6;</code>
       */
      NOT_ACCEPTING_PASSENGERS(6),
      /**
       * <pre>
       * The vehicle or carriage doesn't have any occupancy data available at that time.
       * </pre>
       *
       * <code>NO_DATA_AVAILABLE = 7;</code>
       */
      NO_DATA_AVAILABLE(7),
      /**
       * <pre>
       * The vehicle or carriage is not boardable and never accepts passengers.
       * Useful for special vehicles or carriages (engine, maintenance carriage, etc…).
       * </pre>
       *
       * <code>NOT_BOARDABLE = 8;</code>
       */
      NOT_BOARDABLE(8),
      ;

      /**
       * <pre>
       * The vehicle or carriage is considered empty by most measures, and has few or no
       * passengers onboard, but is still accepting passengers.
       * </pre>
       *
       * <code>EMPTY = 0;</code>
       */
      public static final int EMPTY_VALUE = 0;
      /**
       * <pre>
       * The vehicle or carriage has a relatively large percentage of seats available.
       * What percentage of free seats out of the total seats available is to be
       * considered large enough to fall into this category is determined at the
       * discretion of the producer.
       * </pre>
       *
       * <code>MANY_SEATS_AVAILABLE = 1;</code>
       */
      public static final int MANY_SEATS_AVAILABLE_VALUE = 1;
      /**
       * <pre>
       * The vehicle or carriage has a relatively small percentage of seats available.
       * What percentage of free seats out of the total seats available is to be
       * considered small enough to fall into this category is determined at the
       * discretion of the feed producer.
       * </pre>
       *
       * <code>FEW_SEATS_AVAILABLE = 2;</code>
       */
      public static final int FEW_SEATS_AVAILABLE_VALUE = 2;
      /**
       * <pre>
       * The vehicle or carriage can currently accommodate only standing passengers.
       * </pre>
       *
       * <code>STANDING_ROOM_ONLY = 3;</code>
       */
      public static final int STANDING_ROOM_ONLY_VALUE = 3;
      /**
       * <pre>
       * The vehicle or carriage can currently accommodate only standing passengers
       * and has limited space for them.
       * </pre>
       *
       * <code>CRUSHED_STANDING_ROOM_ONLY = 4;</code>
       */
      public static final int CRUSHED_STANDING_ROOM_ONLY_VALUE = 4;
      /**
       * <pre>
       * The vehicle or carriage is considered full by most measures, but may still be
       * allowing passengers to board.
       * </pre>
       *
       * <code>FULL = 5;</code>
       */
      public static final int FULL_VALUE = 5;
      /**
       * <pre>
       * The vehicle or carriage is not accepting passengers, but usually accepts passengers for boarding.
       * </pre>
       *
       * <code>NOT_ACCEPTING_PASSENGERS = 6;</code>
       */
      public static final int NOT_ACCEPTING_PASSENGERS_VALUE = 6;
      /**
       * <pre>
       * The vehicle or carriage doesn't have any occupancy data available at that time.
       * </pre>
       *
       * <code>NO_DATA_AVAILABLE = 7;</code>
       */
      public static final int NO_DATA_AVAILABLE_VALUE = 7;
      /**
       * <pre>
       * The vehicle or carriage is not boardable and never accepts passengers.
       * Useful for special vehicles or carriages (engine, maintenance carriage, etc…).
       * </pre>
       *
       * <code>NOT_BOARDABLE = 8;</code>
       */
      public static final int NOT_BOARDABLE_VALUE = 8;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static OccupancyStatus valueOf(int value) {
        return forNumber(value);
      }

      public static OccupancyStatus forNumber(int value) {
        switch (value) {
          case 0: return EMPTY;
          case 1: return MANY_SEATS_AVAILABLE;
          case 2: return FEW_SEATS_AVAILABLE;
          case 3: return STANDING_ROOM_ONLY;
          case 4: return CRUSHED_STANDING_ROOM_ONLY;
          case 5: return FULL;
          case 6: return NOT_ACCEPTING_PASSENGERS;
          case 7: return NO_DATA_AVAILABLE;
          case 8: return NOT_BOARDABLE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<OccupancyStatus>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          OccupancyStatus> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<OccupancyStatus>() {
              public OccupancyStatus findValueByNumber(int number) {
                return OccupancyStatus.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDescriptor().getEnumTypes().get(2);
      }

      private static final OccupancyStatus[] VALUES = values();

      public static OccupancyStatus valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private OccupancyStatus(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.VehiclePosition.OccupancyStatus)
    }

    public interface CarriageDetailsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:transit_realtime.VehiclePosition.CarriageDetails)
        com.google.protobuf.GeneratedMessageV3.
            ExtendableMessageOrBuilder<CarriageDetails> {

      /**
       * <pre>
       * Identification of the carriage. Should be unique per vehicle.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      boolean hasId();
      /**
       * <pre>
       * Identification of the carriage. Should be unique per vehicle.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      java.lang.String getId();
      /**
       * <pre>
       * Identification of the carriage. Should be unique per vehicle.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      com.google.protobuf.ByteString
          getIdBytes();

      /**
       * <pre>
       * User visible label that may be shown to the passenger to help identify
       * the carriage. Example: "7712", "Car ABC-32", etc...
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string label = 2;</code>
       */
      boolean hasLabel();
      /**
       * <pre>
       * User visible label that may be shown to the passenger to help identify
       * the carriage. Example: "7712", "Car ABC-32", etc...
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string label = 2;</code>
       */
      java.lang.String getLabel();
      /**
       * <pre>
       * User visible label that may be shown to the passenger to help identify
       * the carriage. Example: "7712", "Car ABC-32", etc...
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string label = 2;</code>
       */
      com.google.protobuf.ByteString
          getLabelBytes();

      /**
       * <pre>
       * Occupancy status for this given carriage, in this vehicle
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
       */
      boolean hasOccupancyStatus();
      /**
       * <pre>
       * Occupancy status for this given carriage, in this vehicle
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
       */
      com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus getOccupancyStatus();

      /**
       * <pre>
       * Occupancy percentage for this given carriage, in this vehicle.
       * Follows the same rules as "VehiclePosition.occupancy_percentage"
       * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
       */
      boolean hasOccupancyPercentage();
      /**
       * <pre>
       * Occupancy percentage for this given carriage, in this vehicle.
       * Follows the same rules as "VehiclePosition.occupancy_percentage"
       * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
       */
      int getOccupancyPercentage();

      /**
       * <pre>
       * Identifies the order of this carriage with respect to the other
       * carriages in the vehicle's list of CarriageDetails.
       * The first carriage in the direction of travel must have a value of 1.
       * The second value corresponds to the second carriage in the direction
       * of travel and must have a value of 2, and so forth.
       * For example, the first carriage in the direction of travel has a value of 1.
       * If the second carriage in the direction of travel has a value of 3,
       * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
       * Carriages without data must be represented with a valid carriage_sequence number and the fields 
       * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 carriage_sequence = 5;</code>
       */
      boolean hasCarriageSequence();
      /**
       * <pre>
       * Identifies the order of this carriage with respect to the other
       * carriages in the vehicle's list of CarriageDetails.
       * The first carriage in the direction of travel must have a value of 1.
       * The second value corresponds to the second carriage in the direction
       * of travel and must have a value of 2, and so forth.
       * For example, the first carriage in the direction of travel has a value of 1.
       * If the second carriage in the direction of travel has a value of 3,
       * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
       * Carriages without data must be represented with a valid carriage_sequence number and the fields 
       * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 carriage_sequence = 5;</code>
       */
      int getCarriageSequence();
    }
    /**
     * <pre>
     * Carriage specific details, used for vehicles composed of several carriages
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.VehiclePosition.CarriageDetails}
     */
    public  static final class CarriageDetails extends
        com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
          CarriageDetails> implements
        // @@protoc_insertion_point(message_implements:transit_realtime.VehiclePosition.CarriageDetails)
        CarriageDetailsOrBuilder {
    private static final long serialVersionUID = 0L;
      // Use CarriageDetails.newBuilder() to construct.
      private CarriageDetails(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, ?> builder) {
        super(builder);
      }
      private CarriageDetails() {
        id_ = "";
        label_ = "";
        occupancyStatus_ = 7;
        occupancyPercentage_ = -1;
      }

      @java.lang.Override
      public final com.google.protobuf.UnknownFieldSet
      getUnknownFields() {
        return this.unknownFields;
      }
      private CarriageDetails(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        int mutable_bitField0_ = 0;
        com.google.protobuf.UnknownFieldSet.Builder unknownFields =
            com.google.protobuf.UnknownFieldSet.newBuilder();
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                id_ = bs;
                break;
              }
              case 18: {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                label_ = bs;
                break;
              }
              case 24: {
                int rawValue = input.readEnum();
                  @SuppressWarnings("deprecation")
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus value = com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.valueOf(rawValue);
                if (value == null) {
                  unknownFields.mergeVarintField(3, rawValue);
                } else {
                  bitField0_ |= 0x00000004;
                  occupancyStatus_ = rawValue;
                }
                break;
              }
              case 32: {
                bitField0_ |= 0x00000008;
                occupancyPercentage_ = input.readInt32();
                break;
              }
              case 40: {
                bitField0_ |= 0x00000010;
                carriageSequence_ = input.readUInt32();
                break;
              }
              default: {
                if (!parseUnknownField(
                    input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
            }
          }
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(this);
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(
              e).setUnfinishedMessage(this);
        } finally {
          this.unknownFields = unknownFields.build();
          makeExtensionsImmutable();
        }
      }
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_CarriageDetails_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_CarriageDetails_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.class, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder.class);
      }

      private int bitField0_;
      public static final int ID_FIELD_NUMBER = 1;
      private volatile java.lang.Object id_;
      /**
       * <pre>
       * Identification of the carriage. Should be unique per vehicle.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Identification of the carriage. Should be unique per vehicle.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            id_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * Identification of the carriage. Should be unique per vehicle.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int LABEL_FIELD_NUMBER = 2;
      private volatile java.lang.Object label_;
      /**
       * <pre>
       * User visible label that may be shown to the passenger to help identify
       * the carriage. Example: "7712", "Car ABC-32", etc...
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string label = 2;</code>
       */
      public boolean hasLabel() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * User visible label that may be shown to the passenger to help identify
       * the carriage. Example: "7712", "Car ABC-32", etc...
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string label = 2;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            label_ = s;
          }
          return s;
        }
      }
      /**
       * <pre>
       * User visible label that may be shown to the passenger to help identify
       * the carriage. Example: "7712", "Car ABC-32", etc...
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional string label = 2;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int OCCUPANCY_STATUS_FIELD_NUMBER = 3;
      private int occupancyStatus_;
      /**
       * <pre>
       * Occupancy status for this given carriage, in this vehicle
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
       */
      public boolean hasOccupancyStatus() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Occupancy status for this given carriage, in this vehicle
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus getOccupancyStatus() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.valueOf(occupancyStatus_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.NO_DATA_AVAILABLE : result;
      }

      public static final int OCCUPANCY_PERCENTAGE_FIELD_NUMBER = 4;
      private int occupancyPercentage_;
      /**
       * <pre>
       * Occupancy percentage for this given carriage, in this vehicle.
       * Follows the same rules as "VehiclePosition.occupancy_percentage"
       * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
       */
      public boolean hasOccupancyPercentage() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Occupancy percentage for this given carriage, in this vehicle.
       * Follows the same rules as "VehiclePosition.occupancy_percentage"
       * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
       */
      public int getOccupancyPercentage() {
        return occupancyPercentage_;
      }

      public static final int CARRIAGE_SEQUENCE_FIELD_NUMBER = 5;
      private int carriageSequence_;
      /**
       * <pre>
       * Identifies the order of this carriage with respect to the other
       * carriages in the vehicle's list of CarriageDetails.
       * The first carriage in the direction of travel must have a value of 1.
       * The second value corresponds to the second carriage in the direction
       * of travel and must have a value of 2, and so forth.
       * For example, the first carriage in the direction of travel has a value of 1.
       * If the second carriage in the direction of travel has a value of 3,
       * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
       * Carriages without data must be represented with a valid carriage_sequence number and the fields 
       * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 carriage_sequence = 5;</code>
       */
      public boolean hasCarriageSequence() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * Identifies the order of this carriage with respect to the other
       * carriages in the vehicle's list of CarriageDetails.
       * The first carriage in the direction of travel must have a value of 1.
       * The second value corresponds to the second carriage in the direction
       * of travel and must have a value of 2, and so forth.
       * For example, the first carriage in the direction of travel has a value of 1.
       * If the second carriage in the direction of travel has a value of 3,
       * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
       * Carriages without data must be represented with a valid carriage_sequence number and the fields 
       * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 carriage_sequence = 5;</code>
       */
      public int getCarriageSequence() {
        return carriageSequence_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!extensionsAreInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        com.google.protobuf.GeneratedMessageV3
          .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails>.ExtensionWriter
            extensionWriter = newExtensionWriter();
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          output.writeEnum(3, occupancyStatus_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          output.writeInt32(4, occupancyPercentage_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          output.writeUInt32(5, carriageSequence_);
        }
        extensionWriter.writeUntil(2000, output);
        extensionWriter.writeUntil(10000, output);
        unknownFields.writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
        }
        if (((bitField0_ & 0x00000004) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(3, occupancyStatus_);
        }
        if (((bitField0_ & 0x00000008) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeInt32Size(4, occupancyPercentage_);
        }
        if (((bitField0_ & 0x00000010) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(5, carriageSequence_);
        }
        size += extensionsSerializedSize();
        size += unknownFields.getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails)) {
          return super.equals(obj);
        }
        com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails other = (com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails) obj;

        if (hasId() != other.hasId()) return false;
        if (hasId()) {
          if (!getId()
              .equals(other.getId())) return false;
        }
        if (hasLabel() != other.hasLabel()) return false;
        if (hasLabel()) {
          if (!getLabel()
              .equals(other.getLabel())) return false;
        }
        if (hasOccupancyStatus() != other.hasOccupancyStatus()) return false;
        if (hasOccupancyStatus()) {
          if (occupancyStatus_ != other.occupancyStatus_) return false;
        }
        if (hasOccupancyPercentage() != other.hasOccupancyPercentage()) return false;
        if (hasOccupancyPercentage()) {
          if (getOccupancyPercentage()
              != other.getOccupancyPercentage()) return false;
        }
        if (hasCarriageSequence() != other.hasCarriageSequence()) return false;
        if (hasCarriageSequence()) {
          if (getCarriageSequence()
              != other.getCarriageSequence()) return false;
        }
        if (!unknownFields.equals(other.unknownFields)) return false;
        if (!getExtensionFields().equals(other.getExtensionFields()))
          return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasId()) {
          hash = (37 * hash) + ID_FIELD_NUMBER;
          hash = (53 * hash) + getId().hashCode();
        }
        if (hasLabel()) {
          hash = (37 * hash) + LABEL_FIELD_NUMBER;
          hash = (53 * hash) + getLabel().hashCode();
        }
        if (hasOccupancyStatus()) {
          hash = (37 * hash) + OCCUPANCY_STATUS_FIELD_NUMBER;
          hash = (53 * hash) + occupancyStatus_;
        }
        if (hasOccupancyPercentage()) {
          hash = (37 * hash) + OCCUPANCY_PERCENTAGE_FIELD_NUMBER;
          hash = (53 * hash) + getOccupancyPercentage();
        }
        if (hasCarriageSequence()) {
          hash = (37 * hash) + CARRIAGE_SEQUENCE_FIELD_NUMBER;
          hash = (53 * hash) + getCarriageSequence();
        }
        hash = hashFields(hash, getExtensionFields());
        hash = (29 * hash) + unknownFields.hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input);
      }
      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * Carriage specific details, used for vehicles composed of several carriages
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * Protobuf type {@code transit_realtime.VehiclePosition.CarriageDetails}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
            com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, Builder> implements
          // @@protoc_insertion_point(builder_implements:transit_realtime.VehiclePosition.CarriageDetails)
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_CarriageDetails_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_CarriageDetails_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.class, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder.class);
        }

        // Construct using com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3
                  .alwaysUseFieldBuilders) {
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          id_ = "";
          bitField0_ = (bitField0_ & ~0x00000001);
          label_ = "";
          bitField0_ = (bitField0_ & ~0x00000002);
          occupancyStatus_ = 7;
          bitField0_ = (bitField0_ & ~0x00000004);
          occupancyPercentage_ = -1;
          bitField0_ = (bitField0_ & ~0x00000008);
          carriageSequence_ = 0;
          bitField0_ = (bitField0_ & ~0x00000010);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_CarriageDetails_descriptor;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails getDefaultInstanceForType() {
          return com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails build() {
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails buildPartial() {
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails result = new com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails(this);
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            to_bitField0_ |= 0x00000001;
          }
          result.id_ = id_;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            to_bitField0_ |= 0x00000002;
          }
          result.label_ = label_;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            to_bitField0_ |= 0x00000004;
          }
          result.occupancyStatus_ = occupancyStatus_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            to_bitField0_ |= 0x00000008;
          }
          result.occupancyPercentage_ = occupancyPercentage_;
          if (((from_bitField0_ & 0x00000010) != 0)) {
            result.carriageSequence_ = carriageSequence_;
            to_bitField0_ |= 0x00000010;
          }
          result.bitField0_ = to_bitField0_;
          onBuilt();
          return result;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }
        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.setField(field, value);
        }
        @java.lang.Override
        public Builder clearField(
            com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }
        @java.lang.Override
        public Builder clearOneof(
            com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }
        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index, java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }
        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, Type> extension,
            Type value) {
          return super.setExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder setExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, java.util.List<Type>> extension,
            int index, Type value) {
          return super.setExtension(extension, index, value);
        }
        @java.lang.Override
        public <Type> Builder addExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, java.util.List<Type>> extension,
            Type value) {
          return super.addExtension(extension, value);
        }
        @java.lang.Override
        public <Type> Builder clearExtension(
            com.google.protobuf.GeneratedMessage.GeneratedExtension<
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, ?> extension) {
          return super.clearExtension(extension);
        }
        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails) {
            return mergeFrom((com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails other) {
          if (other == com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.getDefaultInstance()) return this;
          if (other.hasId()) {
            bitField0_ |= 0x00000001;
            id_ = other.id_;
            onChanged();
          }
          if (other.hasLabel()) {
            bitField0_ |= 0x00000002;
            label_ = other.label_;
            onChanged();
          }
          if (other.hasOccupancyStatus()) {
            setOccupancyStatus(other.getOccupancyStatus());
          }
          if (other.hasOccupancyPercentage()) {
            setOccupancyPercentage(other.getOccupancyPercentage());
          }
          if (other.hasCarriageSequence()) {
            setCarriageSequence(other.getCarriageSequence());
          }
          this.mergeExtensionFields(other);
          this.mergeUnknownFields(other.unknownFields);
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!extensionsAreInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails parsedMessage = null;
          try {
            parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            parsedMessage = (com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails) e.getUnfinishedMessage();
            throw e.unwrapIOException();
          } finally {
            if (parsedMessage != null) {
              mergeFrom(parsedMessage);
            }
          }
          return this;
        }
        private int bitField0_;

        private java.lang.Object id_ = "";
        /**
         * <pre>
         * Identification of the carriage. Should be unique per vehicle.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         */
        public boolean hasId() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <pre>
         * Identification of the carriage. Should be unique per vehicle.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         */
        public java.lang.String getId() {
          java.lang.Object ref = id_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              id_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * Identification of the carriage. Should be unique per vehicle.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         */
        public com.google.protobuf.ByteString
            getIdBytes() {
          java.lang.Object ref = id_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            id_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * Identification of the carriage. Should be unique per vehicle.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         */
        public Builder setId(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          id_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Identification of the carriage. Should be unique per vehicle.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         */
        public Builder clearId() {
          bitField0_ = (bitField0_ & ~0x00000001);
          id_ = getDefaultInstance().getId();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Identification of the carriage. Should be unique per vehicle.
         * </pre>
         *
         * <code>optional string id = 1;</code>
         */
        public Builder setIdBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
          id_ = value;
          onChanged();
          return this;
        }

        private java.lang.Object label_ = "";
        /**
         * <pre>
         * User visible label that may be shown to the passenger to help identify
         * the carriage. Example: "7712", "Car ABC-32", etc...
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string label = 2;</code>
         */
        public boolean hasLabel() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <pre>
         * User visible label that may be shown to the passenger to help identify
         * the carriage. Example: "7712", "Car ABC-32", etc...
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string label = 2;</code>
         */
        public java.lang.String getLabel() {
          java.lang.Object ref = label_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              label_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <pre>
         * User visible label that may be shown to the passenger to help identify
         * the carriage. Example: "7712", "Car ABC-32", etc...
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string label = 2;</code>
         */
        public com.google.protobuf.ByteString
            getLabelBytes() {
          java.lang.Object ref = label_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            label_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <pre>
         * User visible label that may be shown to the passenger to help identify
         * the carriage. Example: "7712", "Car ABC-32", etc...
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string label = 2;</code>
         */
        public Builder setLabel(
            java.lang.String value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          label_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * User visible label that may be shown to the passenger to help identify
         * the carriage. Example: "7712", "Car ABC-32", etc...
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string label = 2;</code>
         */
        public Builder clearLabel() {
          bitField0_ = (bitField0_ & ~0x00000002);
          label_ = getDefaultInstance().getLabel();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * User visible label that may be shown to the passenger to help identify
         * the carriage. Example: "7712", "Car ABC-32", etc...
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional string label = 2;</code>
         */
        public Builder setLabelBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
          label_ = value;
          onChanged();
          return this;
        }

        private int occupancyStatus_ = 7;
        /**
         * <pre>
         * Occupancy status for this given carriage, in this vehicle
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
         */
        public boolean hasOccupancyStatus() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         * <pre>
         * Occupancy status for this given carriage, in this vehicle
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
         */
        public com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus getOccupancyStatus() {
          @SuppressWarnings("deprecation")
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.valueOf(occupancyStatus_);
          return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.NO_DATA_AVAILABLE : result;
        }
        /**
         * <pre>
         * Occupancy status for this given carriage, in this vehicle
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
         */
        public Builder setOccupancyStatus(com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000004;
          occupancyStatus_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Occupancy status for this given carriage, in this vehicle
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 3 [default = NO_DATA_AVAILABLE];</code>
         */
        public Builder clearOccupancyStatus() {
          bitField0_ = (bitField0_ & ~0x00000004);
          occupancyStatus_ = 7;
          onChanged();
          return this;
        }

        private int occupancyPercentage_ = -1;
        /**
         * <pre>
         * Occupancy percentage for this given carriage, in this vehicle.
         * Follows the same rules as "VehiclePosition.occupancy_percentage"
         * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
         */
        public boolean hasOccupancyPercentage() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         * <pre>
         * Occupancy percentage for this given carriage, in this vehicle.
         * Follows the same rules as "VehiclePosition.occupancy_percentage"
         * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
         */
        public int getOccupancyPercentage() {
          return occupancyPercentage_;
        }
        /**
         * <pre>
         * Occupancy percentage for this given carriage, in this vehicle.
         * Follows the same rules as "VehiclePosition.occupancy_percentage"
         * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
         */
        public Builder setOccupancyPercentage(int value) {
          bitField0_ |= 0x00000008;
          occupancyPercentage_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Occupancy percentage for this given carriage, in this vehicle.
         * Follows the same rules as "VehiclePosition.occupancy_percentage"
         * -1 in case data is not available for this given carriage (as protobuf defaults to 0 otherwise)
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional int32 occupancy_percentage = 4 [default = -1];</code>
         */
        public Builder clearOccupancyPercentage() {
          bitField0_ = (bitField0_ & ~0x00000008);
          occupancyPercentage_ = -1;
          onChanged();
          return this;
        }

        private int carriageSequence_ ;
        /**
         * <pre>
         * Identifies the order of this carriage with respect to the other
         * carriages in the vehicle's list of CarriageDetails.
         * The first carriage in the direction of travel must have a value of 1.
         * The second value corresponds to the second carriage in the direction
         * of travel and must have a value of 2, and so forth.
         * For example, the first carriage in the direction of travel has a value of 1.
         * If the second carriage in the direction of travel has a value of 3,
         * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
         * Carriages without data must be represented with a valid carriage_sequence number and the fields 
         * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional uint32 carriage_sequence = 5;</code>
         */
        public boolean hasCarriageSequence() {
          return ((bitField0_ & 0x00000010) != 0);
        }
        /**
         * <pre>
         * Identifies the order of this carriage with respect to the other
         * carriages in the vehicle's list of CarriageDetails.
         * The first carriage in the direction of travel must have a value of 1.
         * The second value corresponds to the second carriage in the direction
         * of travel and must have a value of 2, and so forth.
         * For example, the first carriage in the direction of travel has a value of 1.
         * If the second carriage in the direction of travel has a value of 3,
         * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
         * Carriages without data must be represented with a valid carriage_sequence number and the fields 
         * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional uint32 carriage_sequence = 5;</code>
         */
        public int getCarriageSequence() {
          return carriageSequence_;
        }
        /**
         * <pre>
         * Identifies the order of this carriage with respect to the other
         * carriages in the vehicle's list of CarriageDetails.
         * The first carriage in the direction of travel must have a value of 1.
         * The second value corresponds to the second carriage in the direction
         * of travel and must have a value of 2, and so forth.
         * For example, the first carriage in the direction of travel has a value of 1.
         * If the second carriage in the direction of travel has a value of 3,
         * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
         * Carriages without data must be represented with a valid carriage_sequence number and the fields 
         * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional uint32 carriage_sequence = 5;</code>
         */
        public Builder setCarriageSequence(int value) {
          bitField0_ |= 0x00000010;
          carriageSequence_ = value;
          onChanged();
          return this;
        }
        /**
         * <pre>
         * Identifies the order of this carriage with respect to the other
         * carriages in the vehicle's list of CarriageDetails.
         * The first carriage in the direction of travel must have a value of 1.
         * The second value corresponds to the second carriage in the direction
         * of travel and must have a value of 2, and so forth.
         * For example, the first carriage in the direction of travel has a value of 1.
         * If the second carriage in the direction of travel has a value of 3,
         * consumers will discard data for all carriages (i.e., the multi_carriage_details field).
         * Carriages without data must be represented with a valid carriage_sequence number and the fields 
         * without data should be omitted (alternately, those fields could also be included and set to the "no data" values).
         * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
         * </pre>
         *
         * <code>optional uint32 carriage_sequence = 5;</code>
         */
        public Builder clearCarriageSequence() {
          bitField0_ = (bitField0_ & ~0x00000010);
          carriageSequence_ = 0;
          onChanged();
          return this;
        }
        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }


        // @@protoc_insertion_point(builder_scope:transit_realtime.VehiclePosition.CarriageDetails)
      }

      // @@protoc_insertion_point(class_scope:transit_realtime.VehiclePosition.CarriageDetails)
      private static final com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails();
      }

      public static com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      @java.lang.Deprecated public static final com.google.protobuf.Parser<CarriageDetails>
          PARSER = new com.google.protobuf.AbstractParser<CarriageDetails>() {
        @java.lang.Override
        public CarriageDetails parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new CarriageDetails(input, extensionRegistry);
        }
      };

      public static com.google.protobuf.Parser<CarriageDetails> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CarriageDetails> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int TRIP_FIELD_NUMBER = 1;
    private com.google.transit.realtime.GtfsRealtime.TripDescriptor trip_;
    /**
     * <pre>
     * The Trip that this vehicle is serving.
     * Can be empty or partial if the vehicle can not be identified with a given
     * trip instance.
     * </pre>
     *
     * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
     */
    public boolean hasTrip() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The Trip that this vehicle is serving.
     * Can be empty or partial if the vehicle can not be identified with a given
     * trip instance.
     * </pre>
     *
     * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripDescriptor getTrip() {
      return trip_ == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
    }
    /**
     * <pre>
     * The Trip that this vehicle is serving.
     * Can be empty or partial if the vehicle can not be identified with a given
     * trip instance.
     * </pre>
     *
     * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder getTripOrBuilder() {
      return trip_ == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
    }

    public static final int VEHICLE_FIELD_NUMBER = 8;
    private com.google.transit.realtime.GtfsRealtime.VehicleDescriptor vehicle_;
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
     */
    public boolean hasVehicle() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getVehicle() {
      return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
    }
    /**
     * <pre>
     * Additional information on the vehicle that is serving this trip.
     * </pre>
     *
     * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder getVehicleOrBuilder() {
      return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
    }

    public static final int POSITION_FIELD_NUMBER = 2;
    private com.google.transit.realtime.GtfsRealtime.Position position_;
    /**
     * <pre>
     * Current position of this vehicle.
     * </pre>
     *
     * <code>optional .transit_realtime.Position position = 2;</code>
     */
    public boolean hasPosition() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Current position of this vehicle.
     * </pre>
     *
     * <code>optional .transit_realtime.Position position = 2;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.Position getPosition() {
      return position_ == null ? com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance() : position_;
    }
    /**
     * <pre>
     * Current position of this vehicle.
     * </pre>
     *
     * <code>optional .transit_realtime.Position position = 2;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.PositionOrBuilder getPositionOrBuilder() {
      return position_ == null ? com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance() : position_;
    }

    public static final int CURRENT_STOP_SEQUENCE_FIELD_NUMBER = 3;
    private int currentStopSequence_;
    /**
     * <pre>
     * The stop sequence index of the current stop. The meaning of
     * current_stop_sequence (i.e., the stop that it refers to) is determined by
     * current_status.
     * If current_status is missing IN_TRANSIT_TO is assumed.
     * </pre>
     *
     * <code>optional uint32 current_stop_sequence = 3;</code>
     */
    public boolean hasCurrentStopSequence() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * The stop sequence index of the current stop. The meaning of
     * current_stop_sequence (i.e., the stop that it refers to) is determined by
     * current_status.
     * If current_status is missing IN_TRANSIT_TO is assumed.
     * </pre>
     *
     * <code>optional uint32 current_stop_sequence = 3;</code>
     */
    public int getCurrentStopSequence() {
      return currentStopSequence_;
    }

    public static final int STOP_ID_FIELD_NUMBER = 7;
    private volatile java.lang.Object stopId_;
    /**
     * <pre>
     * Identifies the current stop. The value must be the same as in stops.txt in
     * the corresponding GTFS feed.
     * </pre>
     *
     * <code>optional string stop_id = 7;</code>
     */
    public boolean hasStopId() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Identifies the current stop. The value must be the same as in stops.txt in
     * the corresponding GTFS feed.
     * </pre>
     *
     * <code>optional string stop_id = 7;</code>
     */
    public java.lang.String getStopId() {
      java.lang.Object ref = stopId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          stopId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Identifies the current stop. The value must be the same as in stops.txt in
     * the corresponding GTFS feed.
     * </pre>
     *
     * <code>optional string stop_id = 7;</code>
     */
    public com.google.protobuf.ByteString
        getStopIdBytes() {
      java.lang.Object ref = stopId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stopId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CURRENT_STATUS_FIELD_NUMBER = 4;
    private int currentStatus_;
    /**
     * <pre>
     * The exact status of the vehicle with respect to the current stop.
     * Ignored if current_stop_sequence is missing.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
     */
    public boolean hasCurrentStatus() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * The exact status of the vehicle with respect to the current stop.
     * Ignored if current_stop_sequence is missing.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus getCurrentStatus() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus.valueOf(currentStatus_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus.IN_TRANSIT_TO : result;
    }

    public static final int TIMESTAMP_FIELD_NUMBER = 5;
    private long timestamp_;
    /**
     * <pre>
     * Moment at which the vehicle's position was measured. In POSIX time
     * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 5;</code>
     */
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Moment at which the vehicle's position was measured. In POSIX time
     * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
     * </pre>
     *
     * <code>optional uint64 timestamp = 5;</code>
     */
    public long getTimestamp() {
      return timestamp_;
    }

    public static final int CONGESTION_LEVEL_FIELD_NUMBER = 6;
    private int congestionLevel_;
    /**
     * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
     */
    public boolean hasCongestionLevel() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel getCongestionLevel() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel.valueOf(congestionLevel_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel.UNKNOWN_CONGESTION_LEVEL : result;
    }

    public static final int OCCUPANCY_STATUS_FIELD_NUMBER = 9;
    private int occupancyStatus_;
    /**
     * <pre>
     * If multi_carriage_status is populated with per-carriage OccupancyStatus,
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
     */
    public boolean hasOccupancyStatus() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * If multi_carriage_status is populated with per-carriage OccupancyStatus,
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * </pre>
     *
     * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus getOccupancyStatus() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.valueOf(occupancyStatus_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.EMPTY : result;
    }

    public static final int OCCUPANCY_PERCENTAGE_FIELD_NUMBER = 10;
    private int occupancyPercentage_;
    /**
     * <pre>
     * A percentage value representing the degree of passenger occupancy of the vehicle.
     * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
     * The value 100 should represent the total maximum occupancy the vehicle was designed for,
     * including both seated and standing capacity, and current operating regulations allow.
     * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
     * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
     * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * This field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>optional uint32 occupancy_percentage = 10;</code>
     */
    public boolean hasOccupancyPercentage() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * A percentage value representing the degree of passenger occupancy of the vehicle.
     * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
     * The value 100 should represent the total maximum occupancy the vehicle was designed for,
     * including both seated and standing capacity, and current operating regulations allow.
     * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
     * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
     * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
     * then this field should describe the entire vehicle with all carriages accepting passengers considered.
     * This field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>optional uint32 occupancy_percentage = 10;</code>
     */
    public int getOccupancyPercentage() {
      return occupancyPercentage_;
    }

    public static final int MULTI_CARRIAGE_DETAILS_FIELD_NUMBER = 11;
    private java.util.List<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails> multiCarriageDetails_;
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    public java.util.List<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails> getMultiCarriageDetailsList() {
      return multiCarriageDetails_;
    }
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder> 
        getMultiCarriageDetailsOrBuilderList() {
      return multiCarriageDetails_;
    }
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    public int getMultiCarriageDetailsCount() {
      return multiCarriageDetails_.size();
    }
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails getMultiCarriageDetails(int index) {
      return multiCarriageDetails_.get(index);
    }
    /**
     * <pre>
     * Details of the multiple carriages of this given vehicle.
     * The first occurrence represents the first carriage of the vehicle, 
     * given the current direction of travel. 
     * The number of occurrences of the multi_carriage_details 
     * field represents the number of carriages of the vehicle.
     * It also includes non boardable carriages, 
     * like engines, maintenance carriages, etc… as they provide valuable 
     * information to passengers about where to stand on a platform.
     * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
     * </pre>
     *
     * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder getMultiCarriageDetailsOrBuilder(
        int index) {
      return multiCarriageDetails_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (hasTrip()) {
        if (!getTrip().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasVehicle()) {
        if (!getVehicle().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasPosition()) {
        if (!getPosition().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getMultiCarriageDetailsCount(); i++) {
        if (!getMultiCarriageDetails(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.VehiclePosition>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTrip());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(2, getPosition());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeUInt32(3, currentStopSequence_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeEnum(4, currentStatus_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeUInt64(5, timestamp_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeEnum(6, congestionLevel_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, stopId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(8, getVehicle());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        output.writeEnum(9, occupancyStatus_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        output.writeUInt32(10, occupancyPercentage_);
      }
      for (int i = 0; i < multiCarriageDetails_.size(); i++) {
        output.writeMessage(11, multiCarriageDetails_.get(i));
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getTrip());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getPosition());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, currentStopSequence_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, currentStatus_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, timestamp_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(6, congestionLevel_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, stopId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getVehicle());
      }
      if (((bitField0_ & 0x00000100) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(9, occupancyStatus_);
      }
      if (((bitField0_ & 0x00000200) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(10, occupancyPercentage_);
      }
      for (int i = 0; i < multiCarriageDetails_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, multiCarriageDetails_.get(i));
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.VehiclePosition)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.VehiclePosition other = (com.google.transit.realtime.GtfsRealtime.VehiclePosition) obj;

      if (hasTrip() != other.hasTrip()) return false;
      if (hasTrip()) {
        if (!getTrip()
            .equals(other.getTrip())) return false;
      }
      if (hasVehicle() != other.hasVehicle()) return false;
      if (hasVehicle()) {
        if (!getVehicle()
            .equals(other.getVehicle())) return false;
      }
      if (hasPosition() != other.hasPosition()) return false;
      if (hasPosition()) {
        if (!getPosition()
            .equals(other.getPosition())) return false;
      }
      if (hasCurrentStopSequence() != other.hasCurrentStopSequence()) return false;
      if (hasCurrentStopSequence()) {
        if (getCurrentStopSequence()
            != other.getCurrentStopSequence()) return false;
      }
      if (hasStopId() != other.hasStopId()) return false;
      if (hasStopId()) {
        if (!getStopId()
            .equals(other.getStopId())) return false;
      }
      if (hasCurrentStatus() != other.hasCurrentStatus()) return false;
      if (hasCurrentStatus()) {
        if (currentStatus_ != other.currentStatus_) return false;
      }
      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (getTimestamp()
            != other.getTimestamp()) return false;
      }
      if (hasCongestionLevel() != other.hasCongestionLevel()) return false;
      if (hasCongestionLevel()) {
        if (congestionLevel_ != other.congestionLevel_) return false;
      }
      if (hasOccupancyStatus() != other.hasOccupancyStatus()) return false;
      if (hasOccupancyStatus()) {
        if (occupancyStatus_ != other.occupancyStatus_) return false;
      }
      if (hasOccupancyPercentage() != other.hasOccupancyPercentage()) return false;
      if (hasOccupancyPercentage()) {
        if (getOccupancyPercentage()
            != other.getOccupancyPercentage()) return false;
      }
      if (!getMultiCarriageDetailsList()
          .equals(other.getMultiCarriageDetailsList())) return false;
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTrip()) {
        hash = (37 * hash) + TRIP_FIELD_NUMBER;
        hash = (53 * hash) + getTrip().hashCode();
      }
      if (hasVehicle()) {
        hash = (37 * hash) + VEHICLE_FIELD_NUMBER;
        hash = (53 * hash) + getVehicle().hashCode();
      }
      if (hasPosition()) {
        hash = (37 * hash) + POSITION_FIELD_NUMBER;
        hash = (53 * hash) + getPosition().hashCode();
      }
      if (hasCurrentStopSequence()) {
        hash = (37 * hash) + CURRENT_STOP_SEQUENCE_FIELD_NUMBER;
        hash = (53 * hash) + getCurrentStopSequence();
      }
      if (hasStopId()) {
        hash = (37 * hash) + STOP_ID_FIELD_NUMBER;
        hash = (53 * hash) + getStopId().hashCode();
      }
      if (hasCurrentStatus()) {
        hash = (37 * hash) + CURRENT_STATUS_FIELD_NUMBER;
        hash = (53 * hash) + currentStatus_;
      }
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getTimestamp());
      }
      if (hasCongestionLevel()) {
        hash = (37 * hash) + CONGESTION_LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + congestionLevel_;
      }
      if (hasOccupancyStatus()) {
        hash = (37 * hash) + OCCUPANCY_STATUS_FIELD_NUMBER;
        hash = (53 * hash) + occupancyStatus_;
      }
      if (hasOccupancyPercentage()) {
        hash = (37 * hash) + OCCUPANCY_PERCENTAGE_FIELD_NUMBER;
        hash = (53 * hash) + getOccupancyPercentage();
      }
      if (getMultiCarriageDetailsCount() > 0) {
        hash = (37 * hash) + MULTI_CARRIAGE_DETAILS_FIELD_NUMBER;
        hash = (53 * hash) + getMultiCarriageDetailsList().hashCode();
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.VehiclePosition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Realtime positioning information for a given vehicle.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.VehiclePosition}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.VehiclePosition, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.VehiclePosition)
        com.google.transit.realtime.GtfsRealtime.VehiclePositionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.VehiclePosition.class, com.google.transit.realtime.GtfsRealtime.VehiclePosition.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.VehiclePosition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getTripFieldBuilder();
          getVehicleFieldBuilder();
          getPositionFieldBuilder();
          getMultiCarriageDetailsFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (tripBuilder_ == null) {
          trip_ = null;
        } else {
          tripBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (vehicleBuilder_ == null) {
          vehicle_ = null;
        } else {
          vehicleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (positionBuilder_ == null) {
          position_ = null;
        } else {
          positionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        currentStopSequence_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        stopId_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        currentStatus_ = 2;
        bitField0_ = (bitField0_ & ~0x00000020);
        timestamp_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000040);
        congestionLevel_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        occupancyStatus_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        occupancyPercentage_ = 0;
        bitField0_ = (bitField0_ & ~0x00000200);
        if (multiCarriageDetailsBuilder_ == null) {
          multiCarriageDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000400);
        } else {
          multiCarriageDetailsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehiclePosition_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition build() {
        com.google.transit.realtime.GtfsRealtime.VehiclePosition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition buildPartial() {
        com.google.transit.realtime.GtfsRealtime.VehiclePosition result = new com.google.transit.realtime.GtfsRealtime.VehiclePosition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          if (tripBuilder_ == null) {
            result.trip_ = trip_;
          } else {
            result.trip_ = tripBuilder_.build();
          }
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          if (vehicleBuilder_ == null) {
            result.vehicle_ = vehicle_;
          } else {
            result.vehicle_ = vehicleBuilder_.build();
          }
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          if (positionBuilder_ == null) {
            result.position_ = position_;
          } else {
            result.position_ = positionBuilder_.build();
          }
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.currentStopSequence_ = currentStopSequence_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          to_bitField0_ |= 0x00000010;
        }
        result.stopId_ = stopId_;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          to_bitField0_ |= 0x00000020;
        }
        result.currentStatus_ = currentStatus_;
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.timestamp_ = timestamp_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          to_bitField0_ |= 0x00000080;
        }
        result.congestionLevel_ = congestionLevel_;
        if (((from_bitField0_ & 0x00000100) != 0)) {
          to_bitField0_ |= 0x00000100;
        }
        result.occupancyStatus_ = occupancyStatus_;
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.occupancyPercentage_ = occupancyPercentage_;
          to_bitField0_ |= 0x00000200;
        }
        if (multiCarriageDetailsBuilder_ == null) {
          if (((bitField0_ & 0x00000400) != 0)) {
            multiCarriageDetails_ = java.util.Collections.unmodifiableList(multiCarriageDetails_);
            bitField0_ = (bitField0_ & ~0x00000400);
          }
          result.multiCarriageDetails_ = multiCarriageDetails_;
        } else {
          result.multiCarriageDetails_ = multiCarriageDetailsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehiclePosition, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehiclePosition, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehiclePosition, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehiclePosition, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.VehiclePosition) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.VehiclePosition)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.VehiclePosition other) {
        if (other == com.google.transit.realtime.GtfsRealtime.VehiclePosition.getDefaultInstance()) return this;
        if (other.hasTrip()) {
          mergeTrip(other.getTrip());
        }
        if (other.hasVehicle()) {
          mergeVehicle(other.getVehicle());
        }
        if (other.hasPosition()) {
          mergePosition(other.getPosition());
        }
        if (other.hasCurrentStopSequence()) {
          setCurrentStopSequence(other.getCurrentStopSequence());
        }
        if (other.hasStopId()) {
          bitField0_ |= 0x00000010;
          stopId_ = other.stopId_;
          onChanged();
        }
        if (other.hasCurrentStatus()) {
          setCurrentStatus(other.getCurrentStatus());
        }
        if (other.hasTimestamp()) {
          setTimestamp(other.getTimestamp());
        }
        if (other.hasCongestionLevel()) {
          setCongestionLevel(other.getCongestionLevel());
        }
        if (other.hasOccupancyStatus()) {
          setOccupancyStatus(other.getOccupancyStatus());
        }
        if (other.hasOccupancyPercentage()) {
          setOccupancyPercentage(other.getOccupancyPercentage());
        }
        if (multiCarriageDetailsBuilder_ == null) {
          if (!other.multiCarriageDetails_.isEmpty()) {
            if (multiCarriageDetails_.isEmpty()) {
              multiCarriageDetails_ = other.multiCarriageDetails_;
              bitField0_ = (bitField0_ & ~0x00000400);
            } else {
              ensureMultiCarriageDetailsIsMutable();
              multiCarriageDetails_.addAll(other.multiCarriageDetails_);
            }
            onChanged();
          }
        } else {
          if (!other.multiCarriageDetails_.isEmpty()) {
            if (multiCarriageDetailsBuilder_.isEmpty()) {
              multiCarriageDetailsBuilder_.dispose();
              multiCarriageDetailsBuilder_ = null;
              multiCarriageDetails_ = other.multiCarriageDetails_;
              bitField0_ = (bitField0_ & ~0x00000400);
              multiCarriageDetailsBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getMultiCarriageDetailsFieldBuilder() : null;
            } else {
              multiCarriageDetailsBuilder_.addAllMessages(other.multiCarriageDetails_);
            }
          }
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (hasTrip()) {
          if (!getTrip().isInitialized()) {
            return false;
          }
        }
        if (hasVehicle()) {
          if (!getVehicle().isInitialized()) {
            return false;
          }
        }
        if (hasPosition()) {
          if (!getPosition().isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getMultiCarriageDetailsCount(); i++) {
          if (!getMultiCarriageDetails(i).isInitialized()) {
            return false;
          }
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.VehiclePosition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.VehiclePosition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.transit.realtime.GtfsRealtime.TripDescriptor trip_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripDescriptor, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder> tripBuilder_;
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public boolean hasTrip() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor getTrip() {
        if (tripBuilder_ == null) {
          return trip_ == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
        } else {
          return tripBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder setTrip(com.google.transit.realtime.GtfsRealtime.TripDescriptor value) {
        if (tripBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          trip_ = value;
          onChanged();
        } else {
          tripBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder setTrip(
          com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder builderForValue) {
        if (tripBuilder_ == null) {
          trip_ = builderForValue.build();
          onChanged();
        } else {
          tripBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder mergeTrip(com.google.transit.realtime.GtfsRealtime.TripDescriptor value) {
        if (tripBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0) &&
              trip_ != null &&
              trip_ != com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance()) {
            trip_ =
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.newBuilder(trip_).mergeFrom(value).buildPartial();
          } else {
            trip_ = value;
          }
          onChanged();
        } else {
          tripBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public Builder clearTrip() {
        if (tripBuilder_ == null) {
          trip_ = null;
          onChanged();
        } else {
          tripBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder getTripBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTripFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder getTripOrBuilder() {
        if (tripBuilder_ != null) {
          return tripBuilder_.getMessageOrBuilder();
        } else {
          return trip_ == null ?
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance() : trip_;
        }
      }
      /**
       * <pre>
       * The Trip that this vehicle is serving.
       * Can be empty or partial if the vehicle can not be identified with a given
       * trip instance.
       * </pre>
       *
       * <code>optional .transit_realtime.TripDescriptor trip = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TripDescriptor, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder> 
          getTripFieldBuilder() {
        if (tripBuilder_ == null) {
          tripBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TripDescriptor, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder>(
                  getTrip(),
                  getParentForChildren(),
                  isClean());
          trip_ = null;
        }
        return tripBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.VehicleDescriptor vehicle_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder> vehicleBuilder_;
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public boolean hasVehicle() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getVehicle() {
        if (vehicleBuilder_ == null) {
          return vehicle_ == null ? com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
        } else {
          return vehicleBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public Builder setVehicle(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor value) {
        if (vehicleBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vehicle_ = value;
          onChanged();
        } else {
          vehicleBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public Builder setVehicle(
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder builderForValue) {
        if (vehicleBuilder_ == null) {
          vehicle_ = builderForValue.build();
          onChanged();
        } else {
          vehicleBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public Builder mergeVehicle(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor value) {
        if (vehicleBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
              vehicle_ != null &&
              vehicle_ != com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance()) {
            vehicle_ =
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.newBuilder(vehicle_).mergeFrom(value).buildPartial();
          } else {
            vehicle_ = value;
          }
          onChanged();
        } else {
          vehicleBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public Builder clearVehicle() {
        if (vehicleBuilder_ == null) {
          vehicle_ = null;
          onChanged();
        } else {
          vehicleBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder getVehicleBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getVehicleFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder getVehicleOrBuilder() {
        if (vehicleBuilder_ != null) {
          return vehicleBuilder_.getMessageOrBuilder();
        } else {
          return vehicle_ == null ?
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance() : vehicle_;
        }
      }
      /**
       * <pre>
       * Additional information on the vehicle that is serving this trip.
       * </pre>
       *
       * <code>optional .transit_realtime.VehicleDescriptor vehicle = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder> 
          getVehicleFieldBuilder() {
        if (vehicleBuilder_ == null) {
          vehicleBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder, com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder>(
                  getVehicle(),
                  getParentForChildren(),
                  isClean());
          vehicle_ = null;
        }
        return vehicleBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.Position position_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.Position, com.google.transit.realtime.GtfsRealtime.Position.Builder, com.google.transit.realtime.GtfsRealtime.PositionOrBuilder> positionBuilder_;
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public boolean hasPosition() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Position getPosition() {
        if (positionBuilder_ == null) {
          return position_ == null ? com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance() : position_;
        } else {
          return positionBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public Builder setPosition(com.google.transit.realtime.GtfsRealtime.Position value) {
        if (positionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          position_ = value;
          onChanged();
        } else {
          positionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public Builder setPosition(
          com.google.transit.realtime.GtfsRealtime.Position.Builder builderForValue) {
        if (positionBuilder_ == null) {
          position_ = builderForValue.build();
          onChanged();
        } else {
          positionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public Builder mergePosition(com.google.transit.realtime.GtfsRealtime.Position value) {
        if (positionBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
              position_ != null &&
              position_ != com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance()) {
            position_ =
              com.google.transit.realtime.GtfsRealtime.Position.newBuilder(position_).mergeFrom(value).buildPartial();
          } else {
            position_ = value;
          }
          onChanged();
        } else {
          positionBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public Builder clearPosition() {
        if (positionBuilder_ == null) {
          position_ = null;
          onChanged();
        } else {
          positionBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Position.Builder getPositionBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getPositionFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.PositionOrBuilder getPositionOrBuilder() {
        if (positionBuilder_ != null) {
          return positionBuilder_.getMessageOrBuilder();
        } else {
          return position_ == null ?
              com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance() : position_;
        }
      }
      /**
       * <pre>
       * Current position of this vehicle.
       * </pre>
       *
       * <code>optional .transit_realtime.Position position = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.Position, com.google.transit.realtime.GtfsRealtime.Position.Builder, com.google.transit.realtime.GtfsRealtime.PositionOrBuilder> 
          getPositionFieldBuilder() {
        if (positionBuilder_ == null) {
          positionBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.Position, com.google.transit.realtime.GtfsRealtime.Position.Builder, com.google.transit.realtime.GtfsRealtime.PositionOrBuilder>(
                  getPosition(),
                  getParentForChildren(),
                  isClean());
          position_ = null;
        }
        return positionBuilder_;
      }

      private int currentStopSequence_ ;
      /**
       * <pre>
       * The stop sequence index of the current stop. The meaning of
       * current_stop_sequence (i.e., the stop that it refers to) is determined by
       * current_status.
       * If current_status is missing IN_TRANSIT_TO is assumed.
       * </pre>
       *
       * <code>optional uint32 current_stop_sequence = 3;</code>
       */
      public boolean hasCurrentStopSequence() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * The stop sequence index of the current stop. The meaning of
       * current_stop_sequence (i.e., the stop that it refers to) is determined by
       * current_status.
       * If current_status is missing IN_TRANSIT_TO is assumed.
       * </pre>
       *
       * <code>optional uint32 current_stop_sequence = 3;</code>
       */
      public int getCurrentStopSequence() {
        return currentStopSequence_;
      }
      /**
       * <pre>
       * The stop sequence index of the current stop. The meaning of
       * current_stop_sequence (i.e., the stop that it refers to) is determined by
       * current_status.
       * If current_status is missing IN_TRANSIT_TO is assumed.
       * </pre>
       *
       * <code>optional uint32 current_stop_sequence = 3;</code>
       */
      public Builder setCurrentStopSequence(int value) {
        bitField0_ |= 0x00000008;
        currentStopSequence_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The stop sequence index of the current stop. The meaning of
       * current_stop_sequence (i.e., the stop that it refers to) is determined by
       * current_status.
       * If current_status is missing IN_TRANSIT_TO is assumed.
       * </pre>
       *
       * <code>optional uint32 current_stop_sequence = 3;</code>
       */
      public Builder clearCurrentStopSequence() {
        bitField0_ = (bitField0_ & ~0x00000008);
        currentStopSequence_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object stopId_ = "";
      /**
       * <pre>
       * Identifies the current stop. The value must be the same as in stops.txt in
       * the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 7;</code>
       */
      public boolean hasStopId() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * Identifies the current stop. The value must be the same as in stops.txt in
       * the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 7;</code>
       */
      public java.lang.String getStopId() {
        java.lang.Object ref = stopId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            stopId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Identifies the current stop. The value must be the same as in stops.txt in
       * the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 7;</code>
       */
      public com.google.protobuf.ByteString
          getStopIdBytes() {
        java.lang.Object ref = stopId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stopId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * Identifies the current stop. The value must be the same as in stops.txt in
       * the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 7;</code>
       */
      public Builder setStopId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        stopId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Identifies the current stop. The value must be the same as in stops.txt in
       * the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 7;</code>
       */
      public Builder clearStopId() {
        bitField0_ = (bitField0_ & ~0x00000010);
        stopId_ = getDefaultInstance().getStopId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Identifies the current stop. The value must be the same as in stops.txt in
       * the corresponding GTFS feed.
       * </pre>
       *
       * <code>optional string stop_id = 7;</code>
       */
      public Builder setStopIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        stopId_ = value;
        onChanged();
        return this;
      }

      private int currentStatus_ = 2;
      /**
       * <pre>
       * The exact status of the vehicle with respect to the current stop.
       * Ignored if current_stop_sequence is missing.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
       */
      public boolean hasCurrentStatus() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * The exact status of the vehicle with respect to the current stop.
       * Ignored if current_stop_sequence is missing.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus getCurrentStatus() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus.valueOf(currentStatus_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus.IN_TRANSIT_TO : result;
      }
      /**
       * <pre>
       * The exact status of the vehicle with respect to the current stop.
       * Ignored if current_stop_sequence is missing.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
       */
      public Builder setCurrentStatus(com.google.transit.realtime.GtfsRealtime.VehiclePosition.VehicleStopStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        currentStatus_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The exact status of the vehicle with respect to the current stop.
       * Ignored if current_stop_sequence is missing.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.VehicleStopStatus current_status = 4 [default = IN_TRANSIT_TO];</code>
       */
      public Builder clearCurrentStatus() {
        bitField0_ = (bitField0_ & ~0x00000020);
        currentStatus_ = 2;
        onChanged();
        return this;
      }

      private long timestamp_ ;
      /**
       * <pre>
       * Moment at which the vehicle's position was measured. In POSIX time
       * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 5;</code>
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       * Moment at which the vehicle's position was measured. In POSIX time
       * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 5;</code>
       */
      public long getTimestamp() {
        return timestamp_;
      }
      /**
       * <pre>
       * Moment at which the vehicle's position was measured. In POSIX time
       * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 5;</code>
       */
      public Builder setTimestamp(long value) {
        bitField0_ |= 0x00000040;
        timestamp_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Moment at which the vehicle's position was measured. In POSIX time
       * (i.e., number of seconds since January 1st 1970 00:00:00 UTC).
       * </pre>
       *
       * <code>optional uint64 timestamp = 5;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000040);
        timestamp_ = 0L;
        onChanged();
        return this;
      }

      private int congestionLevel_ = 0;
      /**
       * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
       */
      public boolean hasCongestionLevel() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel getCongestionLevel() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel.valueOf(congestionLevel_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel.UNKNOWN_CONGESTION_LEVEL : result;
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
       */
      public Builder setCongestionLevel(com.google.transit.realtime.GtfsRealtime.VehiclePosition.CongestionLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000080;
        congestionLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.VehiclePosition.CongestionLevel congestion_level = 6;</code>
       */
      public Builder clearCongestionLevel() {
        bitField0_ = (bitField0_ & ~0x00000080);
        congestionLevel_ = 0;
        onChanged();
        return this;
      }

      private int occupancyStatus_ = 0;
      /**
       * <pre>
       * If multi_carriage_status is populated with per-carriage OccupancyStatus,
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
       */
      public boolean hasOccupancyStatus() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       * If multi_carriage_status is populated with per-carriage OccupancyStatus,
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus getOccupancyStatus() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus result = com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.valueOf(occupancyStatus_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus.EMPTY : result;
      }
      /**
       * <pre>
       * If multi_carriage_status is populated with per-carriage OccupancyStatus,
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
       */
      public Builder setOccupancyStatus(com.google.transit.realtime.GtfsRealtime.VehiclePosition.OccupancyStatus value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000100;
        occupancyStatus_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * If multi_carriage_status is populated with per-carriage OccupancyStatus,
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * </pre>
       *
       * <code>optional .transit_realtime.VehiclePosition.OccupancyStatus occupancy_status = 9;</code>
       */
      public Builder clearOccupancyStatus() {
        bitField0_ = (bitField0_ & ~0x00000100);
        occupancyStatus_ = 0;
        onChanged();
        return this;
      }

      private int occupancyPercentage_ ;
      /**
       * <pre>
       * A percentage value representing the degree of passenger occupancy of the vehicle.
       * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
       * The value 100 should represent the total maximum occupancy the vehicle was designed for,
       * including both seated and standing capacity, and current operating regulations allow.
       * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
       * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
       * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 occupancy_percentage = 10;</code>
       */
      public boolean hasOccupancyPercentage() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <pre>
       * A percentage value representing the degree of passenger occupancy of the vehicle.
       * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
       * The value 100 should represent the total maximum occupancy the vehicle was designed for,
       * including both seated and standing capacity, and current operating regulations allow.
       * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
       * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
       * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 occupancy_percentage = 10;</code>
       */
      public int getOccupancyPercentage() {
        return occupancyPercentage_;
      }
      /**
       * <pre>
       * A percentage value representing the degree of passenger occupancy of the vehicle.
       * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
       * The value 100 should represent the total maximum occupancy the vehicle was designed for,
       * including both seated and standing capacity, and current operating regulations allow.
       * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
       * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
       * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 occupancy_percentage = 10;</code>
       */
      public Builder setOccupancyPercentage(int value) {
        bitField0_ |= 0x00000200;
        occupancyPercentage_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * A percentage value representing the degree of passenger occupancy of the vehicle.
       * The values are represented as an integer without decimals. 0 means 0% and 100 means 100%.
       * The value 100 should represent the total maximum occupancy the vehicle was designed for,
       * including both seated and standing capacity, and current operating regulations allow.
       * It is possible that the value goes over 100 if there are currently more passengers than what the vehicle was designed for.
       * The precision of occupancy_percentage should be low enough that you can't track a single person boarding and alighting for privacy reasons.
       * If multi_carriage_status is populated with per-carriage occupancy_percentage, 
       * then this field should describe the entire vehicle with all carriages accepting passengers considered.
       * This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>optional uint32 occupancy_percentage = 10;</code>
       */
      public Builder clearOccupancyPercentage() {
        bitField0_ = (bitField0_ & ~0x00000200);
        occupancyPercentage_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails> multiCarriageDetails_ =
        java.util.Collections.emptyList();
      private void ensureMultiCarriageDetailsIsMutable() {
        if (!((bitField0_ & 0x00000400) != 0)) {
          multiCarriageDetails_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails>(multiCarriageDetails_);
          bitField0_ |= 0x00000400;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder> multiCarriageDetailsBuilder_;

      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails> getMultiCarriageDetailsList() {
        if (multiCarriageDetailsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(multiCarriageDetails_);
        } else {
          return multiCarriageDetailsBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public int getMultiCarriageDetailsCount() {
        if (multiCarriageDetailsBuilder_ == null) {
          return multiCarriageDetails_.size();
        } else {
          return multiCarriageDetailsBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails getMultiCarriageDetails(int index) {
        if (multiCarriageDetailsBuilder_ == null) {
          return multiCarriageDetails_.get(index);
        } else {
          return multiCarriageDetailsBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder setMultiCarriageDetails(
          int index, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails value) {
        if (multiCarriageDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.set(index, value);
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder setMultiCarriageDetails(
          int index, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder builderForValue) {
        if (multiCarriageDetailsBuilder_ == null) {
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.set(index, builderForValue.build());
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder addMultiCarriageDetails(com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails value) {
        if (multiCarriageDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.add(value);
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder addMultiCarriageDetails(
          int index, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails value) {
        if (multiCarriageDetailsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.add(index, value);
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder addMultiCarriageDetails(
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder builderForValue) {
        if (multiCarriageDetailsBuilder_ == null) {
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.add(builderForValue.build());
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder addMultiCarriageDetails(
          int index, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder builderForValue) {
        if (multiCarriageDetailsBuilder_ == null) {
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.add(index, builderForValue.build());
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder addAllMultiCarriageDetails(
          java.lang.Iterable<? extends com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails> values) {
        if (multiCarriageDetailsBuilder_ == null) {
          ensureMultiCarriageDetailsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, multiCarriageDetails_);
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder clearMultiCarriageDetails() {
        if (multiCarriageDetailsBuilder_ == null) {
          multiCarriageDetails_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000400);
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public Builder removeMultiCarriageDetails(int index) {
        if (multiCarriageDetailsBuilder_ == null) {
          ensureMultiCarriageDetailsIsMutable();
          multiCarriageDetails_.remove(index);
          onChanged();
        } else {
          multiCarriageDetailsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder getMultiCarriageDetailsBuilder(
          int index) {
        return getMultiCarriageDetailsFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder getMultiCarriageDetailsOrBuilder(
          int index) {
        if (multiCarriageDetailsBuilder_ == null) {
          return multiCarriageDetails_.get(index);  } else {
          return multiCarriageDetailsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder> 
           getMultiCarriageDetailsOrBuilderList() {
        if (multiCarriageDetailsBuilder_ != null) {
          return multiCarriageDetailsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(multiCarriageDetails_);
        }
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder addMultiCarriageDetailsBuilder() {
        return getMultiCarriageDetailsFieldBuilder().addBuilder(
            com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.getDefaultInstance());
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder addMultiCarriageDetailsBuilder(
          int index) {
        return getMultiCarriageDetailsFieldBuilder().addBuilder(
            index, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.getDefaultInstance());
      }
      /**
       * <pre>
       * Details of the multiple carriages of this given vehicle.
       * The first occurrence represents the first carriage of the vehicle, 
       * given the current direction of travel. 
       * The number of occurrences of the multi_carriage_details 
       * field represents the number of carriages of the vehicle.
       * It also includes non boardable carriages, 
       * like engines, maintenance carriages, etc… as they provide valuable 
       * information to passengers about where to stand on a platform.
       * This message/field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>repeated .transit_realtime.VehiclePosition.CarriageDetails multi_carriage_details = 11;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder> 
           getMultiCarriageDetailsBuilderList() {
        return getMultiCarriageDetailsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder> 
          getMultiCarriageDetailsFieldBuilder() {
        if (multiCarriageDetailsBuilder_ == null) {
          multiCarriageDetailsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetails.Builder, com.google.transit.realtime.GtfsRealtime.VehiclePosition.CarriageDetailsOrBuilder>(
                  multiCarriageDetails_,
                  ((bitField0_ & 0x00000400) != 0),
                  getParentForChildren(),
                  isClean());
          multiCarriageDetails_ = null;
        }
        return multiCarriageDetailsBuilder_;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.VehiclePosition)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.VehiclePosition)
    private static final com.google.transit.realtime.GtfsRealtime.VehiclePosition DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.VehiclePosition();
    }

    public static com.google.transit.realtime.GtfsRealtime.VehiclePosition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<VehiclePosition>
        PARSER = new com.google.protobuf.AbstractParser<VehiclePosition>() {
      @java.lang.Override
      public VehiclePosition parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new VehiclePosition(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<VehiclePosition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VehiclePosition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.VehiclePosition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AlertOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.Alert)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<Alert> {

    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    java.util.List<com.google.transit.realtime.GtfsRealtime.TimeRange> 
        getActivePeriodList();
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TimeRange getActivePeriod(int index);
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    int getActivePeriodCount();
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    java.util.List<? extends com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> 
        getActivePeriodOrBuilderList();
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder getActivePeriodOrBuilder(
        int index);

    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    java.util.List<com.google.transit.realtime.GtfsRealtime.EntitySelector> 
        getInformedEntityList();
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    com.google.transit.realtime.GtfsRealtime.EntitySelector getInformedEntity(int index);
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    int getInformedEntityCount();
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    java.util.List<? extends com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder> 
        getInformedEntityOrBuilderList();
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder getInformedEntityOrBuilder(
        int index);

    /**
     * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
     */
    boolean hasCause();
    /**
     * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
     */
    com.google.transit.realtime.GtfsRealtime.Alert.Cause getCause();

    /**
     * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
     */
    boolean hasEffect();
    /**
     * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
     */
    com.google.transit.realtime.GtfsRealtime.Alert.Effect getEffect();

    /**
     * <pre>
     * The URL which provides additional information about the alert.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString url = 8;</code>
     */
    boolean hasUrl();
    /**
     * <pre>
     * The URL which provides additional information about the alert.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString url = 8;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedString getUrl();
    /**
     * <pre>
     * The URL which provides additional information about the alert.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString url = 8;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getUrlOrBuilder();

    /**
     * <pre>
     * Alert header. Contains a short summary of the alert text as plain-text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
     */
    boolean hasHeaderText();
    /**
     * <pre>
     * Alert header. Contains a short summary of the alert text as plain-text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedString getHeaderText();
    /**
     * <pre>
     * Alert header. Contains a short summary of the alert text as plain-text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getHeaderTextOrBuilder();

    /**
     * <pre>
     * Full description for the alert as plain-text. The information in the
     * description should add to the information of the header.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
     */
    boolean hasDescriptionText();
    /**
     * <pre>
     * Full description for the alert as plain-text. The information in the
     * description should add to the information of the header.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedString getDescriptionText();
    /**
     * <pre>
     * Full description for the alert as plain-text. The information in the
     * description should add to the information of the header.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getDescriptionTextOrBuilder();

    /**
     * <pre>
     * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
     */
    boolean hasTtsHeaderText();
    /**
     * <pre>
     * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedString getTtsHeaderText();
    /**
     * <pre>
     * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getTtsHeaderTextOrBuilder();

    /**
     * <pre>
     * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
     */
    boolean hasTtsDescriptionText();
    /**
     * <pre>
     * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedString getTtsDescriptionText();
    /**
     * <pre>
     * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getTtsDescriptionTextOrBuilder();

    /**
     * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
     */
    boolean hasSeverityLevel();
    /**
     * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
     */
    com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel getSeverityLevel();
  }
  /**
   * <pre>
   * An alert, indicating some sort of incident in the public transit network.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.Alert}
   */
  public  static final class Alert extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        Alert> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.Alert)
      AlertOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Alert.newBuilder() to construct.
    private Alert(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.Alert, ?> builder) {
      super(builder);
    }
    private Alert() {
      activePeriod_ = java.util.Collections.emptyList();
      informedEntity_ = java.util.Collections.emptyList();
      cause_ = 1;
      effect_ = 8;
      severityLevel_ = 1;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Alert(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                activePeriod_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.TimeRange>();
                mutable_bitField0_ |= 0x00000001;
              }
              activePeriod_.add(
                  input.readMessage(com.google.transit.realtime.GtfsRealtime.TimeRange.PARSER, extensionRegistry));
              break;
            }
            case 42: {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                informedEntity_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.EntitySelector>();
                mutable_bitField0_ |= 0x00000002;
              }
              informedEntity_.add(
                  input.readMessage(com.google.transit.realtime.GtfsRealtime.EntitySelector.PARSER, extensionRegistry));
              break;
            }
            case 48: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.Alert.Cause value = com.google.transit.realtime.GtfsRealtime.Alert.Cause.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(6, rawValue);
              } else {
                bitField0_ |= 0x00000001;
                cause_ = rawValue;
              }
              break;
            }
            case 56: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.Alert.Effect value = com.google.transit.realtime.GtfsRealtime.Alert.Effect.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(7, rawValue);
              } else {
                bitField0_ |= 0x00000002;
                effect_ = rawValue;
              }
              break;
            }
            case 66: {
              com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder subBuilder = null;
              if (((bitField0_ & 0x00000004) != 0)) {
                subBuilder = url_.toBuilder();
              }
              url_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TranslatedString.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(url_);
                url_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000004;
              break;
            }
            case 82: {
              com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder subBuilder = null;
              if (((bitField0_ & 0x00000008) != 0)) {
                subBuilder = headerText_.toBuilder();
              }
              headerText_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TranslatedString.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(headerText_);
                headerText_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000008;
              break;
            }
            case 90: {
              com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder subBuilder = null;
              if (((bitField0_ & 0x00000010) != 0)) {
                subBuilder = descriptionText_.toBuilder();
              }
              descriptionText_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TranslatedString.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(descriptionText_);
                descriptionText_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000010;
              break;
            }
            case 98: {
              com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder subBuilder = null;
              if (((bitField0_ & 0x00000020) != 0)) {
                subBuilder = ttsHeaderText_.toBuilder();
              }
              ttsHeaderText_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TranslatedString.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ttsHeaderText_);
                ttsHeaderText_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000020;
              break;
            }
            case 106: {
              com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder subBuilder = null;
              if (((bitField0_ & 0x00000040) != 0)) {
                subBuilder = ttsDescriptionText_.toBuilder();
              }
              ttsDescriptionText_ = input.readMessage(com.google.transit.realtime.GtfsRealtime.TranslatedString.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(ttsDescriptionText_);
                ttsDescriptionText_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000040;
              break;
            }
            case 112: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel value = com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(14, rawValue);
              } else {
                bitField0_ |= 0x00000080;
                severityLevel_ = rawValue;
              }
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          activePeriod_ = java.util.Collections.unmodifiableList(activePeriod_);
        }
        if (((mutable_bitField0_ & 0x00000002) != 0)) {
          informedEntity_ = java.util.Collections.unmodifiableList(informedEntity_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Alert_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Alert_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.Alert.class, com.google.transit.realtime.GtfsRealtime.Alert.Builder.class);
    }

    /**
     * <pre>
     * Cause of this alert.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.Alert.Cause}
     */
    public enum Cause
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>UNKNOWN_CAUSE = 1;</code>
       */
      UNKNOWN_CAUSE(1),
      /**
       * <pre>
       * Not machine-representable.
       * </pre>
       *
       * <code>OTHER_CAUSE = 2;</code>
       */
      OTHER_CAUSE(2),
      /**
       * <code>TECHNICAL_PROBLEM = 3;</code>
       */
      TECHNICAL_PROBLEM(3),
      /**
       * <pre>
       * Public transit agency employees stopped working.
       * </pre>
       *
       * <code>STRIKE = 4;</code>
       */
      STRIKE(4),
      /**
       * <pre>
       * People are blocking the streets.
       * </pre>
       *
       * <code>DEMONSTRATION = 5;</code>
       */
      DEMONSTRATION(5),
      /**
       * <code>ACCIDENT = 6;</code>
       */
      ACCIDENT(6),
      /**
       * <code>HOLIDAY = 7;</code>
       */
      HOLIDAY(7),
      /**
       * <code>WEATHER = 8;</code>
       */
      WEATHER(8),
      /**
       * <code>MAINTENANCE = 9;</code>
       */
      MAINTENANCE(9),
      /**
       * <code>CONSTRUCTION = 10;</code>
       */
      CONSTRUCTION(10),
      /**
       * <code>POLICE_ACTIVITY = 11;</code>
       */
      POLICE_ACTIVITY(11),
      /**
       * <code>MEDICAL_EMERGENCY = 12;</code>
       */
      MEDICAL_EMERGENCY(12),
      ;

      /**
       * <code>UNKNOWN_CAUSE = 1;</code>
       */
      public static final int UNKNOWN_CAUSE_VALUE = 1;
      /**
       * <pre>
       * Not machine-representable.
       * </pre>
       *
       * <code>OTHER_CAUSE = 2;</code>
       */
      public static final int OTHER_CAUSE_VALUE = 2;
      /**
       * <code>TECHNICAL_PROBLEM = 3;</code>
       */
      public static final int TECHNICAL_PROBLEM_VALUE = 3;
      /**
       * <pre>
       * Public transit agency employees stopped working.
       * </pre>
       *
       * <code>STRIKE = 4;</code>
       */
      public static final int STRIKE_VALUE = 4;
      /**
       * <pre>
       * People are blocking the streets.
       * </pre>
       *
       * <code>DEMONSTRATION = 5;</code>
       */
      public static final int DEMONSTRATION_VALUE = 5;
      /**
       * <code>ACCIDENT = 6;</code>
       */
      public static final int ACCIDENT_VALUE = 6;
      /**
       * <code>HOLIDAY = 7;</code>
       */
      public static final int HOLIDAY_VALUE = 7;
      /**
       * <code>WEATHER = 8;</code>
       */
      public static final int WEATHER_VALUE = 8;
      /**
       * <code>MAINTENANCE = 9;</code>
       */
      public static final int MAINTENANCE_VALUE = 9;
      /**
       * <code>CONSTRUCTION = 10;</code>
       */
      public static final int CONSTRUCTION_VALUE = 10;
      /**
       * <code>POLICE_ACTIVITY = 11;</code>
       */
      public static final int POLICE_ACTIVITY_VALUE = 11;
      /**
       * <code>MEDICAL_EMERGENCY = 12;</code>
       */
      public static final int MEDICAL_EMERGENCY_VALUE = 12;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Cause valueOf(int value) {
        return forNumber(value);
      }

      public static Cause forNumber(int value) {
        switch (value) {
          case 1: return UNKNOWN_CAUSE;
          case 2: return OTHER_CAUSE;
          case 3: return TECHNICAL_PROBLEM;
          case 4: return STRIKE;
          case 5: return DEMONSTRATION;
          case 6: return ACCIDENT;
          case 7: return HOLIDAY;
          case 8: return WEATHER;
          case 9: return MAINTENANCE;
          case 10: return CONSTRUCTION;
          case 11: return POLICE_ACTIVITY;
          case 12: return MEDICAL_EMERGENCY;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Cause>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Cause> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Cause>() {
              public Cause findValueByNumber(int number) {
                return Cause.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.Alert.getDescriptor().getEnumTypes().get(0);
      }

      private static final Cause[] VALUES = values();

      public static Cause valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Cause(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.Alert.Cause)
    }

    /**
     * <pre>
     * What is the effect of this problem on the affected entity.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.Alert.Effect}
     */
    public enum Effect
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>NO_SERVICE = 1;</code>
       */
      NO_SERVICE(1),
      /**
       * <code>REDUCED_SERVICE = 2;</code>
       */
      REDUCED_SERVICE(2),
      /**
       * <pre>
       * We don't care about INsignificant delays: they are hard to detect, have
       * little impact on the user, and would clutter the results as they are too
       * frequent.
       * </pre>
       *
       * <code>SIGNIFICANT_DELAYS = 3;</code>
       */
      SIGNIFICANT_DELAYS(3),
      /**
       * <code>DETOUR = 4;</code>
       */
      DETOUR(4),
      /**
       * <code>ADDITIONAL_SERVICE = 5;</code>
       */
      ADDITIONAL_SERVICE(5),
      /**
       * <code>MODIFIED_SERVICE = 6;</code>
       */
      MODIFIED_SERVICE(6),
      /**
       * <code>OTHER_EFFECT = 7;</code>
       */
      OTHER_EFFECT(7),
      /**
       * <code>UNKNOWN_EFFECT = 8;</code>
       */
      UNKNOWN_EFFECT(8),
      /**
       * <code>STOP_MOVED = 9;</code>
       */
      STOP_MOVED(9),
      /**
       * <code>NO_EFFECT = 10;</code>
       */
      NO_EFFECT(10),
      /**
       * <code>ACCESSIBILITY_ISSUE = 11;</code>
       */
      ACCESSIBILITY_ISSUE(11),
      ;

      /**
       * <code>NO_SERVICE = 1;</code>
       */
      public static final int NO_SERVICE_VALUE = 1;
      /**
       * <code>REDUCED_SERVICE = 2;</code>
       */
      public static final int REDUCED_SERVICE_VALUE = 2;
      /**
       * <pre>
       * We don't care about INsignificant delays: they are hard to detect, have
       * little impact on the user, and would clutter the results as they are too
       * frequent.
       * </pre>
       *
       * <code>SIGNIFICANT_DELAYS = 3;</code>
       */
      public static final int SIGNIFICANT_DELAYS_VALUE = 3;
      /**
       * <code>DETOUR = 4;</code>
       */
      public static final int DETOUR_VALUE = 4;
      /**
       * <code>ADDITIONAL_SERVICE = 5;</code>
       */
      public static final int ADDITIONAL_SERVICE_VALUE = 5;
      /**
       * <code>MODIFIED_SERVICE = 6;</code>
       */
      public static final int MODIFIED_SERVICE_VALUE = 6;
      /**
       * <code>OTHER_EFFECT = 7;</code>
       */
      public static final int OTHER_EFFECT_VALUE = 7;
      /**
       * <code>UNKNOWN_EFFECT = 8;</code>
       */
      public static final int UNKNOWN_EFFECT_VALUE = 8;
      /**
       * <code>STOP_MOVED = 9;</code>
       */
      public static final int STOP_MOVED_VALUE = 9;
      /**
       * <code>NO_EFFECT = 10;</code>
       */
      public static final int NO_EFFECT_VALUE = 10;
      /**
       * <code>ACCESSIBILITY_ISSUE = 11;</code>
       */
      public static final int ACCESSIBILITY_ISSUE_VALUE = 11;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Effect valueOf(int value) {
        return forNumber(value);
      }

      public static Effect forNumber(int value) {
        switch (value) {
          case 1: return NO_SERVICE;
          case 2: return REDUCED_SERVICE;
          case 3: return SIGNIFICANT_DELAYS;
          case 4: return DETOUR;
          case 5: return ADDITIONAL_SERVICE;
          case 6: return MODIFIED_SERVICE;
          case 7: return OTHER_EFFECT;
          case 8: return UNKNOWN_EFFECT;
          case 9: return STOP_MOVED;
          case 10: return NO_EFFECT;
          case 11: return ACCESSIBILITY_ISSUE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Effect>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Effect> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Effect>() {
              public Effect findValueByNumber(int number) {
                return Effect.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.Alert.getDescriptor().getEnumTypes().get(1);
      }

      private static final Effect[] VALUES = values();

      public static Effect valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Effect(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.Alert.Effect)
    }

    /**
     * <pre>
     * Severity of this alert.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.Alert.SeverityLevel}
     */
    public enum SeverityLevel
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>UNKNOWN_SEVERITY = 1;</code>
       */
      UNKNOWN_SEVERITY(1),
      /**
       * <code>INFO = 2;</code>
       */
      INFO(2),
      /**
       * <code>WARNING = 3;</code>
       */
      WARNING(3),
      /**
       * <code>SEVERE = 4;</code>
       */
      SEVERE(4),
      ;

      /**
       * <code>UNKNOWN_SEVERITY = 1;</code>
       */
      public static final int UNKNOWN_SEVERITY_VALUE = 1;
      /**
       * <code>INFO = 2;</code>
       */
      public static final int INFO_VALUE = 2;
      /**
       * <code>WARNING = 3;</code>
       */
      public static final int WARNING_VALUE = 3;
      /**
       * <code>SEVERE = 4;</code>
       */
      public static final int SEVERE_VALUE = 4;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SeverityLevel valueOf(int value) {
        return forNumber(value);
      }

      public static SeverityLevel forNumber(int value) {
        switch (value) {
          case 1: return UNKNOWN_SEVERITY;
          case 2: return INFO;
          case 3: return WARNING;
          case 4: return SEVERE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<SeverityLevel>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          SeverityLevel> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<SeverityLevel>() {
              public SeverityLevel findValueByNumber(int number) {
                return SeverityLevel.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.Alert.getDescriptor().getEnumTypes().get(2);
      }

      private static final SeverityLevel[] VALUES = values();

      public static SeverityLevel valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private SeverityLevel(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.Alert.SeverityLevel)
    }

    private int bitField0_;
    public static final int ACTIVE_PERIOD_FIELD_NUMBER = 1;
    private java.util.List<com.google.transit.realtime.GtfsRealtime.TimeRange> activePeriod_;
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    public java.util.List<com.google.transit.realtime.GtfsRealtime.TimeRange> getActivePeriodList() {
      return activePeriod_;
    }
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> 
        getActivePeriodOrBuilderList() {
      return activePeriod_;
    }
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    public int getActivePeriodCount() {
      return activePeriod_.size();
    }
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TimeRange getActivePeriod(int index) {
      return activePeriod_.get(index);
    }
    /**
     * <pre>
     * Time when the alert should be shown to the user. If missing, the
     * alert will be shown as long as it appears in the feed.
     * If multiple ranges are given, the alert will be shown during all of them.
     * </pre>
     *
     * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder getActivePeriodOrBuilder(
        int index) {
      return activePeriod_.get(index);
    }

    public static final int INFORMED_ENTITY_FIELD_NUMBER = 5;
    private java.util.List<com.google.transit.realtime.GtfsRealtime.EntitySelector> informedEntity_;
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    public java.util.List<com.google.transit.realtime.GtfsRealtime.EntitySelector> getInformedEntityList() {
      return informedEntity_;
    }
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder> 
        getInformedEntityOrBuilderList() {
      return informedEntity_;
    }
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    public int getInformedEntityCount() {
      return informedEntity_.size();
    }
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.EntitySelector getInformedEntity(int index) {
      return informedEntity_.get(index);
    }
    /**
     * <pre>
     * Entities whose users we should notify of this alert.
     * </pre>
     *
     * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder getInformedEntityOrBuilder(
        int index) {
      return informedEntity_.get(index);
    }

    public static final int CAUSE_FIELD_NUMBER = 6;
    private int cause_;
    /**
     * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
     */
    public boolean hasCause() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
     */
    public com.google.transit.realtime.GtfsRealtime.Alert.Cause getCause() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.Alert.Cause result = com.google.transit.realtime.GtfsRealtime.Alert.Cause.valueOf(cause_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.Alert.Cause.UNKNOWN_CAUSE : result;
    }

    public static final int EFFECT_FIELD_NUMBER = 7;
    private int effect_;
    /**
     * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
     */
    public boolean hasEffect() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
     */
    public com.google.transit.realtime.GtfsRealtime.Alert.Effect getEffect() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.Alert.Effect result = com.google.transit.realtime.GtfsRealtime.Alert.Effect.valueOf(effect_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.Alert.Effect.UNKNOWN_EFFECT : result;
    }

    public static final int URL_FIELD_NUMBER = 8;
    private com.google.transit.realtime.GtfsRealtime.TranslatedString url_;
    /**
     * <pre>
     * The URL which provides additional information about the alert.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString url = 8;</code>
     */
    public boolean hasUrl() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * The URL which provides additional information about the alert.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString url = 8;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedString getUrl() {
      return url_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : url_;
    }
    /**
     * <pre>
     * The URL which provides additional information about the alert.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString url = 8;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getUrlOrBuilder() {
      return url_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : url_;
    }

    public static final int HEADER_TEXT_FIELD_NUMBER = 10;
    private com.google.transit.realtime.GtfsRealtime.TranslatedString headerText_;
    /**
     * <pre>
     * Alert header. Contains a short summary of the alert text as plain-text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
     */
    public boolean hasHeaderText() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Alert header. Contains a short summary of the alert text as plain-text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedString getHeaderText() {
      return headerText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : headerText_;
    }
    /**
     * <pre>
     * Alert header. Contains a short summary of the alert text as plain-text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getHeaderTextOrBuilder() {
      return headerText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : headerText_;
    }

    public static final int DESCRIPTION_TEXT_FIELD_NUMBER = 11;
    private com.google.transit.realtime.GtfsRealtime.TranslatedString descriptionText_;
    /**
     * <pre>
     * Full description for the alert as plain-text. The information in the
     * description should add to the information of the header.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
     */
    public boolean hasDescriptionText() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Full description for the alert as plain-text. The information in the
     * description should add to the information of the header.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedString getDescriptionText() {
      return descriptionText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : descriptionText_;
    }
    /**
     * <pre>
     * Full description for the alert as plain-text. The information in the
     * description should add to the information of the header.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getDescriptionTextOrBuilder() {
      return descriptionText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : descriptionText_;
    }

    public static final int TTS_HEADER_TEXT_FIELD_NUMBER = 12;
    private com.google.transit.realtime.GtfsRealtime.TranslatedString ttsHeaderText_;
    /**
     * <pre>
     * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
     */
    public boolean hasTtsHeaderText() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedString getTtsHeaderText() {
      return ttsHeaderText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsHeaderText_;
    }
    /**
     * <pre>
     * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getTtsHeaderTextOrBuilder() {
      return ttsHeaderText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsHeaderText_;
    }

    public static final int TTS_DESCRIPTION_TEXT_FIELD_NUMBER = 13;
    private com.google.transit.realtime.GtfsRealtime.TranslatedString ttsDescriptionText_;
    /**
     * <pre>
     * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
     */
    public boolean hasTtsDescriptionText() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedString getTtsDescriptionText() {
      return ttsDescriptionText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsDescriptionText_;
    }
    /**
     * <pre>
     * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
     * </pre>
     *
     * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getTtsDescriptionTextOrBuilder() {
      return ttsDescriptionText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsDescriptionText_;
    }

    public static final int SEVERITY_LEVEL_FIELD_NUMBER = 14;
    private int severityLevel_;
    /**
     * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
     */
    public boolean hasSeverityLevel() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
     */
    public com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel getSeverityLevel() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel result = com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel.valueOf(severityLevel_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel.UNKNOWN_SEVERITY : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getActivePeriodCount(); i++) {
        if (!getActivePeriod(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      for (int i = 0; i < getInformedEntityCount(); i++) {
        if (!getInformedEntity(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasUrl()) {
        if (!getUrl().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasHeaderText()) {
        if (!getHeaderText().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasDescriptionText()) {
        if (!getDescriptionText().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasTtsHeaderText()) {
        if (!getTtsHeaderText().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasTtsDescriptionText()) {
        if (!getTtsDescriptionText().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.Alert>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      for (int i = 0; i < activePeriod_.size(); i++) {
        output.writeMessage(1, activePeriod_.get(i));
      }
      for (int i = 0; i < informedEntity_.size(); i++) {
        output.writeMessage(5, informedEntity_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(6, cause_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(7, effect_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(8, getUrl());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(10, getHeaderText());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeMessage(11, getDescriptionText());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeMessage(12, getTtsHeaderText());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeMessage(13, getTtsDescriptionText());
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeEnum(14, severityLevel_);
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < activePeriod_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, activePeriod_.get(i));
      }
      for (int i = 0; i < informedEntity_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, informedEntity_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(6, cause_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(7, effect_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(8, getUrl());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(10, getHeaderText());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(11, getDescriptionText());
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(12, getTtsHeaderText());
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(13, getTtsDescriptionText());
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(14, severityLevel_);
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.Alert)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.Alert other = (com.google.transit.realtime.GtfsRealtime.Alert) obj;

      if (!getActivePeriodList()
          .equals(other.getActivePeriodList())) return false;
      if (!getInformedEntityList()
          .equals(other.getInformedEntityList())) return false;
      if (hasCause() != other.hasCause()) return false;
      if (hasCause()) {
        if (cause_ != other.cause_) return false;
      }
      if (hasEffect() != other.hasEffect()) return false;
      if (hasEffect()) {
        if (effect_ != other.effect_) return false;
      }
      if (hasUrl() != other.hasUrl()) return false;
      if (hasUrl()) {
        if (!getUrl()
            .equals(other.getUrl())) return false;
      }
      if (hasHeaderText() != other.hasHeaderText()) return false;
      if (hasHeaderText()) {
        if (!getHeaderText()
            .equals(other.getHeaderText())) return false;
      }
      if (hasDescriptionText() != other.hasDescriptionText()) return false;
      if (hasDescriptionText()) {
        if (!getDescriptionText()
            .equals(other.getDescriptionText())) return false;
      }
      if (hasTtsHeaderText() != other.hasTtsHeaderText()) return false;
      if (hasTtsHeaderText()) {
        if (!getTtsHeaderText()
            .equals(other.getTtsHeaderText())) return false;
      }
      if (hasTtsDescriptionText() != other.hasTtsDescriptionText()) return false;
      if (hasTtsDescriptionText()) {
        if (!getTtsDescriptionText()
            .equals(other.getTtsDescriptionText())) return false;
      }
      if (hasSeverityLevel() != other.hasSeverityLevel()) return false;
      if (hasSeverityLevel()) {
        if (severityLevel_ != other.severityLevel_) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getActivePeriodCount() > 0) {
        hash = (37 * hash) + ACTIVE_PERIOD_FIELD_NUMBER;
        hash = (53 * hash) + getActivePeriodList().hashCode();
      }
      if (getInformedEntityCount() > 0) {
        hash = (37 * hash) + INFORMED_ENTITY_FIELD_NUMBER;
        hash = (53 * hash) + getInformedEntityList().hashCode();
      }
      if (hasCause()) {
        hash = (37 * hash) + CAUSE_FIELD_NUMBER;
        hash = (53 * hash) + cause_;
      }
      if (hasEffect()) {
        hash = (37 * hash) + EFFECT_FIELD_NUMBER;
        hash = (53 * hash) + effect_;
      }
      if (hasUrl()) {
        hash = (37 * hash) + URL_FIELD_NUMBER;
        hash = (53 * hash) + getUrl().hashCode();
      }
      if (hasHeaderText()) {
        hash = (37 * hash) + HEADER_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getHeaderText().hashCode();
      }
      if (hasDescriptionText()) {
        hash = (37 * hash) + DESCRIPTION_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getDescriptionText().hashCode();
      }
      if (hasTtsHeaderText()) {
        hash = (37 * hash) + TTS_HEADER_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getTtsHeaderText().hashCode();
      }
      if (hasTtsDescriptionText()) {
        hash = (37 * hash) + TTS_DESCRIPTION_TEXT_FIELD_NUMBER;
        hash = (53 * hash) + getTtsDescriptionText().hashCode();
      }
      if (hasSeverityLevel()) {
        hash = (37 * hash) + SEVERITY_LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + severityLevel_;
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.Alert parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.Alert prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * An alert, indicating some sort of incident in the public transit network.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.Alert}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.Alert, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.Alert)
        com.google.transit.realtime.GtfsRealtime.AlertOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Alert_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Alert_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.Alert.class, com.google.transit.realtime.GtfsRealtime.Alert.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.Alert.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
          getActivePeriodFieldBuilder();
          getInformedEntityFieldBuilder();
          getUrlFieldBuilder();
          getHeaderTextFieldBuilder();
          getDescriptionTextFieldBuilder();
          getTtsHeaderTextFieldBuilder();
          getTtsDescriptionTextFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (activePeriodBuilder_ == null) {
          activePeriod_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          activePeriodBuilder_.clear();
        }
        if (informedEntityBuilder_ == null) {
          informedEntity_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          informedEntityBuilder_.clear();
        }
        cause_ = 1;
        bitField0_ = (bitField0_ & ~0x00000004);
        effect_ = 8;
        bitField0_ = (bitField0_ & ~0x00000008);
        if (urlBuilder_ == null) {
          url_ = null;
        } else {
          urlBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        if (headerTextBuilder_ == null) {
          headerText_ = null;
        } else {
          headerTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (descriptionTextBuilder_ == null) {
          descriptionText_ = null;
        } else {
          descriptionTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        if (ttsHeaderTextBuilder_ == null) {
          ttsHeaderText_ = null;
        } else {
          ttsHeaderTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        if (ttsDescriptionTextBuilder_ == null) {
          ttsDescriptionText_ = null;
        } else {
          ttsDescriptionTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        severityLevel_ = 1;
        bitField0_ = (bitField0_ & ~0x00000200);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Alert_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.Alert getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.Alert build() {
        com.google.transit.realtime.GtfsRealtime.Alert result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.Alert buildPartial() {
        com.google.transit.realtime.GtfsRealtime.Alert result = new com.google.transit.realtime.GtfsRealtime.Alert(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (activePeriodBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            activePeriod_ = java.util.Collections.unmodifiableList(activePeriod_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.activePeriod_ = activePeriod_;
        } else {
          result.activePeriod_ = activePeriodBuilder_.build();
        }
        if (informedEntityBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            informedEntity_ = java.util.Collections.unmodifiableList(informedEntity_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.informedEntity_ = informedEntity_;
        } else {
          result.informedEntity_ = informedEntityBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.cause_ = cause_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.effect_ = effect_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          if (urlBuilder_ == null) {
            result.url_ = url_;
          } else {
            result.url_ = urlBuilder_.build();
          }
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          if (headerTextBuilder_ == null) {
            result.headerText_ = headerText_;
          } else {
            result.headerText_ = headerTextBuilder_.build();
          }
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          if (descriptionTextBuilder_ == null) {
            result.descriptionText_ = descriptionText_;
          } else {
            result.descriptionText_ = descriptionTextBuilder_.build();
          }
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          if (ttsHeaderTextBuilder_ == null) {
            result.ttsHeaderText_ = ttsHeaderText_;
          } else {
            result.ttsHeaderText_ = ttsHeaderTextBuilder_.build();
          }
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          if (ttsDescriptionTextBuilder_ == null) {
            result.ttsDescriptionText_ = ttsDescriptionText_;
          } else {
            result.ttsDescriptionText_ = ttsDescriptionTextBuilder_.build();
          }
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          to_bitField0_ |= 0x00000080;
        }
        result.severityLevel_ = severityLevel_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Alert, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Alert, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Alert, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Alert, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.Alert) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.Alert)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.Alert other) {
        if (other == com.google.transit.realtime.GtfsRealtime.Alert.getDefaultInstance()) return this;
        if (activePeriodBuilder_ == null) {
          if (!other.activePeriod_.isEmpty()) {
            if (activePeriod_.isEmpty()) {
              activePeriod_ = other.activePeriod_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureActivePeriodIsMutable();
              activePeriod_.addAll(other.activePeriod_);
            }
            onChanged();
          }
        } else {
          if (!other.activePeriod_.isEmpty()) {
            if (activePeriodBuilder_.isEmpty()) {
              activePeriodBuilder_.dispose();
              activePeriodBuilder_ = null;
              activePeriod_ = other.activePeriod_;
              bitField0_ = (bitField0_ & ~0x00000001);
              activePeriodBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getActivePeriodFieldBuilder() : null;
            } else {
              activePeriodBuilder_.addAllMessages(other.activePeriod_);
            }
          }
        }
        if (informedEntityBuilder_ == null) {
          if (!other.informedEntity_.isEmpty()) {
            if (informedEntity_.isEmpty()) {
              informedEntity_ = other.informedEntity_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureInformedEntityIsMutable();
              informedEntity_.addAll(other.informedEntity_);
            }
            onChanged();
          }
        } else {
          if (!other.informedEntity_.isEmpty()) {
            if (informedEntityBuilder_.isEmpty()) {
              informedEntityBuilder_.dispose();
              informedEntityBuilder_ = null;
              informedEntity_ = other.informedEntity_;
              bitField0_ = (bitField0_ & ~0x00000002);
              informedEntityBuilder_ = 
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders ?
                   getInformedEntityFieldBuilder() : null;
            } else {
              informedEntityBuilder_.addAllMessages(other.informedEntity_);
            }
          }
        }
        if (other.hasCause()) {
          setCause(other.getCause());
        }
        if (other.hasEffect()) {
          setEffect(other.getEffect());
        }
        if (other.hasUrl()) {
          mergeUrl(other.getUrl());
        }
        if (other.hasHeaderText()) {
          mergeHeaderText(other.getHeaderText());
        }
        if (other.hasDescriptionText()) {
          mergeDescriptionText(other.getDescriptionText());
        }
        if (other.hasTtsHeaderText()) {
          mergeTtsHeaderText(other.getTtsHeaderText());
        }
        if (other.hasTtsDescriptionText()) {
          mergeTtsDescriptionText(other.getTtsDescriptionText());
        }
        if (other.hasSeverityLevel()) {
          setSeverityLevel(other.getSeverityLevel());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getActivePeriodCount(); i++) {
          if (!getActivePeriod(i).isInitialized()) {
            return false;
          }
        }
        for (int i = 0; i < getInformedEntityCount(); i++) {
          if (!getInformedEntity(i).isInitialized()) {
            return false;
          }
        }
        if (hasUrl()) {
          if (!getUrl().isInitialized()) {
            return false;
          }
        }
        if (hasHeaderText()) {
          if (!getHeaderText().isInitialized()) {
            return false;
          }
        }
        if (hasDescriptionText()) {
          if (!getDescriptionText().isInitialized()) {
            return false;
          }
        }
        if (hasTtsHeaderText()) {
          if (!getTtsHeaderText().isInitialized()) {
            return false;
          }
        }
        if (hasTtsDescriptionText()) {
          if (!getTtsDescriptionText().isInitialized()) {
            return false;
          }
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.Alert parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.Alert) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<com.google.transit.realtime.GtfsRealtime.TimeRange> activePeriod_ =
        java.util.Collections.emptyList();
      private void ensureActivePeriodIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          activePeriod_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.TimeRange>(activePeriod_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TimeRange, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder, com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> activePeriodBuilder_;

      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.TimeRange> getActivePeriodList() {
        if (activePeriodBuilder_ == null) {
          return java.util.Collections.unmodifiableList(activePeriod_);
        } else {
          return activePeriodBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public int getActivePeriodCount() {
        if (activePeriodBuilder_ == null) {
          return activePeriod_.size();
        } else {
          return activePeriodBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRange getActivePeriod(int index) {
        if (activePeriodBuilder_ == null) {
          return activePeriod_.get(index);
        } else {
          return activePeriodBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder setActivePeriod(
          int index, com.google.transit.realtime.GtfsRealtime.TimeRange value) {
        if (activePeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActivePeriodIsMutable();
          activePeriod_.set(index, value);
          onChanged();
        } else {
          activePeriodBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder setActivePeriod(
          int index, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder builderForValue) {
        if (activePeriodBuilder_ == null) {
          ensureActivePeriodIsMutable();
          activePeriod_.set(index, builderForValue.build());
          onChanged();
        } else {
          activePeriodBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder addActivePeriod(com.google.transit.realtime.GtfsRealtime.TimeRange value) {
        if (activePeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActivePeriodIsMutable();
          activePeriod_.add(value);
          onChanged();
        } else {
          activePeriodBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder addActivePeriod(
          int index, com.google.transit.realtime.GtfsRealtime.TimeRange value) {
        if (activePeriodBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureActivePeriodIsMutable();
          activePeriod_.add(index, value);
          onChanged();
        } else {
          activePeriodBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder addActivePeriod(
          com.google.transit.realtime.GtfsRealtime.TimeRange.Builder builderForValue) {
        if (activePeriodBuilder_ == null) {
          ensureActivePeriodIsMutable();
          activePeriod_.add(builderForValue.build());
          onChanged();
        } else {
          activePeriodBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder addActivePeriod(
          int index, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder builderForValue) {
        if (activePeriodBuilder_ == null) {
          ensureActivePeriodIsMutable();
          activePeriod_.add(index, builderForValue.build());
          onChanged();
        } else {
          activePeriodBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder addAllActivePeriod(
          java.lang.Iterable<? extends com.google.transit.realtime.GtfsRealtime.TimeRange> values) {
        if (activePeriodBuilder_ == null) {
          ensureActivePeriodIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, activePeriod_);
          onChanged();
        } else {
          activePeriodBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder clearActivePeriod() {
        if (activePeriodBuilder_ == null) {
          activePeriod_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          activePeriodBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public Builder removeActivePeriod(int index) {
        if (activePeriodBuilder_ == null) {
          ensureActivePeriodIsMutable();
          activePeriod_.remove(index);
          onChanged();
        } else {
          activePeriodBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRange.Builder getActivePeriodBuilder(
          int index) {
        return getActivePeriodFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder getActivePeriodOrBuilder(
          int index) {
        if (activePeriodBuilder_ == null) {
          return activePeriod_.get(index);  } else {
          return activePeriodBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> 
           getActivePeriodOrBuilderList() {
        if (activePeriodBuilder_ != null) {
          return activePeriodBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(activePeriod_);
        }
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRange.Builder addActivePeriodBuilder() {
        return getActivePeriodFieldBuilder().addBuilder(
            com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance());
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TimeRange.Builder addActivePeriodBuilder(
          int index) {
        return getActivePeriodFieldBuilder().addBuilder(
            index, com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance());
      }
      /**
       * <pre>
       * Time when the alert should be shown to the user. If missing, the
       * alert will be shown as long as it appears in the feed.
       * If multiple ranges are given, the alert will be shown during all of them.
       * </pre>
       *
       * <code>repeated .transit_realtime.TimeRange active_period = 1;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.TimeRange.Builder> 
           getActivePeriodBuilderList() {
        return getActivePeriodFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TimeRange, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder, com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder> 
          getActivePeriodFieldBuilder() {
        if (activePeriodBuilder_ == null) {
          activePeriodBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TimeRange, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder, com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder>(
                  activePeriod_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          activePeriod_ = null;
        }
        return activePeriodBuilder_;
      }

      private java.util.List<com.google.transit.realtime.GtfsRealtime.EntitySelector> informedEntity_ =
        java.util.Collections.emptyList();
      private void ensureInformedEntityIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          informedEntity_ = new java.util.ArrayList<com.google.transit.realtime.GtfsRealtime.EntitySelector>(informedEntity_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.EntitySelector, com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder, com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder> informedEntityBuilder_;

      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.EntitySelector> getInformedEntityList() {
        if (informedEntityBuilder_ == null) {
          return java.util.Collections.unmodifiableList(informedEntity_);
        } else {
          return informedEntityBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public int getInformedEntityCount() {
        if (informedEntityBuilder_ == null) {
          return informedEntity_.size();
        } else {
          return informedEntityBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.EntitySelector getInformedEntity(int index) {
        if (informedEntityBuilder_ == null) {
          return informedEntity_.get(index);
        } else {
          return informedEntityBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder setInformedEntity(
          int index, com.google.transit.realtime.GtfsRealtime.EntitySelector value) {
        if (informedEntityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInformedEntityIsMutable();
          informedEntity_.set(index, value);
          onChanged();
        } else {
          informedEntityBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder setInformedEntity(
          int index, com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder builderForValue) {
        if (informedEntityBuilder_ == null) {
          ensureInformedEntityIsMutable();
          informedEntity_.set(index, builderForValue.build());
          onChanged();
        } else {
          informedEntityBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder addInformedEntity(com.google.transit.realtime.GtfsRealtime.EntitySelector value) {
        if (informedEntityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInformedEntityIsMutable();
          informedEntity_.add(value);
          onChanged();
        } else {
          informedEntityBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder addInformedEntity(
          int index, com.google.transit.realtime.GtfsRealtime.EntitySelector value) {
        if (informedEntityBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureInformedEntityIsMutable();
          informedEntity_.add(index, value);
          onChanged();
        } else {
          informedEntityBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder addInformedEntity(
          com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder builderForValue) {
        if (informedEntityBuilder_ == null) {
          ensureInformedEntityIsMutable();
          informedEntity_.add(builderForValue.build());
          onChanged();
        } else {
          informedEntityBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder addInformedEntity(
          int index, com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder builderForValue) {
        if (informedEntityBuilder_ == null) {
          ensureInformedEntityIsMutable();
          informedEntity_.add(index, builderForValue.build());
          onChanged();
        } else {
          informedEntityBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder addAllInformedEntity(
          java.lang.Iterable<? extends com.google.transit.realtime.GtfsRealtime.EntitySelector> values) {
        if (informedEntityBuilder_ == null) {
          ensureInformedEntityIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, informedEntity_);
          onChanged();
        } else {
          informedEntityBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder clearInformedEntity() {
        if (informedEntityBuilder_ == null) {
          informedEntity_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          informedEntityBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public Builder removeInformedEntity(int index) {
        if (informedEntityBuilder_ == null) {
          ensureInformedEntityIsMutable();
          informedEntity_.remove(index);
          onChanged();
        } else {
          informedEntityBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder getInformedEntityBuilder(
          int index) {
        return getInformedEntityFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder getInformedEntityOrBuilder(
          int index) {
        if (informedEntityBuilder_ == null) {
          return informedEntity_.get(index);  } else {
          return informedEntityBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public java.util.List<? extends com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder> 
           getInformedEntityOrBuilderList() {
        if (informedEntityBuilder_ != null) {
          return informedEntityBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(informedEntity_);
        }
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder addInformedEntityBuilder() {
        return getInformedEntityFieldBuilder().addBuilder(
            com.google.transit.realtime.GtfsRealtime.EntitySelector.getDefaultInstance());
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder addInformedEntityBuilder(
          int index) {
        return getInformedEntityFieldBuilder().addBuilder(
            index, com.google.transit.realtime.GtfsRealtime.EntitySelector.getDefaultInstance());
      }
      /**
       * <pre>
       * Entities whose users we should notify of this alert.
       * </pre>
       *
       * <code>repeated .transit_realtime.EntitySelector informed_entity = 5;</code>
       */
      public java.util.List<com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder> 
           getInformedEntityBuilderList() {
        return getInformedEntityFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.EntitySelector, com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder, com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder> 
          getInformedEntityFieldBuilder() {
        if (informedEntityBuilder_ == null) {
          informedEntityBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.EntitySelector, com.google.transit.realtime.GtfsRealtime.EntitySelector.Builder, com.google.transit.realtime.GtfsRealtime.EntitySelectorOrBuilder>(
                  informedEntity_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          informedEntity_ = null;
        }
        return informedEntityBuilder_;
      }

      private int cause_ = 1;
      /**
       * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
       */
      public boolean hasCause() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Alert.Cause getCause() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.Alert.Cause result = com.google.transit.realtime.GtfsRealtime.Alert.Cause.valueOf(cause_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.Alert.Cause.UNKNOWN_CAUSE : result;
      }
      /**
       * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
       */
      public Builder setCause(com.google.transit.realtime.GtfsRealtime.Alert.Cause value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        cause_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert.Cause cause = 6 [default = UNKNOWN_CAUSE];</code>
       */
      public Builder clearCause() {
        bitField0_ = (bitField0_ & ~0x00000004);
        cause_ = 1;
        onChanged();
        return this;
      }

      private int effect_ = 8;
      /**
       * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
       */
      public boolean hasEffect() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Alert.Effect getEffect() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.Alert.Effect result = com.google.transit.realtime.GtfsRealtime.Alert.Effect.valueOf(effect_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.Alert.Effect.UNKNOWN_EFFECT : result;
      }
      /**
       * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
       */
      public Builder setEffect(com.google.transit.realtime.GtfsRealtime.Alert.Effect value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        effect_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert.Effect effect = 7 [default = UNKNOWN_EFFECT];</code>
       */
      public Builder clearEffect() {
        bitField0_ = (bitField0_ & ~0x00000008);
        effect_ = 8;
        onChanged();
        return this;
      }

      private com.google.transit.realtime.GtfsRealtime.TranslatedString url_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> urlBuilder_;
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public boolean hasUrl() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString getUrl() {
        if (urlBuilder_ == null) {
          return url_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : url_;
        } else {
          return urlBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public Builder setUrl(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (urlBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          url_ = value;
          onChanged();
        } else {
          urlBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public Builder setUrl(
          com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder builderForValue) {
        if (urlBuilder_ == null) {
          url_ = builderForValue.build();
          onChanged();
        } else {
          urlBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public Builder mergeUrl(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (urlBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0) &&
              url_ != null &&
              url_ != com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance()) {
            url_ =
              com.google.transit.realtime.GtfsRealtime.TranslatedString.newBuilder(url_).mergeFrom(value).buildPartial();
          } else {
            url_ = value;
          }
          onChanged();
        } else {
          urlBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        return this;
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public Builder clearUrl() {
        if (urlBuilder_ == null) {
          url_ = null;
          onChanged();
        } else {
          urlBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder getUrlBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getUrlFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getUrlOrBuilder() {
        if (urlBuilder_ != null) {
          return urlBuilder_.getMessageOrBuilder();
        } else {
          return url_ == null ?
              com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : url_;
        }
      }
      /**
       * <pre>
       * The URL which provides additional information about the alert.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString url = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> 
          getUrlFieldBuilder() {
        if (urlBuilder_ == null) {
          urlBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder>(
                  getUrl(),
                  getParentForChildren(),
                  isClean());
          url_ = null;
        }
        return urlBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.TranslatedString headerText_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> headerTextBuilder_;
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public boolean hasHeaderText() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString getHeaderText() {
        if (headerTextBuilder_ == null) {
          return headerText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : headerText_;
        } else {
          return headerTextBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public Builder setHeaderText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (headerTextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          headerText_ = value;
          onChanged();
        } else {
          headerTextBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public Builder setHeaderText(
          com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder builderForValue) {
        if (headerTextBuilder_ == null) {
          headerText_ = builderForValue.build();
          onChanged();
        } else {
          headerTextBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public Builder mergeHeaderText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (headerTextBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0) &&
              headerText_ != null &&
              headerText_ != com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance()) {
            headerText_ =
              com.google.transit.realtime.GtfsRealtime.TranslatedString.newBuilder(headerText_).mergeFrom(value).buildPartial();
          } else {
            headerText_ = value;
          }
          onChanged();
        } else {
          headerTextBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        return this;
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public Builder clearHeaderText() {
        if (headerTextBuilder_ == null) {
          headerText_ = null;
          onChanged();
        } else {
          headerTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder getHeaderTextBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getHeaderTextFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getHeaderTextOrBuilder() {
        if (headerTextBuilder_ != null) {
          return headerTextBuilder_.getMessageOrBuilder();
        } else {
          return headerText_ == null ?
              com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : headerText_;
        }
      }
      /**
       * <pre>
       * Alert header. Contains a short summary of the alert text as plain-text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString header_text = 10;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> 
          getHeaderTextFieldBuilder() {
        if (headerTextBuilder_ == null) {
          headerTextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder>(
                  getHeaderText(),
                  getParentForChildren(),
                  isClean());
          headerText_ = null;
        }
        return headerTextBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.TranslatedString descriptionText_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> descriptionTextBuilder_;
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public boolean hasDescriptionText() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString getDescriptionText() {
        if (descriptionTextBuilder_ == null) {
          return descriptionText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : descriptionText_;
        } else {
          return descriptionTextBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public Builder setDescriptionText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (descriptionTextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          descriptionText_ = value;
          onChanged();
        } else {
          descriptionTextBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public Builder setDescriptionText(
          com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder builderForValue) {
        if (descriptionTextBuilder_ == null) {
          descriptionText_ = builderForValue.build();
          onChanged();
        } else {
          descriptionTextBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public Builder mergeDescriptionText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (descriptionTextBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0) &&
              descriptionText_ != null &&
              descriptionText_ != com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance()) {
            descriptionText_ =
              com.google.transit.realtime.GtfsRealtime.TranslatedString.newBuilder(descriptionText_).mergeFrom(value).buildPartial();
          } else {
            descriptionText_ = value;
          }
          onChanged();
        } else {
          descriptionTextBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public Builder clearDescriptionText() {
        if (descriptionTextBuilder_ == null) {
          descriptionText_ = null;
          onChanged();
        } else {
          descriptionTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder getDescriptionTextBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getDescriptionTextFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getDescriptionTextOrBuilder() {
        if (descriptionTextBuilder_ != null) {
          return descriptionTextBuilder_.getMessageOrBuilder();
        } else {
          return descriptionText_ == null ?
              com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : descriptionText_;
        }
      }
      /**
       * <pre>
       * Full description for the alert as plain-text. The information in the
       * description should add to the information of the header.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString description_text = 11;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> 
          getDescriptionTextFieldBuilder() {
        if (descriptionTextBuilder_ == null) {
          descriptionTextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder>(
                  getDescriptionText(),
                  getParentForChildren(),
                  isClean());
          descriptionText_ = null;
        }
        return descriptionTextBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.TranslatedString ttsHeaderText_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> ttsHeaderTextBuilder_;
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public boolean hasTtsHeaderText() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString getTtsHeaderText() {
        if (ttsHeaderTextBuilder_ == null) {
          return ttsHeaderText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsHeaderText_;
        } else {
          return ttsHeaderTextBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public Builder setTtsHeaderText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (ttsHeaderTextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ttsHeaderText_ = value;
          onChanged();
        } else {
          ttsHeaderTextBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public Builder setTtsHeaderText(
          com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder builderForValue) {
        if (ttsHeaderTextBuilder_ == null) {
          ttsHeaderText_ = builderForValue.build();
          onChanged();
        } else {
          ttsHeaderTextBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public Builder mergeTtsHeaderText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (ttsHeaderTextBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0) &&
              ttsHeaderText_ != null &&
              ttsHeaderText_ != com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance()) {
            ttsHeaderText_ =
              com.google.transit.realtime.GtfsRealtime.TranslatedString.newBuilder(ttsHeaderText_).mergeFrom(value).buildPartial();
          } else {
            ttsHeaderText_ = value;
          }
          onChanged();
        } else {
          ttsHeaderTextBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public Builder clearTtsHeaderText() {
        if (ttsHeaderTextBuilder_ == null) {
          ttsHeaderText_ = null;
          onChanged();
        } else {
          ttsHeaderTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder getTtsHeaderTextBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getTtsHeaderTextFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getTtsHeaderTextOrBuilder() {
        if (ttsHeaderTextBuilder_ != null) {
          return ttsHeaderTextBuilder_.getMessageOrBuilder();
        } else {
          return ttsHeaderText_ == null ?
              com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsHeaderText_;
        }
      }
      /**
       * <pre>
       * Text for alert header to be used in text-to-speech implementations. This field is the text-to-speech version of header_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_header_text = 12;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> 
          getTtsHeaderTextFieldBuilder() {
        if (ttsHeaderTextBuilder_ == null) {
          ttsHeaderTextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder>(
                  getTtsHeaderText(),
                  getParentForChildren(),
                  isClean());
          ttsHeaderText_ = null;
        }
        return ttsHeaderTextBuilder_;
      }

      private com.google.transit.realtime.GtfsRealtime.TranslatedString ttsDescriptionText_;
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> ttsDescriptionTextBuilder_;
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public boolean hasTtsDescriptionText() {
        return ((bitField0_ & 0x00000100) != 0);
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString getTtsDescriptionText() {
        if (ttsDescriptionTextBuilder_ == null) {
          return ttsDescriptionText_ == null ? com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsDescriptionText_;
        } else {
          return ttsDescriptionTextBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public Builder setTtsDescriptionText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (ttsDescriptionTextBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ttsDescriptionText_ = value;
          onChanged();
        } else {
          ttsDescriptionTextBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public Builder setTtsDescriptionText(
          com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder builderForValue) {
        if (ttsDescriptionTextBuilder_ == null) {
          ttsDescriptionText_ = builderForValue.build();
          onChanged();
        } else {
          ttsDescriptionTextBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public Builder mergeTtsDescriptionText(com.google.transit.realtime.GtfsRealtime.TranslatedString value) {
        if (ttsDescriptionTextBuilder_ == null) {
          if (((bitField0_ & 0x00000100) != 0) &&
              ttsDescriptionText_ != null &&
              ttsDescriptionText_ != com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance()) {
            ttsDescriptionText_ =
              com.google.transit.realtime.GtfsRealtime.TranslatedString.newBuilder(ttsDescriptionText_).mergeFrom(value).buildPartial();
          } else {
            ttsDescriptionText_ = value;
          }
          onChanged();
        } else {
          ttsDescriptionTextBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000100;
        return this;
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public Builder clearTtsDescriptionText() {
        if (ttsDescriptionTextBuilder_ == null) {
          ttsDescriptionText_ = null;
          onChanged();
        } else {
          ttsDescriptionTextBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder getTtsDescriptionTextBuilder() {
        bitField0_ |= 0x00000100;
        onChanged();
        return getTtsDescriptionTextFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder getTtsDescriptionTextOrBuilder() {
        if (ttsDescriptionTextBuilder_ != null) {
          return ttsDescriptionTextBuilder_.getMessageOrBuilder();
        } else {
          return ttsDescriptionText_ == null ?
              com.google.transit.realtime.GtfsRealtime.TranslatedString.getDefaultInstance() : ttsDescriptionText_;
        }
      }
      /**
       * <pre>
       * Text for full description for the alert to be used in text-to-speech implementations. This field is the text-to-speech version of description_text.
       * </pre>
       *
       * <code>optional .transit_realtime.TranslatedString tts_description_text = 13;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
          com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder> 
          getTtsDescriptionTextFieldBuilder() {
        if (ttsDescriptionTextBuilder_ == null) {
          ttsDescriptionTextBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
              com.google.transit.realtime.GtfsRealtime.TranslatedString, com.google.transit.realtime.GtfsRealtime.TranslatedString.Builder, com.google.transit.realtime.GtfsRealtime.TranslatedStringOrBuilder>(
                  getTtsDescriptionText(),
                  getParentForChildren(),
                  isClean());
          ttsDescriptionText_ = null;
        }
        return ttsDescriptionTextBuilder_;
      }

      private int severityLevel_ = 1;
      /**
       * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
       */
      public boolean hasSeverityLevel() {
        return ((bitField0_ & 0x00000200) != 0);
      }
      /**
       * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
       */
      public com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel getSeverityLevel() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel result = com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel.valueOf(severityLevel_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel.UNKNOWN_SEVERITY : result;
      }
      /**
       * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
       */
      public Builder setSeverityLevel(com.google.transit.realtime.GtfsRealtime.Alert.SeverityLevel value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000200;
        severityLevel_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.Alert.SeverityLevel severity_level = 14 [default = UNKNOWN_SEVERITY];</code>
       */
      public Builder clearSeverityLevel() {
        bitField0_ = (bitField0_ & ~0x00000200);
        severityLevel_ = 1;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.Alert)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.Alert)
    private static final com.google.transit.realtime.GtfsRealtime.Alert DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.Alert();
    }

    public static com.google.transit.realtime.GtfsRealtime.Alert getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<Alert>
        PARSER = new com.google.protobuf.AbstractParser<Alert>() {
      @java.lang.Override
      public Alert parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Alert(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Alert> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Alert> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.Alert getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TimeRangeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.TimeRange)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<TimeRange> {

    /**
     * <pre>
     * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval starts at minus infinity.
     * </pre>
     *
     * <code>optional uint64 start = 1;</code>
     */
    boolean hasStart();
    /**
     * <pre>
     * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval starts at minus infinity.
     * </pre>
     *
     * <code>optional uint64 start = 1;</code>
     */
    long getStart();

    /**
     * <pre>
     * End time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval ends at plus infinity.
     * </pre>
     *
     * <code>optional uint64 end = 2;</code>
     */
    boolean hasEnd();
    /**
     * <pre>
     * End time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval ends at plus infinity.
     * </pre>
     *
     * <code>optional uint64 end = 2;</code>
     */
    long getEnd();
  }
  /**
   * <pre>
   * A time interval. The interval is considered active at time 't' if 't' is
   * greater than or equal to the start time and less than the end time.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.TimeRange}
   */
  public  static final class TimeRange extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        TimeRange> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.TimeRange)
      TimeRangeOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TimeRange.newBuilder() to construct.
    private TimeRange(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TimeRange, ?> builder) {
      super(builder);
    }
    private TimeRange() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TimeRange(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              bitField0_ |= 0x00000001;
              start_ = input.readUInt64();
              break;
            }
            case 16: {
              bitField0_ |= 0x00000002;
              end_ = input.readUInt64();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TimeRange_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TimeRange_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.TimeRange.class, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder.class);
    }

    private int bitField0_;
    public static final int START_FIELD_NUMBER = 1;
    private long start_;
    /**
     * <pre>
     * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval starts at minus infinity.
     * </pre>
     *
     * <code>optional uint64 start = 1;</code>
     */
    public boolean hasStart() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval starts at minus infinity.
     * </pre>
     *
     * <code>optional uint64 start = 1;</code>
     */
    public long getStart() {
      return start_;
    }

    public static final int END_FIELD_NUMBER = 2;
    private long end_;
    /**
     * <pre>
     * End time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval ends at plus infinity.
     * </pre>
     *
     * <code>optional uint64 end = 2;</code>
     */
    public boolean hasEnd() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * End time, in POSIX time (i.e., number of seconds since January 1st 1970
     * 00:00:00 UTC).
     * If missing, the interval ends at plus infinity.
     * </pre>
     *
     * <code>optional uint64 end = 2;</code>
     */
    public long getEnd() {
      return end_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TimeRange>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt64(1, start_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeUInt64(2, end_);
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, start_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(2, end_);
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TimeRange)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.TimeRange other = (com.google.transit.realtime.GtfsRealtime.TimeRange) obj;

      if (hasStart() != other.hasStart()) return false;
      if (hasStart()) {
        if (getStart()
            != other.getStart()) return false;
      }
      if (hasEnd() != other.hasEnd()) return false;
      if (hasEnd()) {
        if (getEnd()
            != other.getEnd()) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStart()) {
        hash = (37 * hash) + START_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getStart());
      }
      if (hasEnd()) {
        hash = (37 * hash) + END_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getEnd());
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TimeRange parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TimeRange prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A time interval. The interval is considered active at time 't' if 't' is
     * greater than or equal to the start time and less than the end time.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.TimeRange}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.TimeRange, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.TimeRange)
        com.google.transit.realtime.GtfsRealtime.TimeRangeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TimeRange_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TimeRange_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.TimeRange.class, com.google.transit.realtime.GtfsRealtime.TimeRange.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.TimeRange.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        start_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        end_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TimeRange_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TimeRange getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TimeRange build() {
        com.google.transit.realtime.GtfsRealtime.TimeRange result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TimeRange buildPartial() {
        com.google.transit.realtime.GtfsRealtime.TimeRange result = new com.google.transit.realtime.GtfsRealtime.TimeRange(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.start_ = start_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.end_ = end_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TimeRange, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TimeRange, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TimeRange, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TimeRange, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.TimeRange) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.TimeRange)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TimeRange other) {
        if (other == com.google.transit.realtime.GtfsRealtime.TimeRange.getDefaultInstance()) return this;
        if (other.hasStart()) {
          setStart(other.getStart());
        }
        if (other.hasEnd()) {
          setEnd(other.getEnd());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.TimeRange parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.TimeRange) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long start_ ;
      /**
       * <pre>
       * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval starts at minus infinity.
       * </pre>
       *
       * <code>optional uint64 start = 1;</code>
       */
      public boolean hasStart() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval starts at minus infinity.
       * </pre>
       *
       * <code>optional uint64 start = 1;</code>
       */
      public long getStart() {
        return start_;
      }
      /**
       * <pre>
       * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval starts at minus infinity.
       * </pre>
       *
       * <code>optional uint64 start = 1;</code>
       */
      public Builder setStart(long value) {
        bitField0_ |= 0x00000001;
        start_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Start time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval starts at minus infinity.
       * </pre>
       *
       * <code>optional uint64 start = 1;</code>
       */
      public Builder clearStart() {
        bitField0_ = (bitField0_ & ~0x00000001);
        start_ = 0L;
        onChanged();
        return this;
      }

      private long end_ ;
      /**
       * <pre>
       * End time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval ends at plus infinity.
       * </pre>
       *
       * <code>optional uint64 end = 2;</code>
       */
      public boolean hasEnd() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * End time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval ends at plus infinity.
       * </pre>
       *
       * <code>optional uint64 end = 2;</code>
       */
      public long getEnd() {
        return end_;
      }
      /**
       * <pre>
       * End time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval ends at plus infinity.
       * </pre>
       *
       * <code>optional uint64 end = 2;</code>
       */
      public Builder setEnd(long value) {
        bitField0_ |= 0x00000002;
        end_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * End time, in POSIX time (i.e., number of seconds since January 1st 1970
       * 00:00:00 UTC).
       * If missing, the interval ends at plus infinity.
       * </pre>
       *
       * <code>optional uint64 end = 2;</code>
       */
      public Builder clearEnd() {
        bitField0_ = (bitField0_ & ~0x00000002);
        end_ = 0L;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.TimeRange)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.TimeRange)
    private static final com.google.transit.realtime.GtfsRealtime.TimeRange DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TimeRange();
    }

    public static com.google.transit.realtime.GtfsRealtime.TimeRange getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<TimeRange>
        PARSER = new com.google.protobuf.AbstractParser<TimeRange>() {
      @java.lang.Override
      public TimeRange parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TimeRange(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TimeRange> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TimeRange> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.TimeRange getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PositionOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.Position)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<Position> {

    /**
     * <pre>
     * Degrees North, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float latitude = 1;</code>
     */
    boolean hasLatitude();
    /**
     * <pre>
     * Degrees North, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float latitude = 1;</code>
     */
    float getLatitude();

    /**
     * <pre>
     * Degrees East, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float longitude = 2;</code>
     */
    boolean hasLongitude();
    /**
     * <pre>
     * Degrees East, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float longitude = 2;</code>
     */
    float getLongitude();

    /**
     * <pre>
     * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
     * This can be the compass bearing, or the direction towards the next stop
     * or intermediate location.
     * This should not be direction deduced from the sequence of previous
     * positions, which can be computed from previous data.
     * </pre>
     *
     * <code>optional float bearing = 3;</code>
     */
    boolean hasBearing();
    /**
     * <pre>
     * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
     * This can be the compass bearing, or the direction towards the next stop
     * or intermediate location.
     * This should not be direction deduced from the sequence of previous
     * positions, which can be computed from previous data.
     * </pre>
     *
     * <code>optional float bearing = 3;</code>
     */
    float getBearing();

    /**
     * <pre>
     * Odometer value, in meters.
     * </pre>
     *
     * <code>optional double odometer = 4;</code>
     */
    boolean hasOdometer();
    /**
     * <pre>
     * Odometer value, in meters.
     * </pre>
     *
     * <code>optional double odometer = 4;</code>
     */
    double getOdometer();

    /**
     * <pre>
     * Momentary speed measured by the vehicle, in meters per second.
     * </pre>
     *
     * <code>optional float speed = 5;</code>
     */
    boolean hasSpeed();
    /**
     * <pre>
     * Momentary speed measured by the vehicle, in meters per second.
     * </pre>
     *
     * <code>optional float speed = 5;</code>
     */
    float getSpeed();
  }
  /**
   * <pre>
   * A position.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.Position}
   */
  public  static final class Position extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        Position> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.Position)
      PositionOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use Position.newBuilder() to construct.
    private Position(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.Position, ?> builder) {
      super(builder);
    }
    private Position() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private Position(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 13: {
              bitField0_ |= 0x00000001;
              latitude_ = input.readFloat();
              break;
            }
            case 21: {
              bitField0_ |= 0x00000002;
              longitude_ = input.readFloat();
              break;
            }
            case 29: {
              bitField0_ |= 0x00000004;
              bearing_ = input.readFloat();
              break;
            }
            case 33: {
              bitField0_ |= 0x00000008;
              odometer_ = input.readDouble();
              break;
            }
            case 45: {
              bitField0_ |= 0x00000010;
              speed_ = input.readFloat();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Position_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Position_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.Position.class, com.google.transit.realtime.GtfsRealtime.Position.Builder.class);
    }

    private int bitField0_;
    public static final int LATITUDE_FIELD_NUMBER = 1;
    private float latitude_;
    /**
     * <pre>
     * Degrees North, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float latitude = 1;</code>
     */
    public boolean hasLatitude() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Degrees North, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float latitude = 1;</code>
     */
    public float getLatitude() {
      return latitude_;
    }

    public static final int LONGITUDE_FIELD_NUMBER = 2;
    private float longitude_;
    /**
     * <pre>
     * Degrees East, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float longitude = 2;</code>
     */
    public boolean hasLongitude() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Degrees East, in the WGS-84 coordinate system.
     * </pre>
     *
     * <code>required float longitude = 2;</code>
     */
    public float getLongitude() {
      return longitude_;
    }

    public static final int BEARING_FIELD_NUMBER = 3;
    private float bearing_;
    /**
     * <pre>
     * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
     * This can be the compass bearing, or the direction towards the next stop
     * or intermediate location.
     * This should not be direction deduced from the sequence of previous
     * positions, which can be computed from previous data.
     * </pre>
     *
     * <code>optional float bearing = 3;</code>
     */
    public boolean hasBearing() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
     * This can be the compass bearing, or the direction towards the next stop
     * or intermediate location.
     * This should not be direction deduced from the sequence of previous
     * positions, which can be computed from previous data.
     * </pre>
     *
     * <code>optional float bearing = 3;</code>
     */
    public float getBearing() {
      return bearing_;
    }

    public static final int ODOMETER_FIELD_NUMBER = 4;
    private double odometer_;
    /**
     * <pre>
     * Odometer value, in meters.
     * </pre>
     *
     * <code>optional double odometer = 4;</code>
     */
    public boolean hasOdometer() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Odometer value, in meters.
     * </pre>
     *
     * <code>optional double odometer = 4;</code>
     */
    public double getOdometer() {
      return odometer_;
    }

    public static final int SPEED_FIELD_NUMBER = 5;
    private float speed_;
    /**
     * <pre>
     * Momentary speed measured by the vehicle, in meters per second.
     * </pre>
     *
     * <code>optional float speed = 5;</code>
     */
    public boolean hasSpeed() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Momentary speed measured by the vehicle, in meters per second.
     * </pre>
     *
     * <code>optional float speed = 5;</code>
     */
    public float getSpeed() {
      return speed_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasLatitude()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasLongitude()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.Position>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeFloat(1, latitude_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeFloat(2, longitude_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeFloat(3, bearing_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeDouble(4, odometer_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeFloat(5, speed_);
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(1, latitude_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(2, longitude_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(3, bearing_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(4, odometer_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(5, speed_);
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.Position)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.Position other = (com.google.transit.realtime.GtfsRealtime.Position) obj;

      if (hasLatitude() != other.hasLatitude()) return false;
      if (hasLatitude()) {
        if (java.lang.Float.floatToIntBits(getLatitude())
            != java.lang.Float.floatToIntBits(
                other.getLatitude())) return false;
      }
      if (hasLongitude() != other.hasLongitude()) return false;
      if (hasLongitude()) {
        if (java.lang.Float.floatToIntBits(getLongitude())
            != java.lang.Float.floatToIntBits(
                other.getLongitude())) return false;
      }
      if (hasBearing() != other.hasBearing()) return false;
      if (hasBearing()) {
        if (java.lang.Float.floatToIntBits(getBearing())
            != java.lang.Float.floatToIntBits(
                other.getBearing())) return false;
      }
      if (hasOdometer() != other.hasOdometer()) return false;
      if (hasOdometer()) {
        if (java.lang.Double.doubleToLongBits(getOdometer())
            != java.lang.Double.doubleToLongBits(
                other.getOdometer())) return false;
      }
      if (hasSpeed() != other.hasSpeed()) return false;
      if (hasSpeed()) {
        if (java.lang.Float.floatToIntBits(getSpeed())
            != java.lang.Float.floatToIntBits(
                other.getSpeed())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLatitude()) {
        hash = (37 * hash) + LATITUDE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(
            getLatitude());
      }
      if (hasLongitude()) {
        hash = (37 * hash) + LONGITUDE_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(
            getLongitude());
      }
      if (hasBearing()) {
        hash = (37 * hash) + BEARING_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(
            getBearing());
      }
      if (hasOdometer()) {
        hash = (37 * hash) + ODOMETER_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getOdometer()));
      }
      if (hasSpeed()) {
        hash = (37 * hash) + SPEED_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(
            getSpeed());
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.Position parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.Position prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A position.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.Position}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.Position, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.Position)
        com.google.transit.realtime.GtfsRealtime.PositionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Position_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Position_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.Position.class, com.google.transit.realtime.GtfsRealtime.Position.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.Position.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        latitude_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000001);
        longitude_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000002);
        bearing_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000004);
        odometer_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000008);
        speed_ = 0F;
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_Position_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.Position getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.Position build() {
        com.google.transit.realtime.GtfsRealtime.Position result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.Position buildPartial() {
        com.google.transit.realtime.GtfsRealtime.Position result = new com.google.transit.realtime.GtfsRealtime.Position(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.latitude_ = latitude_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.longitude_ = longitude_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.bearing_ = bearing_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.odometer_ = odometer_;
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.speed_ = speed_;
          to_bitField0_ |= 0x00000010;
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Position, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Position, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Position, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.Position, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.Position) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.Position)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.Position other) {
        if (other == com.google.transit.realtime.GtfsRealtime.Position.getDefaultInstance()) return this;
        if (other.hasLatitude()) {
          setLatitude(other.getLatitude());
        }
        if (other.hasLongitude()) {
          setLongitude(other.getLongitude());
        }
        if (other.hasBearing()) {
          setBearing(other.getBearing());
        }
        if (other.hasOdometer()) {
          setOdometer(other.getOdometer());
        }
        if (other.hasSpeed()) {
          setSpeed(other.getSpeed());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasLatitude()) {
          return false;
        }
        if (!hasLongitude()) {
          return false;
        }
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.Position parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.Position) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private float latitude_ ;
      /**
       * <pre>
       * Degrees North, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float latitude = 1;</code>
       */
      public boolean hasLatitude() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Degrees North, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float latitude = 1;</code>
       */
      public float getLatitude() {
        return latitude_;
      }
      /**
       * <pre>
       * Degrees North, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float latitude = 1;</code>
       */
      public Builder setLatitude(float value) {
        bitField0_ |= 0x00000001;
        latitude_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Degrees North, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float latitude = 1;</code>
       */
      public Builder clearLatitude() {
        bitField0_ = (bitField0_ & ~0x00000001);
        latitude_ = 0F;
        onChanged();
        return this;
      }

      private float longitude_ ;
      /**
       * <pre>
       * Degrees East, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float longitude = 2;</code>
       */
      public boolean hasLongitude() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * Degrees East, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float longitude = 2;</code>
       */
      public float getLongitude() {
        return longitude_;
      }
      /**
       * <pre>
       * Degrees East, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float longitude = 2;</code>
       */
      public Builder setLongitude(float value) {
        bitField0_ |= 0x00000002;
        longitude_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Degrees East, in the WGS-84 coordinate system.
       * </pre>
       *
       * <code>required float longitude = 2;</code>
       */
      public Builder clearLongitude() {
        bitField0_ = (bitField0_ & ~0x00000002);
        longitude_ = 0F;
        onChanged();
        return this;
      }

      private float bearing_ ;
      /**
       * <pre>
       * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
       * This can be the compass bearing, or the direction towards the next stop
       * or intermediate location.
       * This should not be direction deduced from the sequence of previous
       * positions, which can be computed from previous data.
       * </pre>
       *
       * <code>optional float bearing = 3;</code>
       */
      public boolean hasBearing() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
       * This can be the compass bearing, or the direction towards the next stop
       * or intermediate location.
       * This should not be direction deduced from the sequence of previous
       * positions, which can be computed from previous data.
       * </pre>
       *
       * <code>optional float bearing = 3;</code>
       */
      public float getBearing() {
        return bearing_;
      }
      /**
       * <pre>
       * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
       * This can be the compass bearing, or the direction towards the next stop
       * or intermediate location.
       * This should not be direction deduced from the sequence of previous
       * positions, which can be computed from previous data.
       * </pre>
       *
       * <code>optional float bearing = 3;</code>
       */
      public Builder setBearing(float value) {
        bitField0_ |= 0x00000004;
        bearing_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Bearing, in degrees, clockwise from North, i.e., 0 is North and 90 is East.
       * This can be the compass bearing, or the direction towards the next stop
       * or intermediate location.
       * This should not be direction deduced from the sequence of previous
       * positions, which can be computed from previous data.
       * </pre>
       *
       * <code>optional float bearing = 3;</code>
       */
      public Builder clearBearing() {
        bitField0_ = (bitField0_ & ~0x00000004);
        bearing_ = 0F;
        onChanged();
        return this;
      }

      private double odometer_ ;
      /**
       * <pre>
       * Odometer value, in meters.
       * </pre>
       *
       * <code>optional double odometer = 4;</code>
       */
      public boolean hasOdometer() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * Odometer value, in meters.
       * </pre>
       *
       * <code>optional double odometer = 4;</code>
       */
      public double getOdometer() {
        return odometer_;
      }
      /**
       * <pre>
       * Odometer value, in meters.
       * </pre>
       *
       * <code>optional double odometer = 4;</code>
       */
      public Builder setOdometer(double value) {
        bitField0_ |= 0x00000008;
        odometer_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Odometer value, in meters.
       * </pre>
       *
       * <code>optional double odometer = 4;</code>
       */
      public Builder clearOdometer() {
        bitField0_ = (bitField0_ & ~0x00000008);
        odometer_ = 0D;
        onChanged();
        return this;
      }

      private float speed_ ;
      /**
       * <pre>
       * Momentary speed measured by the vehicle, in meters per second.
       * </pre>
       *
       * <code>optional float speed = 5;</code>
       */
      public boolean hasSpeed() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * Momentary speed measured by the vehicle, in meters per second.
       * </pre>
       *
       * <code>optional float speed = 5;</code>
       */
      public float getSpeed() {
        return speed_;
      }
      /**
       * <pre>
       * Momentary speed measured by the vehicle, in meters per second.
       * </pre>
       *
       * <code>optional float speed = 5;</code>
       */
      public Builder setSpeed(float value) {
        bitField0_ |= 0x00000010;
        speed_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * Momentary speed measured by the vehicle, in meters per second.
       * </pre>
       *
       * <code>optional float speed = 5;</code>
       */
      public Builder clearSpeed() {
        bitField0_ = (bitField0_ & ~0x00000010);
        speed_ = 0F;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.Position)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.Position)
    private static final com.google.transit.realtime.GtfsRealtime.Position DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.Position();
    }

    public static com.google.transit.realtime.GtfsRealtime.Position getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<Position>
        PARSER = new com.google.protobuf.AbstractParser<Position>() {
      @java.lang.Override
      public Position parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Position(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<Position> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Position> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.Position getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TripDescriptorOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.TripDescriptor)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<TripDescriptor> {

    /**
     * <pre>
     * The trip_id from the GTFS feed that this selector refers to.
     * For non frequency-based trips, this field is enough to uniquely identify
     * the trip. For frequency-based trip, start_time and start_date might also be
     * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
     * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
     * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
     * </pre>
     *
     * <code>optional string trip_id = 1;</code>
     */
    boolean hasTripId();
    /**
     * <pre>
     * The trip_id from the GTFS feed that this selector refers to.
     * For non frequency-based trips, this field is enough to uniquely identify
     * the trip. For frequency-based trip, start_time and start_date might also be
     * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
     * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
     * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
     * </pre>
     *
     * <code>optional string trip_id = 1;</code>
     */
    java.lang.String getTripId();
    /**
     * <pre>
     * The trip_id from the GTFS feed that this selector refers to.
     * For non frequency-based trips, this field is enough to uniquely identify
     * the trip. For frequency-based trip, start_time and start_date might also be
     * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
     * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
     * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
     * </pre>
     *
     * <code>optional string trip_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getTripIdBytes();

    /**
     * <pre>
     * The route_id from the GTFS that this selector refers to.
     * </pre>
     *
     * <code>optional string route_id = 5;</code>
     */
    boolean hasRouteId();
    /**
     * <pre>
     * The route_id from the GTFS that this selector refers to.
     * </pre>
     *
     * <code>optional string route_id = 5;</code>
     */
    java.lang.String getRouteId();
    /**
     * <pre>
     * The route_id from the GTFS that this selector refers to.
     * </pre>
     *
     * <code>optional string route_id = 5;</code>
     */
    com.google.protobuf.ByteString
        getRouteIdBytes();

    /**
     * <pre>
     * The direction_id from the GTFS feed trips.txt file, indicating the
     * direction of travel for trips this selector refers to.
     * </pre>
     *
     * <code>optional uint32 direction_id = 6;</code>
     */
    boolean hasDirectionId();
    /**
     * <pre>
     * The direction_id from the GTFS feed trips.txt file, indicating the
     * direction of travel for trips this selector refers to.
     * </pre>
     *
     * <code>optional uint32 direction_id = 6;</code>
     */
    int getDirectionId();

    /**
     * <pre>
     * The initially scheduled start time of this trip instance.
     * When the trip_id corresponds to a non-frequency-based trip, this field
     * should either be omitted or be equal to the value in the GTFS feed. When
     * the trip_id correponds to a frequency-based trip, the start_time must be
     * specified for trip updates and vehicle positions. If the trip corresponds
     * to exact_times=1 GTFS record, then start_time must be some multiple
     * (including zero) of headway_secs later than frequencies.txt start_time for
     * the corresponding time period. If the trip corresponds to exact_times=0,
     * then its start_time may be arbitrary, and is initially expected to be the
     * first departure of the trip. Once established, the start_time of this
     * frequency-based trip should be considered immutable, even if the first
     * departure time changes -- that time change may instead be reflected in a
     * StopTimeUpdate.
     * Format and semantics of the field is same as that of
     * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
     * </pre>
     *
     * <code>optional string start_time = 2;</code>
     */
    boolean hasStartTime();
    /**
     * <pre>
     * The initially scheduled start time of this trip instance.
     * When the trip_id corresponds to a non-frequency-based trip, this field
     * should either be omitted or be equal to the value in the GTFS feed. When
     * the trip_id correponds to a frequency-based trip, the start_time must be
     * specified for trip updates and vehicle positions. If the trip corresponds
     * to exact_times=1 GTFS record, then start_time must be some multiple
     * (including zero) of headway_secs later than frequencies.txt start_time for
     * the corresponding time period. If the trip corresponds to exact_times=0,
     * then its start_time may be arbitrary, and is initially expected to be the
     * first departure of the trip. Once established, the start_time of this
     * frequency-based trip should be considered immutable, even if the first
     * departure time changes -- that time change may instead be reflected in a
     * StopTimeUpdate.
     * Format and semantics of the field is same as that of
     * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
     * </pre>
     *
     * <code>optional string start_time = 2;</code>
     */
    java.lang.String getStartTime();
    /**
     * <pre>
     * The initially scheduled start time of this trip instance.
     * When the trip_id corresponds to a non-frequency-based trip, this field
     * should either be omitted or be equal to the value in the GTFS feed. When
     * the trip_id correponds to a frequency-based trip, the start_time must be
     * specified for trip updates and vehicle positions. If the trip corresponds
     * to exact_times=1 GTFS record, then start_time must be some multiple
     * (including zero) of headway_secs later than frequencies.txt start_time for
     * the corresponding time period. If the trip corresponds to exact_times=0,
     * then its start_time may be arbitrary, and is initially expected to be the
     * first departure of the trip. Once established, the start_time of this
     * frequency-based trip should be considered immutable, even if the first
     * departure time changes -- that time change may instead be reflected in a
     * StopTimeUpdate.
     * Format and semantics of the field is same as that of
     * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
     * </pre>
     *
     * <code>optional string start_time = 2;</code>
     */
    com.google.protobuf.ByteString
        getStartTimeBytes();

    /**
     * <pre>
     * The scheduled start date of this trip instance.
     * Must be provided to disambiguate trips that are so late as to collide with
     * a scheduled trip on a next day. For example, for a train that departs 8:00
     * and 20:00 every day, and is 12 hours late, there would be two distinct
     * trips on the same time.
     * This field can be provided but is not mandatory for schedules in which such
     * collisions are impossible - for example, a service running on hourly
     * schedule where a vehicle that is one hour late is not considered to be
     * related to schedule anymore.
     * In YYYYMMDD format.
     * </pre>
     *
     * <code>optional string start_date = 3;</code>
     */
    boolean hasStartDate();
    /**
     * <pre>
     * The scheduled start date of this trip instance.
     * Must be provided to disambiguate trips that are so late as to collide with
     * a scheduled trip on a next day. For example, for a train that departs 8:00
     * and 20:00 every day, and is 12 hours late, there would be two distinct
     * trips on the same time.
     * This field can be provided but is not mandatory for schedules in which such
     * collisions are impossible - for example, a service running on hourly
     * schedule where a vehicle that is one hour late is not considered to be
     * related to schedule anymore.
     * In YYYYMMDD format.
     * </pre>
     *
     * <code>optional string start_date = 3;</code>
     */
    java.lang.String getStartDate();
    /**
     * <pre>
     * The scheduled start date of this trip instance.
     * Must be provided to disambiguate trips that are so late as to collide with
     * a scheduled trip on a next day. For example, for a train that departs 8:00
     * and 20:00 every day, and is 12 hours late, there would be two distinct
     * trips on the same time.
     * This field can be provided but is not mandatory for schedules in which such
     * collisions are impossible - for example, a service running on hourly
     * schedule where a vehicle that is one hour late is not considered to be
     * related to schedule anymore.
     * In YYYYMMDD format.
     * </pre>
     *
     * <code>optional string start_date = 3;</code>
     */
    com.google.protobuf.ByteString
        getStartDateBytes();

    /**
     * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
     */
    boolean hasScheduleRelationship();
    /**
     * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
     */
    com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship getScheduleRelationship();
  }
  /**
   * <pre>
   * A descriptor that identifies an instance of a GTFS trip, or all instances of
   * a trip along a route.
   * - To specify a single trip instance, the trip_id (and if necessary,
   *   start_time) is set. If route_id is also set, then it should be same as one
   *   that the given trip corresponds to.
   * - To specify all the trips along a given route, only the route_id should be
   *   set. Note that if the trip_id is not known, then stop sequence ids in
   *   TripUpdate are not sufficient, and stop_ids must be provided as well. In
   *   addition, absolute arrival/departure times must be provided.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.TripDescriptor}
   */
  public  static final class TripDescriptor extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        TripDescriptor> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.TripDescriptor)
      TripDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use TripDescriptor.newBuilder() to construct.
    private TripDescriptor(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.TripDescriptor, ?> builder) {
      super(builder);
    }
    private TripDescriptor() {
      tripId_ = "";
      routeId_ = "";
      startTime_ = "";
      startDate_ = "";
      scheduleRelationship_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private TripDescriptor(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              tripId_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000008;
              startTime_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000010;
              startDate_ = bs;
              break;
            }
            case 32: {
              int rawValue = input.readEnum();
                @SuppressWarnings("deprecation")
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship value = com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(4, rawValue);
              } else {
                bitField0_ |= 0x00000020;
                scheduleRelationship_ = rawValue;
              }
              break;
            }
            case 42: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              routeId_ = bs;
              break;
            }
            case 48: {
              bitField0_ |= 0x00000004;
              directionId_ = input.readUInt32();
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.TripDescriptor.class, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder.class);
    }

    /**
     * <pre>
     * The relation between this trip and the static schedule. If a trip is done
     * in accordance with temporary schedule, not reflected in GTFS, then it
     * shouldn't be marked as SCHEDULED, but likely as ADDED.
     * </pre>
     *
     * Protobuf enum {@code transit_realtime.TripDescriptor.ScheduleRelationship}
     */
    public enum ScheduleRelationship
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <pre>
       * Trip that is running in accordance with its GTFS schedule, or is close
       * enough to the scheduled trip to be associated with it.
       * </pre>
       *
       * <code>SCHEDULED = 0;</code>
       */
      SCHEDULED(0),
      /**
       * <pre>
       * An extra trip that was added in addition to a running schedule, for
       * example, to replace a broken vehicle or to respond to sudden passenger
       * load.
       * NOTE: Currently, behavior is unspecified for feeds that use this mode. There are discussions on the GTFS GitHub
       * [(1)](https://github.com/google/transit/issues/106) [(2)](https://github.com/google/transit/pull/221)
       * [(3)](https://github.com/google/transit/pull/219) around fully specifying or deprecating ADDED trips and the
       * documentation will be updated when those discussions are finalized.
       * </pre>
       *
       * <code>ADDED = 1;</code>
       */
      ADDED(1),
      /**
       * <pre>
       * A trip that is running with no schedule associated to it (GTFS frequencies.txt exact_times=0).
       * Trips with ScheduleRelationship=UNSCHEDULED must also set all StopTimeUpdates.ScheduleRelationship=UNSCHEDULED.
       * </pre>
       *
       * <code>UNSCHEDULED = 2;</code>
       */
      UNSCHEDULED(2),
      /**
       * <pre>
       * A trip that existed in the schedule but was removed.
       * </pre>
       *
       * <code>CANCELED = 3;</code>
       */
      CANCELED(3),
      /**
       * <pre>
       * Should not be used - for backwards-compatibility only.
       * </pre>
       *
       * <code>REPLACEMENT = 5 [deprecated = true];</code>
       */
      @java.lang.Deprecated
      REPLACEMENT(5),
      /**
       * <pre>
       * An extra trip that was added in addition to a running schedule, for example, to replace a broken vehicle or to
       * respond to sudden passenger load. Used with TripUpdate.TripProperties.trip_id, TripUpdate.TripProperties.start_date,
       * and TripUpdate.TripProperties.start_time to copy an existing trip from static GTFS but start at a different service
       * date and/or time. Duplicating a trip is allowed if the service related to the original trip in (CSV) GTFS
       * (in calendar.txt or calendar_dates.txt) is operating within the next 30 days. The trip to be duplicated is
       * identified via TripUpdate.TripDescriptor.trip_id. This enumeration does not modify the existing trip referenced by
       * TripUpdate.TripDescriptor.trip_id - if a producer wants to cancel the original trip, it must publish a separate
       * TripUpdate with the value of CANCELED. Trips defined in GTFS frequencies.txt with exact_times that is empty or
       * equal to 0 cannot be duplicated. The VehiclePosition.TripDescriptor.trip_id for the new trip must contain
       * the matching value from TripUpdate.TripProperties.trip_id and VehiclePosition.TripDescriptor.ScheduleRelationship
       * must also be set to DUPLICATED.
       * Existing producers and consumers that were using the ADDED enumeration to represent duplicated trips must follow
       * the migration guide (https://github.com/google/transit/tree/master/gtfs-realtime/spec/en/examples/migration-duplicated.md)
       * to transition to the DUPLICATED enumeration.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>DUPLICATED = 6;</code>
       */
      DUPLICATED(6),
      ;

      /**
       * <pre>
       * Trip that is running in accordance with its GTFS schedule, or is close
       * enough to the scheduled trip to be associated with it.
       * </pre>
       *
       * <code>SCHEDULED = 0;</code>
       */
      public static final int SCHEDULED_VALUE = 0;
      /**
       * <pre>
       * An extra trip that was added in addition to a running schedule, for
       * example, to replace a broken vehicle or to respond to sudden passenger
       * load.
       * NOTE: Currently, behavior is unspecified for feeds that use this mode. There are discussions on the GTFS GitHub
       * [(1)](https://github.com/google/transit/issues/106) [(2)](https://github.com/google/transit/pull/221)
       * [(3)](https://github.com/google/transit/pull/219) around fully specifying or deprecating ADDED trips and the
       * documentation will be updated when those discussions are finalized.
       * </pre>
       *
       * <code>ADDED = 1;</code>
       */
      public static final int ADDED_VALUE = 1;
      /**
       * <pre>
       * A trip that is running with no schedule associated to it (GTFS frequencies.txt exact_times=0).
       * Trips with ScheduleRelationship=UNSCHEDULED must also set all StopTimeUpdates.ScheduleRelationship=UNSCHEDULED.
       * </pre>
       *
       * <code>UNSCHEDULED = 2;</code>
       */
      public static final int UNSCHEDULED_VALUE = 2;
      /**
       * <pre>
       * A trip that existed in the schedule but was removed.
       * </pre>
       *
       * <code>CANCELED = 3;</code>
       */
      public static final int CANCELED_VALUE = 3;
      /**
       * <pre>
       * Should not be used - for backwards-compatibility only.
       * </pre>
       *
       * <code>REPLACEMENT = 5 [deprecated = true];</code>
       */
      public static final int REPLACEMENT_VALUE = 5;
      /**
       * <pre>
       * An extra trip that was added in addition to a running schedule, for example, to replace a broken vehicle or to
       * respond to sudden passenger load. Used with TripUpdate.TripProperties.trip_id, TripUpdate.TripProperties.start_date,
       * and TripUpdate.TripProperties.start_time to copy an existing trip from static GTFS but start at a different service
       * date and/or time. Duplicating a trip is allowed if the service related to the original trip in (CSV) GTFS
       * (in calendar.txt or calendar_dates.txt) is operating within the next 30 days. The trip to be duplicated is
       * identified via TripUpdate.TripDescriptor.trip_id. This enumeration does not modify the existing trip referenced by
       * TripUpdate.TripDescriptor.trip_id - if a producer wants to cancel the original trip, it must publish a separate
       * TripUpdate with the value of CANCELED. Trips defined in GTFS frequencies.txt with exact_times that is empty or
       * equal to 0 cannot be duplicated. The VehiclePosition.TripDescriptor.trip_id for the new trip must contain
       * the matching value from TripUpdate.TripProperties.trip_id and VehiclePosition.TripDescriptor.ScheduleRelationship
       * must also be set to DUPLICATED.
       * Existing producers and consumers that were using the ADDED enumeration to represent duplicated trips must follow
       * the migration guide (https://github.com/google/transit/tree/master/gtfs-realtime/spec/en/examples/migration-duplicated.md)
       * to transition to the DUPLICATED enumeration.
       * NOTE: This field is still experimental, and subject to change. It may be formally adopted in the future.
       * </pre>
       *
       * <code>DUPLICATED = 6;</code>
       */
      public static final int DUPLICATED_VALUE = 6;


      public final int getNumber() {
        return value;
      }

      /**
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ScheduleRelationship valueOf(int value) {
        return forNumber(value);
      }

      public static ScheduleRelationship forNumber(int value) {
        switch (value) {
          case 0: return SCHEDULED;
          case 1: return ADDED;
          case 2: return UNSCHEDULED;
          case 3: return CANCELED;
          case 5: return REPLACEMENT;
          case 6: return DUPLICATED;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ScheduleRelationship>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          ScheduleRelationship> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ScheduleRelationship>() {
              public ScheduleRelationship findValueByNumber(int number) {
                return ScheduleRelationship.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDescriptor().getEnumTypes().get(0);
      }

      private static final ScheduleRelationship[] VALUES = values();

      public static ScheduleRelationship valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ScheduleRelationship(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:transit_realtime.TripDescriptor.ScheduleRelationship)
    }

    private int bitField0_;
    public static final int TRIP_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object tripId_;
    /**
     * <pre>
     * The trip_id from the GTFS feed that this selector refers to.
     * For non frequency-based trips, this field is enough to uniquely identify
     * the trip. For frequency-based trip, start_time and start_date might also be
     * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
     * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
     * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
     * </pre>
     *
     * <code>optional string trip_id = 1;</code>
     */
    public boolean hasTripId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * The trip_id from the GTFS feed that this selector refers to.
     * For non frequency-based trips, this field is enough to uniquely identify
     * the trip. For frequency-based trip, start_time and start_date might also be
     * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
     * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
     * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
     * </pre>
     *
     * <code>optional string trip_id = 1;</code>
     */
    public java.lang.String getTripId() {
      java.lang.Object ref = tripId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          tripId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The trip_id from the GTFS feed that this selector refers to.
     * For non frequency-based trips, this field is enough to uniquely identify
     * the trip. For frequency-based trip, start_time and start_date might also be
     * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
     * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
     * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
     * </pre>
     *
     * <code>optional string trip_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getTripIdBytes() {
      java.lang.Object ref = tripId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tripId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROUTE_ID_FIELD_NUMBER = 5;
    private volatile java.lang.Object routeId_;
    /**
     * <pre>
     * The route_id from the GTFS that this selector refers to.
     * </pre>
     *
     * <code>optional string route_id = 5;</code>
     */
    public boolean hasRouteId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * The route_id from the GTFS that this selector refers to.
     * </pre>
     *
     * <code>optional string route_id = 5;</code>
     */
    public java.lang.String getRouteId() {
      java.lang.Object ref = routeId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          routeId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The route_id from the GTFS that this selector refers to.
     * </pre>
     *
     * <code>optional string route_id = 5;</code>
     */
    public com.google.protobuf.ByteString
        getRouteIdBytes() {
      java.lang.Object ref = routeId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        routeId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DIRECTION_ID_FIELD_NUMBER = 6;
    private int directionId_;
    /**
     * <pre>
     * The direction_id from the GTFS feed trips.txt file, indicating the
     * direction of travel for trips this selector refers to.
     * </pre>
     *
     * <code>optional uint32 direction_id = 6;</code>
     */
    public boolean hasDirectionId() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * The direction_id from the GTFS feed trips.txt file, indicating the
     * direction of travel for trips this selector refers to.
     * </pre>
     *
     * <code>optional uint32 direction_id = 6;</code>
     */
    public int getDirectionId() {
      return directionId_;
    }

    public static final int START_TIME_FIELD_NUMBER = 2;
    private volatile java.lang.Object startTime_;
    /**
     * <pre>
     * The initially scheduled start time of this trip instance.
     * When the trip_id corresponds to a non-frequency-based trip, this field
     * should either be omitted or be equal to the value in the GTFS feed. When
     * the trip_id correponds to a frequency-based trip, the start_time must be
     * specified for trip updates and vehicle positions. If the trip corresponds
     * to exact_times=1 GTFS record, then start_time must be some multiple
     * (including zero) of headway_secs later than frequencies.txt start_time for
     * the corresponding time period. If the trip corresponds to exact_times=0,
     * then its start_time may be arbitrary, and is initially expected to be the
     * first departure of the trip. Once established, the start_time of this
     * frequency-based trip should be considered immutable, even if the first
     * departure time changes -- that time change may instead be reflected in a
     * StopTimeUpdate.
     * Format and semantics of the field is same as that of
     * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
     * </pre>
     *
     * <code>optional string start_time = 2;</code>
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * The initially scheduled start time of this trip instance.
     * When the trip_id corresponds to a non-frequency-based trip, this field
     * should either be omitted or be equal to the value in the GTFS feed. When
     * the trip_id correponds to a frequency-based trip, the start_time must be
     * specified for trip updates and vehicle positions. If the trip corresponds
     * to exact_times=1 GTFS record, then start_time must be some multiple
     * (including zero) of headway_secs later than frequencies.txt start_time for
     * the corresponding time period. If the trip corresponds to exact_times=0,
     * then its start_time may be arbitrary, and is initially expected to be the
     * first departure of the trip. Once established, the start_time of this
     * frequency-based trip should be considered immutable, even if the first
     * departure time changes -- that time change may instead be reflected in a
     * StopTimeUpdate.
     * Format and semantics of the field is same as that of
     * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
     * </pre>
     *
     * <code>optional string start_time = 2;</code>
     */
    public java.lang.String getStartTime() {
      java.lang.Object ref = startTime_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          startTime_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The initially scheduled start time of this trip instance.
     * When the trip_id corresponds to a non-frequency-based trip, this field
     * should either be omitted or be equal to the value in the GTFS feed. When
     * the trip_id correponds to a frequency-based trip, the start_time must be
     * specified for trip updates and vehicle positions. If the trip corresponds
     * to exact_times=1 GTFS record, then start_time must be some multiple
     * (including zero) of headway_secs later than frequencies.txt start_time for
     * the corresponding time period. If the trip corresponds to exact_times=0,
     * then its start_time may be arbitrary, and is initially expected to be the
     * first departure of the trip. Once established, the start_time of this
     * frequency-based trip should be considered immutable, even if the first
     * departure time changes -- that time change may instead be reflected in a
     * StopTimeUpdate.
     * Format and semantics of the field is same as that of
     * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
     * </pre>
     *
     * <code>optional string start_time = 2;</code>
     */
    public com.google.protobuf.ByteString
        getStartTimeBytes() {
      java.lang.Object ref = startTime_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startTime_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int START_DATE_FIELD_NUMBER = 3;
    private volatile java.lang.Object startDate_;
    /**
     * <pre>
     * The scheduled start date of this trip instance.
     * Must be provided to disambiguate trips that are so late as to collide with
     * a scheduled trip on a next day. For example, for a train that departs 8:00
     * and 20:00 every day, and is 12 hours late, there would be two distinct
     * trips on the same time.
     * This field can be provided but is not mandatory for schedules in which such
     * collisions are impossible - for example, a service running on hourly
     * schedule where a vehicle that is one hour late is not considered to be
     * related to schedule anymore.
     * In YYYYMMDD format.
     * </pre>
     *
     * <code>optional string start_date = 3;</code>
     */
    public boolean hasStartDate() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * The scheduled start date of this trip instance.
     * Must be provided to disambiguate trips that are so late as to collide with
     * a scheduled trip on a next day. For example, for a train that departs 8:00
     * and 20:00 every day, and is 12 hours late, there would be two distinct
     * trips on the same time.
     * This field can be provided but is not mandatory for schedules in which such
     * collisions are impossible - for example, a service running on hourly
     * schedule where a vehicle that is one hour late is not considered to be
     * related to schedule anymore.
     * In YYYYMMDD format.
     * </pre>
     *
     * <code>optional string start_date = 3;</code>
     */
    public java.lang.String getStartDate() {
      java.lang.Object ref = startDate_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          startDate_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The scheduled start date of this trip instance.
     * Must be provided to disambiguate trips that are so late as to collide with
     * a scheduled trip on a next day. For example, for a train that departs 8:00
     * and 20:00 every day, and is 12 hours late, there would be two distinct
     * trips on the same time.
     * This field can be provided but is not mandatory for schedules in which such
     * collisions are impossible - for example, a service running on hourly
     * schedule where a vehicle that is one hour late is not considered to be
     * related to schedule anymore.
     * In YYYYMMDD format.
     * </pre>
     *
     * <code>optional string start_date = 3;</code>
     */
    public com.google.protobuf.ByteString
        getStartDateBytes() {
      java.lang.Object ref = startDate_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        startDate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEDULE_RELATIONSHIP_FIELD_NUMBER = 4;
    private int scheduleRelationship_;
    /**
     * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
     */
    public boolean hasScheduleRelationship() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
     */
    public com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship getScheduleRelationship() {
      @SuppressWarnings("deprecation")
      com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship result = com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship.valueOf(scheduleRelationship_);
      return result == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship.SCHEDULED : result;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.TripDescriptor>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, tripId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, startTime_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, startDate_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeEnum(4, scheduleRelationship_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, routeId_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt32(6, directionId_);
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, tripId_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, startTime_);
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, startDate_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, scheduleRelationship_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, routeId_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(6, directionId_);
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.TripDescriptor)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.TripDescriptor other = (com.google.transit.realtime.GtfsRealtime.TripDescriptor) obj;

      if (hasTripId() != other.hasTripId()) return false;
      if (hasTripId()) {
        if (!getTripId()
            .equals(other.getTripId())) return false;
      }
      if (hasRouteId() != other.hasRouteId()) return false;
      if (hasRouteId()) {
        if (!getRouteId()
            .equals(other.getRouteId())) return false;
      }
      if (hasDirectionId() != other.hasDirectionId()) return false;
      if (hasDirectionId()) {
        if (getDirectionId()
            != other.getDirectionId()) return false;
      }
      if (hasStartTime() != other.hasStartTime()) return false;
      if (hasStartTime()) {
        if (!getStartTime()
            .equals(other.getStartTime())) return false;
      }
      if (hasStartDate() != other.hasStartDate()) return false;
      if (hasStartDate()) {
        if (!getStartDate()
            .equals(other.getStartDate())) return false;
      }
      if (hasScheduleRelationship() != other.hasScheduleRelationship()) return false;
      if (hasScheduleRelationship()) {
        if (scheduleRelationship_ != other.scheduleRelationship_) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTripId()) {
        hash = (37 * hash) + TRIP_ID_FIELD_NUMBER;
        hash = (53 * hash) + getTripId().hashCode();
      }
      if (hasRouteId()) {
        hash = (37 * hash) + ROUTE_ID_FIELD_NUMBER;
        hash = (53 * hash) + getRouteId().hashCode();
      }
      if (hasDirectionId()) {
        hash = (37 * hash) + DIRECTION_ID_FIELD_NUMBER;
        hash = (53 * hash) + getDirectionId();
      }
      if (hasStartTime()) {
        hash = (37 * hash) + START_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getStartTime().hashCode();
      }
      if (hasStartDate()) {
        hash = (37 * hash) + START_DATE_FIELD_NUMBER;
        hash = (53 * hash) + getStartDate().hashCode();
      }
      if (hasScheduleRelationship()) {
        hash = (37 * hash) + SCHEDULE_RELATIONSHIP_FIELD_NUMBER;
        hash = (53 * hash) + scheduleRelationship_;
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.TripDescriptor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * A descriptor that identifies an instance of a GTFS trip, or all instances of
     * a trip along a route.
     * - To specify a single trip instance, the trip_id (and if necessary,
     *   start_time) is set. If route_id is also set, then it should be same as one
     *   that the given trip corresponds to.
     * - To specify all the trips along a given route, only the route_id should be
     *   set. Note that if the trip_id is not known, then stop sequence ids in
     *   TripUpdate are not sufficient, and stop_ids must be provided as well. In
     *   addition, absolute arrival/departure times must be provided.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.TripDescriptor}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.TripDescriptor, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.TripDescriptor)
        com.google.transit.realtime.GtfsRealtime.TripDescriptorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripDescriptor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripDescriptor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.TripDescriptor.class, com.google.transit.realtime.GtfsRealtime.TripDescriptor.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.TripDescriptor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        tripId_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        routeId_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        directionId_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        startTime_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        startDate_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        scheduleRelationship_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_TripDescriptor_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor build() {
        com.google.transit.realtime.GtfsRealtime.TripDescriptor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor buildPartial() {
        com.google.transit.realtime.GtfsRealtime.TripDescriptor result = new com.google.transit.realtime.GtfsRealtime.TripDescriptor(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.tripId_ = tripId_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.routeId_ = routeId_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.directionId_ = directionId_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          to_bitField0_ |= 0x00000008;
        }
        result.startTime_ = startTime_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          to_bitField0_ |= 0x00000010;
        }
        result.startDate_ = startDate_;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          to_bitField0_ |= 0x00000020;
        }
        result.scheduleRelationship_ = scheduleRelationship_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripDescriptor, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripDescriptor, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripDescriptor, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.TripDescriptor, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.TripDescriptor) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.TripDescriptor)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.TripDescriptor other) {
        if (other == com.google.transit.realtime.GtfsRealtime.TripDescriptor.getDefaultInstance()) return this;
        if (other.hasTripId()) {
          bitField0_ |= 0x00000001;
          tripId_ = other.tripId_;
          onChanged();
        }
        if (other.hasRouteId()) {
          bitField0_ |= 0x00000002;
          routeId_ = other.routeId_;
          onChanged();
        }
        if (other.hasDirectionId()) {
          setDirectionId(other.getDirectionId());
        }
        if (other.hasStartTime()) {
          bitField0_ |= 0x00000008;
          startTime_ = other.startTime_;
          onChanged();
        }
        if (other.hasStartDate()) {
          bitField0_ |= 0x00000010;
          startDate_ = other.startDate_;
          onChanged();
        }
        if (other.hasScheduleRelationship()) {
          setScheduleRelationship(other.getScheduleRelationship());
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.TripDescriptor parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.TripDescriptor) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object tripId_ = "";
      /**
       * <pre>
       * The trip_id from the GTFS feed that this selector refers to.
       * For non frequency-based trips, this field is enough to uniquely identify
       * the trip. For frequency-based trip, start_time and start_date might also be
       * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
       * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
       * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public boolean hasTripId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * The trip_id from the GTFS feed that this selector refers to.
       * For non frequency-based trips, this field is enough to uniquely identify
       * the trip. For frequency-based trip, start_time and start_date might also be
       * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
       * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
       * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public java.lang.String getTripId() {
        java.lang.Object ref = tripId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            tripId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The trip_id from the GTFS feed that this selector refers to.
       * For non frequency-based trips, this field is enough to uniquely identify
       * the trip. For frequency-based trip, start_time and start_date might also be
       * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
       * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
       * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getTripIdBytes() {
        java.lang.Object ref = tripId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tripId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The trip_id from the GTFS feed that this selector refers to.
       * For non frequency-based trips, this field is enough to uniquely identify
       * the trip. For frequency-based trip, start_time and start_date might also be
       * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
       * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
       * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public Builder setTripId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        tripId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The trip_id from the GTFS feed that this selector refers to.
       * For non frequency-based trips, this field is enough to uniquely identify
       * the trip. For frequency-based trip, start_time and start_date might also be
       * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
       * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
       * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public Builder clearTripId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        tripId_ = getDefaultInstance().getTripId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The trip_id from the GTFS feed that this selector refers to.
       * For non frequency-based trips, this field is enough to uniquely identify
       * the trip. For frequency-based trip, start_time and start_date might also be
       * necessary. When schedule_relationship is DUPLICATED within a TripUpdate, the trip_id identifies the trip from
       * static GTFS to be duplicated. When schedule_relationship is DUPLICATED within a VehiclePosition, the trip_id
       * identifies the new duplicate trip and must contain the value for the corresponding TripUpdate.TripProperties.trip_id.
       * </pre>
       *
       * <code>optional string trip_id = 1;</code>
       */
      public Builder setTripIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        tripId_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object routeId_ = "";
      /**
       * <pre>
       * The route_id from the GTFS that this selector refers to.
       * </pre>
       *
       * <code>optional string route_id = 5;</code>
       */
      public boolean hasRouteId() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * The route_id from the GTFS that this selector refers to.
       * </pre>
       *
       * <code>optional string route_id = 5;</code>
       */
      public java.lang.String getRouteId() {
        java.lang.Object ref = routeId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            routeId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The route_id from the GTFS that this selector refers to.
       * </pre>
       *
       * <code>optional string route_id = 5;</code>
       */
      public com.google.protobuf.ByteString
          getRouteIdBytes() {
        java.lang.Object ref = routeId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          routeId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The route_id from the GTFS that this selector refers to.
       * </pre>
       *
       * <code>optional string route_id = 5;</code>
       */
      public Builder setRouteId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        routeId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The route_id from the GTFS that this selector refers to.
       * </pre>
       *
       * <code>optional string route_id = 5;</code>
       */
      public Builder clearRouteId() {
        bitField0_ = (bitField0_ & ~0x00000002);
        routeId_ = getDefaultInstance().getRouteId();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The route_id from the GTFS that this selector refers to.
       * </pre>
       *
       * <code>optional string route_id = 5;</code>
       */
      public Builder setRouteIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        routeId_ = value;
        onChanged();
        return this;
      }

      private int directionId_ ;
      /**
       * <pre>
       * The direction_id from the GTFS feed trips.txt file, indicating the
       * direction of travel for trips this selector refers to.
       * </pre>
       *
       * <code>optional uint32 direction_id = 6;</code>
       */
      public boolean hasDirectionId() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * The direction_id from the GTFS feed trips.txt file, indicating the
       * direction of travel for trips this selector refers to.
       * </pre>
       *
       * <code>optional uint32 direction_id = 6;</code>
       */
      public int getDirectionId() {
        return directionId_;
      }
      /**
       * <pre>
       * The direction_id from the GTFS feed trips.txt file, indicating the
       * direction of travel for trips this selector refers to.
       * </pre>
       *
       * <code>optional uint32 direction_id = 6;</code>
       */
      public Builder setDirectionId(int value) {
        bitField0_ |= 0x00000004;
        directionId_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The direction_id from the GTFS feed trips.txt file, indicating the
       * direction of travel for trips this selector refers to.
       * </pre>
       *
       * <code>optional uint32 direction_id = 6;</code>
       */
      public Builder clearDirectionId() {
        bitField0_ = (bitField0_ & ~0x00000004);
        directionId_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object startTime_ = "";
      /**
       * <pre>
       * The initially scheduled start time of this trip instance.
       * When the trip_id corresponds to a non-frequency-based trip, this field
       * should either be omitted or be equal to the value in the GTFS feed. When
       * the trip_id correponds to a frequency-based trip, the start_time must be
       * specified for trip updates and vehicle positions. If the trip corresponds
       * to exact_times=1 GTFS record, then start_time must be some multiple
       * (including zero) of headway_secs later than frequencies.txt start_time for
       * the corresponding time period. If the trip corresponds to exact_times=0,
       * then its start_time may be arbitrary, and is initially expected to be the
       * first departure of the trip. Once established, the start_time of this
       * frequency-based trip should be considered immutable, even if the first
       * departure time changes -- that time change may instead be reflected in a
       * StopTimeUpdate.
       * Format and semantics of the field is same as that of
       * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
       * </pre>
       *
       * <code>optional string start_time = 2;</code>
       */
      public boolean hasStartTime() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * The initially scheduled start time of this trip instance.
       * When the trip_id corresponds to a non-frequency-based trip, this field
       * should either be omitted or be equal to the value in the GTFS feed. When
       * the trip_id correponds to a frequency-based trip, the start_time must be
       * specified for trip updates and vehicle positions. If the trip corresponds
       * to exact_times=1 GTFS record, then start_time must be some multiple
       * (including zero) of headway_secs later than frequencies.txt start_time for
       * the corresponding time period. If the trip corresponds to exact_times=0,
       * then its start_time may be arbitrary, and is initially expected to be the
       * first departure of the trip. Once established, the start_time of this
       * frequency-based trip should be considered immutable, even if the first
       * departure time changes -- that time change may instead be reflected in a
       * StopTimeUpdate.
       * Format and semantics of the field is same as that of
       * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
       * </pre>
       *
       * <code>optional string start_time = 2;</code>
       */
      public java.lang.String getStartTime() {
        java.lang.Object ref = startTime_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            startTime_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The initially scheduled start time of this trip instance.
       * When the trip_id corresponds to a non-frequency-based trip, this field
       * should either be omitted or be equal to the value in the GTFS feed. When
       * the trip_id correponds to a frequency-based trip, the start_time must be
       * specified for trip updates and vehicle positions. If the trip corresponds
       * to exact_times=1 GTFS record, then start_time must be some multiple
       * (including zero) of headway_secs later than frequencies.txt start_time for
       * the corresponding time period. If the trip corresponds to exact_times=0,
       * then its start_time may be arbitrary, and is initially expected to be the
       * first departure of the trip. Once established, the start_time of this
       * frequency-based trip should be considered immutable, even if the first
       * departure time changes -- that time change may instead be reflected in a
       * StopTimeUpdate.
       * Format and semantics of the field is same as that of
       * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
       * </pre>
       *
       * <code>optional string start_time = 2;</code>
       */
      public com.google.protobuf.ByteString
          getStartTimeBytes() {
        java.lang.Object ref = startTime_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          startTime_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The initially scheduled start time of this trip instance.
       * When the trip_id corresponds to a non-frequency-based trip, this field
       * should either be omitted or be equal to the value in the GTFS feed. When
       * the trip_id correponds to a frequency-based trip, the start_time must be
       * specified for trip updates and vehicle positions. If the trip corresponds
       * to exact_times=1 GTFS record, then start_time must be some multiple
       * (including zero) of headway_secs later than frequencies.txt start_time for
       * the corresponding time period. If the trip corresponds to exact_times=0,
       * then its start_time may be arbitrary, and is initially expected to be the
       * first departure of the trip. Once established, the start_time of this
       * frequency-based trip should be considered immutable, even if the first
       * departure time changes -- that time change may instead be reflected in a
       * StopTimeUpdate.
       * Format and semantics of the field is same as that of
       * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
       * </pre>
       *
       * <code>optional string start_time = 2;</code>
       */
      public Builder setStartTime(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        startTime_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The initially scheduled start time of this trip instance.
       * When the trip_id corresponds to a non-frequency-based trip, this field
       * should either be omitted or be equal to the value in the GTFS feed. When
       * the trip_id correponds to a frequency-based trip, the start_time must be
       * specified for trip updates and vehicle positions. If the trip corresponds
       * to exact_times=1 GTFS record, then start_time must be some multiple
       * (including zero) of headway_secs later than frequencies.txt start_time for
       * the corresponding time period. If the trip corresponds to exact_times=0,
       * then its start_time may be arbitrary, and is initially expected to be the
       * first departure of the trip. Once established, the start_time of this
       * frequency-based trip should be considered immutable, even if the first
       * departure time changes -- that time change may instead be reflected in a
       * StopTimeUpdate.
       * Format and semantics of the field is same as that of
       * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
       * </pre>
       *
       * <code>optional string start_time = 2;</code>
       */
      public Builder clearStartTime() {
        bitField0_ = (bitField0_ & ~0x00000008);
        startTime_ = getDefaultInstance().getStartTime();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The initially scheduled start time of this trip instance.
       * When the trip_id corresponds to a non-frequency-based trip, this field
       * should either be omitted or be equal to the value in the GTFS feed. When
       * the trip_id correponds to a frequency-based trip, the start_time must be
       * specified for trip updates and vehicle positions. If the trip corresponds
       * to exact_times=1 GTFS record, then start_time must be some multiple
       * (including zero) of headway_secs later than frequencies.txt start_time for
       * the corresponding time period. If the trip corresponds to exact_times=0,
       * then its start_time may be arbitrary, and is initially expected to be the
       * first departure of the trip. Once established, the start_time of this
       * frequency-based trip should be considered immutable, even if the first
       * departure time changes -- that time change may instead be reflected in a
       * StopTimeUpdate.
       * Format and semantics of the field is same as that of
       * GTFS/frequencies.txt/start_time, e.g., 11:15:35 or 25:15:35.
       * </pre>
       *
       * <code>optional string start_time = 2;</code>
       */
      public Builder setStartTimeBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000008;
        startTime_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object startDate_ = "";
      /**
       * <pre>
       * The scheduled start date of this trip instance.
       * Must be provided to disambiguate trips that are so late as to collide with
       * a scheduled trip on a next day. For example, for a train that departs 8:00
       * and 20:00 every day, and is 12 hours late, there would be two distinct
       * trips on the same time.
       * This field can be provided but is not mandatory for schedules in which such
       * collisions are impossible - for example, a service running on hourly
       * schedule where a vehicle that is one hour late is not considered to be
       * related to schedule anymore.
       * In YYYYMMDD format.
       * </pre>
       *
       * <code>optional string start_date = 3;</code>
       */
      public boolean hasStartDate() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <pre>
       * The scheduled start date of this trip instance.
       * Must be provided to disambiguate trips that are so late as to collide with
       * a scheduled trip on a next day. For example, for a train that departs 8:00
       * and 20:00 every day, and is 12 hours late, there would be two distinct
       * trips on the same time.
       * This field can be provided but is not mandatory for schedules in which such
       * collisions are impossible - for example, a service running on hourly
       * schedule where a vehicle that is one hour late is not considered to be
       * related to schedule anymore.
       * In YYYYMMDD format.
       * </pre>
       *
       * <code>optional string start_date = 3;</code>
       */
      public java.lang.String getStartDate() {
        java.lang.Object ref = startDate_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            startDate_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * The scheduled start date of this trip instance.
       * Must be provided to disambiguate trips that are so late as to collide with
       * a scheduled trip on a next day. For example, for a train that departs 8:00
       * and 20:00 every day, and is 12 hours late, there would be two distinct
       * trips on the same time.
       * This field can be provided but is not mandatory for schedules in which such
       * collisions are impossible - for example, a service running on hourly
       * schedule where a vehicle that is one hour late is not considered to be
       * related to schedule anymore.
       * In YYYYMMDD format.
       * </pre>
       *
       * <code>optional string start_date = 3;</code>
       */
      public com.google.protobuf.ByteString
          getStartDateBytes() {
        java.lang.Object ref = startDate_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          startDate_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * The scheduled start date of this trip instance.
       * Must be provided to disambiguate trips that are so late as to collide with
       * a scheduled trip on a next day. For example, for a train that departs 8:00
       * and 20:00 every day, and is 12 hours late, there would be two distinct
       * trips on the same time.
       * This field can be provided but is not mandatory for schedules in which such
       * collisions are impossible - for example, a service running on hourly
       * schedule where a vehicle that is one hour late is not considered to be
       * related to schedule anymore.
       * In YYYYMMDD format.
       * </pre>
       *
       * <code>optional string start_date = 3;</code>
       */
      public Builder setStartDate(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        startDate_ = value;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The scheduled start date of this trip instance.
       * Must be provided to disambiguate trips that are so late as to collide with
       * a scheduled trip on a next day. For example, for a train that departs 8:00
       * and 20:00 every day, and is 12 hours late, there would be two distinct
       * trips on the same time.
       * This field can be provided but is not mandatory for schedules in which such
       * collisions are impossible - for example, a service running on hourly
       * schedule where a vehicle that is one hour late is not considered to be
       * related to schedule anymore.
       * In YYYYMMDD format.
       * </pre>
       *
       * <code>optional string start_date = 3;</code>
       */
      public Builder clearStartDate() {
        bitField0_ = (bitField0_ & ~0x00000010);
        startDate_ = getDefaultInstance().getStartDate();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * The scheduled start date of this trip instance.
       * Must be provided to disambiguate trips that are so late as to collide with
       * a scheduled trip on a next day. For example, for a train that departs 8:00
       * and 20:00 every day, and is 12 hours late, there would be two distinct
       * trips on the same time.
       * This field can be provided but is not mandatory for schedules in which such
       * collisions are impossible - for example, a service running on hourly
       * schedule where a vehicle that is one hour late is not considered to be
       * related to schedule anymore.
       * In YYYYMMDD format.
       * </pre>
       *
       * <code>optional string start_date = 3;</code>
       */
      public Builder setStartDateBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        startDate_ = value;
        onChanged();
        return this;
      }

      private int scheduleRelationship_ = 0;
      /**
       * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
       */
      public boolean hasScheduleRelationship() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
       */
      public com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship getScheduleRelationship() {
        @SuppressWarnings("deprecation")
        com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship result = com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship.valueOf(scheduleRelationship_);
        return result == null ? com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship.SCHEDULED : result;
      }
      /**
       * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
       */
      public Builder setScheduleRelationship(com.google.transit.realtime.GtfsRealtime.TripDescriptor.ScheduleRelationship value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        scheduleRelationship_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .transit_realtime.TripDescriptor.ScheduleRelationship schedule_relationship = 4;</code>
       */
      public Builder clearScheduleRelationship() {
        bitField0_ = (bitField0_ & ~0x00000020);
        scheduleRelationship_ = 0;
        onChanged();
        return this;
      }
      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }


      // @@protoc_insertion_point(builder_scope:transit_realtime.TripDescriptor)
    }

    // @@protoc_insertion_point(class_scope:transit_realtime.TripDescriptor)
    private static final com.google.transit.realtime.GtfsRealtime.TripDescriptor DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.google.transit.realtime.GtfsRealtime.TripDescriptor();
    }

    public static com.google.transit.realtime.GtfsRealtime.TripDescriptor getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated public static final com.google.protobuf.Parser<TripDescriptor>
        PARSER = new com.google.protobuf.AbstractParser<TripDescriptor>() {
      @java.lang.Override
      public TripDescriptor parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new TripDescriptor(input, extensionRegistry);
      }
    };

    public static com.google.protobuf.Parser<TripDescriptor> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TripDescriptor> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.transit.realtime.GtfsRealtime.TripDescriptor getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface VehicleDescriptorOrBuilder extends
      // @@protoc_insertion_point(interface_extends:transit_realtime.VehicleDescriptor)
      com.google.protobuf.GeneratedMessageV3.
          ExtendableMessageOrBuilder<VehicleDescriptor> {

    /**
     * <pre>
     * Internal system identification of the vehicle. Should be unique per
     * vehicle, and can be used for tracking the vehicle as it proceeds through
     * the system.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    boolean hasId();
    /**
     * <pre>
     * Internal system identification of the vehicle. Should be unique per
     * vehicle, and can be used for tracking the vehicle as it proceeds through
     * the system.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <pre>
     * Internal system identification of the vehicle. Should be unique per
     * vehicle, and can be used for tracking the vehicle as it proceeds through
     * the system.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    /**
     * <pre>
     * User visible label, i.e., something that must be shown to the passenger to
     * help identify the correct vehicle.
     * </pre>
     *
     * <code>optional string label = 2;</code>
     */
    boolean hasLabel();
    /**
     * <pre>
     * User visible label, i.e., something that must be shown to the passenger to
     * help identify the correct vehicle.
     * </pre>
     *
     * <code>optional string label = 2;</code>
     */
    java.lang.String getLabel();
    /**
     * <pre>
     * User visible label, i.e., something that must be shown to the passenger to
     * help identify the correct vehicle.
     * </pre>
     *
     * <code>optional string label = 2;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <pre>
     * The license plate of the vehicle.
     * </pre>
     *
     * <code>optional string license_plate = 3;</code>
     */
    boolean hasLicensePlate();
    /**
     * <pre>
     * The license plate of the vehicle.
     * </pre>
     *
     * <code>optional string license_plate = 3;</code>
     */
    java.lang.String getLicensePlate();
    /**
     * <pre>
     * The license plate of the vehicle.
     * </pre>
     *
     * <code>optional string license_plate = 3;</code>
     */
    com.google.protobuf.ByteString
        getLicensePlateBytes();
  }
  /**
   * <pre>
   * Identification information for the vehicle performing the trip.
   * </pre>
   *
   * Protobuf type {@code transit_realtime.VehicleDescriptor}
   */
  public  static final class VehicleDescriptor extends
      com.google.protobuf.GeneratedMessageV3.ExtendableMessage<
        VehicleDescriptor> implements
      // @@protoc_insertion_point(message_implements:transit_realtime.VehicleDescriptor)
      VehicleDescriptorOrBuilder {
  private static final long serialVersionUID = 0L;
    // Use VehicleDescriptor.newBuilder() to construct.
    private VehicleDescriptor(com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, ?> builder) {
      super(builder);
    }
    private VehicleDescriptor() {
      id_ = "";
      label_ = "";
      licensePlate_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return this.unknownFields;
    }
    private VehicleDescriptor(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              id_ = bs;
              break;
            }
            case 18: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000002;
              label_ = bs;
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000004;
              licensePlate_ = bs;
              break;
            }
            default: {
              if (!parseUnknownField(
                  input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehicleDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehicleDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.class, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object id_;
    /**
     * <pre>
     * Internal system identification of the vehicle. Should be unique per
     * vehicle, and can be used for tracking the vehicle as it proceeds through
     * the system.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public boolean hasId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * Internal system identification of the vehicle. Should be unique per
     * vehicle, and can be used for tracking the vehicle as it proceeds through
     * the system.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          id_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * Internal system identification of the vehicle. Should be unique per
     * vehicle, and can be used for tracking the vehicle as it proceeds through
     * the system.
     * </pre>
     *
     * <code>optional string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LABEL_FIELD_NUMBER = 2;
    private volatile java.lang.Object label_;
    /**
     * <pre>
     * User visible label, i.e., something that must be shown to the passenger to
     * help identify the correct vehicle.
     * </pre>
     *
     * <code>optional string label = 2;</code>
     */
    public boolean hasLabel() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * User visible label, i.e., something that must be shown to the passenger to
     * help identify the correct vehicle.
     * </pre>
     *
     * <code>optional string label = 2;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          label_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * User visible label, i.e., something that must be shown to the passenger to
     * help identify the correct vehicle.
     * </pre>
     *
     * <code>optional string label = 2;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LICENSE_PLATE_FIELD_NUMBER = 3;
    private volatile java.lang.Object licensePlate_;
    /**
     * <pre>
     * The license plate of the vehicle.
     * </pre>
     *
     * <code>optional string license_plate = 3;</code>
     */
    public boolean hasLicensePlate() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * The license plate of the vehicle.
     * </pre>
     *
     * <code>optional string license_plate = 3;</code>
     */
    public java.lang.String getLicensePlate() {
      java.lang.Object ref = licensePlate_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          licensePlate_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * The license plate of the vehicle.
     * </pre>
     *
     * <code>optional string license_plate = 3;</code>
     */
    public com.google.protobuf.ByteString
        getLicensePlateBytes() {
      java.lang.Object ref = licensePlate_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        licensePlate_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!extensionsAreInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      com.google.protobuf.GeneratedMessageV3
        .ExtendableMessage<com.google.transit.realtime.GtfsRealtime.VehicleDescriptor>.ExtensionWriter
          extensionWriter = newExtensionWriter();
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, id_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, label_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, licensePlate_);
      }
      extensionWriter.writeUntil(2000, output);
      extensionWriter.writeUntil(10000, output);
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, id_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, label_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, licensePlate_);
      }
      size += extensionsSerializedSize();
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.google.transit.realtime.GtfsRealtime.VehicleDescriptor)) {
        return super.equals(obj);
      }
      com.google.transit.realtime.GtfsRealtime.VehicleDescriptor other = (com.google.transit.realtime.GtfsRealtime.VehicleDescriptor) obj;

      if (hasId() != other.hasId()) return false;
      if (hasId()) {
        if (!getId()
            .equals(other.getId())) return false;
      }
      if (hasLabel() != other.hasLabel()) return false;
      if (hasLabel()) {
        if (!getLabel()
            .equals(other.getLabel())) return false;
      }
      if (hasLicensePlate() != other.hasLicensePlate()) return false;
      if (hasLicensePlate()) {
        if (!getLicensePlate()
            .equals(other.getLicensePlate())) return false;
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      if (!getExtensionFields().equals(other.getExtensionFields()))
        return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasId()) {
        hash = (37 * hash) + ID_FIELD_NUMBER;
        hash = (53 * hash) + getId().hashCode();
      }
      if (hasLabel()) {
        hash = (37 * hash) + LABEL_FIELD_NUMBER;
        hash = (53 * hash) + getLabel().hashCode();
      }
      if (hasLicensePlate()) {
        hash = (37 * hash) + LICENSE_PLATE_FIELD_NUMBER;
        hash = (53 * hash) + getLicensePlate().hashCode();
      }
      hash = hashFields(hash, getExtensionFields());
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input);
    }
    public static com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * Identification information for the vehicle performing the trip.
     * </pre>
     *
     * Protobuf type {@code transit_realtime.VehicleDescriptor}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessageV3.ExtendableBuilder<
          com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, Builder> implements
        // @@protoc_insertion_point(builder_implements:transit_realtime.VehicleDescriptor)
        com.google.transit.realtime.GtfsRealtime.VehicleDescriptorOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehicleDescriptor_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehicleDescriptor_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.class, com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.Builder.class);
      }

      // Construct using com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3
                .alwaysUseFieldBuilders) {
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        id_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        label_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        licensePlate_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.google.transit.realtime.GtfsRealtime.internal_static_transit_realtime_VehicleDescriptor_descriptor;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor getDefaultInstanceForType() {
        return com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor build() {
        com.google.transit.realtime.GtfsRealtime.VehicleDescriptor result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.transit.realtime.GtfsRealtime.VehicleDescriptor buildPartial() {
        com.google.transit.realtime.GtfsRealtime.VehicleDescriptor result = new com.google.transit.realtime.GtfsRealtime.VehicleDescriptor(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          to_bitField0_ |= 0x00000001;
        }
        result.id_ = id_;
        if (((from_bitField0_ & 0x00000002) != 0)) {
          to_bitField0_ |= 0x00000002;
        }
        result.label_ = label_;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          to_bitField0_ |= 0x00000004;
        }
        result.licensePlate_ = licensePlate_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }
      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.setField(field, value);
      }
      @java.lang.Override
      public Builder clearField(
          com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }
      @java.lang.Override
      public Builder clearOneof(
          com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }
      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index, java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }
      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, Type> extension,
          Type value) {
        return super.setExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder setExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, java.util.List<Type>> extension,
          int index, Type value) {
        return super.setExtension(extension, index, value);
      }
      @java.lang.Override
      public <Type> Builder addExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, java.util.List<Type>> extension,
          Type value) {
        return super.addExtension(extension, value);
      }
      @java.lang.Override
      public <Type> Builder clearExtension(
          com.google.protobuf.GeneratedMessage.GeneratedExtension<
              com.google.transit.realtime.GtfsRealtime.VehicleDescriptor, ?> extension) {
        return super.clearExtension(extension);
      }
      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.transit.realtime.GtfsRealtime.VehicleDescriptor) {
          return mergeFrom((com.google.transit.realtime.GtfsRealtime.VehicleDescriptor)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.transit.realtime.GtfsRealtime.VehicleDescriptor other) {
        if (other == com.google.transit.realtime.GtfsRealtime.VehicleDescriptor.getDefaultInstance()) return this;
        if (other.hasId()) {
          bitField0_ |= 0x00000001;
          id_ = other.id_;
          onChanged();
        }
        if (other.hasLabel()) {
          bitField0_ |= 0x00000002;
          label_ = other.label_;
          onChanged();
        }
        if (other.hasLicensePlate()) {
          bitField0_ |= 0x00000004;
          licensePlate_ = other.licensePlate_;
          onChanged();
        }
        this.mergeExtensionFields(other);
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!extensionsAreInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.transit.realtime.GtfsRealtime.VehicleDescriptor parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.google.transit.realtime.GtfsRealtime.VehicleDescriptor) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object id_ = "";
      /**
       * <pre>
       * Internal system identification of the vehicle. Should be unique per
       * vehicle, and can be used for tracking the vehicle as it proceeds through
       * the system.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * Internal system identification of the vehicle. Should be unique per
       * vehicle, and can be used for tracking the vehicle as it proceeds through
       * the system.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            id_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * Internal system identification of the vehicle. Should be unique per
       * vehicle, and can be used for tracking the vehicle as it proceeds through
       * the system.
       * </pre>
       *
       * <code>optional string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteSt