/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.proxy;

import org.apache.commons.lang3.StringUtils;
import org.mockserver.client.http.ApacheHttpClient;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyClient {
    private static final Logger logger = LoggerFactory.getLogger(ProxyClient.class);
    private final String uriBase;
    private ApacheHttpClient apacheHttpClient;
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();

    public ProxyClient(String host, int port) {
        if (Boolean.parseBoolean(System.getProperty("defaultProxySet"))) {
            this.uriBase = "https://" + host + ":" + port;
            this.apacheHttpClient = new ApacheHttpClient(true);
        } else {
            this.uriBase = "http://" + host + ":" + port;
            this.apacheHttpClient = new ApacheHttpClient(false);
        }
    }

    public ProxyClient dumpToLogAsJSON() {
        return this.dumpToLogAsJSON(null);
    }

    public ProxyClient dumpToLogAsJSON(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/dumpToLog", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    public ProxyClient dumpToLogAsJava() {
        return this.dumpToLogAsJava(null);
    }

    public ProxyClient dumpToLogAsJava(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/dumpToLog?type=java", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    public ProxyClient reset() {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/reset", "");
        return this;
    }

    public ProxyClient stop() {
        try {
            this.apacheHttpClient.sendPUTRequest(this.uriBase, "/stop", "");
        }
        catch (Exception e) {
            logger.debug("Failed to send stop request to proxy " + e.getMessage());
        }
        return this;
    }

    public ProxyClient clear(HttpRequest httpRequest) {
        this.apacheHttpClient.sendPUTRequest(this.uriBase, "/clear", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
        return this;
    }

    public ProxyClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.apacheHttpClient.sendPUTRequest(this.uriBase, "/verifySequence", this.verificationSequenceSerializer.serialize(verificationSequence));
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public ProxyClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = new Verification().withRequest(httpRequest).withTimes(times);
        String result = this.apacheHttpClient.sendPUTRequest(this.uriBase, "/verify", this.verificationSerializer.serialize(verification));
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    private String butFoundAssertionErrorMessage() {
        String allRequests = this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", "");
        return " but " + (StringUtils.isNotEmpty((CharSequence)allRequests) ? "only found " + allRequests : "found no requests");
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest) {
        return this.expectationSerializer.deserializeArray(this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : ""));
    }

    public String retrieveAsJSON(HttpRequest httpRequest) {
        return this.apacheHttpClient.sendPUTRequest(this.uriBase, "/retrieve", httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "");
    }
}

