/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import com.google.common.base.Charsets;
import org.mockserver.client.AbstractClient;
import org.mockserver.client.server.ClientException;
import org.mockserver.client.server.ForwardChainExpectation;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;

public class MockServerClient
extends AbstractClient {
    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        super(host, port, contextPath);
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, TimeToLive.unlimited()));
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, timeToLive));
    }

    public MockServerClient dumpToLog() {
        return this.dumpToLog(null);
    }

    public MockServerClient dumpToLog(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("dumpToLog")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return this;
    }

    public MockServerClient reset() {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this;
    }

    public MockServerClient stop() {
        return this.stop(false);
    }

    public MockServerClient stop(boolean ignoreFailure) {
        block2: {
            try {
                this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
            }
            catch (Exception e) {
                if (ignoreFailure) break block2;
                this.logger.warn("Failed to send stop request to MockServer " + e.getMessage());
            }
        }
        return this;
    }

    public MockServerClient clear(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return this;
    }

    void sendExpectation(Expectation expectation) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("expectation")).withBody(expectation != null ? this.expectationSerializer.serialize(expectation) : "", Charsets.UTF_8));
        if (httpResponse != null && httpResponse.getStatusCode() != 201) {
            throw new ClientException(this.formatErrorMessage(System.getProperty("line.separator") + "error: %swhile submitted expectation: %s", httpResponse.getBody() + System.getProperty("line.separator"), expectation));
        }
    }

    public MockServerClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0 || httpRequests[0] == null) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public MockServerClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = new Verification().withRequest(httpRequest).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public MockServerClient verifyZeroInteractions() throws AssertionError {
        Verification verification = new Verification().withRequest(HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), Charsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this;
    }

    public Expectation[] retrieveAsExpectations(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString());
    }

    public String retrieveAsJSON(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        return httpResponse.getBodyAsString();
    }
}

