/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.server;

import com.google.common.base.Charsets;
import joptsimple.internal.Strings;
import org.mockserver.character.Character;
import org.mockserver.client.AbstractClient;
import org.mockserver.client.server.ClientException;
import org.mockserver.client.server.ForwardChainExpectation;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class MockServerClient
extends AbstractClient<MockServerClient> {
    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        super(host, port, contextPath, MockServerClient.class);
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, TimeToLive.unlimited()));
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, timeToLive));
    }

    void sendExpectation(Expectation expectation) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("expectation")).withBody(expectation != null ? this.expectationSerializer.serialize(expectation) : "", Charsets.UTF_8));
        if (httpResponse != null && httpResponse.getStatusCode() != 201) {
            throw new ClientException(this.formatErrorMessage(Character.NEW_LINE + "error:%s" + Character.NEW_LINE + "while submitted expectation:%s", httpResponse.getBody(), expectation));
        }
    }

    public Expectation[] retrieveActiveExpectations(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{HttpStateHandler.RetrieveType.ACTIVE_EXPECTATIONS.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", Charsets.UTF_8));
        if (!Strings.isNullOrEmpty((String)httpResponse.getBodyAsString())) {
            return this.expectationSerializer.deserializeArray(httpResponse.getBodyAsString());
        }
        return new Expectation[0];
    }
}

