/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.closurecallback.websocketclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.net.ssl.SSLException;
import org.mockserver.closurecallback.websocketclient.WebSocketClientHandler;
import org.mockserver.closurecallback.websocketclient.WebSocketException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.action.ExpectationCallback;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.model.HttpMessage;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpRequestAndHttpResponse;
import org.mockserver.model.HttpResponse;
import org.mockserver.serialization.WebSocketMessageSerializer;
import org.mockserver.serialization.model.WebSocketClientIdDTO;
import org.mockserver.serialization.model.WebSocketErrorDTO;
import org.slf4j.event.Level;

public class WebSocketClient<T extends HttpMessage> {
    static final AttributeKey<CompletableFuture<String>> REGISTRATION_FUTURE = AttributeKey.valueOf("REGISTRATION_FUTURE");
    private final MockServerLogger mockServerLogger;
    private Channel channel;
    private WebSocketMessageSerializer webSocketMessageSerializer;
    private ExpectationCallback<T> expectationCallback;
    private ExpectationForwardAndResponseCallback expectationForwardResponseCallback;
    private boolean isStopped = false;
    private EventLoopGroup eventLoopGroup;
    private final String clientId;
    public static final String CLIENT_REGISTRATION_ID_HEADER = "X-CLIENT-REGISTRATION-ID";

    public WebSocketClient(EventLoopGroup eventLoopGroup, String clientId, MockServerLogger mockServerLogger) {
        this.eventLoopGroup = eventLoopGroup;
        this.clientId = clientId;
        this.mockServerLogger = mockServerLogger;
        this.webSocketMessageSerializer = new WebSocketMessageSerializer(mockServerLogger);
    }

    private Future<String> register(final InetSocketAddress serverAddress, final String contextPath, final boolean isSecure, int reconnectAttempts) {
        CompletableFuture<String> registrationFuture = new CompletableFuture<String>();
        try {
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).attr(REGISTRATION_FUTURE, registrationFuture)).handler(new ChannelInitializer<SocketChannel>(){

                @Override
                protected void initChannel(SocketChannel ch) throws URISyntaxException {
                    if (isSecure) {
                        try {
                            ch.pipeline().addLast(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).build().newHandler(ch.alloc(), serverAddress.getHostName(), serverAddress.getPort()));
                        }
                        catch (SSLException e) {
                            throw new WebSocketException("Exception when configuring SSL Handler", e);
                        }
                    }
                    ch.pipeline().addLast(new HttpClientCodec());
                    ch.pipeline().addLast(new HttpObjectAggregator(Integer.MAX_VALUE));
                    ch.pipeline().addLast(new WebSocketClientHandler(WebSocketClient.this.mockServerLogger, WebSocketClient.this.clientId, serverAddress, contextPath, WebSocketClient.this, isSecure));
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        ch.pipeline().addLast(new LoggingHandler("WebSocketClient last -->"));
                    }
                }
            })).connect(serverAddress).addListener(connectChannelFuture -> {
                this.channel = connectChannelFuture.channel();
                this.channel.closeFuture().addListener(closeChannelFuture -> {
                    if (!this.isStopped && reconnectAttempts > 0) {
                        this.register(serverAddress, contextPath, isSecure, reconnectAttempts - 1);
                    }
                });
            });
        }
        catch (Exception e) {
            registrationFuture.completeExceptionally(new WebSocketException("Exception while starting web socket client", e));
        }
        return registrationFuture;
    }

    void receivedTextWebSocketFrame(TextWebSocketFrame textWebSocketFrame) {
        block17: {
            try {
                Object deserializedMessage = this.webSocketMessageSerializer.deserialize(textWebSocketFrame.text());
                if (deserializedMessage instanceof HttpRequest) {
                    HttpRequest request = (HttpRequest)deserializedMessage;
                    String webSocketCorrelationId = request.getFirstHeader("WebSocketCorrelationId");
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("received request{}over websocket for client " + this.clientId + " for correlationId " + webSocketCorrelationId).setArguments(request));
                    }
                    if (this.expectationCallback != null) {
                        try {
                            T result = this.expectationCallback.handle(request);
                            if (MockServerLogger.isEnabled(Level.TRACE)) {
                                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("returning{}for request{}over websocket for client " + this.clientId + " for correlationId " + webSocketCorrelationId).setArguments(result, request));
                            }
                            result.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                            this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(result)));
                        }
                        catch (Throwable throwable) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("exception thrown while handling callback for request - " + throwable.getMessage()).setThrowable(throwable));
                            this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(throwable.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                        }
                    }
                    break block17;
                }
                if (deserializedMessage instanceof HttpRequestAndHttpResponse) {
                    HttpRequestAndHttpResponse httpRequestAndHttpResponse = (HttpRequestAndHttpResponse)deserializedMessage;
                    HttpRequest httpRequest = httpRequestAndHttpResponse.getHttpRequest();
                    HttpResponse httpResponse = httpRequestAndHttpResponse.getHttpResponse();
                    String webSocketCorrelationId = httpRequest.getFirstHeader("WebSocketCorrelationId");
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(httpRequestAndHttpResponse.getHttpRequest()).setMessageFormat("received request and response{}over websocket for client " + this.clientId + " for correlationId " + webSocketCorrelationId).setArguments(httpRequestAndHttpResponse));
                    }
                    if (this.expectationForwardResponseCallback != null) {
                        try {
                            HttpResponse response = this.expectationForwardResponseCallback.handle(httpRequest, httpResponse);
                            if (MockServerLogger.isEnabled(Level.TRACE)) {
                                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(httpRequestAndHttpResponse.getHttpRequest()).setMessageFormat("returning response{}for request and response{}over websocket for client " + this.clientId + " for correlationId " + webSocketCorrelationId).setArguments(response, httpRequestAndHttpResponse));
                            }
                            response.withHeader("WebSocketCorrelationId", webSocketCorrelationId);
                            this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(response)));
                        }
                        catch (Throwable throwable) {
                            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setHttpRequest(httpRequest).setMessageFormat("exception thrown while handling callback for request and response - " + throwable.getMessage()).setThrowable(throwable));
                            this.channel.writeAndFlush(new TextWebSocketFrame(this.webSocketMessageSerializer.serialize(new WebSocketErrorDTO().setMessage(throwable.getMessage()).setWebSocketCorrelationId(webSocketCorrelationId))));
                        }
                    }
                    break block17;
                }
                if (deserializedMessage instanceof WebSocketClientIdDTO) {
                    if (MockServerLogger.isEnabled(Level.TRACE)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("received client id{}").setArguments(deserializedMessage));
                    }
                    break block17;
                }
                if (MockServerLogger.isEnabled(Level.WARN)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("web socket client received a message that isn't HttpRequest or HttpRequestAndHttpResponse{} which has been deserialized as{}").setArguments(textWebSocketFrame.text(), deserializedMessage));
                }
                throw new WebSocketException("Unsupported web socket message " + textWebSocketFrame.text());
            }
            catch (Exception e) {
                throw new WebSocketException("Exception while receiving web socket message", e);
            }
        }
    }

    public void stopClient() {
        this.isStopped = true;
        try {
            if (this.eventLoopGroup != null && !this.eventLoopGroup.isShuttingDown()) {
                this.eventLoopGroup.shutdownGracefully();
            }
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close().sync();
                this.channel = null;
            }
        }
        catch (InterruptedException e) {
            throw new WebSocketException("Exception while closing client", e);
        }
    }

    public Future<String> registerExpectationCallback(ExpectationCallback<T> expectationCallback, ExpectationForwardAndResponseCallback expectationForwardResponseCallback, InetSocketAddress serverAddress, String contextPath, boolean isSecure) {
        if (this.expectationCallback == null) {
            this.expectationCallback = expectationCallback;
            this.expectationForwardResponseCallback = expectationForwardResponseCallback;
            return this.register(serverAddress, contextPath, isSecure, 3);
        }
        throw new IllegalArgumentException("It is not possible to set response callback once a forward callback has been set");
    }
}

