/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.httpclient;

import com.google.common.collect.ImmutableMap;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.httpclient.HttpClientInitializer;
import org.mockserver.httpclient.SocketCommunicationException;
import org.mockserver.httpclient.SocketConnectionException;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.BinaryMessage;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Message;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.slf4j.event.Level;

public class NettyHttpClient {
    static final AttributeKey<Boolean> SECURE = AttributeKey.valueOf("SECURE");
    static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf("REMOTE_SOCKET");
    static final AttributeKey<CompletableFuture<Message>> RESPONSE_FUTURE = AttributeKey.valueOf("RESPONSE_FUTURE");
    private final MockServerLogger mockServerLogger;
    private final EventLoopGroup eventLoopGroup;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final boolean forwardProxyClient;
    private final NettySslContextFactory nettySslContextFactory;

    public NettyHttpClient(MockServerLogger mockServerLogger, EventLoopGroup eventLoopGroup, List<ProxyConfiguration> proxyConfigurations, boolean forwardProxyClient) {
        this(mockServerLogger, eventLoopGroup, proxyConfigurations, forwardProxyClient, new NettySslContextFactory(mockServerLogger));
    }

    public NettyHttpClient(MockServerLogger mockServerLogger, EventLoopGroup eventLoopGroup, List<ProxyConfiguration> proxyConfigurations, boolean forwardProxyClient, NettySslContextFactory nettySslContextFactory) {
        this.mockServerLogger = mockServerLogger;
        this.eventLoopGroup = eventLoopGroup;
        this.proxyConfigurations = proxyConfigurations != null ? proxyConfigurations.stream().collect(Collectors.toMap(ProxyConfiguration::getType, proxyConfiguration -> proxyConfiguration)) : ImmutableMap.of();
        this.forwardProxyClient = forwardProxyClient;
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest) throws SocketConnectionException {
        return this.sendRequest(httpRequest, httpRequest.socketAddressFromHostHeader());
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) throws SocketConnectionException {
        return this.sendRequest(httpRequest, remoteAddress, ConfigurationProperties.socketConnectionTimeout());
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress, Integer connectionTimeoutMillis) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfigurations != null && !Boolean.TRUE.equals(httpRequest.isSecure()) && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.HTTP)) {
                ProxyConfiguration proxyConfiguration = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTP);
                remoteAddress = proxyConfiguration.getProxyAddress();
                proxyConfiguration.addProxyAuthenticationHeader(httpRequest);
            } else if (remoteAddress == null) {
                remoteAddress = httpRequest.socketAddressFromHostHeader();
            }
            CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
            CompletableFuture responseFuture = new CompletableFuture();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeoutMillis)).attr(SECURE, httpRequest.isSecure() != null && httpRequest.isSecure() != false)).attr(REMOTE_SOCKET, remoteAddress)).attr(RESPONSE_FUTURE, responseFuture)).handler(new HttpClientInitializer(this.proxyConfigurations, this.mockServerLogger, this.forwardProxyClient, this.nettySslContextFactory, true))).connect(remoteAddress).addListener(future -> {
                if (future.isSuccess()) {
                    future.channel().writeAndFlush(httpRequest);
                } else {
                    httpResponseFuture.completeExceptionally(future.cause());
                }
            });
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    if (message != null) {
                        httpResponseFuture.complete((HttpResponse)message);
                    } else {
                        httpResponseFuture.complete(HttpResponse.response());
                    }
                } else {
                    httpResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return httpResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    public CompletableFuture<BinaryMessage> sendRequest(BinaryMessage binaryRequest, boolean isSecure, InetSocketAddress remoteAddress, Integer connectionTimeoutMillis) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfigurations != null && !isSecure && this.proxyConfigurations.containsKey((Object)ProxyConfiguration.Type.HTTP)) {
                remoteAddress = this.proxyConfigurations.get((Object)ProxyConfiguration.Type.HTTP).getProxyAddress();
            } else if (remoteAddress == null) {
                throw new IllegalArgumentException("Remote address cannot be null");
            }
            CompletableFuture<BinaryMessage> binaryResponseFuture = new CompletableFuture<BinaryMessage>();
            CompletableFuture responseFuture = new CompletableFuture();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, true)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeoutMillis)).attr(SECURE, isSecure)).attr(REMOTE_SOCKET, remoteAddress)).attr(RESPONSE_FUTURE, responseFuture)).handler(new HttpClientInitializer(this.proxyConfigurations, this.mockServerLogger, this.forwardProxyClient, this.nettySslContextFactory, false))).connect(remoteAddress).addListener(future -> {
                if (future.isSuccess()) {
                    if (MockServerLogger.isEnabled(Level.DEBUG)) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("sending bytes hex{}to{}").setArguments(ByteBufUtil.hexDump(binaryRequest.getBytes()), future.channel().attr(REMOTE_SOCKET).get()));
                    }
                    future.channel().writeAndFlush(Unpooled.copiedBuffer(binaryRequest.getBytes()));
                } else {
                    binaryResponseFuture.completeExceptionally(future.cause());
                }
            });
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    binaryResponseFuture.complete((BinaryMessage)message);
                } else {
                    throwable.printStackTrace();
                    binaryResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return binaryResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    public HttpResponse sendRequest(HttpRequest httpRequest, long timeout, TimeUnit unit, boolean ignoreErrors) {
        HttpResponse httpResponse;
        block8: {
            httpResponse = null;
            try {
                httpResponse = this.sendRequest(httpRequest).get(timeout, unit);
            }
            catch (TimeoutException e) {
                if (!ignoreErrors) {
                    throw new SocketCommunicationException("Response was not received from MockServer after " + ConfigurationProperties.maxSocketTimeout() + " milliseconds, to wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ignoreErrors) break block8;
                Throwable cause = ex.getCause();
                if (cause instanceof SocketConnectionException) {
                    throw (SocketConnectionException)cause;
                }
                if (cause instanceof ConnectException) {
                    throw new SocketConnectionException("Unable to connect to socket " + httpRequest.socketAddressFromHostHeader(), cause);
                }
                if (cause instanceof UnknownHostException) {
                    throw new SocketConnectionException("Unable to resolve host " + httpRequest.socketAddressFromHostHeader(), cause);
                }
                if (cause instanceof IOException) {
                    throw new SocketConnectionException(cause.getMessage(), cause);
                }
                throw new RuntimeException("Exception while sending request - " + ex.getMessage(), ex);
            }
        }
        return httpResponse;
    }

    public HttpResponse sendRequest(HttpRequest httpRequest, long timeout, TimeUnit unit) {
        return this.sendRequest(httpRequest, timeout, unit, false);
    }
}

