/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import net.minidev.json.JSONArray;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.MatchDifference;
import org.slf4j.event.Level;

public class JsonPathMatcher
extends BodyMatcher<String> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger", "jsonPath"};
    private final MockServerLogger mockServerLogger;
    private final String matcher;
    private JsonPath jsonPath;

    JsonPathMatcher(MockServerLogger mockServerLogger, String matcher) {
        block3: {
            this.mockServerLogger = mockServerLogger;
            this.matcher = matcher;
            if (StringUtils.isNotBlank(matcher)) {
                try {
                    this.jsonPath = JsonPath.compile(matcher, new Predicate[0]);
                }
                catch (Throwable throwable) {
                    if (!MockServerLogger.isEnabled(Level.DEBUG)) break block3;
                    mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("error while creating xpath expression for [" + matcher + "] assuming matcher not xpath - " + throwable.getMessage()).setArguments(throwable));
                }
            }
        }
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean alreadyLoggedMatchFailure;
        boolean result;
        block9: {
            result = false;
            alreadyLoggedMatchFailure = false;
            if (this.jsonPath == null) {
                if (context != null) {
                    context.addDifference(this.mockServerLogger, "json path match failed expected:{}found:{}failed because:{}", "null", matched, "json path matcher was null");
                    alreadyLoggedMatchFailure = true;
                }
            } else if (this.matcher.equals(matched)) {
                result = true;
            } else if (matched != null) {
                try {
                    result = !((JSONArray)this.jsonPath.read(matched)).isEmpty();
                }
                catch (Throwable throwable) {
                    if (context == null) break block9;
                    context.addDifference(this.mockServerLogger, throwable, "json path match failed expected:{}found:{}failed because:{}", this.matcher, matched, throwable.getMessage());
                    alreadyLoggedMatchFailure = true;
                }
            }
        }
        if (!result && !alreadyLoggedMatchFailure && context != null) {
            context.addDifference(this.mockServerLogger, "json path match failed expected:{}found:{}failed because:{}", this.matcher, matched, "json path did not evaluate to truthy");
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return StringUtils.isBlank(this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

