/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi;

import com.fasterxml.jackson.databind.ObjectWriter;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.openapi.OpenAPIParser;
import org.mockserver.openapi.examples.JsonNodeExampleSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.slf4j.event.Level;

public class OpenAPISerialiser {
    private static final ObjectWriter OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(new JsonNodeExampleSerializer()).writerWithDefaultPrettyPrinter();
    private final MockServerLogger mockServerLogger;

    public OpenAPISerialiser(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    public String asString(OpenAPIDefinition openAPIDefinition) {
        try {
            if (StringUtils.isBlank(openAPIDefinition.getOperationId())) {
                return OBJECT_WRITER.writeValueAsString(OpenAPIParser.buildOpenAPI(openAPIDefinition.getSpecUrlOrPayload(), this.mockServerLogger));
            }
            Optional<Pair<String, Operation>> operation = this.retrieveOperation(openAPIDefinition.getSpecUrlOrPayload(), openAPIDefinition.getOperationId());
            if (operation.isPresent()) {
                return operation.get().getLeft() + ": " + OBJECT_WRITER.writeValueAsString(operation.get().getRight());
            }
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serialising specification for OpenAPIDefinition{}").setArguments(openAPIDefinition).setThrowable(throwable));
        }
        return "";
    }

    public Optional<Pair<String, Operation>> retrieveOperation(String specUrlOrPayload, String operationId) {
        return OpenAPIParser.buildOpenAPI(specUrlOrPayload, this.mockServerLogger).getPaths().values().stream().flatMap(pathItem -> OpenAPIParser.mapOperations(pathItem).stream()).filter(operation -> StringUtils.isBlank(operationId) || ((Operation)operation.getRight()).getOperationId().equals(operationId)).findFirst();
    }

    public Map<String, List<Pair<String, Operation>>> retrieveOperations(OpenAPI openAPI, String operationId) {
        LinkedHashMap<String, List<Pair<String, Operation>>> operations = new LinkedHashMap<String, List<Pair<String, Operation>>>();
        if (openAPI != null) {
            openAPI.getPaths().forEach((key, value) -> {
                List filteredOperations;
                if (key != null && value != null && !(filteredOperations = OpenAPIParser.mapOperations(value).stream().filter(operation -> StringUtils.isBlank(operationId) || operationId.equals(((Operation)operation.getRight()).getOperationId())).sorted(Comparator.comparing(Pair::getLeft)).collect(Collectors.toList())).isEmpty()) {
                    operations.put((String)key, filteredOperations);
                }
            });
        }
        return operations;
    }
}

