/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.openapi.examples;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import org.mockserver.openapi.examples.models.ArrayExample;
import org.mockserver.openapi.examples.models.BigIntegerExample;
import org.mockserver.openapi.examples.models.BooleanExample;
import org.mockserver.openapi.examples.models.DecimalExample;
import org.mockserver.openapi.examples.models.DoubleExample;
import org.mockserver.openapi.examples.models.Example;
import org.mockserver.openapi.examples.models.FloatExample;
import org.mockserver.openapi.examples.models.IntegerExample;
import org.mockserver.openapi.examples.models.LongExample;
import org.mockserver.openapi.examples.models.ObjectExample;
import org.mockserver.openapi.examples.models.StringExample;

public class JsonNodeExampleSerializer
extends JsonSerializer<Example> {
    @Override
    public void serialize(Example value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        if (value instanceof ObjectExample) {
            ObjectExample obj = (ObjectExample)value;
            jsonGenerator.writeStartObject();
            this.writeTo(jsonGenerator, obj);
            jsonGenerator.writeEndObject();
        } else if (value instanceof ArrayExample) {
            ArrayExample obj = (ArrayExample)value;
            jsonGenerator.writeStartArray();
            for (Example item : obj.getItems()) {
                if (item instanceof ObjectExample) {
                    jsonGenerator.writeStartObject();
                }
                this.writeTo(jsonGenerator, item);
                if (!(item instanceof ObjectExample)) continue;
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        } else {
            this.writeTo(jsonGenerator, value);
        }
    }

    public void writeTo(JsonGenerator jsonGenerator, Example o) throws IOException {
        if (o instanceof ObjectExample) {
            ObjectExample obj = (ObjectExample)o;
            for (String key : obj.keySet()) {
                Example value = (Example)obj.get(key);
                this.writeValue(jsonGenerator, key, value);
            }
        } else if (o instanceof ArrayExample) {
            jsonGenerator.writeStartArray();
            List<Example> items = ((ArrayExample)o).getItems();
            for (Example item : items) {
                this.serialize(item, jsonGenerator, (SerializerProvider)null);
            }
            jsonGenerator.writeEndArray();
        } else {
            this.writeValue(jsonGenerator, null, o);
        }
    }

    public void writeValue(JsonGenerator jsonGenerator, String field, Example o) throws IOException {
        if (o instanceof ArrayExample) {
            ArrayExample obj = (ArrayExample)o;
            jsonGenerator.writeArrayFieldStart(field);
            for (Example item : obj.getItems()) {
                if (item instanceof ObjectExample) {
                    jsonGenerator.writeStartObject();
                    this.writeTo(jsonGenerator, item);
                    jsonGenerator.writeEndObject();
                    continue;
                }
                this.writeTo(jsonGenerator, item);
            }
            jsonGenerator.writeEndArray();
        } else if (o instanceof BooleanExample) {
            BooleanExample obj = (BooleanExample)o;
            if (field != null) {
                jsonGenerator.writeBooleanField(field, obj.getValue());
            } else {
                jsonGenerator.writeBoolean(obj.getValue());
            }
        } else if (o instanceof DecimalExample) {
            DecimalExample obj = (DecimalExample)o;
            if (field != null) {
                jsonGenerator.writeNumberField(field, obj.getValue());
            } else {
                jsonGenerator.writeNumber(obj.getValue());
            }
        } else if (o instanceof BigIntegerExample) {
            BigIntegerExample obj = (BigIntegerExample)o;
            if (field != null) {
                jsonGenerator.writeFieldName(field);
                jsonGenerator.writeNumber(obj.getValue());
            } else {
                jsonGenerator.writeNumber(obj.getValue());
            }
        } else if (o instanceof DoubleExample) {
            DoubleExample obj = (DoubleExample)o;
            if (field != null) {
                jsonGenerator.writeNumberField(field, obj.getValue());
            } else {
                jsonGenerator.writeNumber(obj.getValue());
            }
        } else if (o instanceof FloatExample) {
            FloatExample obj = (FloatExample)o;
            if (field != null) {
                jsonGenerator.writeNumberField(field, obj.getValue().floatValue());
            } else {
                jsonGenerator.writeNumber(obj.getValue().floatValue());
            }
        } else if (o instanceof IntegerExample) {
            IntegerExample obj = (IntegerExample)o;
            if (field != null) {
                jsonGenerator.writeNumberField(field, obj.getValue());
            } else {
                jsonGenerator.writeNumber(obj.getValue());
            }
        } else if (o instanceof LongExample) {
            LongExample obj = (LongExample)o;
            if (field != null) {
                jsonGenerator.writeNumberField(field, obj.getValue());
            } else {
                jsonGenerator.writeNumber(obj.getValue());
            }
        } else if (o instanceof ObjectExample) {
            ObjectExample obj = (ObjectExample)o;
            if (field != null) {
                jsonGenerator.writeObjectField(field, obj);
            }
        } else if (o instanceof StringExample) {
            StringExample obj = (StringExample)o;
            if (field != null) {
                jsonGenerator.writeStringField(field, obj.getValue());
            } else {
                jsonGenerator.writeString(obj.getValue());
            }
        }
    }

    @Override
    public Class<Example> handledType() {
        return Example.class;
    }
}

