/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.character.Character;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.OpenAPIExpectation;
import org.mockserver.openapi.OpenAPIConverter;
import org.mockserver.serialization.JsonArraySerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;
import org.mockserver.serialization.model.OpenAPIExpectationDTO;
import org.mockserver.validator.jsonschema.JsonSchemaOpenAPIExpectationValidator;
import org.mockserver.validator.jsonschema.JsonSchemaValidator;
import org.slf4j.event.Level;

public class OpenAPIExpectationSerializer
implements Serializer<OpenAPIExpectation> {
    private final MockServerLogger mockServerLogger;
    private ObjectWriter objectWriter = ObjectMapperFactory.createObjectMapper(true, new JsonSerializer[0]);
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();
    private JsonArraySerializer jsonArraySerializer = new JsonArraySerializer();
    private JsonSchemaOpenAPIExpectationValidator expectationValidator;
    private OpenAPIConverter openAPIConverter;

    public OpenAPIExpectationSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.openAPIConverter = new OpenAPIConverter(mockServerLogger);
    }

    private JsonSchemaOpenAPIExpectationValidator getValidator() {
        if (this.expectationValidator == null) {
            this.expectationValidator = JsonSchemaOpenAPIExpectationValidator.jsonSchemaOpenAPIExpectationValidator(this.mockServerLogger);
        }
        return this.expectationValidator;
    }

    @Override
    public String serialize(OpenAPIExpectation expectation) {
        if (expectation != null) {
            try {
                return this.objectWriter.writeValueAsString(new OpenAPIExpectationDTO(expectation));
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing expectation to JSON with value " + expectation).setThrowable(e));
                throw new RuntimeException("Exception while serializing expectation to JSON with value " + expectation, e);
            }
        }
        return "";
    }

    @Override
    public String serialize(List<OpenAPIExpectation> expectations) {
        return this.serialize(expectations.toArray(new OpenAPIExpectation[0]));
    }

    @Override
    public String serialize(OpenAPIExpectation ... expectations) {
        try {
            if (expectations != null && expectations.length > 0) {
                OpenAPIExpectationDTO[] expectationDTOs = new OpenAPIExpectationDTO[expectations.length];
                for (int i = 0; i < expectations.length; ++i) {
                    expectationDTOs[i] = new OpenAPIExpectationDTO(expectations[i]);
                }
                return this.objectWriter.writeValueAsString(expectationDTOs);
            }
            return "[]";
        }
        catch (Exception e) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while serializing expectation to JSON with value " + Arrays.asList(expectations)).setThrowable(e));
            throw new RuntimeException("Exception while serializing expectation to JSON with value " + Arrays.asList(expectations), e);
        }
    }

    @Override
    public OpenAPIExpectation deserialize(String jsonOpenAPIExpectation) {
        if (StringUtils.isBlank(jsonOpenAPIExpectation)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation is required but value was \"" + jsonOpenAPIExpectation + "\"" + Character.NEW_LINE + Character.NEW_LINE + JsonSchemaValidator.OPEN_API_SPECIFICATION_URL);
        }
        String validationErrors = this.getValidator().isValid(jsonOpenAPIExpectation);
        if (validationErrors.isEmpty()) {
            OpenAPIExpectation expectation = null;
            try {
                OpenAPIExpectationDTO expectationDTO = this.objectMapper.readValue(jsonOpenAPIExpectation, OpenAPIExpectationDTO.class);
                if (expectationDTO != null) {
                    expectation = expectationDTO.buildObject();
                }
            }
            catch (Throwable throwable) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while parsing{}for OpenAPIExpectation " + throwable.getMessage()).setArguments(jsonOpenAPIExpectation).setThrowable(throwable));
                throw new IllegalArgumentException("exception while parsing [" + jsonOpenAPIExpectation + "] for OpenAPIExpectation", throwable);
            }
            return expectation;
        }
        throw new IllegalArgumentException(StringUtils.removeEndIgnoreCase(StringFormatter.formatLogMessage("incorrect openapi expectation json format for:{}schema validation errors:{}", jsonOpenAPIExpectation, validationErrors), "\n"));
    }

    public List<Expectation> deserializeToExpectations(String jsonOpenAPIExpectation) {
        OpenAPIExpectation openAPIExpectation = this.deserialize(jsonOpenAPIExpectation);
        return this.openAPIConverter.buildExpectations(openAPIExpectation.getSpecUrlOrPayload(), openAPIExpectation.getOperationsAndResponses());
    }

    @Override
    public Class<OpenAPIExpectation> supportsType() {
        return OpenAPIExpectation.class;
    }

    public OpenAPIExpectation[] deserializeArray(String jsonOpenAPIExpectations, boolean allowEmpty) {
        ArrayList<OpenAPIExpectation> expectations = new ArrayList<OpenAPIExpectation>();
        if (StringUtils.isBlank(jsonOpenAPIExpectations)) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation or expectation array is required but value was \"" + jsonOpenAPIExpectations + "\"");
        }
        List<String> jsonOpenAPIExpectationList = this.jsonArraySerializer.splitJSONArray(jsonOpenAPIExpectations);
        if (!jsonOpenAPIExpectationList.isEmpty()) {
            ArrayList<String> validationErrorsList = new ArrayList<String>();
            for (String jsonExpecation : jsonOpenAPIExpectationList) {
                try {
                    expectations.add(this.deserialize(jsonExpecation));
                }
                catch (IllegalArgumentException iae) {
                    validationErrorsList.add(iae.getMessage());
                }
            }
            if (!validationErrorsList.isEmpty()) {
                if (validationErrorsList.size() > 1) {
                    throw new IllegalArgumentException(("[" + Character.NEW_LINE + Joiner.on("," + Character.NEW_LINE + Character.NEW_LINE).join(validationErrorsList)).replaceAll(Character.NEW_LINE, Character.NEW_LINE + "  ") + Character.NEW_LINE + "]");
                }
                throw new IllegalArgumentException((String)validationErrorsList.get(0));
            }
        } else if (!allowEmpty) {
            throw new IllegalArgumentException("1 error:" + Character.NEW_LINE + " - an expectation or array of expectations is required");
        }
        return expectations.toArray(new OpenAPIExpectation[0]);
    }
}

