/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.serialization.java.DelayToJavaSerializer;
import org.mockserver.serialization.java.HttpRequestModifierToJavaSerializer;
import org.mockserver.serialization.java.HttpRequestToJavaSerializer;
import org.mockserver.serialization.java.HttpResponseModifierToJavaSerializer;
import org.mockserver.serialization.java.HttpResponseToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpOverrideForwardedRequestToJavaSerializer
implements ToJavaSerializer<HttpOverrideForwardedRequest> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpOverrideForwardedRequest httpForward) {
        StringBuffer output = new StringBuffer();
        if (httpForward != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("forwardOverriddenRequest()");
            if (httpForward.getRequestOverride() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withRequestOverride(");
                output.append(new HttpRequestToJavaSerializer().serialize(numberOfSpacesToIndent + 2, httpForward.getRequestOverride()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (httpForward.getRequestModifier() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withRequestModifier(");
                output.append(new HttpRequestModifierToJavaSerializer().serialize(numberOfSpacesToIndent + 2, httpForward.getRequestModifier()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (httpForward.getResponseOverride() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withResponseOverride(");
                output.append(new HttpResponseToJavaSerializer().serialize(numberOfSpacesToIndent + 2, httpForward.getResponseOverride()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (httpForward.getResponseModifier() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withResponseModifier(");
                output.append(new HttpResponseModifierToJavaSerializer().serialize(numberOfSpacesToIndent + 2, httpForward.getResponseModifier()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
            if (httpForward.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(");
                output.append(new DelayToJavaSerializer().serialize(0, httpForward.getDelay()));
                output.append(")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

