/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.mockserver.character.Character;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.java.ConnectionOptionsToJavaSerializer;
import org.mockserver.serialization.java.CookieToJavaSerializer;
import org.mockserver.serialization.java.DelayToJavaSerializer;
import org.mockserver.serialization.java.HeaderToJavaSerializer;
import org.mockserver.serialization.java.MultiValueToJavaSerializer;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpResponseToJavaSerializer
implements ToJavaSerializer<HttpResponse> {
    private final Base64Converter base64Converter = new Base64Converter();

    @Override
    public String serialize(int numberOfSpacesToIndent, HttpResponse httpResponse) {
        StringBuffer output = new StringBuffer();
        if (httpResponse != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("response()");
            if (httpResponse.getStatusCode() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withStatusCode(").append(httpResponse.getStatusCode()).append(")");
            }
            if (httpResponse.getReasonPhrase() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withReasonPhrase(\"").append(StringEscapeUtils.escapeJava(httpResponse.getReasonPhrase())).append("\")");
            }
            this.outputHeaders(numberOfSpacesToIndent + 1, output, httpResponse.getHeaderList());
            this.outputCookies(numberOfSpacesToIndent + 1, output, httpResponse.getCookieList());
            if (StringUtils.isNotBlank(httpResponse.getBodyAsString())) {
                if (httpResponse.getBody() instanceof BinaryBody) {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output);
                    BinaryBody body = (BinaryBody)httpResponse.getBody();
                    output.append(".withBody(new Base64Converter().base64StringToBytes(\"").append(this.base64Converter.bytesToBase64String(body.getRawBytes())).append("\"))");
                } else {
                    this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withBody(\"").append(StringEscapeUtils.escapeJava(httpResponse.getBodyAsString())).append("\")");
                }
            }
            if (httpResponse.getDelay() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withDelay(").append(new DelayToJavaSerializer().serialize(0, httpResponse.getDelay())).append(")");
            }
            if (httpResponse.getConnectionOptions() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withConnectionOptions(");
                output.append(new ConnectionOptionsToJavaSerializer().serialize(numberOfSpacesToIndent + 2, httpResponse.getConnectionOptions()));
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(")");
            }
        }
        return output.toString();
    }

    private void outputCookies(int numberOfSpacesToIndent, StringBuffer output, List<Cookie> cookies) {
        if (cookies.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withCookies(");
            this.appendObject(numberOfSpacesToIndent + 1, output, new CookieToJavaSerializer(), cookies);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private void outputHeaders(int numberOfSpacesToIndent, StringBuffer output, List<Header> headers) {
        if (headers.size() > 0) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(".withHeaders(");
            this.appendObject(numberOfSpacesToIndent + 1, output, new HeaderToJavaSerializer(), headers);
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append(")");
        }
    }

    private <T extends ObjectWithReflectiveEqualsHashCodeToString> void appendObject(int numberOfSpacesToIndent, StringBuffer output, MultiValueToJavaSerializer<T> toJavaSerializer, List<T> objects) {
        output.append(toJavaSerializer.serializeAsJava(numberOfSpacesToIndent, objects));
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart("", numberOfSpacesToIndent, ' '));
    }
}

