/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.serializers.body;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.mockserver.serialization.model.BinaryBodyDTO;

public class BinaryBodyDTOSerializer
extends StdSerializer<BinaryBodyDTO> {
    public BinaryBodyDTOSerializer() {
        super(BinaryBodyDTO.class);
    }

    @Override
    public void serialize(BinaryBodyDTO binaryBodyDTO, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        if (binaryBodyDTO.getNot() != null && binaryBodyDTO.getNot().booleanValue()) {
            jgen.writeBooleanField("not", binaryBodyDTO.getNot());
        }
        if (binaryBodyDTO.getOptional() != null && binaryBodyDTO.getOptional().booleanValue()) {
            jgen.writeBooleanField("optional", binaryBodyDTO.getOptional());
        }
        jgen.writeStringField("type", binaryBodyDTO.getType().name());
        jgen.writeObjectField("base64Bytes", binaryBodyDTO.getBase64Bytes());
        if (binaryBodyDTO.getContentType() != null) {
            jgen.writeStringField("contentType", binaryBodyDTO.getContentType());
        }
        jgen.writeEndObject();
    }
}

