/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.velocity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.velocity.script.VelocityScriptEngineFactory;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.DTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.slf4j.event.Level;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final ScriptEngine engine;
    private static final ObjectMapper OBJECT_MAPPER;
    private final MockServerLogger logFormatter;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public VelocityTemplateEngine(MockServerLogger logFormatter) {
        this.logFormatter = logFormatter;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(logFormatter);
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        Object result;
        try {
            JsonNode generatedObject;
            StringWriter writer;
            block5: {
                writer = new StringWriter();
                SimpleScriptContext context = new SimpleScriptContext();
                context.setWriter(writer);
                context.setAttribute("request", new HttpRequestTemplateObject(request), 100);
                engine.eval(template, (ScriptContext)context);
                generatedObject = null;
                try {
                    generatedObject = OBJECT_MAPPER.readTree(((Object)writer).toString());
                }
                catch (Throwable throwable) {
                    if (!MockServerLogger.isEnabled(Level.TRACE)) break block5;
                    this.logFormatter.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("exception deserialising generated content:{}into json node for request:{}").setArguments(((Object)writer).toString(), request));
                }
            }
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.logFormatter.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TEMPLATE_GENERATED).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("generated output:{}from template:{}for request:{}").setArguments(generatedObject != null ? generatedObject : ((Object)writer).toString(), template, request));
            }
            result = this.httpTemplateOutputDeserializer.deserializer(request, ((Object)writer).toString(), dtoClass);
        }
        catch (Exception e) {
            throw new RuntimeException(StringFormatter.formatLogMessage("Exception transforming template:{}for request:{}", template, request), e);
        }
        return result;
    }

    static {
        OBJECT_MAPPER = ObjectMapperFactory.createObjectMapper();
        manager.registerEngineName("velocity", new VelocityScriptEngineFactory());
        engine = manager.getEngineByName("velocity");
    }
}

