/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.base.Strings;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.Version;
import org.mockserver.client.ClientException;
import org.mockserver.client.ForwardChainExpectation;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.model.ClearType;
import org.mockserver.model.Format;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.PortBinding;
import org.mockserver.model.RetrieveType;
import org.mockserver.serialization.ExpectationSerializer;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.PortBindingSerializer;
import org.mockserver.serialization.VerificationSequenceSerializer;
import org.mockserver.serialization.VerificationSerializer;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.mockserver.verify.VerificationTimes;

public class MockServerClient
implements Closeable {
    protected final MockServerLogger mockServerLogger = new MockServerLogger(this.getClass());
    private final String host;
    private final String contextPath;
    private final Class<MockServerClient> clientClass = MockServerClient.class;
    protected Future<Integer> portFuture;
    private Boolean secure;
    private Integer port;
    private NettyHttpClient nettyHttpClient = new NettyHttpClient();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer(this.mockServerLogger);
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer(this.mockServerLogger);
    private VerificationSerializer verificationSerializer = new VerificationSerializer(this.mockServerLogger);
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer(this.mockServerLogger);

    public MockServerClient(Future<Integer> portFuture) {
        this.host = "127.0.0.1";
        this.portFuture = portFuture;
        this.contextPath = "";
    }

    public MockServerClient(String host, int port) {
        this(host, port, "");
    }

    public MockServerClient(String host, int port, String contextPath) {
        if (StringUtils.isEmpty((CharSequence)host)) {
            throw new IllegalArgumentException("Host can not be null or empty");
        }
        if (contextPath == null) {
            throw new IllegalArgumentException("ContextPath can not be null");
        }
        this.host = host;
        this.port = port;
        this.contextPath = contextPath;
    }

    public boolean isSecure() {
        return this.secure != null ? this.secure : false;
    }

    public MockServerClient withSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    private int port() {
        if (this.port == null) {
            try {
                this.port = this.portFuture.get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return this.port;
    }

    public InetSocketAddress remoteAddress() {
        return new InetSocketAddress(this.host, this.port());
    }

    public String contextPath() {
        return this.contextPath;
    }

    private String calculatePath(String path) {
        String cleanedPath = "/mockserver/" + path;
        if (!Strings.isNullOrEmpty((String)this.contextPath)) {
            cleanedPath = (!this.contextPath.startsWith("/") ? "/" : "") + this.contextPath + (!this.contextPath.endsWith("/") ? "/" : "") + (cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    private HttpResponse sendRequest(HttpRequest request) {
        HttpResponse response;
        if (this.secure != null) {
            request.withSecure(this.secure);
        }
        if ((response = this.nettyHttpClient.sendRequest(request.withHeader(HttpHeaderNames.HOST.toString(), new String[]{this.host + ":" + this.port()}), ConfigurationProperties.maxSocketTimeout(), TimeUnit.MILLISECONDS)) != null) {
            if (response.getStatusCode() != null && response.getStatusCode().intValue() == HttpResponseStatus.BAD_REQUEST.code()) {
                throw new IllegalArgumentException(response.getBodyAsString());
            }
            String serverVersion = response.getFirstHeader("version");
            String clientVersion = Version.getVersion();
            if (!(Strings.isNullOrEmpty((String)serverVersion) || Strings.isNullOrEmpty((String)clientVersion) || clientVersion.equals(serverVersion))) {
                throw new ClientException("Client version \"" + clientVersion + "\" does not match server version \"" + serverVersion + "\"");
            }
        }
        return response;
    }

    public boolean isRunning() {
        return this.isRunning(10, 500L, TimeUnit.MILLISECONDS);
    }

    public boolean isRunning(int attempts, long timeout, TimeUnit timeUnit) {
        try {
            HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("status")));
            if (httpResponse.getStatusCode().intValue() == HttpStatusCode.OK_200.code()) {
                return true;
            }
            if (attempts == 0) {
                return false;
            }
            try {
                timeUnit.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.isRunning(attempts - 1, timeout, timeUnit);
        }
        catch (SocketConnectionException sce) {
            return false;
        }
    }

    public List<Integer> bind(Integer ... ports) {
        String boundPorts = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("bind")).withBody(this.portBindingSerializer.serialize(PortBinding.portBinding((Integer[])ports)), StandardCharsets.UTF_8)).getBodyAsString();
        return this.portBindingSerializer.deserialize(boundPorts).getPorts();
    }

    public MockServerClient stop() {
        MockServerEventBus.getInstance().publish(MockServerEventBus.EventType.STOP);
        return this.stop(false);
    }

    public MockServerClient stop(boolean ignoreFailure) {
        block4: {
            try {
                this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("stop")));
                if (this.isRunning()) {
                    for (int i = 0; this.isRunning() && i < 50; ++i) {
                        TimeUnit.MILLISECONDS.sleep(5L);
                    }
                }
            }
            catch (Exception e) {
                if (ignoreFailure) break block4;
                this.mockServerLogger.warn("Failed to send stop request to MockServer " + e.getMessage());
            }
        }
        return this.clientClass.cast(this);
    }

    @Override
    public void close() {
        this.stop();
    }

    public MockServerClient reset() {
        MockServerEventBus.getInstance().publish(MockServerEventBus.EventType.RESET);
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("reset")));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(HttpRequest httpRequest) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient clear(HttpRequest httpRequest, ClearType type) {
        this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("clear")).withQueryStringParameter("type", new String[]{type.name().toLowerCase()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", StandardCharsets.UTF_8));
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(HttpRequest ... httpRequests) throws AssertionError {
        if (httpRequests == null || httpRequests.length == 0 || httpRequests[0] == null) {
            throw new IllegalArgumentException("verify(HttpRequest...) requires a non null non empty array of HttpRequest objects");
        }
        VerificationSequence verificationSequence = new VerificationSequence().withRequests(httpRequests);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verifySequence")).withBody(this.verificationSequenceSerializer.serialize(verificationSequence), StandardCharsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verify(HttpRequest httpRequest, VerificationTimes times) throws AssertionError {
        if (httpRequest == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null HttpRequest object");
        }
        if (times == null) {
            throw new IllegalArgumentException("verify(HttpRequest, VerificationTimes) requires a non null VerificationTimes object");
        }
        Verification verification = Verification.verification().withRequest(httpRequest).withTimes(times);
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this.clientClass.cast(this);
    }

    public MockServerClient verifyZeroInteractions() throws AssertionError {
        Verification verification = Verification.verification().withRequest(HttpRequest.request()).withTimes(VerificationTimes.exactly((int)0));
        String result = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("verify")).withBody(this.verificationSerializer.serialize(verification), StandardCharsets.UTF_8)).getBodyAsString();
        if (result != null && !result.isEmpty()) {
            throw new AssertionError((Object)result);
        }
        return this.clientClass.cast(this);
    }

    public HttpRequest[] retrieveRecordedRequests(HttpRequest httpRequest) {
        String recordedRequests = this.retrieveRecordedRequests(httpRequest, Format.JSON);
        if (StringUtils.isNotEmpty((CharSequence)recordedRequests) && !recordedRequests.equals("[]")) {
            return this.httpRequestSerializer.deserializeArray(recordedRequests);
        }
        return new HttpRequest[0];
    }

    public String retrieveRecordedRequests(HttpRequest httpRequest, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.REQUESTS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public Expectation[] retrieveRecordedExpectations(HttpRequest httpRequest) {
        String recordedExpectations = this.retrieveRecordedExpectations(httpRequest, Format.JSON);
        if (!Strings.isNullOrEmpty((String)recordedExpectations) && !recordedExpectations.equals("[]")) {
            return this.expectationSerializer.deserializeArray(recordedExpectations);
        }
        return new Expectation[0];
    }

    public String retrieveRecordedExpectations(HttpRequest httpRequest, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.RECORDED_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String retrieveLogMessages(HttpRequest httpRequest) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.LOGS.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }

    public String[] retrieveLogMessagesArray(HttpRequest httpRequest) {
        return this.retrieveLogMessages(httpRequest).split(HttpStateHandler.LOG_SEPARATOR);
    }

    public ForwardChainExpectation when(HttpRequest httpRequest) {
        return this.when(httpRequest, Times.unlimited());
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, TimeToLive.unlimited()));
    }

    public ForwardChainExpectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new ForwardChainExpectation(this, new Expectation(httpRequest, times, timeToLive));
    }

    void sendExpectation(Expectation expectation) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("expectation")).withBody(expectation != null ? this.expectationSerializer.serialize(expectation) : "", StandardCharsets.UTF_8));
        if (httpResponse != null && httpResponse.getStatusCode() != 201) {
            throw new ClientException(StringFormatter.formatLogMessage((String)"error:{}while submitted expectation:{}", (Object[])new Object[]{httpResponse.getBody(), expectation}));
        }
    }

    public Expectation[] retrieveActiveExpectations(HttpRequest httpRequest) {
        String activeExpectations = this.retrieveActiveExpectations(httpRequest, Format.JSON);
        if (!Strings.isNullOrEmpty((String)activeExpectations) && !activeExpectations.equals("[]")) {
            return this.expectationSerializer.deserializeArray(activeExpectations);
        }
        return new Expectation[0];
    }

    public String retrieveActiveExpectations(HttpRequest httpRequest, Format format) {
        HttpResponse httpResponse = this.sendRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("retrieve")).withQueryStringParameter("type", new String[]{RetrieveType.ACTIVE_EXPECTATIONS.name()}).withQueryStringParameter("format", new String[]{format.name()}).withBody(httpRequest != null ? this.httpRequestSerializer.serialize(httpRequest) : "", StandardCharsets.UTF_8));
        return httpResponse.getBodyAsString();
    }
}

